/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.ComponentInfo;
import com.sun.management.viper.ServiceInfo;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.ExternalClientProviderInfo;
import com.sun.management.viperimpl.ExternalClientProviderInfoImpl;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.ServiceInfoImpl;
import com.sun.management.viperimpl.ToolInfoImpl;
import com.sun.management.viperimpl.ViperProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class VRegistry {
    private static final String Trashbase_Dir = "deleted/";
    private static final String Codebase_Dir = "codebase/";
    private static final String Lib_Dir = "lib/";
    private static final String Services_Dir = "services/";
    private static final String Tools_Dir = "tools/";
    private static final String XCProviders_Dir = "xcproviders/";
    private static final String Registry_DB = "/properties/registry.ser";
    private static final String Default_Home = "/usr/sadm/smc";
    private static final String ClassList_DB = "/properties/classlist.txt";
    private static final String Reload_Lock = "/reload";
    public static final String GLOBAL = "ALL";
    public static final String GLOBALTOOL = "ALLTOOL";
    public static final String GLOBALSERVICE = "ALLSERVICE";

    private static String getViperRTHome() {
        return ViperProperties.getViperRTHome();
    }

    private static String getRegistryFile() {
        return VRegistry.getViperRTHome() + Registry_DB;
    }

    private static String getBackupRegistryFile() {
        return VRegistry.getViperRTHome() + Registry_DB + ".backup";
    }

    public static String getCodebase() {
        String dirname = VRegistry.getViperRTHome() + "/" + Codebase_Dir;
        File dir1 = new File(dirname + Services_Dir);
        File dir2 = new File(dirname + Tools_Dir);
        File dir3 = new File(dirname + XCProviders_Dir);
        if (!dir1.exists()) {
            dir1.mkdirs();
        }
        if (!dir2.exists()) {
            dir2.mkdirs();
        }
        if (!dir3.exists()) {
            dir3.mkdirs();
        }
        return dirname;
    }

    static void makeDirectories() {
        String rthome = VRegistry.getViperRTHome() + "/";
        new File(rthome + Codebase_Dir).mkdir();
        new File(rthome + Lib_Dir).mkdir();
        new File(rthome + "properties").mkdir();
    }

    public static String getTrashbase() {
        String dirname = VRegistry.getViperRTHome() + "/" + Trashbase_Dir;
        File dir1 = new File(dirname + Services_Dir);
        File dir2 = new File(dirname + Tools_Dir);
        File dir3 = new File(dirname + XCProviders_Dir);
        if (!dir1.exists()) {
            dir1.mkdirs();
        }
        if (!dir2.exists()) {
            dir2.mkdirs();
        }
        if (!dir3.exists()) {
            dir3.mkdirs();
        }
        return dirname;
    }

    public static String getReloadLockFile() {
        return VRegistry.getViperRTHome() + Reload_Lock;
    }

    public static String toJarName(int componentType, String beanClassName) {
        String dir;
        switch (componentType) {
            case 1: {
                dir = Tools_Dir;
                break;
            }
            case 2: {
                dir = Services_Dir;
                break;
            }
            case 3: {
                dir = XCProviders_Dir;
                break;
            }
            default: {
                dir = "";
            }
        }
        return dir + beanClassName + ".jar";
    }

    public static String toAttachedJarName(int componentType, String beanClassName, String jarBasename) {
        String dir;
        if (beanClassName.equals(GLOBAL)) {
            return "ALL@" + jarBasename;
        }
        if (beanClassName.equals(GLOBALTOOL)) {
            return "tools/ALLTOOL@" + jarBasename;
        }
        if (beanClassName.equals(GLOBALSERVICE)) {
            return "services/ALLSERVICE@" + jarBasename;
        }
        switch (componentType) {
            case 1: {
                dir = Tools_Dir;
                break;
            }
            case 2: {
                dir = Services_Dir;
                break;
            }
            case 3: {
                dir = XCProviders_Dir;
                break;
            }
            default: {
                dir = "";
            }
        }
        return dir + beanClassName + "@" + jarBasename;
    }

    public static String toFullJarPath(String jarName) {
        if (jarName == null) {
            return null;
        }
        return VRegistry.getCodebase() + jarName;
    }

    protected static ServiceInfoImpl[] readServices() {
        return (ServiceInfoImpl[])VRegistry.readRegistry()[0];
    }

    protected static void writeServices(ServiceInfoImpl[] slist) {
        VRegistry.writeRegistrySection(0, slist);
    }

    protected static ToolInfoImpl[] readTools() {
        return (ToolInfoImpl[])VRegistry.readRegistry()[1];
    }

    protected static void writeTools(ToolInfoImpl[] list) {
        VRegistry.writeRegistrySection(1, list);
    }

    protected static ExternalClientProviderInfoImpl[] readXCProviders() {
        return (ExternalClientProviderInfoImpl[])VRegistry.readRegistry()[2];
    }

    protected static void writeXCProviders(ExternalClientProviderInfoImpl[] list) {
        VRegistry.writeRegistrySection(2, list);
    }

    protected static LibInfoImpl[] readAllLibJars() {
        return (LibInfoImpl[])VRegistry.readRegistry()[3];
    }

    protected static void writeAllLibJars(LibInfoImpl[] list) {
        VRegistry.writeRegistrySection(3, list);
    }

    protected static Properties readAllProperties() {
        return (Properties)VRegistry.readRegistry()[4];
    }

    protected static void writeAllProperties(Properties list) {
        VRegistry.writeRegistrySection(4, list);
    }

    protected static Properties readAllServiceProperties() {
        return (Properties)VRegistry.readRegistry()[5];
    }

    protected static void writeAllServiceProperties(Properties list) {
        VRegistry.writeRegistrySection(5, list);
    }

    protected static Properties readAllToolProperties() {
        return (Properties)VRegistry.readRegistry()[6];
    }

    protected static void writeAllToolProperties(Properties list) {
        VRegistry.writeRegistrySection(6, list);
    }

    private static void writeRegistrySection(int index, Object section) {
        Object[] sections = VRegistry.readRegistry();
        sections[index] = section;
        VRegistry.writeRegistry(sections);
    }

    private static void writeRegistry(Object[] sections) {
        String filename = VRegistry.getRegistryFile();
        String backup = VRegistry.getBackupRegistryFile();
        try {
            File file;
            File oldfile = new File(backup);
            if (oldfile.exists()) {
                oldfile.delete();
            }
            if ((file = new File(filename)).exists()) {
                file.renameTo(oldfile);
            }
            FileOutputStream fout = new FileOutputStream(filename);
            ObjectOutputStream out = new ObjectOutputStream(fout);
            out.writeObject(sections);
            out.close();
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
            String msg = "Unable to open repository for write";
            Debug.trace((String)"VRegistry", (int)Debug.WARNING, (String)msg, (Throwable)ioe);
        }
    }

    private static Object[] readRegistry() {
        String filename = VRegistry.getRegistryFile();
        String backup = VRegistry.getBackupRegistryFile();
        String msg = null;
        Object[] result = VRegistry.readRegistryFromFile(filename);
        if (result[0] == null || result[1] == null || result[2] == null || result[3] == null || result[4] == null || result[5] == null || result[6] == null) {
            File file = new File(filename);
            File bfile = new File(backup);
            if (bfile.exists()) {
                if (file.exists()) {
                    file.delete();
                }
                bfile.renameTo(file);
                msg = "Roll back to backup registry";
                Debug.trace((String)"VRegistry", (int)Debug.INFORMATION, (String)msg, null);
            }
            result = VRegistry.readRegistryFromFile(filename);
        }
        if (result[0] == null) {
            result[0] = new ServiceInfoImpl[0];
        }
        if (result[1] == null) {
            result[1] = new ToolInfoImpl[0];
        }
        if (result[2] == null) {
            result[2] = new ExternalClientProviderInfoImpl[0];
        }
        if (result[3] == null) {
            result[3] = new LibInfoImpl[0];
        }
        if (result[4] == null) {
            result[4] = new Properties();
        }
        if (result[5] == null) {
            result[5] = new Properties();
        }
        if (result[6] == null) {
            result[6] = new Properties();
        }
        return result;
    }

    private static Object[] readRegistryFromFile(String file) {
        Object[] result = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            result = (Object[])in.readObject();
            in.close();
        }
        catch (Exception ioe) {
            String msg = "Unable to read repository database";
            Debug.trace((String)"VRegistry", (int)Debug.ERROR, (String)msg, (Throwable)ioe);
        }
        if (result == null) {
            result = new Object[7];
            for (int i = 0; i < 7; ++i) {
                result[i] = null;
            }
        }
        return result;
    }

    private static void printProperties(Properties p) {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            System.out.println("Key = " + s + " Value = " + p.getProperty(s));
        }
    }

    protected static int checkBean(ToolInfo info) {
        if (info == null) {
            return 1;
        }
        ToolInfoImpl[] tlist = VRegistry.readTools();
        String classname = info.getClassName();
        if (tlist != null) {
            for (int i = 0; i < tlist.length; ++i) {
                if (!tlist[i].getClassName().equals(classname)) continue;
                return 0;
            }
        }
        return 1;
    }

    protected static int checkBean(ServiceInfo info) {
        if (info == null) {
            return 1;
        }
        ServiceInfoImpl[] slist = VRegistry.readServices();
        String classname = info.getClassName();
        if (slist != null) {
            for (int i = 0; i < slist.length; ++i) {
                if (!slist[i].getClassName().equals(classname)) continue;
                return 0;
            }
        }
        return 1;
    }

    protected static int checkBean(ExternalClientProviderInfo info) {
        if (info == null) {
            return 1;
        }
        ExternalClientProviderInfoImpl[] list = VRegistry.readXCProviders();
        String classname = info.getClassName();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].getClassName().equals(classname)) continue;
                return 0;
            }
        }
        return 1;
    }

    public static LibInfoImpl addEntry(ComponentInfo info, String[] libs) {
        if (info instanceof ToolInfo) {
            return VRegistry.addEntry((ToolInfo)info, libs);
        }
        if (info instanceof ServiceInfo) {
            return VRegistry.addEntry((ServiceInfo)info, libs);
        }
        if (info instanceof ExternalClientProviderInfo) {
            return VRegistry.addEntry((ExternalClientProviderInfo)info, libs);
        }
        return null;
    }

    public static ServiceInfoImpl addEntry(ServiceInfo info, String[] libs) {
        ServiceInfoImpl[] slist = VRegistry.readServices();
        ServiceInfoImpl[] newlist = new ServiceInfoImpl[slist.length + 1];
        for (int i = 0; i < slist.length; ++i) {
            newlist[i] = slist[i];
            if (!slist[i].getClassName().equals(info.getClassName())) continue;
            for (int j = i; j < slist.length - 1; ++j) {
                slist[j] = slist[j + 1];
            }
            newlist = slist;
            break;
        }
        newlist[newlist.length - 1] = new ServiceInfoImpl(info);
        newlist[newlist.length - 1].setNativeLibs(libs);
        VRegistry.writeServices(newlist);
        return newlist[newlist.length - 1];
    }

    public static ToolInfoImpl addEntry(ToolInfo info, String[] libs) {
        ToolInfoImpl[] tlist = VRegistry.readTools();
        ToolInfoImpl[] newlist = new ToolInfoImpl[tlist.length + 1];
        for (int i = 0; i < tlist.length; ++i) {
            newlist[i] = tlist[i];
            if (!tlist[i].getClassName().equals(info.getClassName())) continue;
            for (int j = i; j < tlist.length - 1; ++j) {
                tlist[j] = tlist[j + 1];
            }
            newlist = tlist;
            break;
        }
        newlist[newlist.length - 1] = new ToolInfoImpl(info);
        newlist[newlist.length - 1].setNativeLibs(libs);
        VRegistry.writeTools(newlist);
        return newlist[newlist.length - 1];
    }

    protected static ExternalClientProviderInfoImpl addEntry(ExternalClientProviderInfo info, String[] libs) {
        ExternalClientProviderInfoImpl[] xcplist = VRegistry.readXCProviders();
        ExternalClientProviderInfoImpl[] newlist = new ExternalClientProviderInfoImpl[xcplist.length + 1];
        for (int i = 0; i < xcplist.length; ++i) {
            newlist[i] = xcplist[i];
            if (!xcplist[i].getClassName().equals(info.getClassName())) continue;
            for (int j = i; j < xcplist.length - 1; ++j) {
                xcplist[j] = xcplist[j + 1];
            }
            newlist = xcplist;
            break;
        }
        newlist[newlist.length - 1] = new ExternalClientProviderInfoImpl(info);
        newlist[newlist.length - 1].setNativeLibs(libs);
        VRegistry.writeXCProviders(newlist);
        return newlist[newlist.length - 1];
    }

    public static boolean removeEntry(String beanClassName) {
        ExternalClientProviderInfoImpl[] xcplist;
        ToolInfoImpl[] tlist;
        String libString;
        int i;
        boolean isAJarFile = false;
        ServiceInfoImpl[] slist = VRegistry.readServices();
        if (slist.length > 0) {
            ServiceInfoImpl[] newlist = new ServiceInfoImpl[slist.length - 1];
            for (i = 0; i < slist.length; ++i) {
                isAJarFile = slist[i].getJarName().endsWith(beanClassName);
                if (slist[i].getClassName().equals(beanClassName) || isAJarFile) {
                    LibInfoImpl[] l;
                    String[] libs = slist[i].getNativeLibs();
                    if (libs != null) {
                        String dirname = VRegistry.getViperRTHome() + "/" + Lib_Dir;
                        for (int k = 0; k < libs.length; ++k) {
                            libString = dirname + libs[k];
                            VRegistry.deleteFile(libString);
                        }
                    }
                    if ((l = slist[i].getAttachments()) != null) {
                        for (int p = 0; p < l.length; ++p) {
                            String jn = l[p].getJarPath();
                            VRegistry.deleteLibInfoObject(jn, l[p]);
                        }
                    }
                    for (int j = i + 1; j < slist.length; ++j) {
                        newlist[j - 1] = slist[j];
                    }
                    break;
                }
                if (i >= slist.length - 1) continue;
                newlist[i] = slist[i];
            }
            if (i < slist.length) {
                if (!isAJarFile) {
                    VRegistry.deleteFile(slist[i].getJarPath());
                }
                VRegistry.writeServices(newlist);
                return true;
            }
        }
        if ((tlist = VRegistry.readTools()).length > 0) {
            ToolInfoImpl[] newlist = new ToolInfoImpl[tlist.length - 1];
            for (i = 0; i < tlist.length; ++i) {
                isAJarFile = tlist[i].getJarName().endsWith(beanClassName);
                if (tlist[i].getClassName().equals(beanClassName) || isAJarFile) {
                    LibInfoImpl[] l;
                    String[] libs = tlist[i].getNativeLibs();
                    if (libs != null) {
                        String dirname = VRegistry.getViperRTHome() + "/" + Lib_Dir;
                        for (int k = 0; k < libs.length; ++k) {
                            libString = dirname + libs[k];
                            VRegistry.deleteFile(libString);
                        }
                    }
                    if ((l = tlist[i].getAttachments()) != null) {
                        for (int p = 0; p < l.length; ++p) {
                            String jn = l[p].getJarPath();
                            VRegistry.deleteLibInfoObject(jn, l[p]);
                        }
                    }
                    for (int j = i + 1; j < tlist.length; ++j) {
                        newlist[j - 1] = tlist[j];
                    }
                    break;
                }
                if (i >= tlist.length - 1) continue;
                newlist[i] = tlist[i];
            }
            if (i < tlist.length) {
                String jname = tlist[i].getJarPath();
                if (!isAJarFile) {
                    VRegistry.deleteFile(jname);
                }
                VRegistry.writeTools(newlist);
                return true;
            }
        }
        if ((xcplist = VRegistry.readXCProviders()).length > 0) {
            ExternalClientProviderInfoImpl[] newlist = new ExternalClientProviderInfoImpl[xcplist.length - 1];
            for (i = 0; i < xcplist.length; ++i) {
                isAJarFile = xcplist[i].getJarName().endsWith(beanClassName);
                if (xcplist[i].getClassName().equals(beanClassName) || isAJarFile) {
                    String[] libs = xcplist[i].getNativeLibs();
                    if (libs != null) {
                        String dirname = VRegistry.getViperRTHome() + "/" + Lib_Dir;
                        for (int k = 0; k < libs.length; ++k) {
                            libString = dirname + libs[k];
                            VRegistry.deleteFile(libString);
                        }
                    }
                    for (int j = i + 1; j < xcplist.length; ++j) {
                        newlist[j - 1] = xcplist[j];
                    }
                    break;
                }
                if (i >= xcplist.length - 1) continue;
                newlist[i] = xcplist[i];
            }
            if (i < xcplist.length) {
                String jname = xcplist[i].getJarPath();
                if (!isAJarFile) {
                    VRegistry.deleteFile(jname);
                }
                VRegistry.writeXCProviders(newlist);
                return true;
            }
        }
        return false;
    }

    private static int unsetProperties(String s, Properties p) {
        String key = "";
        StringTokenizer parser = new StringTokenizer(s, ":");
        try {
            while (parser.hasMoreElements()) {
                String tmpStr;
                key = tmpStr = parser.nextElement().toString().trim();
                int index = tmpStr.indexOf(61);
                if (index >= 0) {
                    key = tmpStr.substring(0, index);
                }
                if (p.get(key) == null) {
                    return 1;
                }
                p.remove(key);
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        return 0;
    }

    private static void setProperties(String s, Properties p) {
        StringTokenizer parser = new StringTokenizer(s, ":");
        try {
            while (parser.hasMoreElements()) {
                String tmpStr = parser.nextElement().toString().trim();
                int index = tmpStr.indexOf(61);
                String key = tmpStr.substring(0, index);
                String value = tmpStr.substring(index + 2, tmpStr.length() - 1);
                p.setProperty(key, value);
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    private static int searchAndRemoveProperties(String libName, String keyStr, Properties p, LibInfoImpl[] l) {
        if (libName == null || libName.trim().length() == 0) {
            return VRegistry.unsetProperties(keyStr, p);
        }
        for (int j = 0; j < l.length; ++j) {
            String fullJarName = l[j].getJarName();
            String jarName = VRegistry.baseName(fullJarName);
            if (!jarName.equals(libName)) continue;
            return VRegistry.unsetProperties(keyStr, l[j].getProperties());
        }
        return 3;
    }

    public static int removeProperties(String keyStr, String beanName, String libName) {
        int i;
        ServiceInfoImpl[] slist = null;
        ToolInfoImpl[] tlist = null;
        ExternalClientProviderInfoImpl[] xcplist = null;
        Properties newprops = null;
        LibInfoImpl[] shared = VRegistry.readAllLibJars();
        if (beanName.equals(GLOBAL)) {
            newprops = VRegistry.readAllProperties();
            int retValue = VRegistry.searchAndRemoveProperties(libName, keyStr, newprops, shared);
            if (retValue != 0) {
                return retValue;
            }
            VRegistry.writeAllProperties(newprops);
            return 0;
        }
        if (beanName.equals(GLOBALTOOL)) {
            newprops = VRegistry.readAllToolProperties();
            int retValue = VRegistry.searchAndRemoveProperties(libName, keyStr, newprops, shared);
            if (retValue != 0) {
                return retValue;
            }
            VRegistry.writeAllToolProperties(newprops);
            return 0;
        }
        if (beanName.equals(GLOBALSERVICE)) {
            newprops = VRegistry.readAllServiceProperties();
            int retValue = VRegistry.searchAndRemoveProperties(libName, keyStr, newprops, shared);
            if (retValue != 0) {
                return retValue;
            }
            VRegistry.writeAllServiceProperties(newprops);
            return 0;
        }
        slist = VRegistry.readServices();
        for (i = 0; i < slist.length; ++i) {
            if (!slist[i].getClassName().equals(beanName)) continue;
            int retValue = VRegistry.searchAndRemoveProperties(libName, keyStr, slist[i].getProperties(), slist[i].getAttachments());
            if (retValue != 0) {
                return retValue;
            }
            VRegistry.writeServices(slist);
            return 0;
        }
        tlist = VRegistry.readTools();
        for (i = 0; i < tlist.length; ++i) {
            if (!tlist[i].getClassName().equals(beanName)) continue;
            int retValue = VRegistry.searchAndRemoveProperties(libName, keyStr, tlist[i].getProperties(), tlist[i].getAttachments());
            if (retValue != 0) {
                return retValue;
            }
            VRegistry.writeTools(tlist);
            return 0;
        }
        xcplist = VRegistry.readXCProviders();
        for (i = 0; i < xcplist.length; ++i) {
            if (!xcplist[i].getClassName().equals(beanName)) continue;
            int retValue = VRegistry.searchAndRemoveProperties(libName, keyStr, xcplist[i].getProperties(), new LibInfoImpl[0]);
            if (retValue != 0) {
                return retValue;
            }
            VRegistry.writeXCProviders(xcplist);
            return 0;
        }
        return 2;
    }

    private static String baseName(String filename) {
        int i = filename.indexOf(64);
        if (i >= 0) {
            return filename.substring(i + 1);
        }
        return filename;
    }

    private static int isThereProperty(String s, Properties p) {
        StringTokenizer parser = new StringTokenizer(s, ":");
        try {
            while (parser.hasMoreElements()) {
                int index;
                String tmpStr = parser.nextElement().toString().trim();
                String key = tmpStr.substring(0, index = tmpStr.indexOf(61));
                if (p.get(key) == null) continue;
                return 0;
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        return 1;
    }

    private static int validateProperties(String libName, String keyStr, Properties p, LibInfoImpl[] l) {
        if (libName == null || libName.trim().length() == 0) {
            return VRegistry.isThereProperty(keyStr, p);
        }
        for (int j = 0; j < l.length; ++j) {
            String jarName = VRegistry.baseName(l[j].getJarName());
            if (!jarName.equals(libName)) continue;
            return VRegistry.isThereProperty(keyStr, l[j].getProperties());
        }
        return 1;
    }

    private static boolean searchAndAddProperties(String libName, String keyStr, Properties p, LibInfoImpl[] l) {
        if (libName == null || libName.trim().length() == 0) {
            VRegistry.setProperties(keyStr, p);
            return true;
        }
        for (int j = 0; j < l.length; ++j) {
            String fullJarName = l[j].getJarName();
            String jarName = VRegistry.baseName(fullJarName);
            if (!jarName.equals(libName)) continue;
            VRegistry.setProperties(keyStr, l[j].getProperties());
            return true;
        }
        return false;
    }

    protected static int checkProperties(String keyStr, String beanName, String libName) {
        if (beanName.equals(GLOBAL) || beanName.equals(GLOBALTOOL) || beanName.equals(GLOBALSERVICE)) {
            Properties tmpProperty = null;
            if (beanName.equals(GLOBAL)) {
                tmpProperty = VRegistry.readAllProperties();
            } else if (beanName.equals(GLOBALTOOL)) {
                tmpProperty = VRegistry.readAllToolProperties();
            } else if (beanName.equals(GLOBALSERVICE)) {
                tmpProperty = VRegistry.readAllServiceProperties();
            }
            return VRegistry.validateProperties(libName, keyStr, tmpProperty, VRegistry.readAllLibJars());
        }
        ServiceInfoImpl[] slist = VRegistry.readServices();
        for (int i = 0; i < slist.length; ++i) {
            if (!slist[i].getClassName().equals(beanName)) continue;
            return VRegistry.validateProperties(libName, keyStr, slist[i].getProperties(), slist[i].getAttachments());
        }
        ToolInfoImpl[] tlist = VRegistry.readTools();
        for (int i = 0; i < tlist.length; ++i) {
            if (!tlist[i].getClassName().equals(beanName)) continue;
            return VRegistry.validateProperties(libName, keyStr, tlist[i].getProperties(), tlist[i].getAttachments());
        }
        ExternalClientProviderInfoImpl[] xcplist = VRegistry.readXCProviders();
        for (int i = 0; i < xcplist.length; ++i) {
            if (!xcplist[i].getClassName().equals(beanName)) continue;
            return VRegistry.validateProperties(libName, keyStr, xcplist[i].getProperties(), new LibInfoImpl[0]);
        }
        return 1;
    }

    public static int addProperties(String keyStr, String beanName, String libName) {
        boolean setFlag = false;
        LibInfoImpl[] shared = VRegistry.readAllLibJars();
        if (beanName.equals(GLOBAL)) {
            Properties tmpProperty = VRegistry.readAllProperties();
            setFlag = VRegistry.searchAndAddProperties(libName, keyStr, tmpProperty, shared);
            if (!setFlag) {
                return 2;
            }
            VRegistry.writeAllProperties(tmpProperty);
            return 0;
        }
        if (beanName.equals(GLOBALTOOL)) {
            Properties tmpProperty = VRegistry.readAllToolProperties();
            setFlag = VRegistry.searchAndAddProperties(libName, keyStr, tmpProperty, shared);
            if (!setFlag) {
                return 2;
            }
            VRegistry.writeAllToolProperties(tmpProperty);
            return 0;
        }
        if (beanName.equals(GLOBALSERVICE)) {
            Properties tmpProperty = VRegistry.readAllServiceProperties();
            setFlag = VRegistry.searchAndAddProperties(libName, keyStr, tmpProperty, shared);
            if (!setFlag) {
                return 2;
            }
            VRegistry.writeAllServiceProperties(tmpProperty);
            return 0;
        }
        ServiceInfoImpl[] slist = VRegistry.readServices();
        for (int i = 0; i < slist.length; ++i) {
            if (!slist[i].getClassName().equals(beanName)) continue;
            setFlag = VRegistry.searchAndAddProperties(libName, keyStr, slist[i].getProperties(), slist[i].getAttachments());
            if (!setFlag) {
                return 2;
            }
            VRegistry.writeServices(slist);
            return 0;
        }
        ToolInfoImpl[] tlist = VRegistry.readTools();
        for (int i = 0; i < tlist.length; ++i) {
            if (!tlist[i].getClassName().equals(beanName)) continue;
            setFlag = VRegistry.searchAndAddProperties(libName, keyStr, tlist[i].getProperties(), tlist[i].getAttachments());
            if (!setFlag) {
                return 2;
            }
            VRegistry.writeTools(tlist);
            return 0;
        }
        ExternalClientProviderInfoImpl[] xcplist = VRegistry.readXCProviders();
        for (int i = 0; i < xcplist.length; ++i) {
            if (!xcplist[i].getClassName().equals(beanName)) continue;
            setFlag = VRegistry.searchAndAddProperties(libName, keyStr, xcplist[i].getProperties(), new LibInfoImpl[0]);
            if (!setFlag) {
                return 2;
            }
            VRegistry.writeXCProviders(xcplist);
            return 0;
        }
        return 1;
    }

    protected static int checkJarEntry(String beanName, String jarBaseName) {
        LibInfoImpl[] jars;
        int i;
        ServiceInfoImpl[] slist = VRegistry.readServices();
        ToolInfoImpl[] tlist = VRegistry.readTools();
        ExternalClientProviderInfoImpl[] xcplist = VRegistry.readXCProviders();
        LibInfoImpl[] shared = VRegistry.readAllLibJars();
        if (shared != null && (beanName.equals(GLOBAL) || beanName.equals(GLOBALTOOL) || beanName.equals(GLOBALSERVICE))) {
            for (int j = 0; j < shared.length; ++j) {
                String jarName = VRegistry.toAttachedJarName(-1, beanName, jarBaseName);
                if (!jarName.equals(shared[j].getJarName())) continue;
                return 0;
            }
        }
        if (tlist != null) {
            for (i = 0; i < tlist.length; ++i) {
                if (!tlist[i].getClassName().equals(beanName)) continue;
                jars = tlist[i].getAttachments();
                for (int k = 0; k < jars.length; ++k) {
                    if (!jarBaseName.equals(VRegistry.baseName(jars[k].getJarName()))) continue;
                    return 0;
                }
                return 2;
            }
        }
        if (slist != null) {
            for (i = 0; i < slist.length; ++i) {
                if (!slist[i].getClassName().equals(beanName)) continue;
                jars = slist[i].getAttachments();
                for (int k = 0; k < jars.length; ++k) {
                    if (!jarBaseName.equals(VRegistry.baseName(jars[k].getJarName()))) continue;
                    return 0;
                }
                return 2;
            }
        }
        if (xcplist != null) {
            for (i = 0; i < xcplist.length; ++i) {
                if (!xcplist[i].getClassName().equals(beanName)) continue;
                jars = xcplist[i].getAttachments();
                for (int k = 0; k < jars.length; ++k) {
                    if (!jarBaseName.equals(VRegistry.baseName(jars[k].getJarName()))) continue;
                    return 0;
                }
                return 2;
            }
        }
        return 1;
    }

    public static String addJarToEntry(String beanName, String jarBasename, String[] libs) {
        ExternalClientProviderInfoImpl[] xcplist;
        ServiceInfoImpl[] slist;
        int i;
        LibInfoImpl[] shared = VRegistry.readAllLibJars();
        if (beanName.equals(GLOBAL) || beanName.equals(GLOBALTOOL) || beanName.equals(GLOBALSERVICE)) {
            int p;
            String newJarName = VRegistry.toAttachedJarName(-1, beanName, jarBasename);
            LibInfoImpl[] moreshared = new LibInfoImpl[shared.length + 1];
            for (p = 0; p < shared.length; ++p) {
                if (newJarName.equals(shared[p].getJarName())) {
                    moreshared = shared;
                    break;
                }
                moreshared[p] = shared[p];
            }
            moreshared[p] = new LibInfoImpl(null, null, null, null);
            moreshared[p].setJarName(newJarName);
            moreshared[p].setNativeLibs(libs);
            VRegistry.writeAllLibJars(moreshared);
            return moreshared[p].getJarPath();
        }
        ToolInfoImpl[] tlist = VRegistry.readTools();
        if (tlist != null) {
            String jarName = VRegistry.toAttachedJarName(0, beanName, jarBasename);
            for (i = 0; i < tlist.length; ++i) {
                int k;
                if (!tlist[i].getClassName().equals(beanName)) continue;
                LibInfoImpl[] l = tlist[i].getAttachments();
                int newLen = 0;
                newLen = l == null ? 1 : l.length + 1;
                LibInfoImpl[] l_new = new LibInfoImpl[newLen];
                for (k = 0; k < newLen - 1; ++k) {
                    if (l[k].getJarName().equals(jarName)) {
                        l_new = l;
                        break;
                    }
                    l_new[k] = l[k];
                }
                l_new[k] = new LibInfoImpl(null, null, null, null);
                l_new[k].setJarName(jarName);
                l_new[k].setNativeLibs(libs);
                tlist[i].setAttachments(l_new);
                VRegistry.writeTools(tlist);
                return l_new[k].getJarPath();
            }
        }
        if ((slist = VRegistry.readServices()) != null) {
            String jarName = VRegistry.toAttachedJarName(0, beanName, jarBasename);
            for (i = 0; i < slist.length; ++i) {
                int k;
                if (!slist[i].getClassName().equals(beanName)) continue;
                LibInfoImpl[] l = slist[i].getAttachments();
                int newLen = 0;
                newLen = l == null ? 1 : l.length + 1;
                LibInfoImpl[] l_new = new LibInfoImpl[newLen];
                for (k = 0; k < newLen - 1; ++k) {
                    if (l[k].getJarName().equals(jarName)) {
                        l_new = l;
                        break;
                    }
                    l_new[k] = l[k];
                }
                l_new[k] = new LibInfoImpl(null, null, null, null);
                l_new[k].setJarName(jarName);
                l_new[k].setNativeLibs(libs);
                slist[i].setAttachments(l_new);
                VRegistry.writeServices(slist);
                return l_new[k].getJarPath();
            }
        }
        if ((xcplist = VRegistry.readXCProviders()) != null) {
            String jarName = VRegistry.toAttachedJarName(0, beanName, jarBasename);
            for (i = 0; i < xcplist.length; ++i) {
                int k;
                if (!xcplist[i].getClassName().equals(beanName)) continue;
                LibInfoImpl[] l = xcplist[i].getAttachments();
                int newLen = 0;
                newLen = l == null ? 1 : l.length + 1;
                LibInfoImpl[] l_new = new LibInfoImpl[newLen];
                for (k = 0; k < newLen - 1; ++k) {
                    if (l[k].getJarName().equals(jarName)) {
                        l_new = l;
                        break;
                    }
                    l_new[k] = l[k];
                }
                l_new[k] = new LibInfoImpl(null, null, null, null);
                l_new[k].setJarName(jarName);
                l_new[k].setNativeLibs(libs);
                xcplist[i].setAttachments(l_new);
                VRegistry.writeXCProviders(xcplist);
                return l_new[k].getJarPath();
            }
        }
        return null;
    }

    public static String removeJarFromEntry(String beanName, String jarBasename) {
        ExternalClientProviderInfoImpl[] xcplist;
        ServiceInfoImpl[] slist;
        int i;
        LibInfoImpl[] shared = VRegistry.readAllLibJars();
        if (beanName.equals(GLOBAL) || beanName.equals(GLOBALTOOL) || beanName.equals(GLOBALSERVICE)) {
            if (shared.length == 0) {
                return null;
            }
            LibInfoImpl[] lessshared = new LibInfoImpl[shared.length - 1];
            String jarName = VRegistry.toAttachedJarName(-1, beanName, jarBasename);
            String jarPath = VRegistry.toFullJarPath(jarName);
            int k = 0;
            for (int j = 0; j < shared.length; ++j) {
                String oldJar = shared[j].getJarName();
                if (!oldJar.equals(jarName)) {
                    if (k == shared.length - 1) {
                        return null;
                    }
                    lessshared[k++] = shared[j];
                    continue;
                }
                VRegistry.deleteLibInfoObject(jarPath, shared[j]);
            }
            VRegistry.writeAllLibJars(lessshared);
            return jarPath;
        }
        ToolInfoImpl[] tlist = VRegistry.readTools();
        if (tlist != null) {
            String jarName = VRegistry.toAttachedJarName(0, beanName, jarBasename);
            String jarPath = VRegistry.toFullJarPath(jarName);
            for (i = 0; i < tlist.length; ++i) {
                if (!tlist[i].getClassName().equals(beanName)) continue;
                LibInfoImpl[] l = tlist[i].getAttachments();
                LibInfoImpl[] new_l = null;
                int newLen = 0;
                if (l == null || l.length == 0) {
                    return null;
                }
                newLen = l.length - 1;
                new_l = new LibInfoImpl[newLen];
                int x = 0;
                for (int p = 0; p < l.length; ++p) {
                    if (l[p].getJarName().equals(jarName)) {
                        VRegistry.deleteLibInfoObject(jarPath, l[p]);
                        continue;
                    }
                    if (x < newLen) {
                        new_l[x++] = l[p];
                        continue;
                    }
                    return null;
                }
                tlist[i].setAttachments(new_l);
                VRegistry.writeTools(tlist);
                return jarPath;
            }
        }
        if ((slist = VRegistry.readServices()) != null) {
            String jarName = VRegistry.toAttachedJarName(0, beanName, jarBasename);
            String jarPath = VRegistry.toFullJarPath(jarName);
            for (i = 0; i < slist.length; ++i) {
                if (!slist[i].getClassName().equals(beanName)) continue;
                LibInfoImpl[] l = slist[i].getAttachments();
                LibInfoImpl[] new_l = null;
                int newLen = 0;
                if (l == null || l.length == 0) {
                    return null;
                }
                newLen = l.length - 1;
                new_l = new LibInfoImpl[newLen];
                int x = 0;
                for (int p = 0; p < l.length; ++p) {
                    if (l[p].getJarName().equals(jarName)) {
                        VRegistry.deleteLibInfoObject(jarPath, l[p]);
                        continue;
                    }
                    if (x < newLen) {
                        new_l[x++] = l[p];
                        continue;
                    }
                    return null;
                }
                slist[i].setAttachments(new_l);
                VRegistry.writeServices(slist);
                return jarPath;
            }
        }
        if ((xcplist = VRegistry.readXCProviders()) != null) {
            String jarName = VRegistry.toAttachedJarName(0, beanName, jarBasename);
            String jarPath = VRegistry.toFullJarPath(jarName);
            for (i = 0; i < xcplist.length; ++i) {
                if (!xcplist[i].getClassName().equals(beanName)) continue;
                LibInfoImpl[] l = xcplist[i].getAttachments();
                LibInfoImpl[] new_l = null;
                int newLen = 0;
                if (l == null || l.length == 0) {
                    return null;
                }
                newLen = l.length - 1;
                new_l = new LibInfoImpl[newLen];
                int x = 0;
                for (int p = 0; p < l.length; ++p) {
                    if (l[p].getJarName().equals(jarName)) {
                        VRegistry.deleteLibInfoObject(jarPath, l[p]);
                        continue;
                    }
                    if (x < newLen) {
                        new_l[x++] = l[p];
                        continue;
                    }
                    return null;
                }
                xcplist[i].setAttachments(new_l);
                VRegistry.writeXCProviders(xcplist);
                return jarPath;
            }
        }
        return null;
    }

    private static void deleteLibInfoObject(String fileName, LibInfoImpl l) {
        String[] libs = l.getNativeLibs();
        if (libs != null) {
            String dirname = VRegistry.getViperRTHome() + "/" + Lib_Dir;
            for (int k = 0; k < libs.length; ++k) {
                String libName = dirname + libs[k];
                VRegistry.deleteFile(libName);
            }
        }
        VRegistry.deleteFile(fileName);
        l = null;
    }

    public static void deleteFile(String fname) {
        File oldfile = new File(fname);
        if (oldfile.exists()) {
            oldfile.delete();
        }
    }

    public static Hashtable getClassList() {
        Hashtable<String, String> classList = new Hashtable<String, String>(2729, 0.75f);
        String home = VRegistry.getViperRTHome();
        try {
            String aline;
            FileReader freader = new FileReader(home + ClassList_DB);
            BufferedReader reader = new BufferedReader(freader);
            while ((aline = reader.readLine()) != null) {
                String jpath;
                String pre;
                String str;
                int len = (aline = aline.trim()).length();
                if (len <= 0) continue;
                int i = aline.indexOf(58);
                int j = aline.indexOf(58, i + 1);
                if (i <= 0 || j <= i + 1 || j + 1 >= len) continue;
                String cfname = aline.substring(0, i).trim();
                String jfname = aline.substring(i + 1, j).trim();
                StringTokenizer tokens = new StringTokenizer(jfname, "@");
                if (tokens.countTokens() == 2 && (str = tokens.nextToken()).equalsIgnoreCase(GLOBALTOOL)) {
                    jfname = Tools_Dir + jfname;
                }
                if ((pre = classList.put(cfname, jpath = VRegistry.toFullJarPath(jfname))) == null) continue;
                String s = "Repository: class: " + cfname + " location is overridden by " + jpath;
                Debug.trace((String)"VRegistry", (int)Debug.WARNING, (String)s, null);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return classList;
    }
}

