/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viper.BeanNotFoundException;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Service;
import com.sun.management.viper.ServiceInfrastructure;
import com.sun.management.viper.VException;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.ContainerContext;
import com.sun.management.viperimpl.ExternalClientProviderInfoImpl;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.ServiceAgent;
import com.sun.management.viperimpl.ServiceContainer;
import com.sun.management.viperimpl.ServiceContextImpl;
import com.sun.management.viperimpl.ServiceInfoImpl;
import com.sun.management.viperimpl.ToolInfoImpl;
import com.sun.management.viperimpl.VCallerImpl;
import com.sun.management.viperimpl.server.ViperServer;
import com.sun.management.viperimpl.server.repository.ObjectFactory;
import com.sun.management.viperimpl.server.repository.RepositoryException;
import com.sun.management.viperimpl.server.repository.ServiceInstance;
import com.sun.management.viperimpl.server.repository.VRegistry;
import com.sun.management.viperimpl.services.authentication.server.AuthenticationLibrary;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class RepositoryService {
    private static final String REPOSITORY_RESOURCE = "com.sun.management.viperimpl.server.repository.RepositoryServiceResources";
    private static ResourceBundle resource = null;
    private static ServiceInfoImpl[] slist;
    private static ExternalClientProviderInfoImpl[] xcplist;
    private static Hashtable servicelist;
    private static Hashtable toollist;
    private static Properties allProperties;
    private static Properties allServiceProperties;
    private static Properties allToolProperties;
    private Hashtable activeServices = new Hashtable();
    private Hashtable cidTable = new Hashtable();
    private SecureRandom random = ViperServer.getRandom();
    private ObjectFactory factory = null;
    private ServiceInfrastructure infra = null;
    private ContainerContext cContext = null;
    private Date lastReloadTime = null;
    private String msg = null;
    private transient Service directService = null;
    private transient Hashtable directHandles = new Hashtable();

    public RepositoryService(String[] coreServices, ServiceInfrastructure inf, ContainerContext cManager) throws RepositoryException, CriticalStopException, BeanNotFoundException {
        try {
            resource = ResourceBundle.getBundle(REPOSITORY_RESOURCE);
        }
        catch (MissingResourceException mre) {
            System.err.println("Can't load repository resource.");
        }
        this.factory = new ObjectFactory();
        this.infra = inf;
        this.cContext = cManager;
        slist = VRegistry.readServices();
        for (int i = 0; i < slist.length; ++i) {
            servicelist.put(slist[i].getClassName(), slist[i]);
        }
        ToolInfoImpl[] tlist = VRegistry.readTools();
        for (int i = 0; i < tlist.length; ++i) {
            toollist.put(tlist[i].getClassName(), tlist[i]);
        }
        xcplist = VRegistry.readXCProviders();
        LibInfoImpl[] sharedJars = VRegistry.readAllLibJars();
        if (sharedJars != null) {
            Vector<String> sharedFiles = new Vector<String>();
            for (int i = 0; i < sharedJars.length; ++i) {
                if (sharedJars[i].getJarName().startsWith("tools/ALLTOOL@")) continue;
                sharedFiles.addElement(sharedJars[i].getJarPath());
            }
            String[] sharedJarFiles = sharedFiles.toArray(new String[0]);
            this.factory.setClassPath("ALL", sharedJarFiles);
        }
        allProperties = VRegistry.readAllProperties();
        allToolProperties = VRegistry.readAllToolProperties();
        allServiceProperties = VRegistry.readAllServiceProperties();
        this.lastReloadTime = new Date();
        for (int i = 0; i < coreServices.length; ++i) {
            Object o = this.createDirectHandle(coreServices[i], inf);
            if (o == null) continue;
            this.directHandles.put(coreServices[i], o);
        }
        this.loadDaemons(inf, slist);
    }

    private Object createDirectHandle(String servicename, ServiceInfrastructure inf) throws RepositoryException, CriticalStopException, BeanNotFoundException {
        this.directService = null;
        this.getServiceAgent(servicename, null, null);
        if (this.directService == null) {
            throw new BeanNotFoundException("ServiceNotFound", (Object)servicename);
        }
        return this.directService;
    }

    private void loadDaemons(ServiceInfrastructure inf, ServiceInfoImpl[] services) {
        for (int i = 0; i < services.length; ++i) {
            if (!services[i].isDaemon()) continue;
            try {
                this.getServiceAgent(services[i].getClassName(), null, null);
                continue;
            }
            catch (VException re) {
                Debug.trace((String)"Repository Service", (int)Debug.ERROR, (String)("Load daemon " + services[i].getClassName() + " error"), (Throwable)re);
            }
        }
    }

    public Object getCoreService(String name) {
        return this.directHandles.get(name);
    }

    public ToolInfoImpl getToolInfo(String name) throws BeanNotFoundException {
        String key;
        if (name == null) {
            throw new BeanNotFoundException("ToolNotFound", (Object)name);
        }
        ToolInfoImpl info = (ToolInfoImpl)toollist.get(name);
        if (info == null) {
            throw new BeanNotFoundException("ToolNotFound", (Object)name);
        }
        ToolInfoImpl result = (ToolInfoImpl)info.clone();
        Properties ps = new Properties(allProperties);
        Enumeration<?> e = allToolProperties.propertyNames();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            ps.setProperty(key, allToolProperties.getProperty(key));
        }
        Properties itsProperties = result.getProperties();
        Enumeration<?> e2 = itsProperties.propertyNames();
        while (e2.hasMoreElements()) {
            key = (String)e2.nextElement();
            ps.setProperty(key, itsProperties.getProperty(key));
        }
        result.setProperties(ps);
        return result;
    }

    public Vector getToolInfoList() {
        Vector<ToolInfoImpl> list = new Vector<ToolInfoImpl>(20, 10);
        Enumeration e = toollist.keys();
        while (e.hasMoreElements()) {
            String classname = (String)e.nextElement();
            try {
                list.addElement(this.getToolInfo(classname));
            }
            catch (BeanNotFoundException bnfe) {}
        }
        return list;
    }

    public ServiceInfoImpl[] getServiceInfo(String name) throws BeanNotFoundException {
        ServiceInfoImpl[] infos = this.findServiceInfo(name);
        if (infos == null) {
            throw new BeanNotFoundException("ServiceNotFound", (Object)name);
        }
        for (int i = 0; i < infos.length; ++i) {
            String key;
            ServiceInfoImpl si = (ServiceInfoImpl)infos[i].clone();
            Properties ps = new Properties(allProperties);
            Enumeration<?> e = allServiceProperties.propertyNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                ps.setProperty(key, allServiceProperties.getProperty(key));
            }
            Properties itsProperties = si.getProperties();
            Enumeration<?> e2 = itsProperties.propertyNames();
            while (e2.hasMoreElements()) {
                key = (String)e2.nextElement();
                ps.setProperty(key, itsProperties.getProperty(key));
            }
            si.setProperties(ps);
            infos[i] = si;
        }
        return infos;
    }

    public Vector getServiceInfoList() {
        Vector<ServiceInfoImpl> list = new Vector<ServiceInfoImpl>(20, 10);
        for (int i = 0; i < slist.length; ++i) {
            String classname = slist[i].getClassName();
            try {
                list.addElement(this.getServiceInfo(classname)[0]);
                continue;
            }
            catch (BeanNotFoundException e) {
                // empty catch block
            }
        }
        return list;
    }

    public ExternalClientProviderInfoImpl[] getExternalClientProviderInfo(String clientType) throws BeanNotFoundException {
        if (clientType == null) {
            throw new BeanNotFoundException("XCProviderNotFound", (Object)"null");
        }
        Vector<ExternalClientProviderInfoImpl> result = new Vector<ExternalClientProviderInfoImpl>();
        if (xcplist != null) {
            block0: for (int i = xcplist.length - 1; i >= 0; --i) {
                String[] types = xcplist[i].getClientTypes();
                if (types == null) continue;
                for (int j = 0; j < types.length; ++j) {
                    if (!types[j].equals(clientType)) continue;
                    result.add(xcplist[i]);
                    continue block0;
                }
            }
        }
        if (result.size() > 0) {
            return result.toArray(new ExternalClientProviderInfoImpl[0]);
        }
        throw new BeanNotFoundException("XCProviderNotFound", (Object)clientType);
    }

    public ServiceAgent getServiceAgent(String name, VCallerImpl creator, Vector loadingServices) throws BeanNotFoundException, CriticalStopException {
        ServiceInfoImpl[] infos = this.findServiceInfo(name);
        if (infos == null) {
            throw new BeanNotFoundException("ServiceNotFound", (Object)name);
        }
        String classname = null;
        ServiceInstance newSI = null;
        for (int retry = 0; retry < infos.length; ++retry) {
            Vector objs;
            ServiceInfoImpl info = infos[retry];
            classname = info.getClassName();
            if (info.isSingleton() && (objs = (Vector)this.activeServices.get(classname)) != null && objs.size() > 0) {
                ServiceInstance si = (ServiceInstance)objs.elementAt(0);
                this.directService = null;
                return si.newAgent(creator);
            }
            String[] depends = info.getLoadDependencies();
            if (depends != null && depends.length > 0) {
                for (int i = 0; i < depends.length; ++i) {
                    if (loadingServices == null) {
                        loadingServices = new Vector<String>();
                    }
                    if (loadingServices.contains(classname)) {
                        throw new CriticalStopException("DependencyDeadlock", (Object)name);
                    }
                    loadingServices.addElement(classname);
                    this.getServiceAgent(depends[i], creator, loadingServices);
                }
            }
            Object[] pair = this.factory.createCAPair(classname, info.getJarPaths());
            try {
                if (pair[0] == null || pair[1] == null) {
                    throw new CriticalStopException("ContainerAgentNotFound", (Object)name);
                }
                ServiceContainer sc = (ServiceContainer)((Object)pair[0]);
                ServiceAgent sa = (ServiceAgent)pair[1];
                sc.setContext(this.cContext);
                String processOwner = AuthenticationLibrary.getProcessOwnerName();
                VCallerImpl vcImpl = new VCallerImpl(processOwner, "SMC Service", InetAddress.getLocalHost().getHostName(), InetAddress.getLocalHost().getHostName(), null);
                ServiceContextImpl serviceContext = new ServiceContextImpl(null, info.getProperties(), vcImpl);
                this.directService = sc.create(this.infra, serviceContext);
                newSI = new ServiceInstance(sc, sa, creator);
                break;
            }
            catch (Throwable t) {
                Debug.trace((String)"RepositoryService", (int)Debug.WARNING, (String)("Cannot load service implementation " + info.getClassName()), (Throwable)t);
                String[] fargs = new String[]{info.getClassName(), t.toString()};
                ViperServer.writeLog("LMS_RepositoryName", 300, "LMS_ServiceFailed", "LMD_ServiceFailed", fargs, REPOSITORY_RESOURCE, null);
                continue;
            }
        }
        if (newSI == null) {
            throw new CriticalStopException("InitStartBeanFailed", (Object)name);
        }
        Vector<ServiceInstance> instances = (Vector<ServiceInstance>)this.activeServices.get(classname);
        if (instances == null) {
            instances = new Vector<ServiceInstance>(1);
            instances.addElement(newSI);
            this.activeServices.put(classname, instances);
        } else {
            instances.addElement(newSI);
        }
        ServiceAgent sag = newSI.newAgent(creator);
        return sag;
    }

    public String getToolJarName(String name) throws BeanNotFoundException {
        ToolInfoImpl ti = (ToolInfoImpl)toollist.get(name);
        if (ti == null) {
            throw new BeanNotFoundException("ToolNotFound", (Object)name);
        }
        return ti.getJarName();
    }

    public void unload() {
        Enumeration e = this.activeServices.keys();
        while (e.hasMoreElements()) {
            String beanName = (String)e.nextElement();
            ServiceInfoImpl si = (ServiceInfoImpl)servicelist.get(beanName);
            Vector instances = (Vector)this.activeServices.remove(beanName);
            if (instances == null) continue;
            for (int i = 0; i < instances.size(); ++i) {
                ServiceInstance inst = (ServiceInstance)instances.elementAt(i);
                ServiceContainer sc = inst.getContainer();
                try {
                    sc.stop();
                    sc.destroy();
                    continue;
                }
                catch (Exception ex) {
                    Debug.trace((String)"Repository Service", (int)Debug.ERROR, (String)"upload services error", (Throwable)ex);
                }
            }
        }
    }

    public void register(byte[] jar) throws RemoteException, RepositoryException {
    }

    public void unregister(String beanName) throws RemoteException, RepositoryException {
    }

    public String getMessage(String key, String param1) {
        if (param1 != null) {
            Object[] fargs = new Object[]{param1};
            return this.getMessage(key, fargs);
        }
        return this.getMessage(key, (Object[])null);
    }

    public String getMessage(String key, Object[] params) {
        if (key == null) {
            return null;
        }
        String result = resource == null ? key : resource.getString(key);
        if (params != null && params.length > 0) {
            try {
                result = MessageFormat.format(result, params);
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        return result;
    }

    public ServiceInfoImpl[] findServiceInfo(String serviceName) {
        if (serviceName == null) {
            return null;
        }
        Vector<ServiceInfoImpl> result = new Vector<ServiceInfoImpl>();
        block0: for (int i = slist.length - 1; i >= 0; --i) {
            if (slist[i].getClassName().equals(serviceName)) {
                result.add(slist[i]);
                continue;
            }
            String[] interfaces = slist[i].getInterfaces();
            for (int j = 0; j < interfaces.length; ++j) {
                if (!interfaces[j].equals(serviceName)) continue;
                result.add(slist[i]);
                continue block0;
            }
        }
        if (result.size() > 0) {
            return result.toArray(new ServiceInfoImpl[0]);
        }
        return null;
    }

    static {
        servicelist = new Hashtable();
        toollist = new Hashtable();
    }
}

