/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server.repository;

import com.sun.management.viperimpl.ExternalClientProviderInfoImpl;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.ServiceInfoImpl;
import com.sun.management.viperimpl.ToolInfoImpl;
import com.sun.management.viperimpl.server.repository.VRegistry;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class InfoPrinter {
    public static void usage() {
        System.out.println("InfoPrinter");
        System.out.println("\tList all entries in the registry.");
    }

    public static void main(String[] argv) {
        if (argv.length != 0) {
            InfoPrinter.usage();
            System.exit(1);
        }
        try {
            LibInfoImpl[] l;
            String[] libs;
            int i;
            String printMsg;
            Vector all = new Vector();
            Vector allTool = new Vector();
            Vector allService = new Vector();
            ServiceInfoImpl[] allsi = VRegistry.readServices();
            ToolInfoImpl[] allti = VRegistry.readTools();
            ExternalClientProviderInfoImpl[] allxcpi = VRegistry.readXCProviders();
            LibInfoImpl[] shared = VRegistry.readAllLibJars();
            Properties allProperties = VRegistry.readAllProperties();
            Properties allToolProperties = VRegistry.readAllToolProperties();
            Properties allServiceProperties = VRegistry.readAllServiceProperties();
            if (allxcpi != null && allxcpi.length > 0) {
                Object[] fargs11 = new Object[]{new Integer(allxcpi.length).toString()};
                printMsg = ImplResourceManager.getFormattedString("print_lbl0", fargs11);
                System.out.println("\n" + printMsg);
                for (int i2 = 0; i2 < allxcpi.length; ++i2) {
                    System.out.println("\n\t" + allxcpi[i2].getClassName());
                    InfoPrinter.printXClientTypes(allxcpi[i2].getClientTypes());
                    InfoPrinter.printProperties(allxcpi[i2].getProperties(), 2);
                    String[] libs2 = allxcpi[i2].getNativeLibs();
                    InfoPrinter.printNativeLibs(libs2, true);
                    LibInfoImpl[] l2 = allxcpi[i2].getAttachments();
                    InfoPrinter.printAttachments(l2);
                }
            } else {
                Object[] fargs12 = new Object[]{"NO"};
                printMsg = ImplResourceManager.getFormattedString("print_lbl0", fargs12);
                System.out.println("\n" + printMsg);
            }
            Object[] fargs = new Object[]{new Integer(allProperties.size()).toString(), "ALL"};
            printMsg = ImplResourceManager.getFormattedString("print_lbl1", fargs);
            System.out.println("\n" + printMsg);
            InfoPrinter.printProperties(allProperties, 1);
            Object[] fargs1 = new Object[]{new Integer(allToolProperties.size()).toString(), "ALLTOOL"};
            printMsg = ImplResourceManager.getFormattedString("print_lbl1", fargs1);
            System.out.println("\n" + printMsg);
            InfoPrinter.printProperties(allToolProperties, 1);
            Object[] fargs2 = new Object[]{new Integer(allServiceProperties.size()).toString(), "ALLSERVICE"};
            printMsg = ImplResourceManager.getFormattedString("print_lbl1", fargs2);
            System.out.println("\n" + printMsg);
            InfoPrinter.printProperties(allServiceProperties, 1);
            InfoPrinter.parseSharedLib(shared, all, allTool, allService);
            if (all != null && all.size() > 0) {
                Object[] fargs3 = new Object[]{new Integer(all.size()).toString(), "ALL"};
                printMsg = ImplResourceManager.getFormattedString("print_lbl2", fargs3);
                System.out.println("\n" + printMsg);
                InfoPrinter.printGlobalJars(all);
            } else {
                Object[] fargs4 = new Object[]{"NO", "ALL"};
                printMsg = ImplResourceManager.getFormattedString("print_lbl2", fargs4);
                System.out.println("\n" + printMsg);
            }
            int globalLib = 0;
            if (allService != null) {
                globalLib += allService.size();
            }
            if (globalLib > 0) {
                Object[] fargs5 = new Object[]{new Integer(globalLib).toString(), "ALLSERVICE"};
                printMsg = ImplResourceManager.getFormattedString("print_lbl2", fargs5);
                System.out.println("\n" + printMsg);
                if (allService != null) {
                    InfoPrinter.printGlobalJars(allService);
                }
            } else {
                Object[] fargs6 = new Object[]{"NO", "ALLSERVICE"};
                printMsg = ImplResourceManager.getFormattedString("print_lbl2", fargs6);
                System.out.println("\n" + printMsg);
            }
            if (allsi != null && allsi.length > 0) {
                Object[] fargs7 = new Object[]{new Integer(allsi.length).toString()};
                printMsg = ImplResourceManager.getFormattedString("print_lbl3", fargs7);
                System.out.println("\n" + printMsg);
                for (i = 0; i < allsi.length; ++i) {
                    System.out.println("\n\t" + allsi[i].getClassName());
                    InfoPrinter.printInterfaces(allsi[i].getInterfaces());
                    InfoPrinter.printProperties(allsi[i].getProperties(), 2);
                    libs = allsi[i].getNativeLibs();
                    InfoPrinter.printNativeLibs(libs, true);
                    l = allsi[i].getAttachments();
                    InfoPrinter.printAttachments(l);
                }
            } else {
                Object[] fargs8 = new Object[]{"NO"};
                printMsg = ImplResourceManager.getFormattedString("print_lbl3", fargs8);
                System.out.println("\n" + printMsg);
            }
            globalLib = 0;
            if (allTool != null) {
                globalLib += allTool.size();
            }
            if (globalLib > 0) {
                Object[] fargs9 = new Object[]{new Integer(globalLib).toString(), "ALLTOOL"};
                printMsg = ImplResourceManager.getFormattedString("print_lbl2", fargs9);
                System.out.println("\n" + printMsg);
                if (allTool != null) {
                    InfoPrinter.printGlobalJars(allTool);
                }
            } else {
                Object[] fargs10 = new Object[]{"NO", "ALLTOOL"};
                printMsg = ImplResourceManager.getFormattedString("print_lbl2", fargs10);
                System.out.println("\n" + printMsg);
            }
            if (allti != null && allti.length > 0) {
                Object[] fargs11 = new Object[]{new Integer(allti.length).toString()};
                printMsg = ImplResourceManager.getFormattedString("print_lbl4", fargs11);
                System.out.println("\n" + printMsg);
                for (i = 0; i < allti.length; ++i) {
                    System.out.println("\n\t" + allti[i].getClassName());
                    InfoPrinter.printProperties(allti[i].getProperties(), 2);
                    libs = allti[i].getNativeLibs();
                    InfoPrinter.printNativeLibs(libs, true);
                    l = allti[i].getAttachments();
                    InfoPrinter.printAttachments(l);
                }
            } else {
                Object[] fargs12 = new Object[]{"NO"};
                printMsg = ImplResourceManager.getFormattedString("print_lbl4", fargs12);
                System.out.println("\n" + printMsg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(ImplResourceManager.getString("print_lbl5"));
            System.exit(1);
        }
        System.exit(0);
    }

    private static void printInterfaces(String[] list) {
        System.out.println("\t\t" + ImplResourceManager.getString("print_lbl8") + " = {");
        for (int y = 0; y < list.length; ++y) {
            System.out.println("\t\t\t" + list[y]);
        }
        System.out.println("\t\t}");
    }

    private static void printXClientTypes(String[] list) {
        System.out.print("\t\t" + ImplResourceManager.getString("print_lbl9") + " = { ");
        for (int y = 0; y < list.length; ++y) {
            if (y > 0) {
                System.out.print(", ");
            }
            System.out.print(list[y]);
        }
        System.out.println(" }");
    }

    private static void printNativeLibs(String[] l, boolean flag) {
        if (l != null) {
            String nativeLibs = "";
            for (int j = 0; j < l.length; ++j) {
                nativeLibs = nativeLibs + l[j];
                nativeLibs = nativeLibs + " ";
            }
            if ((nativeLibs = nativeLibs.trim()).length() > 0) {
                if (flag) {
                    System.out.println("\t\t" + ImplResourceManager.getString("print_lbl6") + " = " + nativeLibs);
                } else {
                    System.out.println("\t\t\t\t" + ImplResourceManager.getString("print_lbl6") + " = " + nativeLibs);
                }
            }
        }
    }

    private static void printGlobalJars(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            LibInfoImpl l = (LibInfoImpl)v.get(i);
            System.out.println("\t" + InfoPrinter.baseName(l.getJarName()));
            String[] nL = l.getNativeLibs();
            InfoPrinter.printNativeLibs(nL, false);
            InfoPrinter.printProperties(l.getProperties(), 2);
        }
    }

    private static void printAttachments(LibInfoImpl[] l) {
        if (l != null) {
            for (int y = 0; y < l.length; ++y) {
                System.out.println("\t\t" + ImplResourceManager.getString("print_lbl7") + " = " + InfoPrinter.baseName(l[y].getJarName()));
                String[] nL = l[y].getNativeLibs();
                InfoPrinter.printNativeLibs(nL, false);
                InfoPrinter.printProperties(l[y].getProperties(), 4);
            }
        }
    }

    private static String baseName(String filename) {
        int i = filename.indexOf(64);
        if (i >= 0) {
            return filename.substring(i + 1);
        }
        return filename;
    }

    private static void printProperties(Properties p, int tabSpace) {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (tabSpace == 1) {
                System.out.println("\t" + s + "=" + p.getProperty(s));
                continue;
            }
            if (tabSpace == 2) {
                System.out.println("\t\t" + s + "=" + p.getProperty(s));
                continue;
            }
            if (tabSpace != 4) continue;
            System.out.println("\t\t\t\t" + s + "=" + p.getProperty(s));
        }
    }

    private static void parseSharedLib(LibInfoImpl[] l, Vector all, Vector allTool, Vector allService) {
        for (int i = 0; i < l.length; ++i) {
            String jarName = l[i].getJarName();
            if (jarName.startsWith("tools/ALLTOOL@")) {
                allTool.addElement(l[i]);
                continue;
            }
            if (jarName.startsWith("services/ALLSERVICE@")) {
                allService.addElement(l[i]);
                continue;
            }
            all.addElement(l[i]);
        }
    }
}

