/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server;

import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.VException;
import com.sun.management.viper.VIdentity;
import com.sun.management.viper.VPermission;
import com.sun.management.viper.services.AuthorizationException;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viper.util.VDebug;
import com.sun.management.viperimpl.ConnectionInfo;
import com.sun.management.viperimpl.SMCVersion;
import com.sun.management.viperimpl.VSecurityManager;
import com.sun.management.viperimpl.server.Registry;
import com.sun.management.viperimpl.server.ViperCommandClient;
import com.sun.management.viperimpl.server.ViperCommandServer;
import com.sun.management.viperimpl.server.ViperImpl;
import com.sun.management.viperimpl.servlet.ServletServer;
import com.sun.management.viperimpl.util.SimpleDebugger;
import com.sun.management.viperimpl.util.UnixFileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;

public class ViperServer {
    public static final String PN_VIPER_HOME = "viper.home";
    public static final String PN_VIPER_RTHOME = "viper.rthome";
    public static final String PN_VIPER_PORT = "viper.servlet.port";
    public static final String PN_VIPER_URL = "viper.server.url";
    public static final String SMC_BOOT_DELIM = "@#@";
    static final String SERVER_RESOURCE = "com.sun.management.viperimpl.server.ViperServerResources";
    static final String SERVER_NAME = "LMS_ServerName";
    static final String VIPER_RMI_PREFIX = "Viper";
    static final String SERVER_TEMP_BASE = "/var/run/smc";
    static final int DEFAULT_SERVLET_PORT = 898;
    static final String SERVER_CONFIG_FILE1 = "/etc/smc/smcserver.config";
    static final String SERVER_CONFIG_FILE2 = "/policy/smcserver.config";
    static final VPermission PERMISSION_DEFAULTPORT = new VPermission("solaris.smc.server.defport");
    private static int ServletPort = 898;
    static String ServerTempDir = "/var/run/smc";
    private static String ServerRMIName = "Viper";
    private static String Viper_Home = "/usr/sadm/lib/smc";
    private static String Viper_RTHome = "/var/sadm/smc";
    private static ServletServer webserver = null;
    private static String WEB_DIR = "/htdocs";
    private static ViperImpl viper = null;
    public static Remote viperRemote = null;
    private static SecureRandom rand = null;
    private static ResourceBundle resource = null;
    static Date serverStartDate = null;
    private static OutputStream fifoStream = null;
    private static String msg = null;
    private static int debugLevel;
    private static final int RANDOM_KEYSIZE = 20;

    public static void main(String[] args) {
        ViperServer.init(args);
        ViperServer.start();
    }

    public static void init(String[] args) {
        Object[] fargs;
        String stemp;
        CommandParser scp;
        ViperServer.stampMessage("starting up");
        serverStartDate = new Date();
        String argv0 = System.getProperty("viper.argv0");
        if (argv0 == null) {
            argv0 = "smcserver";
        }
        VSCommandParser parser = new VSCommandParser(argv0, ViperServer.getMessage("vservername", null), false, System.in, System.out);
        CommandOption debugOption = new CommandOption("debug", ViperServer.getMessage("debugoption", null), new String[]{"d", "debug"}, 2, true, false, null, false);
        debugOption.setHidden(true);
        CommandOption portOption = new CommandOption("port", ViperServer.getMessage("portoption", null), new String[]{"p", "port"}, 2, true, false, null, false);
        CommandOption helpOption = new CommandOption("help", ViperServer.getMessage("helpoption", null), new String[]{"h", "help"}, 0, true, false, null, false);
        helpOption.setPriority(true);
        CommandOption forceStartOption = new CommandOption("force", ViperServer.getMessage("forceStartoption", null), new String[]{"f", "force"}, 0, true, false, null, false);
        forceStartOption.setHidden(true);
        CommandParser startCmd = new CommandParser("start", ViperServer.getMessage("startcmddesc", null), true, System.in, System.out);
        CommandParser stopCmd = new CommandParser("stop", ViperServer.getMessage("stopcmddesc", null), true, System.in, System.out);
        CommandParser statusCmd = new CommandParser("status", ViperServer.getMessage("statuscmddesc", null), true, System.in, System.out);
        parser.addOption(debugOption);
        parser.addOption(helpOption);
        parser.addOption(forceStartOption);
        parser.addOption(portOption);
        parser.addSubCommand(statusCmd);
        parser.addSubCommand(startCmd);
        parser.addSubCommand(stopCmd);
        if (parser.parseArgs(args)) {
            if (portOption.wasSet()) {
                System.setProperty(PN_VIPER_PORT, ((Integer)portOption.getValue()).toString());
            } else {
                System.setProperty(PN_VIPER_PORT, new Integer(898).toString());
            }
        } else {
            ViperServer.exit("argument_err", null, 1);
        }
        if (helpOption.wasSet()) {
            parser.printUsage(null);
            System.exit(0);
        }
        if (debugOption.wasSet()) {
            Debug.setDebugImpl((VDebug)new SimpleDebugger());
            debugLevel = (Integer)debugOption.getValue();
            Debug.setDebugLevel((int)debugLevel);
        }
        if ((scp = parser.getSubCommand()) == null) {
            scp = startCmd;
        }
        if (!scp.getName().equals("start")) {
            String[] line = parser.getSubCommandLine();
            ViperCommandClient.main(line);
        }
        if (System.getSecurityManager() == null) {
            try {
                System.setSecurityManager(new VSecurityManager());
            }
            catch (Exception e) {
                ViperServer.exit("exit_nosecuritymanager", null, 1);
            }
        }
        if ((stemp = System.getProperty(PN_VIPER_HOME)) != null) {
            Viper_Home = stemp;
        } else {
            System.setProperty(PN_VIPER_HOME, Viper_Home);
        }
        stemp = System.getProperty(PN_VIPER_RTHOME);
        if (stemp != null) {
            Viper_RTHome = stemp;
        } else {
            System.setProperty(PN_VIPER_RTHOME, Viper_RTHome);
        }
        new File(Viper_RTHome).mkdir();
        Integer sport = Integer.getInteger(PN_VIPER_PORT);
        if (sport != null) {
            ServletPort = sport;
        }
        ServerTempDir = SERVER_TEMP_BASE + ServletPort;
        ServerRMIName = VIPER_RMI_PREFIX + ServletPort;
        if (scp.getName().equals("start")) {
            File dirFile = new File(ServerTempDir);
            if (dirFile.exists() && !forceStartOption.wasSet()) {
                fargs = new Object[]{SMCVersion.getFullVersion(), Integer.toString(ServletPort)};
                ViperServer.exit("ServerStatus", fargs, 0);
            }
            fargs = new Object[]{SMCVersion.getFullVersion()};
            System.out.println(ViperServer.getMessage("start_server", fargs));
        }
        try {
            InetAddress thisAddress = InetAddress.getLocalHost();
            String localHostName = thisAddress.getHostAddress();
            String viperURL = "http://" + localHostName + ":" + ServletPort + "/";
            System.setProperty(PN_VIPER_URL, viperURL);
            System.setProperty("java.rmi.server.codebase", viperURL + "vipercodebase/");
            System.setProperty("java.rmi.server.useCodebaseOnly", "true");
            ViperServer.sendReadyAndTest(ServletPort);
            if (fifoStream == null) {
                ViperServer.cleanTempDir();
                if (!UnixFileUtilities.mkdir(ServerTempDir, 448)) {
                    Object[] fargs2 = new String[]{ServerTempDir};
                    String msg = ViperServer.getMessage("tmpdir_failed", fargs2);
                    throw new SecurityException(msg);
                }
            }
            File cb = new File(Viper_Home + WEB_DIR);
            ViperServer.stampMessage("About to new ServletServer()");
            webserver = new ServletServer(ServletPort, cb.toURL(), ServerTempDir);
            ViperServer.stampMessage("ServletServer created");
        }
        catch (UnknownHostException e) {
            ViperServer.exit("exit_nocodebase", null, 1);
        }
        catch (MalformedURLException mue) {
            ViperServer.exit("exit_nowebdir", null, 1);
        }
        catch (IOException ioe) {
            fargs = new Object[]{Integer.toString(ServletPort), ioe.getLocalizedMessage()};
            ViperServer.exit("exit_noport", fargs, 1);
        }
        catch (SecurityException se) {
            ViperServer.exit("exit_notemp", null, 1);
        }
        catch (CriticalStopException cse) {
            Debug.trace((String)"ViperServer", (int)Debug.ERROR, (String)"Http server cannot be started", (Throwable)cse);
            ViperServer.exit("exit_nowebserver", null, 1);
        }
        catch (IllegalArgumentException iae) {
            ViperServer.exit("exit_badport", null, 1);
        }
        catch (Throwable t) {
            ViperServer.exit("exit_unknown", null, 1);
        }
    }

    public static void start() {
        Object[] fargs;
        try {
            Registry.doEverything();
        }
        catch (Throwable t) {
            Object[] fargs2 = new Object[]{t.toString()};
            ViperServer.exit("exit_preregfailed", fargs2, 1);
        }
        Properties config = null;
        try {
            String configfile = SERVER_CONFIG_FILE1;
            if (!new File(configfile).exists()) {
                configfile = Viper_Home + SERVER_CONFIG_FILE2;
            }
            FileInputStream config_fis = new FileInputStream(configfile);
            config = new Properties();
            config.load(config_fis);
            config_fis.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            viper = new ViperImpl(config);
            viperRemote = UnicastRemoteObject.toStub(viper);
        }
        catch (VException ve) {
            ViperServer.cleanTempDir();
            fargs = new Object[]{ve.getLocalizedMessage()};
            ViperServer.exit("exit_initfailed", fargs, 1);
        }
        catch (RemoteException e) {
            ViperServer.cleanTempDir();
            fargs = new Object[]{e.getMessage()};
            ViperServer.exit("exit_noremote", fargs, 1);
        }
        ViperServer.sendDone(ServletPort);
        ViperCommandServer vct = new ViperCommandServer(viper);
        vct.start();
        fargs = new String[]{Integer.toString(ServletPort)};
        ViperServer.writeLog("LMS_ServerStartup", "LMD_ServerStartup", (String[])fargs, 100);
        ViperServer.stampMessage("SMC server is ready");
        System.out.println(ViperServer.getMessage("serverready", null));
        System.out.println("0");
        rand = ViperServer.getRandom();
        rand.nextLong();
    }

    public static SecureRandom getRandom() {
        if (rand == null) {
            byte[] seed = ViperServer.getSeed();
            rand = new SecureRandom(seed);
        }
        return rand;
    }

    private static synchronized byte[] getSeed() {
        byte[] kb1 = new byte[20];
        byte[] kb2 = new byte[20];
        byte[] seed = new byte[20];
        long time = System.currentTimeMillis();
        Random seeder = new Random(time);
        seeder.nextBytes(kb1);
        seeder.nextBytes(kb2);
        time = System.currentTimeMillis();
        long mask = 1L;
        long test = 0L;
        for (int i = 0; i < 20; ++i) {
            test = time & mask;
            seed[i] = test > 0L ? kb1[i] : kb2[i];
            mask <<= 1;
        }
        return seed;
    }

    public static void checkPermission(VIdentity user, VPermission perm) throws RemoteException, AuthorizationException {
        viper.checkPermission(user, perm);
    }

    static void exitServer(VIdentity caller, int exitval) throws VException {
        if (ServletPort == 898) {
            try {
                ViperServer.checkPermission(caller, PERMISSION_DEFAULTPORT);
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
        String[] fargs = new String[]{Integer.toString(ServletPort)};
        ViperServer.writeLog("LMS_ServerShutdown", "LMD_ServerShutdown", fargs, 100);
        viper.onExit();
        ViperServer.cleanTempDir();
        System.exit(exitval);
    }

    public static ConnectionInfo[] getUsageInfo() throws RemoteException, VException {
        return viper.getCurrentConnectionList();
    }

    private static void cleanTempDir() {
        ViperServer.recursiveDelete(new File(ServerTempDir), 2);
    }

    private static void recursiveDelete(File dir, int max_hop) {
        if (dir != null && dir.exists()) {
            File[] subs;
            if (max_hop > 0 && dir.isDirectory() && (subs = dir.listFiles()) != null) {
                for (int i = 0; i < subs.length; ++i) {
                    ViperServer.recursiveDelete(subs[i], max_hop - 1);
                }
            }
            if (!dir.delete()) {
                String msg = ViperServer.getMessage("tmpdir_rmfailed", new Object[]{dir});
                throw new SecurityException(msg);
            }
        }
    }

    protected static void stampMessage(String msg) {
        if (debugLevel > 1) {
            System.err.println("server " + ViperServer.timestamp() + ": " + msg);
        }
    }

    public static String timestamp() {
        long t = System.currentTimeMillis();
        long sec = (t - t % 1000L) / 1000L;
        long usec = t % 1000L;
        return "" + sec + "." + (usec < 10L ? "00" : (usec < 100L ? "0" : "")) + usec + "000";
    }

    static void openFIFO() {
        if (fifoStream != null) {
            return;
        }
        String fifoPath = System.getProperty("viper.fifo.path");
        if (fifoPath == null) {
            return;
        }
        File fifo = new File(fifoPath);
        if (!fifo.exists()) {
            return;
        }
        try {
            fifoStream = new FileOutputStream(fifo);
        }
        catch (IOException e) {
            Debug.trace((String)"server", (int)1, (String)"Failed to open FIFO", (Throwable)e);
        }
    }

    static void closeFIFO() {
        if (fifoStream == null) {
            return;
        }
        try {
            fifoStream.close();
        }
        catch (IOException e) {
            Debug.trace((String)"server", (int)1, (String)"Failed to close FIFO", (Throwable)e);
        }
        fifoStream = null;
    }

    static void sendReadyAndTest(int port) throws IOException {
        if (fifoStream == null) {
            return;
        }
        try {
            Debug.trace((String)"server", (int)0, (String)("Sending READY to parent (port " + port + ")"), null);
            String readymsg = "READY" + port + SMC_BOOT_DELIM;
            fifoStream.write(readymsg.getBytes());
        }
        catch (IOException e) {
            Debug.trace((String)"server", (int)1, (String)"Failed to write to FIFO", (Throwable)e);
        }
        boolean socketAvailable = false;
        int times = 0;
        int timeout = 250;
        while (!socketAvailable && timeout <= 60000) {
            try {
                ++times;
                new ServerSocket(port).close();
                socketAvailable = true;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(timeout);
                    timeout *= 2;
                }
                catch (Exception e1) {}
            }
        }
        ViperServer.stampMessage("Tried socket " + times + " times.");
        new ServerSocket(port).close();
    }

    static void sendDone(int port) {
        if (fifoStream == null) {
            return;
        }
        try {
            Debug.trace((String)"server", (int)0, (String)("Sending DONE to parent (port " + port + ")"), null);
            String donemsg = "DONE" + port + SMC_BOOT_DELIM;
            fifoStream.write(donemsg.getBytes());
        }
        catch (IOException e) {
            Debug.trace((String)"server", (int)1, (String)"Failed to write to FIFO", (Throwable)e);
        }
    }

    static String getMessage(String msg, Object[] args) {
        if (msg == null) {
            return null;
        }
        String result = msg;
        try {
            result = resource.getString(result);
            result = MessageFormat.format(result, args);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    static void exit(String msg, Object[] args, int exitCode) {
        if (msg != null) {
            System.out.println(ViperServer.getMessage(msg, args));
        }
        System.out.println(exitCode);
        System.exit(exitCode);
    }

    private static void writeLog(String sumKey, String detKey, String[] fargs, int severity) {
        ViperImpl.writeBufferedLog(SERVER_NAME, "system", severity, sumKey, detKey, fargs, SERVER_RESOURCE, null);
    }

    public static void writeLog(String source, int severity, String sumKey, String detKey, String[] fargs, String resource, String data) {
        ViperImpl.writeBufferedLog(source, "system", severity, sumKey, detKey, fargs, resource, data);
    }

    public static Date getServerStartDate() {
        return serverStartDate;
    }

    public static int getServletPort() {
        return ServletPort;
    }

    static {
        ResourceManager.seed((boolean)false);
        try {
            resource = ResourceBundle.getBundle(SERVER_RESOURCE);
        }
        catch (MissingResourceException mre) {
            System.out.println("Can't load server resource.");
        }
    }

    static class VSCommandParser
    extends CommandParser {
        public VSCommandParser(String commandName, String commandDesc, boolean ignoreUnknowns, InputStream inStream, PrintStream outStream) {
            super(commandName, commandDesc, ignoreUnknowns, inStream, outStream);
        }

        public void printUsage(String err) {
            this.outStream.println(this.commandDesc);
            if (err != null) {
                this.outStream.println(CommandParser.getMessage((String)"Error: {0}", (Object[])new String[]{err}));
            }
            this.outStream.println(CommandParser.getMessage((String)"Usage: {0} [flags] command [flags]", (Object[])new String[]{this.commandName}));
            this.outStream.println("\n" + CommandParser.getMessage((String)"Common flags:"));
            for (int i = 0; i < this.commandOptions.size(); ++i) {
                CommandOption o = (CommandOption)this.commandOptions.elementAt(i);
                if (o.getName() == "port") {
                    this.outStream.println("\t-p, --port PORT  " + o.getDescription());
                    continue;
                }
                if (o.getName() != "help") continue;
                this.outStream.println("\t-h, --help       " + o.getDescription());
            }
            this.outStream.println("\n" + CommandParser.getMessage((String)"Commands:"));
            for (String key : this.subCommands.keySet()) {
                String d = ((CommandParser)this.subCommands.get(key)).getDescription();
                this.outStream.println("\t" + key + "\t         " + d);
            }
        }
    }
}

