/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.config.FolderNode;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.config.VBaseNode;
import com.sun.management.viperimpl.console.config.toolInf;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.w3c.dom.Node;

public class addtool
implements toolInf {
    private CommandOption scopeOption = new CommandOption("scope", "Scope of tool", "S", 1, true, false, null, false);
    private CommandOption serverOption = new CommandOption("server", "Server where tool is located", "s", 1, true, false, (Object)"localhost", false);
    private CommandOption classOption = new CommandOption("class", "Class name of tool", "c", 1, true, false, null, false);
    private CommandOption propsOption = new CommandOption("key:value", "Properties", "p", 1, true, true, null, false);
    private CommandOption folderOption = new CommandOption("folder path", "Folder Path", "F", 1, true, true, null, false);
    private CommandOption tbxOption = new CommandOption("tbxURL", "ToolBox URL", "t", 1, true, false, null, false);
    private CommandOption loadOption = new CommandOption("load", "Load on console init", "l", 0, true, false, null, false);
    private CommandOption bgOption = new CommandOption("background", "Don't block on load", "b", 0, true, false, null, false);
    private CommandOption NameOption = new CommandOption("Folder/Toolbox Name", "Folder/Toolbox Name", "n", 1, true, false, null, false);
    private CommandOption DescOption = new CommandOption("Folder/Toolbox Description", "Folder/Toolbox Description", "d", 1, true, false, null, false);
    private CommandOption SmallIconOption = new CommandOption("Folder/Toolbox Small Icon", "Folder/Toolbox Small Icon", "m", 1, true, false, null, false);
    private CommandOption LargeIconOption = new CommandOption("Folder Large Icon", "Folder Large Icon", "L", 1, true, false, null, false);
    private CommandOption helpOption = new CommandOption("help", "Help", "h", 0, true, false, null, false);
    private CommandOption fileinOption = new CommandOption("in-file", "Input file", "f", 1, false, false, null, false);
    private CommandOption fileoutOption = new CommandOption("out-file", "Output file", "o", 1, true, false, (Object)"-", false);
    private static String folderName = "/";
    private static String legacyToolName = "LegacyAppTool.client.LaunchLegacyAppTool";
    private int retVal = -99;

    public int getExecStatus() {
        return this.retVal;
    }

    private void setExecStatus(int status) {
        if (this.retVal == -99) {
            this.retVal = status;
        }
    }

    public void exec(String[] args) throws Exception {
        int portIndex;
        ResourceManager.seed((boolean)false);
        CommandParser cp = new CommandParser("addtool", "Tool to add tools", true, System.in, System.out);
        cp.addOption(this.fileinOption);
        cp.addOption(this.fileoutOption);
        cp.addOption(this.scopeOption);
        cp.addOption(this.serverOption);
        cp.addOption(this.classOption);
        cp.addOption(this.propsOption);
        cp.addOption(this.tbxOption);
        cp.addOption(this.folderOption);
        cp.addOption(this.loadOption);
        cp.addOption(this.NameOption);
        cp.addOption(this.DescOption);
        cp.addOption(this.SmallIconOption);
        cp.addOption(this.LargeIconOption);
        cp.addOption(this.helpOption);
        String fileout = null;
        String classname = null;
        String scope = null;
        String servername = null;
        String tbxURL = null;
        String folder = null;
        Properties props = new Properties();
        int serverPort = -1;
        if (!cp.parseArgs(args)) {
            this.retVal = 1;
            throw new Exception("Failed to parse args");
        }
        if (this.helpOption.wasSet()) {
            this.retVal = 0;
            throw new Exception(cp.getUsage(null));
        }
        String filein = (String)this.fileinOption.getValue();
        OutputStream outStream = System.out;
        try {
            if (this.fileoutOption.wasSet()) {
                fileout = (String)this.fileoutOption.getValue();
                outStream = new FileOutputStream(fileout);
            }
        }
        catch (Exception e) {
            this.retVal = 1;
            throw new Exception("\n" + e + "\n");
        }
        if (this.scopeOption.wasSet()) {
            scope = (String)this.scopeOption.getValue();
        }
        if (this.tbxOption.wasSet()) {
            tbxURL = (String)this.tbxOption.getValue();
        }
        if (this.folderOption.wasSet()) {
            folder = (String)this.folderOption.getValue();
            if (!folder.startsWith("/")) {
                folder = "/" + folder;
            }
            if (!folder.endsWith("/")) {
                folder = folder + "/";
            }
        }
        if (this.serverOption.wasSet() && (portIndex = (servername = (String)this.serverOption.getValue()).indexOf(58)) >= 0) {
            String tmpStr = servername;
            servername = tmpStr.substring(0, portIndex);
            String portNumber = tmpStr.substring(portIndex + 1);
            if (portNumber.length() > 0) {
                serverPort = new Integer(portNumber);
            }
        }
        boolean autoload = this.loadOption.wasSet();
        boolean bgload = this.bgOption.wasSet();
        if (this.propsOption.wasSet()) {
            Enumeration e = this.propsOption.getValues().elements();
            while (e.hasMoreElements()) {
                String s = ((String)e.nextElement()).trim();
                int i = s.indexOf(":");
                props.setProperty(s.substring(0, i), s.substring(i + 1));
            }
        }
        if (this.classOption.wasSet()) {
            classname = ((String)this.classOption.getValue()).trim();
        }
        try {
            VBaseNode child;
            VBaseConfiguration conf = VBaseConfiguration.createConfiguration(new File(filein).toURL(), true, true);
            VBaseNode root = (VBaseNode)conf.getRootNode();
            if (folder != null) {
                Enumeration e = root.children();
                while (e.hasMoreElements()) {
                    VBaseNode s = (VBaseNode)e.nextElement();
                    if ((s = this.findFolderNode(s, folder)) != null) {
                        root = s;
                        break;
                    }
                    folderName = "/";
                }
            }
            if (tbxURL == null) {
                if (this.NameOption.wasSet()) {
                    child = null;
                    String fName = null;
                    String folderDesc = null;
                    String folderSmallIcon = null;
                    String folderLargeIcon = null;
                    fName = ((String)this.NameOption.getValue()).trim();
                    folderDesc = ((String)this.DescOption.getValue()).trim();
                    folderSmallIcon = ((String)this.SmallIconOption.getValue()).trim();
                    folderLargeIcon = ((String)this.LargeIconOption.getValue()).trim();
                    child = conf.createFolderNode(fName, folderDesc, folderSmallIcon, folderLargeIcon, scope);
                    root.appendChild((Node)((Object)child));
                } else {
                    child = null;
                    if (classname.equals(legacyToolName)) {
                        String appName = props.getProperty("Name");
                        child = conf.createToolNode(servername, serverPort, classname, autoload, bgload, scope, props, appName, null, null, null);
                        child.setTreeDisplay(false);
                    } else {
                        child = conf.createToolNode(servername, serverPort, classname, autoload, bgload, scope, props);
                    }
                    root.appendChild((Node)((Object)child));
                }
            } else {
                this.checkURLValidity(tbxURL, filein, fileout);
                child = null;
                child = conf.createToolBoxURLNode(tbxURL);
                root.appendChild((Node)((Object)child));
            }
            conf.write(outStream);
        }
        catch (Exception e) {
            this.retVal = 1;
            throw e;
        }
        this.retVal = 0;
    }

    public static void main(String[] args) {
        addtool t;
        block2: {
            t = new addtool();
            try {
                t.exec(args);
            }
            catch (Exception e) {
                if (e.getMessage().length() <= 0) break block2;
                System.out.println(e.getMessage());
            }
        }
        System.exit(t.getExecStatus());
    }

    protected int checkURLValidity(String urlLink, String filein, String fileout) throws Exception {
        String fileSep = System.getProperty("file.separator");
        if (!urlLink.endsWith(".tbx")) {
            this.setExecStatus(1);
            throw new Exception("Toolbox URL should always end with \".tbx\" extension.");
        }
        if (urlLink.indexOf("://") < 0 && !urlLink.startsWith("file:") && urlLink.startsWith(fileSep)) {
            urlLink = "file:" + urlLink;
        }
        try {
            URL u = new URL(urlLink);
        }
        catch (MalformedURLException me) {
            this.setExecStatus(1);
            throw new Exception(me.getMessage());
        }
        return 0;
    }

    protected VBaseNode findFolderNode(VBaseNode v, String folder) throws Exception {
        if (!(v instanceof FolderNode)) {
            return null;
        }
        if (v.getName() == null) {
            return null;
        }
        String tmpFolder = folderName + v.getName() + "/";
        if (!folder.startsWith(tmpFolder)) {
            return null;
        }
        folderName = tmpFolder;
        if (folder.equals(folderName)) {
            return v;
        }
        try {
            VBaseNode t = null;
            Enumeration e = v.children();
            while (e.hasMoreElements()) {
                VBaseNode v1 = (VBaseNode)e.nextElement();
                t = this.findFolderNode(v1, folder);
                if (t == null) continue;
                return t;
            }
        }
        catch (Exception e) {
            this.setExecStatus(1);
            throw e;
        }
        return null;
    }
}

