/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl;

import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Service;
import com.sun.management.viper.ServiceContext;
import com.sun.management.viper.ServiceInfrastructure;
import com.sun.management.viper.ServiceProvider;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.ServiceContainer;
import java.rmi.RemoteException;

public abstract class UnicastContainer
extends ServiceContainer {
    protected ServiceProvider bean = null;
    private int beanstatus = 0;

    protected UnicastContainer() throws RemoteException {
    }

    protected int getBeanStatus() {
        return this.beanstatus;
    }

    public Service create(ServiceInfrastructure inf, ServiceContext context) throws CriticalStopException {
        if (this.bean == null) {
            throw new CriticalStopException("ServiceNotFound");
        }
        if (!(this.bean instanceof Service)) {
            throw new CriticalStopException("InvalidServiceImpl");
        }
        if (this.beanstatus == 1) {
            this.bean.destroy();
        } else if (this.beanstatus == 2) {
            this.bean.stop();
            this.bean.destroy();
        }
        this.bean.setContext(context);
        this.bean.init(inf);
        this.bean.start();
        this.beanstatus = 2;
        return (Service)this.bean;
    }

    public void remove(Service obj) throws CriticalStopException {
        if (obj == this.bean) {
            this.destroy();
        }
    }

    public void init(ServiceInfrastructure inf) throws CriticalStopException {
        super.init(inf);
        if (this.bean != null) {
            try {
                if (this.beanstatus == 1) {
                    this.bean.destroy();
                } else if (this.beanstatus == 2) {
                    this.bean.stop();
                    this.bean.destroy();
                }
                this.bean.init(inf);
                this.beanstatus = 1;
            }
            catch (Throwable t) {
                if (t instanceof CriticalStopException) {
                    throw (CriticalStopException)t;
                }
                Debug.trace((String)"UnicastContainer", (int)Debug.ERROR, (String)("failed to init service " + this.bean + ":" + t.getMessage()), null);
            }
        }
    }

    public void start() throws CriticalStopException {
        if (this.bean != null) {
            try {
                if (this.beanstatus == 0) {
                    String msg = "Error: start is called before init(), service won't be started.";
                    Debug.trace((String)"UnicastContainer", (int)Debug.INFORMATION, (String)msg, null);
                    return;
                }
                if (this.beanstatus == 2) {
                    return;
                }
                this.bean.start();
                this.beanstatus = 2;
            }
            catch (Throwable t) {
                if (t instanceof CriticalStopException) {
                    throw (CriticalStopException)t;
                }
                Debug.trace((String)"UnicastContainer", (int)Debug.ERROR, (String)("failed to start service " + this.bean + ":" + t.getMessage()), null);
            }
        }
    }

    public void destroy() throws CriticalStopException {
        if (this.bean != null) {
            try {
                if (this.beanstatus == 0) {
                    return;
                }
                if (this.beanstatus == 2) {
                    this.bean.stop();
                }
                this.bean.destroy();
                this.beanstatus = 0;
            }
            catch (Throwable t) {
                if (t instanceof CriticalStopException) {
                    throw (CriticalStopException)t;
                }
                Debug.trace((String)"UnicastContainer", (int)Debug.ERROR, (String)("failed to destroy service " + this.bean + ":" + t.getMessage()), null);
            }
        }
    }

    public void stop() throws CriticalStopException {
        if (this.bean != null) {
            try {
                if (this.beanstatus == 0) {
                    return;
                }
                if (this.beanstatus == 1) {
                    return;
                }
                this.bean.stop();
                this.beanstatus = 1;
            }
            catch (Throwable t) {
                if (t instanceof CriticalStopException) {
                    throw (CriticalStopException)t;
                }
                Debug.trace((String)"UnicastContainer", (int)Debug.ERROR, (String)("failed to stop service " + this.bean + ":" + t.getMessage()), null);
            }
        }
    }
}

