/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.patch;

import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.PatchInfoImpl;
import java.io.Serializable;
import java.util.StringTokenizer;

public class PatchID
implements Serializable {
    private PatchInfoImpl extendedinfo;
    private String basecode;
    private String version;

    public PatchID(String string) throws MalformedPatchException {
        if ('-' == string.trim().charAt(0)) {
            throw new MalformedPatchException("Invalid patch ID (leading '-') \"" + string + "\"");
        }
        if ('-' == string.trim().charAt(string.trim().length() - 1)) {
            throw new MalformedPatchException("Invalid patch ID (trailing '-') \"" + string + "\"");
        }
        if (string.indexOf("--") != -1) {
            throw new MalformedPatchException("Invalid patch ID (contains '--') \"" + string + "\"");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        if (stringTokenizer.countTokens() != 2) {
            throw new MalformedPatchException("Invalid patch ID \"" + string + "\"");
        }
        this.basecode = stringTokenizer.nextToken();
        this.version = stringTokenizer.nextToken();
        if (this.basecode == null || this.version == null) {
            throw new MalformedPatchException("Invalid patch ID \"" + string + "\", missing base code or version.");
        }
        if (this.basecode.length() < 6 || this.basecode.length() > 7) {
            throw new MalformedPatchException("Basecode is incorrect length.");
        }
        if (this.basecode.length() == 7 && !Character.isLetter(this.basecode.charAt(0))) {
            throw new MalformedPatchException("Invalid patch ID \"" + string + "\", unknown patch type detected");
        }
        if (this.version.length() != 2 && this.version.length() != 3) {
            throw new MalformedPatchException("Version is incorrect length.");
        }
    }

    protected PatchID() {
    }

    public String getBasecode() {
        return this.basecode;
    }

    public String getRevision() {
        return this.version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPatchID() {
        return this.basecode + "-" + this.version;
    }

    public void setExtendedInfo(PatchInfoImpl patchInfoImpl) {
        this.extendedinfo = patchInfoImpl;
    }

    public PatchInfoImpl getExtendedInfo() {
        return this.extendedinfo;
    }

    public boolean equals(PatchID patchID) {
        String string;
        String string2;
        if (this.basecode != null && patchID.getBasecode() != null) {
            string2 = this.basecode.trim();
            string = patchID.getBasecode().trim();
            if (string2 != "" && string != "" ? !string2.equals(string) : string2.compareTo(string) != 0) {
                return false;
            }
        }
        if (this.version != null && patchID.getRevision() != null) {
            string2 = this.version.trim();
            string = patchID.getRevision().trim();
            if (string2 != "" && string != "" ? !string2.equals(string) : string2.compareTo(string) != 0) {
                return false;
            }
        }
        return true;
    }
}

