/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.model;

import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchList;

public class CancelManager {
    private boolean cancelRequested = false;
    private boolean debug = false;
    boolean internalStatus = false;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private static CancelManager myself = null;
    private static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CancelManager getInstance() {
        if (myself != null) {
            return myself;
        }
        Object object = lock;
        synchronized (object) {
            myself = new CancelManager();
        }
        return myself;
    }

    private CancelManager() {
        this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
        this.internalStatus = this.properties.getProperty("patchpro.internal.statustags", "false").compareTo("true") == 0;
    }

    public void doExitIfCancelRequested() {
        if (this.cancelRequested) {
            if (this.debug) {
                System.out.println("Abort due to cancel request.");
            }
            System.exit(0);
        }
    }

    public void doExitIfCancelRequested(int n) {
        if (this.cancelRequested) {
            if (this.debug) {
                System.out.println("Abort due to cancel request.");
            }
            System.exit(n);
        }
    }

    public void doExitIfCancelRequested(String string, PatchList patchList, String string2, String string3, String string4) {
        if (this.cancelRequested) {
            if (this.debug) {
                System.out.println("Abort due to cancel request.");
            }
            this.printTaggedMessage(string, patchList, string2, string3, string4);
            System.exit(0);
        }
    }

    public void doExitIfCancelRequested(String string, String string2, String string3, String string4) {
        if (this.cancelRequested) {
            if (this.debug) {
                System.out.println("Abort due to cancel request.");
            }
            this.printTaggedMessage(string, string2, string3, string4);
            System.exit(0);
        }
    }

    private void printTaggedMessage(String string, PatchList patchList, String string2, String string3, String string4) {
        String string5 = "";
        if (this.internalStatus) {
            for (int i = 0; i < patchList.size(); ++i) {
                Patch patch;
                try {
                    patch = patchList.getPatchAt(i);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    continue;
                }
                String string6 = patch.getPatchID().getPatchID();
                string5 = string2 == null ? string + " " + string6 : (string3 == null ? string + " " + string6 + " " + string2 : (string4 == null ? string + " " + string6 + " " + string2 + " " + string3 + " \"" + string6 + "\"" : string + " " + string6 + " " + string2 + " " + string3 + " \"" + string6 + "\" " + string4));
                System.out.println(string5.trim());
            }
        }
    }

    private void printTaggedMessage(String string, String string2, String string3, String string4) {
        String string5 = "";
        if (this.debug) {
            System.out.println("Entered printTaggedMessage()");
        }
        if (this.internalStatus) {
            if (string2 == null) {
                string5 = string;
            } else if (string3 == null) {
                string5 = string + " " + string2;
            } else if (string4 == null) {
                string5 = string + " " + string2 + " " + string3;
            } else {
                string5 = string + " " + string2 + " " + string3 + " " + string4;
                if (this.debug) {
                    System.out.println("printTaggedMessage(): msg: " + string5);
                }
            }
            System.out.println(string5.trim());
        }
    }

    public boolean isCancelRequested() {
        return this.cancelRequested;
    }

    public void setCancelRequested(boolean bl) {
        this.cancelRequested = bl;
    }
}

