/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.PatchInstallFailedException;
import com.sun.patchpro.manipulators.SunOSInstaller;
import com.sun.patchpro.manipulators.SunOSSunPatchManipulator;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.util.LocalizedMessages;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Vector;

public class SunOSSunPatchInstaller
extends SunOSInstaller {
    private static final String RECONFIGURE_FILE = "/reconfigure";
    Process patchInstallProcess = null;
    private boolean installSucceeded = true;
    private LocalizedMessages msgcat = null;

    public SunOSSunPatchInstaller(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
        this.msgcat = new LocalizedMessages(patchProProperties.getLocale());
    }

    public void install() {
        File file;
        this.initializeProgress(0.0, 4.0);
        try {
            file = this.extractPatch();
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            this.issueFail(new PatchInstallFailedException(57));
            return;
        }
        this.incrementProgress(1.0);
        Runtime runtime = Runtime.getRuntime();
        Vector<String> vector = new Vector<String>();
        vector.add(this.properties.getProperty("SunOS.command.install.patch", "/usr/sbin/patchadd"));
        String string = this.properties.getProperty("patchpro.internal.transitional", "true");
        if (string != null && string.equals("true")) {
            vector.add("-t");
        }
        if (this.backoutDirectory != null) {
            vector.add("-B");
            vector.add(this.backoutDirectory.getPath());
        }
        vector.add(file.getPath() + File.separator + this.activePatch.getPatchID().getPatchID());
        if (this.debug) {
            System.out.println("Install command string: " + vector);
            this.incrementProgress(2.0);
        } else {
            String[] stringArray = vector.toArray(new String[0]);
            this.printTaggedMessage("STATUS INSTALL BEGIN " + this.activePatch.getPatchID().getPatchID());
            try {
                this.patchInstallProcess = runtime.exec(stringArray);
                this.incrementProgress(1.0);
            }
            catch (IOException iOException) {
                this.log.println(this, 2, "Received java.io.IOException while installing a patch");
                this.log.printStackTrace(this, 2, iOException);
                this.issueFail(new PatchInstallFailedException(56));
            }
            try {
                Serializable serializable;
                this.incrementProgress(1.0);
                StringBuffer stringBuffer = new StringBuffer("");
                StringBuffer stringBuffer2 = new StringBuffer("");
                InputStream inputStream = null;
                InputStream inputStream2 = null;
                inputStream = this.patchInstallProcess.getInputStream();
                inputStream2 = this.patchInstallProcess.getErrorStream();
                StreamReader streamReader = new StreamReader(inputStream, stringBuffer);
                StreamReader streamReader2 = new StreamReader(inputStream2, stringBuffer2);
                streamReader.start();
                streamReader2.start();
                int n = this.patchInstallProcess.waitFor();
                streamReader.join(5000L);
                streamReader2.join(5000L);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n == 0 && ((SunOSSunPatchManipulator)this.manipulator).isReconfigureRequired()) {
                    serializable = new File(RECONFIGURE_FILE);
                    try {
                        ((File)serializable).createNewFile();
                    }
                    catch (IOException iOException) {
                        this.log.println(this, 7, "Failed to create /reconfigure file.");
                    }
                }
                if (n != 0) {
                    this.installSucceeded = false;
                    this.log.println(this, 7, "Patch install (patchadd) returned: " + n);
                    int n2 = n;
                    switch (n) {
                        case 0: {
                            n2 = 0;
                            break;
                        }
                        case 1: {
                            n2 = 1;
                            this.printTaggedMessage("STATUS INSTALL END " + this.activePatch.getPatchID().getPatchID() + " " + "INSTALL.1" + " \"" + this.msgcat.getMessage("tagstatusmsg.INSTALL_CODE_USAGE_ERROR", "Install of update failed. Utility used to install the update detected a usage error and failed with exit code {0}.\n{1}") + "\" \"" + n + "\" \"" + stringBuffer.toString() + "\n" + stringBuffer2.toString() + "\"");
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            this.printTaggedMessage("STATUS INSTALL END " + this.activePatch.getPatchID().getPatchID() + " " + "INSTALL.2" + " \"" + this.msgcat.getMessage("tagstatusmsg.INSTALL_CODE_PATCH_ALREADY_APPLIED", "Install of update failed. Unable to install the update since it is already applied on the system.Utility used to install the update failed with exit code {0}.\n{1}") + "\" \"" + n + "\" \"" + stringBuffer.toString() + "\n" + stringBuffer2.toString() + "\"");
                            break;
                        }
                        case 3: {
                            n2 = 3;
                            this.printTaggedMessage("STATUS INSTALL END " + this.activePatch.getPatchID().getPatchID() + " " + "INSTALL.3" + " \"" + this.msgcat.getMessage("tagstatusmsg.INSTALL_CODE_NON_ROOT_UID", "Install of update failed. Only the root user can install the update. Utility used to install the update failed with exit code {0}.\n{1}") + "\" \"" + n + "\" \"" + stringBuffer.toString() + "\n" + stringBuffer2.toString() + "\"");
                            break;
                        }
                        case 4: {
                            n2 = 4;
                            this.printTaggedMessage("STATUS INSTALL END " + this.activePatch.getPatchID().getPatchID() + " " + "INSTALL.4" + " \"" + this.msgcat.getMessage("tagstatusmsg.INSTALL_CODE_SAVES_FILES_FAILED", "Install of update failed. Utility used to install the update is not able to save files. Utility used to install the update failed with exit code {0}.\n{1}") + "\" \"" + n + "\" \"" + stringBuffer.toString() + "\n" + stringBuffer2.toString() + "\"");
                            break;
                        }
                        case 5: {
                            n2 = 5;
                            this.printTaggedMessage("STATUS INSTALL END " + this.activePatch.getPatchID().getPatchID() + " " + "INSTALL.5" + " \"" + this.msgcat.getMessage("tagstatusmsg.INSTALL_CODE_PKGADD_FAILED", "Install of update failed. Utility used to install the update is not able to add packages. Utility used to install the update failed with exit code {0}.\n{1}") + "\" \"" + n + "\" \"" + stringBuffer.toString() + "\n" + stringBuffer2.toString() + "\"");
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            this.printTaggedMessage("STATUS INSTALL END " + this.activePatch.getPatchID().getPatchID() + " " + "INSTALL.255" + " " + "\"Utility used to install the update failed " + "with exit code {0}.\n{1}\"" + " \"" + n + "\" \"" + stringBuffer.toString() + "\n" + stringBuffer2.toString() + "\"");
                            break;
                        }
                        case 9: {
                            n2 = 9;
                            this.printTaggedMessage("STATUS INSTALL END " + this.activePatch.getPatchID().getPatchID() + " " + "INSTALL.9" + " \"" + this.msgcat.getMessage("tagstatusmsg.INSTALL_CODE_PKGADD_NOT_FOUND", "Install of update failed. Utility used to install the update could not find the tool to install packages. Utility used to install the update failed with exit code {0}.\n{1}") + "\" \"" + n + "\" \"" + stringBuffer.toString() + "\n" + stringBuffer2.toString() + "\"");
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: {
                            this.printTaggedMessage("STATUS INSTALL END " + this.activePatch.getPatchID().getPatchID() + " " + "INSTALL.255" + " " + "\"Utility used to install the update failed " + "with exit code {0}.\n{1}\"" + " \"" + n + "\" \"" + stringBuffer.toString() + "\n" + stringBuffer2.toString() + "\"");
                            break;
                        }
                        case 18: {
                            n2 = 18;
                            this.printTaggedMessage("STATUS INSTALL END " + this.activePatch.getPatchID().getPatchID() + " " + "INSTALL.18" + " \"" + this.msgcat.getMessage("tagstatusmsg.INSTALL_CODE_NOT_ENOUGH_SPACE", "Install of update failed. There is not enough filesystem space for the utility used to install the update. Utility used to install the update failed with exit code {0}.\n{1}") + "\" \"" + n + "\" \"" + stringBuffer.toString() + "\n" + stringBuffer2.toString() + "\"");
                            break;
                        }
                        default: {
                            this.printTaggedMessage("STATUS INSTALL END " + this.activePatch.getPatchID().getPatchID() + " " + "INSTALL.255" + " " + "\"Utility used to install the update failed " + "with exit code {0}.\n{1}\"" + " \"" + n + "\" \"" + stringBuffer.toString() + "\n" + stringBuffer2.toString() + "\"");
                        }
                    }
                    this.issueFail(new PatchInstallFailedException(n2, stringBuffer.toString() + " " + stringBuffer2.toString()));
                } else {
                    serializable = this.activePatch.getPatchInfo().getProperties();
                    if (((PatchProperties)serializable).isRebootafter() || ((PatchProperties)serializable).isRebootimmediate() || ((PatchProperties)serializable).isReconfigafter() || ((PatchProperties)serializable).isReconfigimmediate()) {
                        this.printTaggedMessage("STATUS INSTALL END " + this.activePatch.getPatchID().getPatchID() + " " + "INSTALL.252" + " \"" + this.msgcat.getMessage("tagstatusmsg.INSTALL_CODE_REBOOT", "Update {0} installed successfully but requires a system reboot.") + "\" \"" + this.activePatch.getPatchID().getPatchID() + "\"");
                    } else {
                        this.printTaggedMessage("STATUS INSTALL END " + this.activePatch.getPatchID().getPatchID() + " " + "INSTALL.0" + " \"" + this.msgcat.getMessage("tagstatusmsg.INSTALL_CODE_SUCCESS", "Request to install update {0} was successful.") + "\" \"" + this.activePatch.getPatchID().getPatchID() + "\"");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.log.printStackTrace(this, 2, interruptedException);
                this.issueFail(new PatchInstallFailedException(57));
            }
        }
        this.incrementProgress(1.0);
    }

    public void postInstall() {
        if (this.installSucceeded) {
            super.postInstall();
        }
    }

    private void printTaggedMessage(String string) {
        if (this.internalStatus) {
            System.out.println(string);
        }
    }

    class StreamReader
    extends Thread {
        BufferedReader r;
        StringBuffer output;

        public StreamReader(InputStream inputStream, StringBuffer stringBuffer) {
            this.r = new BufferedReader(new InputStreamReader(inputStream));
            this.output = stringBuffer;
        }

        public void run() {
            try {
                String string;
                while ((string = this.r.readLine()) != null) {
                    this.output.append(string);
                }
            }
            catch (Throwable throwable) {
                SunOSSunPatchInstaller.this.log.printStackTrace(this, 7, throwable);
            }
        }
    }
}

