/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.SoftwarePackage;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.SunOSRmtT4InstallerPrtl;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.TelnetSession;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public abstract class SunOSRmtT4ControllerInstallerPrtl
extends SunOSRmtT4InstallerPrtl {
    private static final String[] validLoop1CardValues = new String[]{"u1l1", "u2l1", "u3l1", "u4l1", "u5l1", "u6l1"};
    private static final String[] validLoop2CardValues = new String[]{"u1l2", "u2l2", "u3l2", "u4l2", "u5l2", "u6l2"};
    private int prompt_index = 5;
    private String controllerImage = null;
    private String loopCardImage = null;
    private String level2Image = null;
    private String level1Image = null;
    private Vector hardwareComponentsToUpdate = new Vector();
    private Vector sortedLoop1Cards = new Vector();
    private Vector sortedLoop2Cards = new Vector();
    protected PatchProProperties properties = null;

    public SunOSRmtT4ControllerInstallerPrtl(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
        this.properties = patchProProperties;
        this.initializeHardwareList();
    }

    protected void initializeHardwareList() {
        Enumeration enumeration = null;
        HardwareComponent hardwareComponent = null;
        enumeration = this.manipulator.getTargetHardware();
        while (enumeration != null && enumeration.hasMoreElements()) {
            hardwareComponent = (HardwareComponent)enumeration.nextElement();
            this.hardwareComponentsToUpdate.addElement(hardwareComponent);
        }
    }

    protected Enumeration getHardwareComponentsToUpdate() {
        return this.hardwareComponentsToUpdate.elements();
    }

    protected void getControllerFirmwareImages(File file) throws InteractiveSessionException {
        Properties properties = null;
        SoftwarePackage softwarePackage = this.installFirmwarePackage(file);
        properties = softwarePackage.getPkginfo();
        this.manipulator.getHost().addSoftwarePackage(softwarePackage);
        this.setControllerImage(properties.getProperty("SUNW_CONTROLLER_NAME", null));
        this.setLoopCardImage(properties.getProperty("SUNW_LOOPCARD_NAME", null));
        this.setLevel2Image(properties.getProperty("SUNW_LEVEL2_NAME", null));
        this.setLevel1Image(properties.getProperty("SUNW_LEVEL1_NAME", null));
    }

    protected void applyLoopCardFirmwareImages(String string) throws InteractiveSessionException {
        if (this.getLoopCardImage() != null) {
            int n = 0;
            int n2 = 0;
            String string2 = null;
            String string3 = null;
            TelnetSession telnetSession = null;
            try {
                int n3;
                n = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.downloadfw.loopcard.limit", "2400")));
                n2 = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.reboot.loopcard.limit", "1200")));
                string2 = this.properties.getProperty("patchpro.userid", "root");
                string3 = this.getPassword(string);
                telnetSession = new TelnetSession();
                telnetSession.connect(string, string2, string3);
                telnetSession.send("cd /\r", 1000);
                if (!telnetSession.expectedResponse("lpc version\r", "<3>", 5000)) {
                    this.log.println(this, 2, "Cannot issue the \"lpc version\" command to view the versions of all loop cards.");
                    throw new Exception("Unable to apply loop card image \"" + this.getLoopCardImage() + "\". The lpc command is not usable." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                }
                if (!telnetSession.expectedResponse("ls\r", this.getLoopCardImage(), 5000)) {
                    this.log.println(this, 2, "The loop card image that was uploaded is not present on the storage array.");
                    throw new Exception(this.getLoopCardImage() + " image was not found");
                }
                this.getLoopCardsToProcess(this.sortedLoop1Cards, this.sortedLoop2Cards);
                String string4 = "";
                for (n3 = 0; n3 < this.sortedLoop1Cards.size(); ++n3) {
                    string4 = (String)this.sortedLoop1Cards.elementAt(n3);
                    if (!telnetSession.expectedResponse("lpc download " + string4 + " " + this.getLoopCardImage() + "\r", "<" + this.prompt_index++ + ">", n)) {
                        this.log.println(this, 2, "The amount of time reserved to download loop card image to " + string4 + " has expired." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                        throw new Exception("Expected : \"<" + (this.prompt_index - 1) + ">" + "\" prompt not detected after \"lpc download " + string4 + " " + this.getLoopCardImage() + "\" issued." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                    if (telnetSession.getAllSessionMessages().indexOf(string4 + " failed") != -1) {
                        this.log.println(this, 2, "Unable to download the " + this.getLoopCardImage() + " image to " + string4 + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                        throw new Exception("Unable to download the " + this.getLoopCardImage() + " image to " + string4 + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                    Thread.sleep(10000L);
                    if (!telnetSession.expectedResponse("lpc reboot " + string4 + "\r", "<" + this.prompt_index++ + ">", n2)) {
                        this.log.println(this, 2, "The amount of time reserved to reboot loop card image " + string4 + " has expired." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                        throw new Exception("Expected : \"<" + (this.prompt_index - 1) + ">" + "\" prompt not detected after \"lpc reboot " + string4 + " issued." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                    if (telnetSession.getAllSessionMessages().indexOf(string4 + " failed") != -1) {
                        this.log.println(this, 2, "Unable to reboot " + string4 + " after " + this.getLoopCardImage() + " was downloaded." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                        throw new Exception("Unable to reboot " + string4 + " after " + this.getLoopCardImage() + " was downloaded." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                    Thread.sleep(10000L);
                }
                for (n3 = 0; n3 < this.sortedLoop2Cards.size(); ++n3) {
                    string4 = (String)this.sortedLoop2Cards.elementAt(n3);
                    if (!telnetSession.expectedResponse("lpc download " + string4 + " " + this.getLoopCardImage() + "\r", "<" + this.prompt_index++ + ">", n)) {
                        this.log.println(this, 2, "The amount of time reserved to download loop card image to " + string4 + " has expired." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                        throw new Exception("Expected : \"<" + (this.prompt_index - 1) + ">" + "\" prompt not detected after \"lpc download " + string4 + " " + this.getLoopCardImage() + "\" issued." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                    if (telnetSession.getAllSessionMessages().indexOf(string4 + " failed") != -1) {
                        this.log.println(this, 2, "Unable to download the " + this.getLoopCardImage() + " image to " + string4 + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                        throw new Exception("Unable to download the " + this.getLoopCardImage() + " image to " + string4 + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                    Thread.sleep(10000L);
                    if (!telnetSession.expectedResponse("lpc reboot " + string4 + "\r", "<" + this.prompt_index++ + ">", n2)) {
                        this.log.println(this, 2, "The amount of time reserved to reboot loop card image " + string4 + " has expired." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                        throw new Exception("Expected : \"<" + (this.prompt_index - 1) + ">" + "\" prompt not detected after \"lpc reboot " + string4 + " issued." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                    if (telnetSession.getAllSessionMessages().indexOf(string4 + " failed") != -1) {
                        this.log.println(this, 2, "Unable to reboot " + string4 + " after " + this.getLoopCardImage() + " was downloaded." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                        throw new Exception("Unable to reboot " + string4 + " after " + this.getLoopCardImage() + " was downloaded." + "\n\nSession output:\n" + telnetSession.getAllSessionMessages());
                    }
                    Thread.sleep(10000L);
                }
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 2, exception);
                throw new InteractiveSessionException(exception.getMessage());
            }
            finally {
                if (telnetSession != null) {
                    telnetSession.disconnect();
                }
            }
        }
    }

    protected void getLoopCardsToProcess(Vector vector, Vector vector2) {
        int n;
        Enumeration enumeration = null;
        HardwareComponent hardwareComponent = null;
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector<String> vector5 = new Vector<String>();
        Vector<String> vector6 = new Vector<String>();
        for (n = 0; n < validLoop1CardValues.length; ++n) {
            vector3.addElement(validLoop1CardValues[n]);
        }
        for (n = 0; n < validLoop2CardValues.length; ++n) {
            vector4.addElement(validLoop2CardValues[n]);
        }
        enumeration = this.getHardwareComponentsToUpdate();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            hardwareComponent = (HardwareComponent)enumeration.nextElement();
            if (vector3.contains(hardwareComponent.getLocator())) {
                vector5.addElement(hardwareComponent.getLocator());
                continue;
            }
            if (!vector4.contains(hardwareComponent.getLocator())) continue;
            vector6.addElement(hardwareComponent.getLocator());
        }
        if (vector5.size() > 0) {
            if (vector5.contains("u1l1")) {
                vector.addElement("u1l1");
            }
            if (vector5.contains("u2l1")) {
                vector.addElement("u2l1");
            }
            if (vector5.contains("u3l1")) {
                vector.addElement("u3l1");
            }
            if (vector5.contains("u4l1")) {
                vector.addElement("u4l1");
            }
            if (vector5.contains("u5l1")) {
                vector.addElement("u5l1");
            }
            if (vector5.contains("u6l1")) {
                vector.addElement("u6l1");
            }
        }
        if (vector6.size() > 0) {
            if (vector6.contains("u1l2")) {
                vector2.addElement("u1l2");
            }
            if (vector6.contains("u2l2")) {
                vector2.addElement("u2l2");
            }
            if (vector6.contains("u3l2")) {
                vector2.addElement("u3l2");
            }
            if (vector6.contains("u4l2")) {
                vector2.addElement("u4l2");
            }
            if (vector6.contains("u5l2")) {
                vector2.addElement("u5l2");
            }
            if (vector6.contains("u6l2")) {
                vector2.addElement("u6l2");
            }
        }
    }

    protected void failOverMaster(String string, String string2, String string3, String string4) throws InteractiveSessionException {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        n2 = this.convertToMilliseconds(this.convertStringToInteger(this.properties.getProperty("patchpro.reconnect.controller.maxattempts", "100")));
        TelnetSession telnetSession = new TelnetSession();
        telnetSession.connect(string2, string3, string4);
        this.log.println(this, 7, "Issue Command: disable u" + string);
        telnetSession.send("disable u" + string + "\r", 30000);
        telnetSession.disconnect();
        while (true) {
            try {
                telnetSession = new TelnetSession();
                telnetSession.connect(string2, string3, string4);
                this.log.println(this, 7, "Issue Command: enable u" + string);
                telnetSession.send("enable u" + string + "\r");
                for (int i = 0; i < n2; ++i) {
                    if (telnetSession.expectedResponse("sys stat\r", string + "    ONLINE     AlterM", 5000)) {
                        bl = true;
                        break;
                    }
                    Thread.sleep(10000L);
                }
                if (!bl) {
                    bl2 = true;
                    this.log.println(this, 2, "The amount of time reserved to complete the failover cycle for master u" + string + " has expired.");
                    System.out.println("\nError: Unable to fail over master u" + string + "\nenable u" + string + " failed");
                    throw new Exception("Error: Unable to fail over master u" + string);
                }
                this.log.println(this, 7, "Successfully failed over master u" + string);
            }
            catch (Exception exception) {
                if (bl2) {
                    if (telnetSession != null) {
                        String string5 = exception.getMessage() + "\n\nSession output:\n" + telnetSession.getAllSessionMessages();
                        telnetSession.disconnect();
                        telnetSession = null;
                        throw new InteractiveSessionException(string5);
                    }
                    throw new InteractiveSessionException(exception.getMessage());
                }
                telnetSession = null;
                System.gc();
                this.log.println(this, 7, "Expected : login prompt to access host was not detected.\nNumber of attempts to connect to master controller is " + ++n);
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n < n2) continue;
            }
            break;
        }
        if (telnetSession != null) {
            telnetSession.disconnect();
        }
    }

    protected void setControllerImage(String string) {
        this.controllerImage = string;
    }

    protected String getControllerImage() {
        return this.controllerImage;
    }

    protected void setLoopCardImage(String string) {
        this.loopCardImage = string;
    }

    protected String getLoopCardImage() {
        return this.loopCardImage;
    }

    protected void setLevel2Image(String string) {
        this.level2Image = string;
    }

    protected String getLevel2Image() {
        return this.level2Image;
    }

    protected void setLevel1Image(String string) {
        this.level1Image = string;
    }

    protected String getLevel1Image() {
        return this.level1Image;
    }
}

