/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.log;

import com.sun.patchpro.log.Log;
import java.io.PrintWriter;
import java.io.StringWriter;

public class PatchProLog {
    public static final int EMERGENCY = 0;
    public static final int ALERT = 1;
    public static final int CRITICAL = 2;
    public static final int ERROR = 3;
    public static final int WARNING = 4;
    public static final int NOTICE = 5;
    public static final int INFO = 6;
    public static final int DEBUG = 7;
    private static PatchProLog log;
    private Log logger;

    public static synchronized PatchProLog getInstance() {
        if (log == null) {
            log = new PatchProLog();
        }
        return log;
    }

    public synchronized void setLogger(Log log) {
        this.logger = log;
    }

    public void print(Object object, int n, String string) {
        if (this.logger != null) {
            this.logger.print(object, n, string);
        }
    }

    public void println(Object object, int n, String string) {
        this.print(object, n, string + "\n");
    }

    public void printStackTrace(Object object, int n, Throwable throwable) {
        if (this.logger != null) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            this.logger.print(object, n, stringWriter.toString());
        }
    }

    public static String createMessage(int n, String string) {
        String string2 = "";
        switch (n) {
            case 1: {
                string2 = string2 + "ALERT: ";
                break;
            }
            case 2: {
                string2 = string2 + "CRITICAL: ";
                break;
            }
            case 3: {
                string2 = string2 + "ERROR: ";
                break;
            }
            case 4: {
                string2 = string2 + "WARNING: ";
                break;
            }
            case 5: {
                string2 = string2 + "NOTICE: ";
                break;
            }
            case 6: {
                string2 = string2 + "INFO: ";
                break;
            }
        }
        string2 = string2 + string;
        return string2;
    }

    private PatchProLog() {
    }
}

