/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.adapter;

import com.sun.cc.platform.user.DuplicateAccountException;
import com.sun.cc.platform.user.UserServiceClient;
import com.sun.cc.platform.user.UserServiceClientFactory;
import com.sun.cns.basicreg.BasicReg;
import com.sun.cns.basicreg.adapter.Adapter;
import com.sun.cns.basicreg.advertisement.SystemAdvertisement;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.util.ResponseBuilder;
import com.sun.cns.basicreg.util.XMLError;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.jdom.Document;

public class eCRAdapter
extends Adapter {
    private static String token = null;
    static /* synthetic */ Class class$com$sun$cns$basicreg$adapter$eCRAdapter;

    public eCRAdapter() {
        this.setInitialURL("https://cns-services.sun.com/UserInformationService/UserInformationService");
        this.reLoadURL("user.url");
        LOG.info("Using eCRAdapter endpoint := " + ENDPOINT);
    }

    public eCRAdapter(Document inDoc) {
        this.setLogger(Logger.getLogger((class$com$sun$cns$basicreg$adapter$eCRAdapter == null ? (class$com$sun$cns$basicreg$adapter$eCRAdapter = eCRAdapter.class$("com.sun.cns.basicreg.adapter.eCRAdapter")) : class$com$sun$cns$basicreg$adapter$eCRAdapter).getName()));
        this.setInitialURL("https://cns-services.sun.com/UserInformationService/UserInformationService");
        this.reLoadURL("user.url");
        this.reLoadProxyFromCCR();
        theDocument = inDoc;
        if (theDocument == null) {
            LOG.warning("Constructor doc object is null!!!");
            theDocument = new Document();
        }
        LOG.info("Using eCRAdapter endpoint := " + ENDPOINT);
    }

    public static Document authenticateUser() {
        String user = "";
        String pass = "";
        return eCRAdapter.authenticateUser(eCRAdapter.findEntry("username"), eCRAdapter.findEntry("password"));
    }

    public static Document authenticateUser(String id, String pass) {
        Document result = null;
        try {
            UserServiceClient client = UserServiceClientFactory.getInstance().getClient(ENDPOINT, System.out);
            long start_time = System.currentTimeMillis();
            token = client.validate(id, pass);
            LOG.info("UserMgmt authenticateUser call took : " + (System.currentTimeMillis() - start_time) + " ms.");
            if (token != null) {
                LOG.info("user is authenticated and token = " + token);
                result = ResponseBuilder.buildResponseDocument(token, "user");
            } else {
                XMLError error = null;
                error = new XMLError("authentication failed", "system", "102", "F");
                LOG.severe("invalid username or password");
                ArrayList<XMLError> errorList = new ArrayList<XMLError>();
                errorList.add(error);
                result = ResponseBuilder.buildResponseDocument(errorList, "user");
            }
        }
        catch (Exception e) {
            XMLError error = null;
            if (eCRAdapter.connectToSun()) {
                LOG.severe("Exception in web service communication");
                error = new XMLError("Exception in web service communication", "system", "230", "F");
            } else if (eCRAdapter.isProxyEnabled()) {
                LOG.severe("Exception in proxy communication");
                error = new XMLError("Exception in proxy communication", "system", "235", "F");
            } else {
                LOG.severe("Exception in internet communication");
                error = new XMLError("Exception in internet communication", "system", "245", "F");
            }
            ArrayList<XMLError> errorList = new ArrayList<XMLError>();
            errorList.add(error);
            result = ResponseBuilder.buildResponseDocument(errorList, "user");
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        return result;
    }

    public Document registerUser() {
        Document result = null;
        SystemAdvertisement sysAdv = BasicReg.getSystemAdvertisement();
        try {
            UserServiceClient client = UserServiceClientFactory.getInstance().getClient(ENDPOINT, null);
            long start_time = System.currentTimeMillis();
            token = client.registerUser(eCRAdapter.findEntry("username"), eCRAdapter.findEntry("password"), eCRAdapter.findEntry("firstname"), eCRAdapter.findEntry("lastname"), eCRAdapter.findEntry("companyname"), eCRAdapter.findEntry("address1"), eCRAdapter.findEntry("address2"), eCRAdapter.findEntry("address3"), eCRAdapter.findEntry("city"), eCRAdapter.findEntry("state"), eCRAdapter.findEntry("zipcode"), eCRAdapter.findCountryCodeEntry(eCRAdapter.findEntry("country")), eCRAdapter.findEntry("phonenumber"), eCRAdapter.findEntry("email"), eCRAdapter.findLanguageCodeEntry(eCRAdapter.findEntry("language")), eCRAdapter.findEntry("jobtitle"), new Boolean(eCRAdapter.findEntry("contactselect")), true, true, sysAdv.getAgentUuid());
            LOG.info("UserMgmt registerUser call took : " + (System.currentTimeMillis() - start_time) + " ms.");
            if (token != null) {
                LOG.info("returned token = " + token);
                result = ResponseBuilder.buildResponseDocument(token, "user");
            } else {
                XMLError error = null;
                error = new XMLError("account creation failure", "system", "105", "F");
                LOG.severe("account creation failure");
                ArrayList<XMLError> errorList = new ArrayList<XMLError>();
                errorList.add(error);
                result = ResponseBuilder.buildResponseDocument(errorList, "user");
            }
        }
        catch (DuplicateAccountException dae) {
            XMLError error = null;
            error = new XMLError("duplicate account failure", "system", "106", "F");
            LOG.severe("duplicate account failure");
            ArrayList<XMLError> errorList = new ArrayList<XMLError>();
            errorList.add(error);
            result = ResponseBuilder.buildResponseDocument(errorList, "user");
            LOG.severe(CommonUtil.getStackTrace(dae));
        }
        catch (Exception e) {
            XMLError error = null;
            if (eCRAdapter.connectToSun()) {
                LOG.severe("Exception in user service communication");
                error = new XMLError("Exception in user service communication", "system", "230", "F");
            } else if (eCRAdapter.isProxyEnabled()) {
                LOG.severe("Exception in proxy communication");
                error = new XMLError("Exception in proxy communication", "system", "235", "F");
            } else {
                LOG.severe("Exception in internet communication");
                error = new XMLError("Exception in internet communication", "system", "245", "F");
            }
            ArrayList<XMLError> errorList = new ArrayList<XMLError>();
            errorList.add(error);
            result = ResponseBuilder.buildResponseDocument(errorList, "user");
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

