/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.util;

import com.sun.web.util.Ascii;
import com.sun.web.util.HttpDate;
import java.io.IOException;
import java.io.OutputStream;

public class MessageBytes
extends Ascii {
    protected byte[] bytes;
    protected int offset;
    protected int length;

    public MessageBytes() {
    }

    public MessageBytes(byte[] byArray, int n, int n2) {
        this.setBytes(byArray, n, n2);
    }

    public void reset() {
        this.bytes = null;
    }

    public void setBytes(byte[] byArray, int n, int n2) {
        this.bytes = byArray;
        this.offset = n;
        this.length = n2;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getBytes(byte[] byArray, int n) {
        if (this.bytes != null) {
            System.arraycopy(this.bytes, this.offset, byArray, n, this.length);
        }
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isSet() {
        return this.bytes != null;
    }

    public String toString() {
        return this.bytes != null ? new String(this.bytes, this.offset, this.length) : null;
    }

    public int toInteger() throws NumberFormatException {
        return MessageBytes.parseInt(this.bytes, this.offset, this.length);
    }

    public long toDate(HttpDate httpDate) throws IllegalArgumentException {
        if (this.bytes != null) {
            httpDate.parse(this.bytes, this.offset, this.length);
            return httpDate.getTime();
        }
        throw new IllegalArgumentException("invalid date format");
    }

    public boolean equals(String string) {
        byte[] byArray = this.bytes;
        int n = this.length;
        if (byArray == null || n != string.length()) {
            return false;
        }
        int n2 = this.offset;
        for (int i = 0; i < n; ++i) {
            if (byArray[n2++] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        byte[] byArray = this.bytes;
        int n = this.length;
        if (byArray == null || n != string.length()) {
            return false;
        }
        int n2 = this.offset;
        for (int i = 0; i < n; ++i) {
            if (MessageBytes.toLower(byArray[n2++]) == MessageBytes.toLower((byte)string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.bytes;
        if (byArray2 == null || n2 != this.length) {
            return false;
        }
        int n3 = this.offset;
        while (n2-- > 0) {
            if (byArray[n++] == byArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.bytes;
        if (byArray2 == null || n2 != this.length) {
            return false;
        }
        int n3 = this.offset;
        while (n2-- > 0) {
            if (MessageBytes.toLower(byArray[n++]) == MessageBytes.toLower(byArray2[n3++])) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string) {
        byte[] byArray = this.bytes;
        int n = string.length();
        if (byArray == null || n > this.length) {
            return false;
        }
        int n2 = this.offset;
        for (int i = 0; i < n; ++i) {
            if (byArray[n2++] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.bytes != null) {
            outputStream.write(this.bytes, this.offset, this.length);
        }
    }

    public int length() {
        return this.bytes != null ? this.length : 0;
    }
}

