/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.web.server.ConnectionHandler;
import com.sun.web.server.EndpointManager;
import com.sun.web.util.StringManager;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

class Endpoint
implements Runnable {
    private StringManager sm = StringManager.getManager("com.sun.web.server");
    private EndpointManager manager = EndpointManager.getManager();
    private boolean running = true;
    private InetAddress inet;
    private int port;
    private ServerSocket serverSocket;

    Endpoint(InetAddress inetAddress, int n) {
        this.inet = inetAddress;
        this.port = n;
    }

    int getPort() {
        return this.port;
    }

    InetAddress getAddress() {
        return this.inet;
    }

    void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    void shutdown() {
        this.running = false;
    }

    public void run() {
        while (this.running) {
            Object object;
            try {
                Socket socket = this.serverSocket.accept();
                object = this.manager.getHandler();
                ((ConnectionHandler)object).setEndpoint(this);
                ((ConnectionHandler)object).setSocket(socket);
                ((Thread)object).start();
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Exception exception) {
                this.running = false;
                object = this.sm.getString("endpoint.err.fatal", this.serverSocket, exception);
                System.err.println((String)object);
            }
        }
        this.manager.notifyEndpointDown(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.inet != null) {
            stringBuffer.append(this.inet);
        }
        stringBuffer.append(":" + this.port);
        return stringBuffer.toString();
    }
}

