/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util;

import com.sun.management.viperimpl.util.UnixDomainSocket;
import java.io.FileInputStream;
import java.io.IOException;

class UnixDomainSocketInputStream
extends FileInputStream {
    private boolean eof;
    private UnixDomainSocket impl;
    private byte[] temp = new byte[1];

    private static native void init();

    private native int socketRead(byte[] var1, int var2, int var3) throws IOException;

    UnixDomainSocketInputStream(UnixDomainSocket impl) throws IOException {
        super(impl.getFileDescriptor());
        this.impl = impl;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int length) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (length == 0) {
            return 0;
        }
        int n = this.socketRead(b, off, length);
        if (n <= 0) {
            this.eof = true;
            return -1;
        }
        return n;
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        int n = this.read(this.temp, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    public long skip(long numbytes) throws IOException {
        int r;
        long n;
        if (numbytes <= 0L) {
            return 0L;
        }
        int buflen = (int)Math.min(1024L, n);
        byte[] data = new byte[buflen];
        for (n = numbytes; n > 0L && (r = this.read(data, 0, (int)Math.min((long)buflen, n))) >= 0; n -= (long)r) {
        }
        return numbytes - n;
    }

    public int available() throws IOException {
        return this.impl.available();
    }

    public void close() throws IOException {
        this.impl.close();
    }

    protected void finalize() {
    }

    static {
        UnixDomainSocketInputStream.init();
    }
}

