/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.client;

import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.services.authentication.AuthenticationRequest;
import com.sun.management.viperimpl.services.authentication.client.ClientSecurityContext;
import com.sun.management.viperimpl.util.TimerTask;

public class HeartbeatTask
extends TimerTask {
    private AuthenticationRequest requester;
    private ClientSecurityContext csc;

    public HeartbeatTask(AuthenticationRequest requester, ClientSecurityContext csc) {
        if (requester == null || csc == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.requester = requester;
        this.csc = csc;
    }

    public void run() {
        if (this.csc.getAuthState() == 4 && this.csc.getHeartbeatPeriod() > 0L) {
            try {
                this.requester.authRequest("heartbeat", this.csc.generateMessageToken(null));
                return;
            }
            catch (Throwable t) {
                Debug.trace((String)"Authentication Client", (int)Debug.ERROR, (String)"Heart beat exception", (Throwable)t);
            }
        }
        this.cancel();
    }
}

