/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.client;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.services.authentication.AuthenticationRequest;
import com.sun.management.viperimpl.services.authentication.AuthenticatorSecurityToken;
import com.sun.management.viperimpl.services.authentication.ConfirmSecurityToken;
import com.sun.management.viperimpl.services.authentication.RequestSecurityToken;
import com.sun.management.viperimpl.services.authentication.ResponseSecurityToken;
import com.sun.management.viperimpl.services.authentication.SecurityToken;
import com.sun.management.viperimpl.services.authentication.client.ClientSecurityContext;
import com.sun.management.viperimpl.services.authentication.client.ClientSecurityFactory;
import com.sun.management.viperimpl.services.authentication.client.HeartbeatTask;
import com.sun.management.viperimpl.util.Timer;
import com.sun.management.viperimpl.util.TimerTask;
import java.util.Hashtable;
import java.util.Properties;

public class AuthenticationClient {
    private static final String AUTH_PACKAGE = "com.sun.management.viperimpl.services.authentication.client";
    private static final String AUTH_FACTORY_CLASSNAME = "ClientSecurityFactory";
    private static boolean inited = false;
    private static int dfltType;
    private static Hashtable factTable;
    private static Timer heart;

    public static void init(Properties props) throws AuthenticationException {
        String dflt_flavor;
        ClientSecurityFactory sf;
        if (inited) {
            return;
        }
        String[] flavors = AuthenticationFlavor.getAuthFlavors();
        if (flavors.length < 1) {
            Debug.trace((String)"Authentication Client: Authentication Service", (int)Debug.ERROR, (String)"No authentication flavors configured", null);
            throw new AuthenticationException("No authentication flavors configured");
        }
        String basename = "com.sun.management.viperimpl.services.authentication.client.";
        factTable = new Hashtable();
        for (int i = 0; i < flavors.length; ++i) {
            String classname = basename + flavors[i] + AUTH_FACTORY_CLASSNAME;
            try {
                Class<?> cl = Class.forName(classname);
                sf = (ClientSecurityFactory)cl.newInstance();
            }
            catch (Exception ex) {
                Debug.trace((String)"Authentication Client: Authentication Service", (int)Debug.ERROR, (String)("Cannot create new instance of security factory " + classname), (Throwable)ex);
                throw new AuthenticationException("Cannot create new instance of security factory ", (Object)classname, ex);
            }
            sf.init(props);
            factTable.put(new Integer(i), sf);
        }
        int dflt_type = -1;
        if (props != null && (dflt_flavor = props.getProperty("auth.flavor.default")) != null) {
            dflt_type = AuthenticationFlavor.checkAuthFlavor((String)dflt_flavor);
        }
        if (dflt_type < 0) {
            dflt_type = AuthenticationFlavor.getDefaultAuthType();
        }
        if ((sf = (ClientSecurityFactory)factTable.get(new Integer(dflt_type))) == null) {
            Debug.trace((String)"Authentication Client: Authentication Service", (int)Debug.ERROR, (String)"No default authentication flavor is configured", null);
            throw new AuthenticationException("No default authentication flavor is configured");
        }
        dfltType = dflt_type;
        heart = new Timer(true);
        inited = true;
    }

    public static ClientSecurityContext getSecurityContext() throws AuthenticationException {
        return AuthenticationClient.createSecurityContext(dfltType);
    }

    public static ClientSecurityContext getSecurityContext(AuthenticationFlavor authFlavor) throws AuthenticationException {
        return AuthenticationClient.createSecurityContext(authFlavor.getAuthType());
    }

    public static void authenticate(AuthenticationRequest requester, ClientSecurityContext csc) throws AuthenticationException {
        ConfirmSecurityToken ctok;
        AuthenticatorSecurityToken atok;
        ResponseSecurityToken rtok;
        RequestSecurityToken itok;
        if (csc.getAuthState() != 0) {
            throw new AuthenticationException("EXM_PCF");
        }
        long beg = System.currentTimeMillis();
        try {
            itok = csc.generateRequestToken();
        }
        catch (AuthenticationException ex) {
            csc.reset();
            throw ex;
        }
        try {
            rtok = (ResponseSecurityToken)requester.authRequest("negotiate", itok);
        }
        catch (AuthenticationException ex) {
            Debug.trace((String)"Authentication Client: Authentication Service", (int)Debug.ERROR, (String)("Session authenticate: negotiate failed: " + ex.getMessage()), (Throwable)ex);
            csc.reset();
            throw ex;
        }
        try {
            atok = csc.verifyResponseToken(rtok);
        }
        catch (AuthenticationException ex) {
            csc.reset();
            throw ex;
        }
        try {
            ctok = (ConfirmSecurityToken)requester.authRequest("authenticate", atok);
        }
        catch (AuthenticationException ex) {
            Debug.trace((String)"Authentication Client: Authentication Service", (int)Debug.ERROR, (String)("Session authenticate: authenticate failed: " + ex.getMessage()), null);
            csc.reset();
            throw ex;
        }
        try {
            csc.verifyConfirmToken(ctok);
        }
        catch (AuthenticationException ex) {
            csc.reset();
            throw ex;
        }
        if (csc.getHeartbeatPeriod() > 0L) {
            heart.schedule((TimerTask)new HeartbeatTask(requester, csc), csc.getHeartbeatPeriod(), csc.getHeartbeatPeriod());
        }
    }

    public static void close(AuthenticationRequest requester, ClientSecurityContext csc) throws AuthenticationException {
        SecurityToken st = csc.getSecurityToken();
        csc.reset();
        requester.authRequest("close", st);
    }

    private static synchronized ClientSecurityContext createSecurityContext(int type) throws AuthenticationException {
        ClientSecurityFactory sf = (ClientSecurityFactory)factTable.get(new Integer(type));
        if (sf == null) {
            Debug.trace((String)"Authentication Client: Authentication Service", (int)Debug.ERROR, (String)("Request to create security context for non-existent flavor" + type), null);
            throw new AuthenticationException("Request to create security context for non-existent authentication type ", (Object)new Integer(type));
        }
        ClientSecurityContext csc = sf.getClientSecurityContext();
        return csc;
    }
}

