/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.tty;

import com.sun.management.viperimpl.console.PrivilegeManager;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import java.security.CodeSource;
import java.text.MessageFormat;
import java.util.LinkedList;

public final class TTYPrivilegeManager
implements PrivilegeManager {
    protected PrintStream output = null;
    protected InputStream input = null;
    protected PrintStream error = null;
    protected boolean trustedMode = false;
    protected LinkedList grantSet = null;
    protected LinkedList denySet = null;
    protected static final int GRANT_PRIVILEGE = 0;
    protected static final int DENY_PRIVILEGE = 1;
    protected static final int GRANT_CODEBASE = 2;
    protected static final int DENY_CODEBASE = 3;
    protected static final int READ = 0;
    protected static final int WRITE = 1;
    protected static final int DELETE = 2;
    protected static final int LINK = 3;
    protected static final int EXEC = 4;
    protected static String title = null;
    protected static String wishToAllow = null;
    protected static String grantString = null;
    protected static String denyString = null;
    protected static String unknownLoc = null;
    protected static String dontAsk = null;
    protected static MessageFormat readDesc = null;
    protected static MessageFormat readFDDesc = null;
    protected static MessageFormat writeDesc = null;
    protected static MessageFormat writeFDDesc = null;
    protected static MessageFormat deleteDesc = null;
    protected static MessageFormat execDesc = null;
    protected static MessageFormat linkDesc = null;

    public TTYPrivilegeManager() {
        this.installStrings();
    }

    void init(InputStream input, PrintStream output, PrintStream error, boolean trusted) {
        this.input = input;
        this.output = output;
        this.error = error;
        this.trustedMode = trusted;
    }

    boolean checkGrantSet(URL location) {
        if (this.grantSet == null) {
            return false;
        }
        if (location == null) {
            return this.grantSet.contains(null);
        }
        return this.grantSet.contains(location.toString());
    }

    void checkDenySet(URL location) {
        if (this.denySet == null) {
            return;
        }
        if (location == null && this.denySet.contains(null)) {
            throw new SecurityException();
        }
        if (this.denySet.contains(location.toString())) {
            throw new SecurityException();
        }
    }

    protected synchronized void promptUserToAllow(CodeSource codeSource, int type, Object[] args) {
        URL location = null;
        if (codeSource != null) {
            location = codeSource.getLocation();
        }
        if (this.checkGrantSet(location)) {
            return;
        }
        this.checkDenySet(location);
        int userPref = this.doPrompt(codeSource, type, args);
        if (userPref == 2) {
            if (this.grantSet == null) {
                this.grantSet = new LinkedList();
            }
            if (location == null) {
                this.grantSet.add(null);
            } else {
                this.grantSet.add(location.toString());
            }
        } else {
            if (userPref == 3) {
                if (this.denySet == null) {
                    this.denySet = new LinkedList();
                }
                if (location == null) {
                    this.denySet.add(null);
                } else {
                    this.denySet.add(location.toString());
                }
                throw new SecurityException();
            }
            if (userPref == 1) {
                throw new SecurityException();
            }
        }
    }

    public void checkReadPrivilege(FileDescriptor fd, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 0, new Object[]{fd});
    }

    public void checkReadPrivilege(String file, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 0, new Object[]{file});
    }

    public void checkReadPrivilege(String file, Object context, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 0, new Object[]{file, context});
    }

    public void checkWritePrivilege(FileDescriptor fd, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 1, new Object[]{fd});
    }

    public void checkWritePrivilege(String file, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 1, new Object[]{file});
    }

    public void checkDeletePrivilege(String file, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 2, new Object[]{file});
    }

    public void checkExecPrivilege(String cmd, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 4, new Object[]{cmd});
    }

    public void checkLinkPrivilege(String lib, CodeSource codeSource) {
        if (this.trustedMode) {
            return;
        }
        this.promptUserToAllow(codeSource, 3, new Object[]{lib});
    }

    protected int doPrompt(CodeSource codeSource, int type, Object[] args) {
        switch (type) {
            case 0: {
                return this.doReadPrompt(codeSource, args);
            }
            case 1: {
                return this.doWritePrompt(codeSource, args);
            }
            case 2: {
                return this.doDeletePrompt(codeSource, args);
            }
            case 3: {
                return this.doLinkPrompt(codeSource, args);
            }
            case 4: {
                return this.doExecPrompt(codeSource, args);
            }
        }
        return 1;
    }

    protected int doReadPrompt(CodeSource codeSource, Object[] args) {
        try {
            String hostPort = this.getHostPortFor(codeSource);
            this.error.println("\n[ " + title + " ]");
            if (args[0] instanceof String) {
                String file = (String)args[0];
                this.error.println(readDesc.format(new Object[]{hostPort, file}));
            } else {
                this.error.println(readFDDesc.format(new Object[]{hostPort}));
            }
            return this.handleInput();
        }
        catch (Throwable throwable) {
            return 1;
        }
    }

    protected int doWritePrompt(CodeSource codeSource, Object[] args) {
        try {
            String hostPort = this.getHostPortFor(codeSource);
            this.error.println("\n[ " + title + " ]");
            if (args[0] instanceof String) {
                String file = (String)args[0];
                this.error.println(writeDesc.format(new Object[]{hostPort, file}));
            } else {
                this.error.println(writeFDDesc.format(new Object[]{hostPort}));
            }
            return this.handleInput();
        }
        catch (Throwable throwable) {
            return 1;
        }
    }

    protected int doDeletePrompt(CodeSource codeSource, Object[] args) {
        try {
            String hostPort = this.getHostPortFor(codeSource);
            this.error.println("\n[ " + title + " ]");
            String file = (String)args[0];
            this.error.println(deleteDesc.format(new Object[]{hostPort, file}));
            return this.handleInput();
        }
        catch (Throwable throwable) {
            return 1;
        }
    }

    protected int doLinkPrompt(CodeSource codeSource, Object[] args) {
        try {
            String hostPort = this.getHostPortFor(codeSource);
            this.error.println("\n[ " + title + " ]");
            String file = (String)args[0];
            this.error.println(linkDesc.format(new Object[]{hostPort, file}));
            return this.handleInput();
        }
        catch (Throwable throwable) {
            return 1;
        }
    }

    protected int doExecPrompt(CodeSource codeSource, Object[] args) {
        try {
            String hostPort = this.getHostPortFor(codeSource);
            this.error.println("\n[ " + title + " ]");
            String file = (String)args[0];
            this.error.println(execDesc.format(new Object[]{hostPort, file}));
            return this.handleInput();
        }
        catch (Throwable throwable) {
            return 1;
        }
    }

    protected int handleInput() throws Exception {
        this.error.print(wishToAllow);
        this.error.print(" [" + grantString + " | " + denyString + "] : ");
        BufferedReader br = new BufferedReader(new InputStreamReader(this.input));
        String choice = br.readLine();
        choice = choice.trim();
        choice = choice.toLowerCase();
        this.error.println();
        this.error.print(dontAsk);
        this.error.print(" [" + grantString + " | " + denyString + "] : ");
        String choice2 = br.readLine();
        choice2 = choice2.trim();
        choice2 = choice2.toLowerCase();
        String grant = grantString.toLowerCase();
        if (choice.length() == 0 || choice.equals(grant)) {
            if (choice2.length() == 0 || choice2.equals(grant)) {
                return 2;
            }
            return 0;
        }
        if (choice2.length() == 0 || choice2.equals(grant)) {
            return 3;
        }
        return 1;
    }

    protected String getHostPortFor(CodeSource codeSource) {
        URL u = null;
        if (codeSource != null) {
            u = codeSource.getLocation();
        }
        if (u == null) {
            return unknownLoc;
        }
        String host = u.getHost();
        if (host == null) {
            return u.toString();
        }
        try {
            InetAddress ia = InetAddress.getByName(host);
            host = ia.getHostName();
        }
        catch (Throwable t) {
            // empty catch block
        }
        int port = u.getPort();
        if (port != -1) {
            return host + ":" + port;
        }
        return host;
    }

    protected void installStrings() {
        unknownLoc = ImplResourceManager.getString("an unkown location");
        wishToAllow = ImplResourceManager.getString("WishToAllow");
        grantString = ImplResourceManager.getString("GrantString");
        denyString = ImplResourceManager.getString("DenyString");
        try {
            readDesc = new MessageFormat(ImplResourceManager.getString("ReadDescription"));
            readFDDesc = new MessageFormat(ImplResourceManager.getString("ReadFDDescription"));
            writeDesc = new MessageFormat(ImplResourceManager.getString("WriteDescription"));
            writeFDDesc = new MessageFormat(ImplResourceManager.getString("WriteFDDescription"));
            deleteDesc = new MessageFormat(ImplResourceManager.getString("DeleteDescription"));
            execDesc = new MessageFormat(ImplResourceManager.getString("ExecDescription"));
            linkDesc = new MessageFormat(ImplResourceManager.getString("LinkDescription"));
            dontAsk = ImplResourceManager.getString("RememberDecision");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        title = ImplResourceManager.getString("Security Manager Alert");
    }

    public static void main(String[] args) {
        TTYPrivilegeManager pm = new TTYPrivilegeManager();
        pm.init(System.in, System.out, System.err, false);
        pm.checkReadPrivilege("/usr/sadm/lib", null);
        pm.checkWritePrivilege("/usr/sadm/lib", null);
        pm.checkDeletePrivilege("/usr/sadm/lib", null);
        pm.checkLinkPrivilege("/usr/sadm/lib", null);
        pm.checkExecPrivilege("/usr/sadm/lib", null);
        System.exit(0);
    }
}

