/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.console.VConsole;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleLF;
import com.sun.management.viper.console.VConsoleManager;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.gui.VAboutBox;
import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.VGUIConsole;
import com.sun.management.viper.console.gui.VSplashScreen;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.SMCVersion;
import com.sun.management.viperimpl.console.BaseConsoleManager;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.gui.GUIConsoleManager;
import com.sun.management.viperimpl.console.gui.PreferencesPane;
import com.sun.management.viperimpl.console.gui.lf.SMCLF;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class SMCConsole
extends VGUIConsole {
    protected static VAboutBox aboutBox = null;
    protected static PreferencesPane prefsPane = null;
    protected static Class imageClass = null;
    protected static ImageIcon frameIcon = null;
    protected String initialToolBox = null;

    public SMCConsole() {
        VSplashScreen.setMessageText((String)ImplResourceManager.getString("Setting look & feel..."));
        this.setConsoleTitle(this.getMyConsoleTitle() + " " + SMCConsole.smcVersion());
        try {
            if (imageClass == null) {
                imageClass = Class.forName("com.sun.management.viperimpl.console.gui.SMCConsole");
                String sep = System.getProperty("file.separator");
                frameIcon = sep.equals("/") ? ConsoleUtility.loadImageIcon((String)"images/smc_48.gif", (Class)imageClass) : ConsoleUtility.loadImageIcon((String)"images/smc_16.gif", (Class)imageClass);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected String getMyConsoleTitle() {
        return ImplResourceManager.getString("Solaris Management Console");
    }

    protected String getMyAboutTitle() {
        return ImplResourceManager.getString("About Solaris Management Console");
    }

    protected VConsoleLF getMyLookAndFeel() {
        return null;
    }

    protected VConsoleManager getMyManager() {
        return new GUIConsoleManager();
    }

    protected void initProperties() {
        this.setProperties(VConsoleProperties.newInstance((String)".smc.properties"));
    }

    protected void initManager() {
        try {
            VSplashScreen.setMessageText((String)ImplResourceManager.getString("Setting console manager..."));
            this.consoleManager = this.getMyManager();
            this.consoleManager.init((VConsole)this, null);
            this.addConsoleActionListener((VConsoleActionListener)this.consoleManager);
            this.consoleManager.addConsoleActionListener((VConsoleActionListener)this);
            this.consoleManager.setProperties(this.properties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setInitialOptions(String initialAuthData, String initialHostName, String initialUserName, String initialPassword, String initialRoleName, String initialRolePassword, String initialToolBox, String initialTool, AdminMgmtScope initialScope, String[] initialToolOptions, boolean trusted, boolean yesToAll, boolean silent, InputStream input, PrintStream output, PrintStream error) {
        this.initialToolBox = initialToolBox;
        ((BaseConsoleManager)this.consoleManager).setInitialOptions(initialHostName, initialUserName, initialPassword, initialRoleName, initialRolePassword, initialToolBox, initialTool, initialScope, initialToolOptions, trusted, yesToAll, silent, input, output, error);
    }

    /*
     * Loose catch block
     */
    public void start() throws CriticalStopException {
        block11: {
            this.showBusyState(true);
            this.notifyListeners(new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)ImplResourceManager.getString("Starting Console...")));
            this.createDialogs();
            if (this.dataModel != null) {
                this.showBusyState(false);
                return;
            }
            if (this.initialToolBox != null) {
                this.showBusyState(false);
                this.openConsole(this.initialToolBox);
                return;
            }
            String tbToLoad = this.properties.getProperty("vconsole.loadonstartup");
            if (tbToLoad == null) break block11;
            if (tbToLoad.equals("vconsole.hometoolbox")) {
                tbToLoad = this.properties.getProperty("vconsole.hometoolbox");
            } else if (tbToLoad.equals("vconsole.lasttoolbox")) {
                tbToLoad = this.properties.getProperty("vconsole.lasttoolbox");
            } else {
                this.openConsole(null);
                this.showBusyState(false);
                return;
            }
            this.showBusyState(false);
            this.openConsole(tbToLoad);
            return;
            {
                catch (Throwable t) {
                    Debug.trace((String)"Console", (int)Debug.ERROR, (String)"Problem starting console", (Throwable)t);
                    throw new CriticalStopException(t.getMessage());
                }
            }
        }
        try {
            String host = InetAddress.getLocalHost().getHostName();
            String defaultTB = "http://" + host + ":" + 898 + "/toolboxes/smc.tbx";
            VBaseConfiguration.createConfiguration(new URL(defaultTB), ResourceManager.currentLocale);
            this.properties.setProperty("vconsole.loadonstartup", "vconsole.hometoolbox");
            this.properties.setProperty("vconsole.hometoolbox", defaultTB);
            this.showBusyState(false);
            this.openConsole(defaultTB);
            return;
        }
        catch (Throwable throwable) {
            this.showBusyState(false);
            this.openConsole(null);
        }
    }

    public void setContainer(Container container) {
        super.setContainer(container);
        try {
            if (container instanceof Frame) {
                ((Frame)container).setIconImage(frameIcon.getImage());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void consoleAction(VConsoleEvent e) {
        super.consoleAction(e);
        String eventID = e.getID();
        if (eventID.equals("vconsole.displaypreferences")) {
            try {
                if (prefsPane == null) {
                    prefsPane = new PreferencesPane();
                    VFrame f = new VFrame();
                    prefsPane.setContainer((Component)f);
                }
                prefsPane.setProperties(this.properties);
                prefsPane.init();
                prefsPane.showCenter((Component)this.properties.getPropertyObject("vconsole.frame"));
                prefsPane.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static String smcVersion() {
        return SMCVersion.getVersion();
    }

    protected static String viperVersion() {
        return "1.1";
    }

    protected void showAboutInfo() {
        if (aboutBox == null) {
            this.createAboutBox();
        }
        aboutBox.getContainer().showCenter(null);
    }

    protected void showHelpOverview() {
        super.showHelpOverview();
        this.helpViewer.consoleAction(new VConsoleEvent((Object)this, "vconsole.hyperlinkevent", (Object)"smc_userguide_overview"));
    }

    protected void createAboutBox() {
        aboutBox = new VAboutBox();
        aboutBox.setTitle(this.getMyConsoleTitle() + " " + SMCVersion.getVersion());
        String desc = ImplResourceManager.getString("About_Copyright") + "\n" + ImplResourceManager.getString("Build date: ") + "2006/01/20" + "\n\n" + ImplResourceManager.getString("About_Copyright_fr");
        aboutBox.setDescription(desc);
        aboutBox.requestDefaultFocus();
        String dType = this.properties.getProperty("vconsole.dialogtype");
        if (dType == null || dType.equals("vconsole.frame")) {
            JFrame frame = (JFrame)this.properties.getPropertyObject("vconsole.frame");
            VDialog d = new VDialog((Frame)frame, this.getMyAboutTitle(), true);
            aboutBox.setContainer((VContainer)d);
            d.setComponent((Component)aboutBox);
        }
    }

    protected void installLookAndFeel() {
        super.setLookAndFeel((VConsoleLF)new SMCLF());
    }

    public static void main(String[] args) {
    }
}

