/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class FontChooser
extends VOptionPane
implements Serializable,
TreeSelectionListener,
ActionListener,
Runnable {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected JDialog dialog = null;
    protected JComboBox comboBox2 = null;
    protected DefaultMutableTreeNode rootNode = null;
    protected JTree fontTree = null;
    protected JTextArea preview = null;
    protected JScrollPane treePane = null;
    protected JButton colorButton = null;
    protected Font font = this.getFont();
    protected int returnValue = 1;
    protected JButton okButton = null;
    protected JButton cancelButton = null;
    protected JLabel fontsLabel = null;
    protected JLabel sizeLabel = null;
    protected JLabel colorLabel = null;
    protected JLabel previewLabel = null;
    protected transient String normalHelp = null;
    protected transient String normalTitle = null;
    protected JColorChooser colorChooser = null;

    public FontChooser() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBorder(new EmptyBorder(15, 15, 15, 15));
        this.toggleContentTitle(false);
        JPanel totalPanel = new JPanel();
        totalPanel.setLayout(new BoxLayout(totalPanel, 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        this.fontsLabel = new JLabel();
        p1.add(this.fontsLabel);
        p1.add(Box.createHorizontalGlue());
        totalPanel.add(p1);
        totalPanel.add(Box.createVerticalStrut(10));
        totalPanel.add(this.buildTreePane());
        totalPanel.add(Box.createVerticalStrut(10));
        JPanel p3 = new JPanel(new GridLayout(1, 2));
        JPanel p31 = new JPanel();
        p31.setLayout(new BoxLayout(p31, 0));
        this.sizeLabel = new JLabel();
        p31.add(this.sizeLabel);
        p31.add(Box.createHorizontalStrut(10));
        this.comboBox2 = new JComboBox();
        p31.add(this.comboBox2);
        p31.add(Box.createHorizontalStrut(5));
        JPanel p32 = new JPanel();
        p32.add(Box.createHorizontalStrut(5));
        p32.setLayout(new BoxLayout(p32, 0));
        this.colorLabel = new JLabel();
        p32.add(this.colorLabel);
        p32.add(Box.createHorizontalStrut(10));
        this.colorButton = new JButton("  ");
        p32.add(this.colorButton);
        p3.add(p31);
        p3.add(p32);
        totalPanel.add(p3);
        totalPanel.add(Box.createVerticalStrut(10));
        this.initComboBox();
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FontChooser.this.colorChooser == null) {
                    FontChooser.this.colorChooser = new JColorChooser();
                }
                JColorChooser cfr_ignored_0 = FontChooser.this.colorChooser;
                Color c = JColorChooser.showDialog(FontChooser.this.dialog, ImplResourceManager.getString("Choose Color"), FontChooser.this.colorButton.getBackground());
                if (c != null) {
                    FontChooser.this.colorButton.setBackground(c);
                    FontChooser.this.preview.setForeground(c);
                }
            }
        });
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        this.previewLabel = new JLabel();
        p2.add(this.previewLabel);
        p2.add(Box.createHorizontalGlue());
        totalPanel.add(p2);
        totalPanel.add(Box.createVerticalStrut(10));
        totalPanel.add(this.buildPreview());
        this.getContentPane().add((Component)totalPanel, "Center");
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontChooser.this.returnValue = 0;
                if (FontChooser.this.dialog != null) {
                    FontChooser.this.dialog.setVisible(false);
                }
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontChooser.this.returnValue = 1;
                if (FontChooser.this.dialog != null) {
                    FontChooser.this.dialog.setVisible(false);
                }
            }
        });
        this.getButtonPane().add(this.okButton);
        this.getButtonPane().add(this.cancelButton);
        this.treePane.setViewportView(this.buildTree());
        this.init();
    }

    protected void loadSystemFonts() {
        Vector fontFamilyNode = new Vector();
        Font[] fonts = null;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            fonts = ge.getAllFonts();
            for (int i = 0; i < fonts.length; ++i) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(new chooserFont(fonts[i]));
                String family = fonts[i].getFamily();
                String testFamily = null;
                DefaultMutableTreeNode test = null;
                Enumeration<TreeNode> e = this.rootNode.children();
                while (e.hasMoreElements() && (testFamily = (String)(test = (DefaultMutableTreeNode)e.nextElement()).getUserObject()).compareTo(family) != 0) {
                    test = null;
                }
                if (test == null) {
                    DefaultMutableTreeNode parent = new DefaultMutableTreeNode(family);
                    this.rootNode.add(parent);
                    parent.add(node);
                    continue;
                }
                test.add(node);
            }
            DefaultTreeModel model = (DefaultTreeModel)this.fontTree.getModel();
            model.reload(this.rootNode);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected Component buildTreePane() {
        this.treePane = new JScrollPane(){

            public Dimension getPreferredSize() {
                return new Dimension(350, 200);
            }
        };
        return this.treePane;
    }

    protected JTree buildTree() {
        this.rootNode = new DefaultMutableTreeNode();
        this.fontTree = new JTree(this.rootNode);
        this.fontTree.setShowsRootHandles(true);
        this.fontTree.setRootVisible(false);
        TreeSelectionModel tsm = this.fontTree.getSelectionModel();
        tsm.addTreeSelectionListener(this);
        return this.fontTree;
    }

    protected void initComboBox() {
        this.comboBox2.setEditable(true);
        this.comboBox2.addItem(new Integer("8"));
        this.comboBox2.addItem(new Integer("9"));
        this.comboBox2.addItem(new Integer("10"));
        this.comboBox2.addItem(new Integer("11"));
        this.comboBox2.addItem(new Integer("12"));
        this.comboBox2.addItem(new Integer("13"));
        this.comboBox2.addItem(new Integer("14"));
        this.comboBox2.addItem(new Integer("16"));
        this.comboBox2.addItem(new Integer("18"));
        this.comboBox2.addItem(new Integer("20"));
        this.comboBox2.addItem(new Integer("24"));
        this.comboBox2.addItem(new Integer("28"));
        this.comboBox2.addActionListener(this);
    }

    protected JComponent buildPreview() {
        this.preview = new JTextArea("AaBbCc...XxYyZz"){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 50);
            }
        };
        this.preview.setFont(this.font);
        this.preview.setBorder(new EmptyBorder(5, 5, 5, 5));
        return new JScrollPane(this.preview);
    }

    public void init() {
        this.installStrings();
        this.updateFontAndColor();
    }

    public Font getFont() {
        return this.font;
    }

    public Color getColor() {
        if (this.colorButton != null) {
            return this.colorButton.getBackground();
        }
        return null;
    }

    public int showFontDialog(Font initialFont, Color initialColor, Component parent) {
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        this.dialog = new VDialog(frame, null, true);
        this.setHelpHTML(this.normalHelp);
        this.setTitle(this.normalTitle);
        super.setContainer((Component)this.dialog);
        this.dialog.pack();
        this.preview.setFont(initialFont);
        this.preview.setForeground(initialColor);
        this.colorButton.setBackground(initialColor);
        this.comboBox2.getEditor().setItem(new Integer(initialFont.getSize()));
        this.fontTree.clearSelection();
        TreeModel model = this.fontTree.getModel();
        if (model instanceof DefaultTreeModel) {
            ((DefaultTreeModel)model).reload((TreeNode)model.getRoot());
        }
        this.dialog.setLocationRelativeTo(parent);
        if (this.rootNode.getChildCount() == 0) {
            try {
                new Thread(this).start();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.dialog.show();
        return this.returnValue;
    }

    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(150L);
            if (this.parentContainer instanceof VContainer) {
                this.parentContainer.showBusyState(true);
            }
            this.loadSystemFonts();
            if (this.parentContainer instanceof VContainer) {
                this.parentContainer.showBusyState(false);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void installStrings() {
        this.fontsLabel.setText(ImplResourceManager.getString("Available Fonts"));
        this.fontsLabel.setLabelFor(this.fontTree);
        this.fontsLabel.setDisplayedMnemonic(ImplResourceManager.getString("Available Fonts_mnemonic").charAt(0));
        this.previewLabel.setText(ImplResourceManager.getString("Preview"));
        this.previewLabel.setLabelFor(this.preview);
        this.previewLabel.setDisplayedMnemonic(ImplResourceManager.getString("Preview_mnemonic").charAt(0));
        this.sizeLabel.setText(ImplResourceManager.getString("Size"));
        this.sizeLabel.setLabelFor(this.comboBox2);
        this.sizeLabel.setDisplayedMnemonic(ImplResourceManager.getString("Size_mnemonic").charAt(0));
        this.colorLabel.setText(ImplResourceManager.getString("Color"));
        this.colorLabel.setLabelFor(this.colorButton);
        this.colorLabel.setDisplayedMnemonic(ImplResourceManager.getString("Color_mnemonic").charAt(0));
        this.cancelButton.setText(ResourceManager.getString((String)"CANCEL_BUTTON"));
        this.cancelButton.setMnemonic(ResourceManager.getString((String)"CANCEL_BUTTON__mnemonic").charAt(0));
        this.cancelButton.getAccessibleContext().setAccessibleName(ResourceManager.getString((String)"CANCEL_BUTTON_accessible_name"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getString((String)"CANCEL_BUTTON_accessible_desc"));
        this.okButton.setText(ResourceManager.getString((String)"OK_BUTTON"));
        this.okButton.setMnemonic(ResourceManager.getString((String)"OK_BUTTON_mnemonic").charAt(0));
        this.okButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("OK_BUTTON_accessible_name"));
        this.okButton.getAccessibleContext().setAccessibleDescription(ImplResourceManager.getString("OK_BUTTON_accessible_name"));
        this.normalHelp = ImplResourceManager.getString("FontChooserHelp");
        this.normalHelp = ContextHelpLoader.getContextHelp((String)this.normalHelp, null);
        this.normalTitle = ImplResourceManager.getString("Choose Font");
        this.setTitle(this.normalTitle);
        this.setHelpHTML(this.normalHelp);
    }

    protected void updateFontAndColor() {
        this.fontsLabel.setFont(ResourceManager.labelFont);
        this.fontsLabel.setForeground(ResourceManager.labelColor);
        this.sizeLabel.setFont(ResourceManager.labelFont);
        this.sizeLabel.setForeground(ResourceManager.labelColor);
        this.previewLabel.setFont(ResourceManager.labelFont);
        this.previewLabel.setForeground(ResourceManager.labelColor);
        this.okButton.setFont(ResourceManager.menuFont);
        this.okButton.setForeground(ResourceManager.menuColor);
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setForeground(ResourceManager.menuColor);
    }

    public void valueChanged(TreeSelectionEvent e) {
        try {
            TreePath path = this.fontTree.getSelectionPath();
            if (path == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object obj = node.getUserObject();
            if (obj instanceof chooserFont) {
                chooserFont myf = (chooserFont)obj;
                Object o = this.comboBox2.getEditor().getItem();
                Integer size = null;
                if (o instanceof Integer) {
                    size = (Integer)o;
                } else if (o instanceof String) {
                    size = new Integer((String)o);
                }
                this.font = myf.getFont().deriveFont(size.floatValue());
                this.preview.setFont(this.font);
            }
            this.preview.validate();
            this.preview.repaint();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Object o = this.comboBox2.getEditor().getItem();
            Integer size = null;
            if (o instanceof Integer) {
                size = (Integer)o;
            } else if (o instanceof String) {
                size = new Integer((String)o);
            }
            if (this.font == null) {
                this.font = this.preview.getFont();
            }
            this.font = this.font.deriveFont(size.floatValue());
            this.preview.setFont(this.font);
            this.preview.validate();
            this.preview.repaint();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ResourceManager.seed((boolean)true);
        FontChooser chooser = new FontChooser();
        chooser.setFont(new JLabel().getFont());
        int r = chooser.showFontDialog(null, null, null);
        System.exit(0);
    }

    public void setContextHelp(String s) {
        this.normalHelp = ContextHelpLoader.getContextHelp((String)s, null);
    }

    class chooserFont {
        protected Font f = null;

        public chooserFont(Font f) {
            this.f = f;
        }

        public Font getFont() {
            return this.f;
        }

        public String toString() {
            String family = this.f.getFamily();
            String fname = this.f.getFontName();
            String name = fname.substring(family.length());
            if (name.length() == 0) {
                name = "Plain";
            }
            return name;
        }
    }
}

