/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.config.FolderNode;
import com.sun.management.viperimpl.console.config.ToolBoxNode;
import com.sun.management.viperimpl.console.config.ToolBoxURLNode;
import com.sun.management.viperimpl.console.config.ToolNode;
import com.sun.management.viperimpl.console.config.VBaseConfiguration;
import com.sun.management.viperimpl.console.config.VBaseNode;
import com.sun.management.viperimpl.console.config.toolInf;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import org.w3c.dom.Node;

public class checktool
implements toolInf {
    private CommandOption fileinOption = new CommandOption("in-file", "Input file", "f", 1, true, false, null, false);
    private CommandOption fileoutOption = new CommandOption("out-file", "output file", "o", 1, true, false, null, false);
    private CommandOption classOption = new CommandOption("CLASS", "Class name of tool", "c", 1, true, false, null, false);
    private CommandOption argsOption = new CommandOption("args", "Application Arguments", "p", 1, true, true, null, false);
    private CommandOption serverOption = new CommandOption("server", "Server where tool is located", "s", 1, true, false, null, false);
    private CommandOption scopeOption = new CommandOption("scope", "Scope of tool", "S", 1, true, false, null, false);
    private CommandOption tbxURLOption = new CommandOption("tbxURL", "ToolBox URL", "t", 1, true, false, null, false);
    private CommandOption folderOption = new CommandOption("folder name", "Folder Path", "F", 1, true, false, null, false);
    private CommandOption targetOption = new CommandOption("target", "smcconf target - legacy|tool|tbxURL|urlLink|folder|toolbox", "T", 1, false, false, null, false);
    private CommandOption operationOption = new CommandOption("operation", "operation - check/delete", "O", 1, false, false, null, false);
    private CommandOption NameOption = new CommandOption("Folder/Toolbox Name", "Folder/Toolbox Name", "n", 1, true, false, null, false);
    private CommandOption DescOption = new CommandOption("Folder/Toolbox Description", "Folder/Toolbox Description", "d", 1, true, false, null, false);
    private CommandOption SmallIconOption = new CommandOption("Folder/Toolbox Small Icon", "Folder/Toolbox Small Icon", "m", 1, true, false, null, false);
    private CommandOption LargeIconOption = new CommandOption("Folder/Toolbox Large Icon", "Folder/Toolbox Large Icon", "L", 1, true, false, null, false);
    private CommandOption helpOption = new CommandOption("help", "Help", "h", 0, true, false, null, false);
    private static String folderName = "/";
    private int retVal;

    public int getExecStatus() {
        return this.retVal;
    }

    private void setExecStatus(int status) {
        if (this.retVal == -99) {
            this.retVal = status;
        }
    }

    public void exec(String[] args) throws Exception {
        this.retVal = -99;
        ResourceManager.seed((boolean)false);
        CommandParser cp = new CommandParser("checktool", "Tool to check existing tools", true, System.in, System.out);
        cp.addOption(this.fileinOption);
        cp.addOption(this.fileoutOption);
        cp.addOption(this.classOption);
        cp.addOption(this.argsOption);
        cp.addOption(this.serverOption);
        cp.addOption(this.scopeOption);
        cp.addOption(this.tbxURLOption);
        cp.addOption(this.folderOption);
        cp.addOption(this.targetOption);
        cp.addOption(this.operationOption);
        cp.addOption(this.NameOption);
        cp.addOption(this.DescOption);
        cp.addOption(this.SmallIconOption);
        cp.addOption(this.LargeIconOption);
        cp.addOption(this.helpOption);
        String filein = null;
        String appClass = null;
        String appTarget = null;
        String fileout = null;
        String appOperation = null;
        String serverName = null;
        String folder = null;
        Properties props = new Properties();
        int serverPort = -1;
        if (!cp.parseArgs(args)) {
            this.retVal = 1;
            throw new Exception("Failed to parse args");
        }
        if (this.helpOption.wasSet()) {
            this.retVal = 0;
            throw new Exception(cp.getUsage(null));
        }
        if (this.fileinOption.wasSet()) {
            filein = (String)this.fileinOption.getValue();
        }
        appTarget = ((String)this.targetOption.getValue()).trim();
        appOperation = ((String)this.operationOption.getValue()).trim();
        if (this.classOption.wasSet()) {
            appClass = ((String)this.classOption.getValue()).trim();
        }
        if (this.fileoutOption.wasSet()) {
            fileout = ((String)this.fileoutOption.getValue()).trim();
        }
        if (this.folderOption.wasSet()) {
            folder = ((String)this.folderOption.getValue()).trim();
            if (!folder.startsWith("/")) {
                folder = "/" + folder;
            }
            if (!folder.endsWith("/")) {
                folder = folder + "/";
            }
        }
        if (appTarget.equals("legacy")) {
            File file;
            String executable;
            int portIndex;
            String appArgs = null;
            if (this.serverOption.wasSet() && (portIndex = (serverName = ((String)this.serverOption.getValue()).trim()).indexOf(58)) >= 0) {
                String tmpStr = serverName;
                serverName = tmpStr.substring(0, portIndex);
                String portNumber = tmpStr.substring(portIndex + 1).trim();
                if (portNumber.length() > 0) {
                    serverPort = new Integer(portNumber);
                }
            }
            if (this.argsOption.wasSet()) {
                Enumeration e = this.argsOption.getValues().elements();
                while (e.hasMoreElements()) {
                    String s = ((String)e.nextElement()).trim();
                    int i = s.indexOf(":");
                    props.setProperty(s.substring(0, i), s.substring(i + 1));
                }
                appArgs = props.toString();
            }
            if ((executable = props.getProperty("Command")) != null && !(file = new File(executable)).exists()) {
                this.retVal = 1;
                throw new Exception("Cannot find the specified executable path \"" + executable + "\"");
            }
            this.retVal = this.checkLegacyTool(filein, fileout, appClass, appArgs, folder, serverName, serverPort, appOperation);
        } else if (appTarget.equals("tool")) {
            int portIndex;
            String appScope = null;
            String propString = null;
            if (this.scopeOption.wasSet()) {
                appScope = ((String)this.scopeOption.getValue()).trim();
            }
            if (this.serverOption.wasSet() && (portIndex = (serverName = ((String)this.serverOption.getValue()).trim()).indexOf(58)) >= 0) {
                String tmpStr = serverName;
                serverName = tmpStr.substring(0, portIndex);
                String portNumber = tmpStr.substring(portIndex + 1).trim();
                if (portNumber.length() > 0) {
                    serverPort = new Integer(portNumber);
                }
            }
            if (this.argsOption.wasSet()) {
                Enumeration e = this.argsOption.getValues().elements();
                while (e.hasMoreElements()) {
                    String s = ((String)e.nextElement()).trim();
                    int i = s.indexOf(":");
                    props.setProperty(s.substring(0, i), s.substring(i + 1));
                }
                propString = props.toString();
            }
            this.retVal = this.checkViperTool(filein, fileout, appClass, appScope, serverName, appOperation, propString, serverPort, folder);
        } else if (appTarget.equals("tbxURL")) {
            String appTbxUrl = null;
            if (this.tbxURLOption.wasSet()) {
                appTbxUrl = ((String)this.tbxURLOption.getValue()).trim();
            }
            this.retVal = this.checkTbxUrlTool(filein, fileout, appTbxUrl, appOperation, folder);
        } else if (appTarget.equals("urlLink")) {
            String appTbxUrl = null;
            if (this.tbxURLOption.wasSet()) {
                appTbxUrl = ((String)this.tbxURLOption.getValue()).trim();
                this.retVal = this.checkUrlLink(appTbxUrl, fileout);
            }
        } else if (appTarget.equals("folder")) {
            String folderName = null;
            String folderDesc = null;
            String folderSmallIcon = null;
            String folderLargeIcon = null;
            folderName = ((String)this.NameOption.getValue()).trim();
            if (folderName.startsWith("/")) {
                folderName = folderName.substring(1, folderName.length());
            }
            if (folderName.endsWith("/")) {
                folderName = folderName.substring(0, folderName.length() - 1);
            }
            if (folderName.indexOf("/") > 0) {
                throw new Exception("Invalid '/' character in folder name" + ((String)this.NameOption.getValue()).trim());
            }
            if (folder != null && !folder.endsWith("/")) {
                folder = folder + "/";
            }
            if (this.DescOption.wasSet()) {
                folderDesc = ((String)this.DescOption.getValue()).trim();
            }
            if (this.SmallIconOption.wasSet()) {
                folderSmallIcon = ((String)this.SmallIconOption.getValue()).trim();
                this.checkIconValidity(folderSmallIcon, true);
            }
            if (this.LargeIconOption.wasSet()) {
                folderLargeIcon = ((String)this.LargeIconOption.getValue()).trim();
                this.checkIconValidity(folderLargeIcon, false);
            }
            if (folder == null) {
                folder = "/";
            }
            this.retVal = this.checkFolder(filein, fileout, folder, appOperation, folderName);
        } else if (appTarget.equals("toolbox")) {
            String appScope = null;
            String toolBoxName = null;
            String toolBoxDesc = null;
            String toolBoxSmallIcon = null;
            String toolBoxLargeIcon = null;
            if (this.scopeOption.wasSet()) {
                appScope = ((String)this.scopeOption.getValue()).trim();
            }
            if (this.NameOption.wasSet()) {
                toolBoxName = ((String)this.NameOption.getValue()).trim();
            }
            if (this.DescOption.wasSet()) {
                toolBoxDesc = ((String)this.DescOption.getValue()).trim();
            }
            if (this.SmallIconOption.wasSet()) {
                toolBoxSmallIcon = ((String)this.SmallIconOption.getValue()).trim();
            }
            if (this.LargeIconOption.wasSet()) {
                toolBoxLargeIcon = ((String)this.LargeIconOption.getValue()).trim();
            }
            OutputStream outStream = System.out;
            ToolBoxNode child = null;
            try {
                File outFile = new File(fileout);
                if (!outFile.exists()) {
                    outFile.createNewFile();
                }
                outStream = new FileOutputStream(fileout);
                VBaseConfiguration conf = VBaseConfiguration.createConfiguration();
                child = conf.createToolBoxNode(toolBoxName, toolBoxDesc, null, toolBoxSmallIcon, toolBoxLargeIcon, appScope, null);
                child.setAttribute("Version", "0.0");
                conf.appendChild((Node)((Object)child));
                conf.write(outStream);
                this.retVal = 0;
            }
            catch (Exception e) {
                this.retVal = 1;
                throw new Exception("\n" + e.getMessage() + "\n");
            }
        } else {
            this.retVal = 1;
            throw new Exception(cp.getUsage(null));
        }
    }

    public static void main(String[] args) {
        checktool t;
        block2: {
            t = new checktool();
            try {
                t.exec(args);
            }
            catch (Exception e) {
                if (e.getMessage().length() <= 0) break block2;
                System.out.println(e.getMessage());
            }
        }
        System.exit(t.getExecStatus());
    }

    private int checkIconValidity(String icon, boolean b) throws Exception {
        Object i = null;
        int errValue = 0;
        int iconSize = 0;
        if (b) {
            errValue = 3;
            iconSize = 16;
        } else {
            errValue = 4;
            iconSize = 32;
        }
        if (icon.indexOf(":/") >= 0) {
            try {
                URL u = new URL(icon);
            }
            catch (Exception e) {
                this.setExecStatus(errValue);
                throw new Exception("");
            }
        }
        return 0;
    }

    protected int checkUrlLink(String urlLink, String fileout) throws Exception {
        String fileSep = System.getProperty("file.separator");
        if (urlLink.indexOf("://") < 0 && !urlLink.startsWith("file:")) {
            if (urlLink.indexOf(fileSep) < 0 && !urlLink.endsWith(".tbx")) {
                urlLink = urlLink + fileSep + urlLink;
            }
            if (!urlLink.startsWith(fileSep)) {
                String toolboxDir = System.getProperty("viper.rthome") + "/toolboxes/";
                urlLink = "file:" + toolboxDir + urlLink;
            } else {
                urlLink = "file:" + urlLink;
            }
        }
        if (!urlLink.endsWith(".tbx")) {
            urlLink = urlLink + ".tbx";
        }
        try {
            String inputLine;
            File outFile;
            URL u = new URL(urlLink);
            URLConnection uc = u.openConnection();
            BufferedReader dis = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            int lastIndex = fileout.lastIndexOf(fileSep);
            String dir1 = fileout.substring(0, lastIndex);
            File dir2 = new File(dir1);
            if (!dir2.exists()) {
                dir2.mkdirs();
            }
            if (!(outFile = new File(fileout)).exists()) {
                outFile.createNewFile();
            }
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(fileout));
            while ((inputLine = dis.readLine()) != null) {
                inputLine = inputLine + "\n";
                dos.writeBytes(inputLine);
            }
            dis.close();
            dos.close();
        }
        catch (MalformedURLException me) {
            this.setExecStatus(1);
            throw new Exception(me.getMessage());
        }
        catch (IOException ioe) {
            this.setExecStatus(1);
            throw new Exception(ioe.getMessage());
        }
        return 0;
    }

    protected int checkTbxUrlTool(String filein, String fileout, String appTbxUrl, String appOperation, String folder) throws Exception {
        VBaseConfiguration conf = null;
        VBaseNode s = null;
        int retValue = -1;
        try {
            try {
                conf = VBaseConfiguration.createConfiguration(new URL(filein), true, true);
            }
            catch (MalformedURLException e) {
                conf = VBaseConfiguration.createConfiguration(new File(filein).toURL(), true, true);
            }
            VBaseNode root = (VBaseNode)conf.getRootNode();
            if (root == null) {
                return 1;
            }
            if (!root.children().hasMoreElements()) {
                if (appOperation.equals("check")) {
                    this.setExecStatus(1);
                    throw new Exception("");
                }
                this.setExecStatus(2);
                throw new Exception("");
            }
            Enumeration e = root.children();
            while (e.hasMoreElements()) {
                s = (VBaseNode)e.nextElement();
                if (folder == null) {
                    this.checkTbxUrlChildNode(s, appTbxUrl, appOperation, fileout, conf, folder);
                    continue;
                }
                s = this.findFolderNode(s, folder);
                folderName = "/";
                if (s == null) continue;
                try {
                    Enumeration e1 = s.children();
                    while (e1.hasMoreElements()) {
                        VBaseNode v2 = (VBaseNode)e1.nextElement();
                        this.checkTbxUrlChildNode(v2, appTbxUrl, appOperation, fileout, conf, folder);
                    }
                }
                catch (Exception e2) {
                    this.setExecStatus(1);
                    throw e2;
                }
                return 1;
            }
            if (s == null) {
                this.setExecStatus(2);
                throw new Exception("");
            }
        }
        catch (Exception e) {
            this.setExecStatus(1);
            throw e;
        }
        return 1;
    }

    protected int checkFolder(String filein, String fileout, String folder, String appOperation, String newfolderName) throws Exception {
        VBaseConfiguration conf = null;
        VBaseNode s = null;
        int retValue = -1;
        try {
            Enumeration e;
            try {
                conf = VBaseConfiguration.createConfiguration(new URL(filein), true, true);
            }
            catch (MalformedURLException e2) {
                conf = VBaseConfiguration.createConfiguration(new File(filein).toURL(), true, true);
            }
            VBaseNode root = (VBaseNode)conf.getRootNode();
            if (root == null) {
                return 1;
            }
            if (!root.children().hasMoreElements()) {
                if (appOperation.equals("check")) {
                    this.setExecStatus(1);
                    throw new Exception("");
                }
                this.setExecStatus(2);
                throw new Exception("");
            }
            if (!folder.equals("/")) {
                e = root.children();
                while (e.hasMoreElements()) {
                    s = (VBaseNode)e.nextElement();
                    if ((s = this.getFolderNode(s, folder)) != null) break;
                    folderName = "/";
                }
            }
            folder = folder + newfolderName + "/";
            e = root.children();
            while (e.hasMoreElements()) {
                s = (VBaseNode)e.nextElement();
                if ((s = this.getFolderNode(s, folder)) == null) {
                    folderName = "/";
                    continue;
                }
                if (appOperation.equals("check")) {
                    this.setExecStatus(0);
                    throw new Exception("");
                }
                this.checkFolderChildNode(s, appOperation, fileout, conf, folder, newfolderName);
            }
            if (s == null) {
                if (appOperation.equals("check")) {
                    this.setExecStatus(1);
                    throw new Exception("");
                }
                this.setExecStatus(2);
                throw new Exception("");
            }
        }
        catch (Exception e) {
            this.setExecStatus(1);
            throw e;
        }
        return 1;
    }

    protected int checkViperTool(String filein, String fileout, String appClass, String appScope, String serverName, String appOperation, String propString, int serverPort, String folder) throws Exception {
        VBaseConfiguration conf = null;
        VBaseNode s = null;
        try {
            try {
                conf = VBaseConfiguration.createConfiguration(new URL(filein), true, true);
            }
            catch (MalformedURLException e) {
                conf = VBaseConfiguration.createConfiguration(new File(filein).toURL(), true, true);
            }
            VBaseNode root = (VBaseNode)conf.getRootNode();
            if (root == null) {
                return 1;
            }
            if (!root.children().hasMoreElements()) {
                if (appOperation.equals("check")) {
                    this.setExecStatus(1);
                    throw new Exception("");
                }
                this.setExecStatus(2);
                throw new Exception("");
            }
            Enumeration e = root.children();
            while (e.hasMoreElements()) {
                s = (VBaseNode)e.nextElement();
                if (folder == null) {
                    this.checkViperChildNode(s, appClass, appScope, serverName, propString, appOperation, fileout, conf, serverPort, folder);
                    continue;
                }
                s = this.findFolderNode(s, folder);
                folderName = "/";
                if (s == null) continue;
                try {
                    Enumeration e1 = s.children();
                    while (e1.hasMoreElements()) {
                        VBaseNode v2 = (VBaseNode)e1.nextElement();
                        this.checkViperChildNode(v2, appClass, appScope, serverName, propString, appOperation, fileout, conf, serverPort, folder);
                    }
                }
                catch (Exception e2) {
                    this.setExecStatus(1);
                    throw e2;
                }
                return 1;
            }
            if (s == null) {
                this.setExecStatus(2);
                throw new Exception("");
            }
        }
        catch (Exception e) {
            this.setExecStatus(1);
            throw e;
        }
        return 1;
    }

    protected int checkLegacyTool(String filein, String fileout, String appClass, String appArgs, String folder, String serverName, int serverPort, String appOperation) throws Exception {
        VBaseConfiguration conf = null;
        VBaseNode s = null;
        try {
            try {
                conf = VBaseConfiguration.createConfiguration(new URL(filein), true, true);
            }
            catch (MalformedURLException e) {
                conf = VBaseConfiguration.createConfiguration(new File(filein).toURL(), true, true);
            }
            VBaseNode root = (VBaseNode)conf.getRootNode();
            if (root == null) {
                return 1;
            }
            if (!root.children().hasMoreElements()) {
                if (appOperation.equals("check")) {
                    this.setExecStatus(1);
                    throw new Exception("");
                }
                this.setExecStatus(2);
                throw new Exception("");
            }
            Enumeration e = root.children();
            while (e.hasMoreElements()) {
                s = (VBaseNode)e.nextElement();
                if (folder == null) {
                    this.checkLegacyChildNode(s, appClass, appArgs, folder, serverName, serverPort, appOperation, fileout, conf);
                    continue;
                }
                s = this.findFolderNode(s, folder);
                folderName = "/";
                if (s == null) continue;
                try {
                    Enumeration e1 = s.children();
                    while (e1.hasMoreElements()) {
                        VBaseNode v2 = (VBaseNode)e1.nextElement();
                        this.checkLegacyChildNode(v2, appClass, appArgs, folder, serverName, serverPort, appOperation, fileout, conf);
                    }
                }
                catch (Exception e2) {
                    this.setExecStatus(1);
                    throw e2;
                }
                return 1;
            }
            if (s == null) {
                this.setExecStatus(2);
                throw new Exception("");
            }
        }
        catch (Exception e) {
            this.setExecStatus(1);
            throw e;
        }
        return 1;
    }

    protected int checkLegacyChildNode(VBaseNode v, String appClass, String appArgs, String folder, String serverName, int serverPort, String appOperation, String fileout, VBaseConfiguration conf) throws Exception {
        boolean nodeFound = false;
        if (v == null) {
            return 1;
        }
        if (v instanceof ToolNode) {
            int appServerPort;
            String appServerName;
            String className = ((ToolNode)v).getClassName();
            if (!className.equals(appClass)) {
                return 1;
            }
            Properties p = ((ToolNode)v).getParameters();
            String pString = null;
            if (p != null) {
                pString = p.toString();
            }
            if (pString != null || appArgs != null) {
                if (pString == null || appArgs == null) {
                    return 1;
                }
                if (!pString.equals(appArgs)) {
                    return 1;
                }
            }
            if ((appServerName = ((ToolNode)v).getServerName()) != null && (appServerName = appServerName.trim()).length() <= 0) {
                appServerName = null;
            }
            if (appServerName != null && (appServerName = appServerName.trim()).length() <= 0) {
                appServerName = null;
            }
            if (appServerName != null || serverName != null) {
                if (appServerName == null || serverName == null) {
                    return 1;
                }
                if (!appServerName.equals(serverName)) {
                    return 1;
                }
            }
            if ((appServerPort = ((ToolNode)v).getServerPort()) != -1 || serverPort != -1) {
                if (appServerPort == -1 || serverPort == -1) {
                    return 1;
                }
                if (appServerPort != serverPort) {
                    return 1;
                }
            }
            nodeFound = true;
        }
        if (nodeFound) {
            if (appOperation.equals("check")) {
                this.setExecStatus(0);
                throw new Exception("");
            }
            v.removeFromParent();
            OutputStream outStream = System.out;
            try {
                outStream = new FileOutputStream(fileout);
                conf.write(outStream);
            }
            catch (Exception y) {
                this.setExecStatus(1);
                throw y;
            }
            this.setExecStatus(0);
            throw new Exception("");
        }
        if (folder == null) {
            try {
                Enumeration e = v.children();
                while (e.hasMoreElements()) {
                    VBaseNode v1 = (VBaseNode)e.nextElement();
                    this.checkLegacyChildNode(v1, appClass, appArgs, folder, serverName, serverPort, appOperation, fileout, conf);
                }
            }
            catch (Exception e) {
                this.setExecStatus(1);
                throw e;
            }
        }
        return 1;
    }

    protected VBaseNode getFolderNode(VBaseNode v, String folder) throws Exception {
        Object t1 = null;
        if (v instanceof FolderNode && v.getName() != null) {
            String tmpFolder = folderName + v.getName() + "/";
            if (folder.startsWith(tmpFolder)) {
                if (folder.equals(tmpFolder)) {
                    return v;
                }
                folderName = tmpFolder;
            }
            try {
                VBaseNode v1;
                VBaseNode t = null;
                Enumeration e = v.children();
                while (e.hasMoreElements() && ((v1 = (VBaseNode)e.nextElement()).getName() == null || (t = this.getFolderNode(v1, folder)) == null)) {
                }
                return t;
            }
            catch (Exception e) {
                this.setExecStatus(1);
                throw e;
            }
        }
        return null;
    }

    protected VBaseNode findFolderNode(VBaseNode v, String folder) throws Exception {
        String tmpFolder;
        if (v instanceof FolderNode && v.getName() != null && folder.startsWith(tmpFolder = folderName + v.getName() + "/")) {
            folderName = tmpFolder;
            if (folder.equals(folderName)) {
                return v;
            }
            try {
                VBaseNode t = null;
                Enumeration e = v.children();
                while (e.hasMoreElements()) {
                    VBaseNode v1 = (VBaseNode)e.nextElement();
                    t = this.findFolderNode(v1, folder);
                    if (t == null) continue;
                    return t;
                }
            }
            catch (Exception e) {
                this.setExecStatus(1);
                throw e;
            }
        }
        return null;
    }

    protected int checkFolderChildNode(VBaseNode v, String appOperation, String fileout, VBaseConfiguration conf, String folder, String newfolderName) throws Exception {
        boolean nodeFound = false;
        if (v == null) {
            return 1;
        }
        if (v instanceof FolderNode) {
            nodeFound = true;
        }
        if (nodeFound) {
            if (appOperation.equals("check")) {
                this.setExecStatus(0);
                throw new Exception("");
            }
            v.removeFromParent();
            OutputStream outStream = System.out;
            try {
                outStream = new FileOutputStream(fileout);
                conf.write(outStream);
            }
            catch (Exception y) {
                this.setExecStatus(1);
                throw y;
            }
            this.setExecStatus(0);
            throw new Exception("");
        }
        if (folder == null) {
            try {
                Enumeration e = v.children();
                while (e.hasMoreElements()) {
                    VBaseNode v1 = (VBaseNode)e.nextElement();
                    this.checkFolderChildNode(v1, appOperation, fileout, conf, folder, newfolderName);
                }
            }
            catch (Exception e) {
                this.setExecStatus(1);
                throw e;
            }
        }
        return 1;
    }

    protected int checkViperChildNode(VBaseNode v, String appClass, String appScope, String serverName, String propString, String appOperation, String fileout, VBaseConfiguration conf, int serverPort, String folder) throws Exception {
        boolean nodeFound = false;
        if (v == null) {
            return 1;
        }
        if (v instanceof ToolNode) {
            Properties p;
            int appServerPort;
            String appServerName;
            String className = ((ToolNode)v).getClassName();
            if (!className.equals(appClass)) {
                return 1;
            }
            String scope = ((ToolNode)v).getScope();
            if (scope != null && scope.startsWith("file:/")) {
                scope = null;
            }
            if (appScope != null || scope != null) {
                if (appScope == null || scope == null) {
                    return 1;
                }
                if (!appScope.equals(scope)) {
                    return 1;
                }
            }
            if ((appServerName = ((ToolNode)v).getServerName()) != null && (appServerName = appServerName.trim()).length() <= 0) {
                appServerName = null;
            }
            if (appServerName != null || serverName != null) {
                if (appServerName == null || serverName == null) {
                    return 1;
                }
                if (!appServerName.equals(serverName)) {
                    return 1;
                }
            }
            if ((appServerPort = ((ToolNode)v).getServerPort()) != -1 || serverPort != -1) {
                if (appServerPort == -1 || serverPort == -1) {
                    return 1;
                }
                if (appServerPort != serverPort) {
                    return 1;
                }
            }
            if ((p = ((ToolNode)v).getParameters()) != null || propString != null) {
                if (p == null || propString == null) {
                    return 1;
                }
                String pString = p.toString();
                if (!pString.equals(propString)) {
                    return 1;
                }
            }
            nodeFound = true;
        }
        if (nodeFound) {
            if (appOperation.equals("check")) {
                this.setExecStatus(0);
                throw new Exception("");
            }
            v.removeFromParent();
            OutputStream outStream = System.out;
            try {
                outStream = new FileOutputStream(fileout);
                conf.write(outStream);
            }
            catch (Exception y) {
                this.setExecStatus(1);
                throw y;
            }
            this.setExecStatus(0);
            throw new Exception("");
        }
        if (folder == null) {
            try {
                Enumeration e = v.children();
                while (e.hasMoreElements()) {
                    VBaseNode v1 = (VBaseNode)e.nextElement();
                    this.checkViperChildNode(v1, appClass, appScope, serverName, propString, appOperation, fileout, conf, serverPort, folder);
                }
            }
            catch (Exception e) {
                this.setExecStatus(1);
                throw e;
            }
        }
        return 1;
    }

    protected int checkTbxUrlChildNode(VBaseNode v, String appTbxUrl, String appOperation, String fileout, VBaseConfiguration conf, String folder) throws Exception {
        boolean nodeFound = false;
        if (v == null) {
            return 1;
        }
        if (v instanceof ToolBoxURLNode) {
            String tbxURL = ((ToolBoxURLNode)v).getURL().toString().trim();
            if (appTbxUrl != null || tbxURL != null) {
                if (appTbxUrl == null || tbxURL == null) {
                    return 1;
                }
                if (!appTbxUrl.equals(tbxURL)) {
                    return 1;
                }
            }
            nodeFound = true;
        }
        if (nodeFound) {
            if (appOperation.equals("check")) {
                this.setExecStatus(0);
                throw new Exception("");
            }
            v.removeFromParent();
            OutputStream outStream = System.out;
            try {
                outStream = new FileOutputStream(fileout);
                conf.write(outStream);
            }
            catch (Exception y) {
                this.setExecStatus(1);
                throw y;
            }
            this.setExecStatus(0);
            throw new Exception("");
        }
        if (folder == null) {
            try {
                Enumeration e = v.children();
                while (e.hasMoreElements()) {
                    VBaseNode v1 = (VBaseNode)e.nextElement();
                    this.checkTbxUrlChildNode(v1, appTbxUrl, appOperation, fileout, conf, folder);
                }
            }
            catch (Exception e) {
                this.setExecStatus(1);
                throw e;
            }
        }
        return 1;
    }
}

