/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.config;

import com.sun.management.viperimpl.console.config.BGImageNode;
import com.sun.management.viperimpl.console.config.GenericElement;
import com.sun.management.viperimpl.console.config.TaggedTextNode;
import com.sun.management.viperimpl.console.config.VConfigurationNode;
import com.sun.xml.tree.ParseContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class VBaseNode
extends GenericElement
implements VConfigurationNode {
    protected String scope;
    protected String name;
    protected String description;
    protected String smallIcon;
    protected String largeIcon;
    protected String bgImage;
    protected String bgImageLoc;
    protected boolean treeDisplay = true;
    protected URL baseURL;
    protected Node[] slots;
    protected int SLOT_NAME = -1;
    protected int SLOT_DESCRIPTION = -1;
    protected int SLOT_BGIMAGE = -1;
    protected int SLOT_ICON = -1;
    protected int SLOT_LARGEICON = -1;
    protected int SLOT_SCOPE = -1;

    public void startParse(ParseContext context) throws SAXException {
        super.startParse(context);
        try {
            this.baseURL = new URL(this.getBaseURL(context));
        }
        catch (MalformedURLException e) {
            this.baseURL = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.SLOT_NAME < 0) {
            return;
        }
        this.name = name;
        if (name != null && name.length() > 0) {
            this.setTaggedNode("Name", name, this.SLOT_NAME);
        } else if (this.slots[this.SLOT_NAME] != null) {
            this.removeChild(this.slots[this.SLOT_NAME]);
            this.slots[this.SLOT_NAME] = null;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        if (this.SLOT_DESCRIPTION < 0) {
            return;
        }
        this.description = desc;
        if (desc != null && this.name.length() > 0) {
            this.setTaggedNode("Description", desc, this.SLOT_DESCRIPTION);
        } else if (this.slots[this.SLOT_DESCRIPTION] != null) {
            this.removeChild(this.slots[this.SLOT_DESCRIPTION]);
            this.slots[this.SLOT_DESCRIPTION] = null;
        }
    }

    public String getSmallIconText() {
        return this.smallIcon;
    }

    public URL getSmallIcon() {
        try {
            return new URL(this.smallIcon);
        }
        catch (MalformedURLException e) {
            try {
                return new URL(this.baseURL, this.smallIcon);
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }

    public void setSmallIcon(String icon) {
        if (this.SLOT_ICON < 0) {
            return;
        }
        this.smallIcon = icon;
        if (icon != null && icon.length() > 0) {
            this.setTaggedNode("Icon", icon, this.SLOT_ICON);
        } else if (this.slots[this.SLOT_ICON] != null) {
            this.removeChild(this.slots[this.SLOT_ICON]);
            this.slots[this.SLOT_ICON] = null;
        }
    }

    public void setSmallIcon(URL icon) {
        if (icon != null) {
            this.setSmallIcon(icon.toString());
        } else {
            this.setSmallIcon((String)null);
        }
    }

    public String getLargeIconText() {
        return this.largeIcon;
    }

    public URL getLargeIcon() {
        try {
            return new URL(this.largeIcon);
        }
        catch (MalformedURLException e) {
            try {
                return new URL(this.baseURL, this.largeIcon);
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }

    public void setLargeIcon(String icon) {
        if (this.SLOT_LARGEICON < 0) {
            return;
        }
        this.largeIcon = icon;
        if (icon != null && icon.length() > 0) {
            this.setTaggedNode("LargeIcon", icon, this.SLOT_LARGEICON);
        } else if (this.slots[this.SLOT_LARGEICON] != null) {
            this.removeChild(this.slots[this.SLOT_LARGEICON]);
            this.slots[this.SLOT_LARGEICON] = null;
        }
    }

    public void setLargeIcon(URL icon) {
        if (icon != null) {
            this.setLargeIcon(icon.toString());
        } else {
            this.setLargeIcon((String)null);
        }
    }

    public String getScopeText() {
        return this.scope;
    }

    public String getScope() {
        if (this.scope != null) {
            return this.scope;
        }
        Node parent = this.getParentNode();
        if (parent != null && parent instanceof VConfigurationNode) {
            return ((VConfigurationNode)((Object)parent)).getScope();
        }
        return null;
    }

    public void setScope(String scope) {
        if (this.SLOT_SCOPE < 0) {
            return;
        }
        this.scope = scope;
        if (scope != null) {
            this.setTaggedNode("Scope", scope, this.SLOT_SCOPE);
        } else if (this.slots[this.SLOT_SCOPE] != null) {
            this.removeChild(this.slots[this.SLOT_SCOPE]);
            this.slots[this.SLOT_SCOPE] = null;
        }
    }

    public String getBackgroundImageText() {
        return this.bgImage;
    }

    public URL getBackgroundImage() {
        try {
            return new URL(this.bgImage);
        }
        catch (MalformedURLException e) {
            try {
                return new URL(this.baseURL, this.bgImage);
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }

    public String getBackgroundImageLocation() {
        return this.bgImageLoc;
    }

    public void setBackgroundImage(String image, String location) {
        if (this.SLOT_BGIMAGE < 0) {
            return;
        }
        this.bgImage = image;
        this.bgImageLoc = location;
        if (image != null && location != null) {
            BGImageNode newNode = this.getConfiguration().createBGImageNode(image, location);
            this.setTaggedNode((Node)((Object)newNode), this.SLOT_BGIMAGE);
        } else if (this.slots[this.SLOT_BGIMAGE] != null) {
            this.removeChild(this.slots[this.SLOT_BGIMAGE]);
            this.slots[this.SLOT_BGIMAGE] = null;
        }
    }

    public void setBackgroundImage(URL image, String location) {
        this.setBackgroundImage(image.toString(), location);
    }

    public boolean getTreeDisplay() {
        return this.treeDisplay;
    }

    public void setTreeDisplay(boolean treeDisplay) {
        this.treeDisplay = treeDisplay;
        if (!treeDisplay) {
            this.setAttribute("TreeDisplay", "false");
        } else if (this.getAttribute("TreeDisplay") != null && !this.getAttribute("TreeDisplay").equals("")) {
            this.removeAttribute("TreeDisplay");
        }
    }

    protected String getBaseURL(ParseContext context) {
        String sid = context.getLocator().getSystemId();
        int slashIndex = sid.lastIndexOf(47);
        return sid.substring(0, slashIndex + 1);
    }

    protected boolean isTrueValue(String value) {
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    protected ImageIcon getValidImageIcon(String childValue, ParseContext context) {
        ImageIcon ii;
        URL url = null;
        try {
            url = childValue.indexOf(":") >= 0 ? new URL(childValue) : new URL(this.getBaseURL(context) + childValue);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url.toString().startsWith("file:")) {
            ii = new File(url.getFile()).exists() ? new ImageIcon(url) : new ImageIcon();
        } else {
            ii = new ImageIcon(url);
            try {
                ObjectOutputStream os = new ObjectOutputStream(new ByteArrayOutputStream(512));
                os.writeObject(ii);
                os.flush();
            }
            catch (Exception e) {
                ii = new ImageIcon();
            }
        }
        ii.setDescription(childValue);
        return ii;
    }

    protected void setTaggedNode(Node newNode, int pos) {
        if (this.slots[pos] != null) {
            this.replaceChild(newNode, this.slots[pos]);
        } else {
            int i;
            for (i = pos; i < this.slots.length; ++i) {
                if (this.slots[i] == null) continue;
                this.insertBefore(newNode, this.slots[i]);
                break;
            }
            if (i == this.slots.length) {
                for (i = pos - 1; i >= 0; --i) {
                    if (this.slots[i] == null) continue;
                    Node n = this.item(1 + this.getIndexOf(this.slots[i]));
                    if (n != null) {
                        this.insertBefore(newNode, n);
                        break;
                    }
                    this.appendChild(newNode);
                    break;
                }
                if (i == -1) {
                    this.insertBefore(newNode, this.getFirstChild());
                }
            }
        }
        this.slots[pos] = newNode;
    }

    protected void setTaggedNode(String tag, String contents, int pos) {
        TaggedTextNode newNode = new TaggedTextNode(tag);
        this.setTaggedNode((Node)((Object)newNode), pos);
        newNode.appendChild(this.getOwnerDocument().createTextNode(contents));
    }

    protected int getFilteredLength() {
        int length = 0;
        for (int i = 0; i < super.getLength(); ++i) {
            if (!(this.item(i) instanceof VBaseNode)) continue;
            ++length;
        }
        return length;
    }

    public Enumeration children() {
        return new Enumeration(){
            int index = 0;
            int filtered_index = 0;

            public boolean hasMoreElements() {
                return this.filtered_index < VBaseNode.this.getFilteredLength();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object nextElement() {
                VBaseNode vBaseNode = VBaseNode.this;
                synchronized (vBaseNode) {
                    while (this.hasMoreElements()) {
                        if (!(VBaseNode.this.item(this.index++) instanceof VBaseNode)) continue;
                        ++this.filtered_index;
                        return VBaseNode.this.item(this.index - 1);
                    }
                }
                throw new NoSuchElementException("VConfigurationNode Enumeration");
            }
        };
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public VConfigurationNode getChildAt(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
        if (index > this.getFilteredLength()) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.getFilteredLength());
        }
        int fi = 0;
        for (int i = 0; i < this.getLength(); ++i) {
            if (!(this.item(i) instanceof VBaseNode)) continue;
            if (fi == index) {
                return (VBaseNode)((Object)this.item(i));
            }
            ++fi;
        }
        throw new NoSuchElementException("Unknown Error");
    }

    public int getIndex(VConfigurationNode node) {
        if (node == null) {
            return -1;
        }
        int fi = 0;
        for (int i = 0; i < this.getLength(); ++i) {
            if (!(this.item(i) instanceof VBaseNode)) continue;
            if (node.equals(this.item(i))) {
                return fi;
            }
            ++fi;
        }
        return -1;
    }

    public int getChildCount() {
        return this.getFilteredLength();
    }

    public VConfigurationNode getParent() {
        return (VBaseNode)((Object)this.getParentNode());
    }

    public boolean isLeaf() {
        return !this.hasChildNodes();
    }

    public void insert(VConfigurationNode child, int index) {
        if (index < this.getFilteredLength()) {
            this.insertBefore((Node)((Object)child), (Node)((Object)this.getChildAt(index)));
        } else {
            this.add(child);
        }
    }

    public void add(VConfigurationNode child) {
        this.appendChild((Node)((Object)child));
    }

    public void remove(int index) {
        this.removeChild((Node)((Object)this.getChildAt(index)));
    }

    public void remove(VConfigurationNode node) {
        this.removeChild((Node)((Object)node));
    }

    public void removeFromParent() {
        this.getParentNode().removeChild((Node)((Object)this));
    }

    public void setParent(VConfigurationNode newParent) {
        this.removeFromParent();
        this.getParentNode().appendChild((Node)((Object)this));
    }

    public void setUserObject(Object object) {
    }

    protected String indent(int indent) {
        String ret = "";
        for (int i = 0; i < indent; ++i) {
            ret = ret + "|  ";
        }
        return ret;
    }

    protected void printNode(int indent) {
        System.out.println(this.indent(indent) + this.getNodeName() + ": " + this.getName() + " (scope = " + this.getScope() + ")" + " len = " + this.getLength() + ", " + this.getFilteredLength());
    }

    protected void printTree(int indent) {
        System.out.println(this.indent(indent));
        System.out.println(this.indent(indent) + "+vvvvvv");
        this.printNode(indent);
        Enumeration e = this.children();
        while (e != null && e.hasMoreElements()) {
            ((VBaseNode)e.nextElement()).printTree(indent + 1);
        }
        System.out.println(this.indent(indent) + "+^^^^^^");
    }
}

