/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Enumeration;

public final class CodeSourcePolicy
extends Policy {
    private InheritableThreadLocal failedCodeSource = new InheritableThreadLocal();
    private Policy realPolicy;

    public CodeSourcePolicy(Policy realPolicy) {
        this.realPolicy = realPolicy != null ? realPolicy : Policy.getPolicy();
    }

    public PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection pc = this.realPolicy.getPermissions(codesource);
        return new SpyPermissionCollection(pc, codesource);
    }

    public void refresh() {
        this.realPolicy.refresh();
    }

    CodeSource getFailedCodeSource() {
        return (CodeSource)this.failedCodeSource.get();
    }

    private class SpyPermissionCollection
    extends PermissionCollection {
        CodeSource codesource;
        PermissionCollection realPC;

        public SpyPermissionCollection(PermissionCollection pc, CodeSource codesource) {
            this.realPC = pc;
            this.codesource = codesource;
        }

        public void add(Permission permission) {
            this.realPC.add(permission);
        }

        public Enumeration elements() {
            return this.realPC.elements();
        }

        public boolean implies(Permission permission) {
            boolean granted = this.realPC.implies(permission);
            if (!granted) {
                CodeSourcePolicy.this.failedCodeSource.set(this.codesource);
            }
            return granted;
        }
    }
}

