/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console;

import com.sun.management.viper.AdminMgmtScope;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.console.gui.VSplashScreen;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viper.util.VDebug;
import com.sun.management.viperimpl.SMCVersion;
import com.sun.management.viperimpl.console.BaseConsoleOptions;
import com.sun.management.viperimpl.console.CSecurityManager;
import com.sun.management.viperimpl.console.CodeSourcePolicy;
import com.sun.management.viperimpl.console.ManagerUtility;
import com.sun.management.viperimpl.console.editor.SMCEditor;
import com.sun.management.viperimpl.console.gui.SMCConsole;
import com.sun.management.viperimpl.console.tty.SMCTerminal;
import com.sun.management.viperimpl.util.AuthData;
import com.sun.management.viperimpl.util.ImplResourceManager;
import com.sun.management.viperimpl.util.SimpleDebugger;
import java.awt.Container;
import java.awt.Font;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Policy;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;

public class BaseConsoleOptionsManager {
    protected static CommandOption termOption = null;
    protected static CommandOption hostOption = null;
    protected static CommandOption authDataOption = null;
    protected static CommandOption userOption = null;
    protected static CommandOption pwordOption = null;
    protected static CommandOption roleOption = null;
    protected static CommandOption rolePwordOption = null;
    protected static CommandOption toolOption = null;
    protected static CommandOption scopeOption = null;
    protected static CommandOption confOption = null;
    protected static CommandOption debugOption = null;
    protected static CommandOption helpOption = null;
    protected static CommandOption trustedOption = null;
    protected static CommandOption yesOption = null;
    protected static CommandOption silentOption = null;
    protected static CommandOption versionOption = null;
    protected static CommandOption ptOption = null;
    protected static CommandParser parser = null;
    protected static CommandParser openCommand = null;
    protected static CommandParser editCommand = null;
    protected static CommandParser subCommand = null;
    protected static InputStream input = null;
    protected static PrintStream output = null;
    protected static PrintStream error = null;
    protected static String[] secArgs = null;

    protected static void launchConsole(String[] args, InputStream inputS, PrintStream outputS, PrintStream errorS) {
        ResourceManager.seed((boolean)false);
        parser = new CommandParser("smc", "Solaris Management Console", true, inputS, outputS);
        input = inputS;
        output = outputS;
        error = errorS;
        Debug.setDebugImpl((VDebug)new SimpleDebugger());
        BaseConsoleOptionsManager.init();
        BaseConsoleOptionsManager.setParserOptions();
        if (!BaseConsoleOptionsManager.parseAndProcessArgs(args)) {
            System.err.println("Error parsing and processing args");
            System.exit(1);
        } else {
            BaseConsoleOptionsManager.redirectToConsole();
        }
    }

    protected static void init() {
        String hostName = null;
        String userName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
            userName = System.getProperty("user.name");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        termOption = BaseConsoleOptions.getTerminalOption();
        hostOption = BaseConsoleOptions.getHostOption(hostName);
        authDataOption = BaseConsoleOptions.getAuthDataOption();
        userOption = BaseConsoleOptions.getUserNameOption(userName);
        pwordOption = BaseConsoleOptions.getPasswordOption(null);
        roleOption = BaseConsoleOptions.getRoleNameOption(null);
        rolePwordOption = BaseConsoleOptions.getRolePasswordOption(null);
        toolOption = BaseConsoleOptions.getToolOption(null);
        scopeOption = BaseConsoleOptions.getScopeOption(null);
        confOption = BaseConsoleOptions.getToolBoxOption(null);
        debugOption = BaseConsoleOptions.getDebugOption();
        helpOption = BaseConsoleOptions.getHelpOption();
        trustedOption = BaseConsoleOptions.getTrustedOption();
        yesOption = BaseConsoleOptions.getYesOption();
        silentOption = BaseConsoleOptions.getSilentOption();
        versionOption = BaseConsoleOptions.getVersionOption();
        ptOption = BaseConsoleOptions.getPassThruOption();
    }

    protected static void setParserOptions() {
        if (parser == null) {
            return;
        }
        editCommand = new CommandParser("edit", ImplResourceManager.getString("edit_option_desc"), true, input, output);
        parser.addSubCommand(editCommand);
        openCommand = new CommandParser("open", ImplResourceManager.getString("open_option_desc"), true, input, output);
        parser.addSubCommand(openCommand);
    }

    protected static void configureOpenCommand(CommandParser parser) {
        if (parser == null) {
            return;
        }
        parser.addOption(debugOption);
        parser.addOption(termOption);
        parser.addOption(hostOption);
        parser.addOption(authDataOption);
        parser.addOption(userOption);
        parser.addOption(pwordOption);
        parser.addOption(roleOption);
        parser.addOption(rolePwordOption);
        parser.addOption(toolOption);
        parser.addOption(scopeOption);
        parser.addOption(confOption);
        parser.addOption(helpOption);
        parser.addOption(trustedOption);
        parser.addOption(yesOption);
        parser.addOption(silentOption);
    }

    protected static void configureEditCommand(CommandParser parser) {
        if (parser == null) {
            return;
        }
        parser.addOption(debugOption);
        parser.addOption(confOption);
        parser.addOption(helpOption);
    }

    protected static boolean parseAndProcessArgs(String[] args) {
        try {
            String[] unmatchedOptions;
            secArgs = CommandParser.getSecondaryArgs((String[])args);
            args = CommandParser.getPrimaryArgs((String[])args);
            parser.addOption(helpOption);
            parser.addOption(debugOption);
            parser.addOption(versionOption);
            if (!parser.parseArgs(args)) {
                return false;
            }
            BaseConsoleOptionsManager.handleHelpOption(parser);
            BaseConsoleOptionsManager.handleVersionOption();
            BaseConsoleOptionsManager.handleDebugOption();
            helpOption = BaseConsoleOptions.getHelpOption();
            debugOption = BaseConsoleOptions.getDebugOption();
            subCommand = parser.getSubCommand();
            if (subCommand == null) {
                subCommand = openCommand;
            } else {
                unmatchedOptions = parser.getUnmatchedOptions();
                if (unmatchedOptions.length > 0) {
                    parser.printUsage(null);
                    System.exit(0);
                }
                args = parser.getSubCommandArgs();
            }
            if (subCommand == openCommand) {
                BaseConsoleOptionsManager.configureOpenCommand(subCommand);
            } else {
                BaseConsoleOptionsManager.configureEditCommand(subCommand);
            }
            if (!subCommand.parseArgs(args)) {
                return false;
            }
            unmatchedOptions = subCommand.getUnmatchedOptions();
            if (unmatchedOptions.length > 0) {
                subCommand.printUsage(null);
                System.exit(0);
            }
            BaseConsoleOptionsManager.handleDebugOption();
            BaseConsoleOptionsManager.handleHelpOption(subCommand);
            if (termOption.wasSet()) {
                BaseConsoleOptionsManager.parseAndProcessTerminalOptions();
            }
            return true;
        }
        catch (Throwable t) {
            Debug.trace((String)"BaseConsoleOptionsManager", (int)Debug.ERROR, (String)"Unexpected error parsing command line", (Throwable)t);
            return false;
        }
    }

    protected static void handleHelpOption(CommandParser parser) {
        if (helpOption == null || parser == null) {
            return;
        }
        if (helpOption.wasSet()) {
            parser.printUsage(null);
            System.exit(0);
        }
    }

    protected static void handleVersionOption() {
        if (versionOption == null || parser == null) {
            return;
        }
        if (versionOption.wasSet()) {
            output.println("Solaris Management Console " + SMCVersion.getFullVersion());
            System.exit(0);
        }
    }

    protected static void handleDebugOption() {
        if (debugOption == null) {
            return;
        }
        if (debugOption.wasSet()) {
            Debug.setDebugLevel((int)((Integer)debugOption.getValue()));
        }
    }

    protected static void parseAndProcessTerminalOptions() {
        if (parser == null) {
            return;
        }
        if (!authDataOption.wasSet()) {
            if (!pwordOption.wasSet()) {
                error.println("Authenticating as user: " + (String)userOption.getValue());
                pwordOption.promptUser(input, error);
            }
            if (roleOption.wasSet() && !rolePwordOption.wasSet()) {
                error.println("Authenticating as role: " + (String)roleOption.getValue());
                rolePwordOption.promptUser(input, error);
            }
        } else {
            File f = null;
            try {
                f = new File((String)authDataOption.getValue());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (f == null || !f.exists() || !f.canRead()) {
                error.println("Authentication Data either not found or not readable.");
                System.exit(1);
            }
        }
    }

    protected static String[] tokenizeInput(String argString) {
        if (argString == null) {
            return null;
        }
        String[] returnArgs = null;
        StringTokenizer tokenizer = new StringTokenizer(argString);
        int numTokens = tokenizer.countTokens();
        returnArgs = new String[numTokens];
        for (int x = 0; x < numTokens; ++x) {
            returnArgs[x] = tokenizer.nextToken();
        }
        return returnArgs;
    }

    protected static void establishSecurityManager() {
        try {
            CodeSourcePolicy newpolicy = new CodeSourcePolicy(Policy.getPolicy());
            Policy.setPolicy(newpolicy);
        }
        catch (Throwable t) {
            Debug.trace((String)"OptionsManager", (int)Debug.WARNING, (String)"Unable to set CodeSourcePolicy", (Throwable)t);
        }
        try {
            System.setSecurityManager(new CSecurityManager());
        }
        catch (Throwable t) {
            Debug.trace((String)"OptionsManager", (int)Debug.WARNING, (String)"Unable to set security manager", (Throwable)t);
        }
    }

    protected static void redirectToConsole() {
        BaseConsoleOptionsManager.establishSecurityManager();
        AdminMgmtScope scope = null;
        try {
            scope = !scopeOption.wasSet() ? new AdminMgmtScope("file", null, (String)hostOption.getValue(), null) : (AdminMgmtScope)scopeOption.getValue();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            String hostName = null;
            String userName = null;
            String password = null;
            String roleName = null;
            String rolePassword = null;
            String authDataFile = (String)authDataOption.getValue();
            if (authDataOption.wasSet()) {
                try {
                    AuthData authData = new AuthData(authDataFile);
                    hostName = authData.getHostname();
                    userName = authData.getUserName();
                    char[] pw = authData.getPassword();
                    if (pw != null) {
                        password = new String(pw);
                    }
                    roleName = authData.getRoleName();
                    pw = authData.getRolePassword();
                    if (pw != null) {
                        rolePassword = new String(pw);
                    }
                    authData.destroy();
                }
                catch (Throwable t) {
                    error.println("Error in Authentication Data file:");
                    error.println(t.getMessage());
                    System.exit(1);
                }
            }
            if (hostOption.wasSet() || hostName == null || hostName.length() == 0) {
                hostName = (String)hostOption.getValue();
            }
            String toolbox = null;
            if (confOption.wasSet()) {
                String fileSep;
                toolbox = (String)confOption.getValue();
                if (toolbox.startsWith(fileSep = System.getProperty("file.separator"))) {
                    toolbox = "file:" + toolbox;
                } else if (toolbox.startsWith("." + fileSep)) {
                    toolbox = "file:" + toolbox;
                } else if (toolbox.startsWith(".." + fileSep)) {
                    toolbox = "file:" + toolbox;
                }
                try {
                    URL u = new URL(toolbox);
                }
                catch (MalformedURLException mue) {
                    String host = hostName;
                    int port = ManagerUtility.parsePortFromString(host);
                    if (port < 0) {
                        port = 898;
                        host = host + ":" + port;
                    }
                    if (!toolbox.endsWith(".tbx")) {
                        toolbox = toolbox + ".tbx";
                    }
                    toolbox = "http://" + host + "/toolboxes/" + toolbox;
                }
            }
            if (userOption.wasSet() || userName == null || userName.length() == 0) {
                userName = (String)userOption.getValue();
            }
            if (pwordOption.wasSet()) {
                password = (String)pwordOption.getValue();
            }
            if (roleOption.wasSet()) {
                roleName = (String)roleOption.getValue();
            }
            if (rolePwordOption.wasSet()) {
                rolePassword = (String)rolePwordOption.getValue();
            }
            boolean terminalMode = termOption.wasSet();
            String display = System.getProperty("viper.display");
            if (display != null && display.equals("false") && !terminalMode) {
                error.println("\n" + ImplResourceManager.getString("NoDisplayForGUI"));
                System.exit(1);
            }
            if (terminalMode && (password == null || password.length() == 0)) {
                error.println("\n" + ImplResourceManager.getString("MissingAuthData"));
                System.exit(1);
            }
            if (terminalMode && !toolOption.wasSet()) {
                toolOption.promptUser(input, output);
                if (secArgs == null) {
                    ptOption.promptUser(input, output);
                    secArgs = BaseConsoleOptionsManager.tokenizeInput((String)ptOption.getValue());
                }
            }
            String toolName = null;
            if (toolOption.wasSet()) {
                Vector toolSet = toolOption.getValues();
                if (toolSet != null && toolSet.size() > 1) {
                    error.println("Multiple tools not yet supported, will launch first tool only...");
                }
                toolName = (String)toolSet.elementAt(0);
            }
            boolean trusted = trustedOption.wasSet();
            boolean yesToAll = yesOption.wasSet();
            boolean silent = silentOption.wasSet();
            String subCommandName = subCommand.getName();
            if (subCommandName.equals(openCommand.getName())) {
                BaseConsoleOptionsManager.openConsole(authDataFile, hostName, userName, password, roleName, rolePassword, toolbox, toolName, scope, secArgs, trusted, yesToAll, silent, input, output, error, terminalMode);
            } else if (subCommandName.equals(editCommand.getName())) {
                BaseConsoleOptionsManager.editConsole(authDataFile, hostName, userName, password, roleName, rolePassword, toolbox, toolName, scope, secArgs, trusted, yesToAll, silent, input, output, error, terminalMode);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    protected static void openConsole(String authData, String hostName, String userName, String password, String roleName, String rolePassword, String toolbox, String toolName, AdminMgmtScope scope, String[] secArgs, boolean trusted, boolean yesToAll, boolean silent, InputStream input, PrintStream output, PrintStream error, boolean terminalMode) throws Exception {
        if (terminalMode) {
            SMCTerminal terminal = new SMCTerminal();
            terminal.init(null);
            terminal.setInitialOptions(authData, hostName, userName, password, roleName, rolePassword, toolbox, toolName, scope, secArgs, trusted, yesToAll, silent, input, output, error);
            terminal.start();
        } else {
            ResourceManager.seed((boolean)true);
            VSplashScreen vss = new VSplashScreen(null);
            ImageIcon ii = ConsoleUtility.loadImageIcon((String)"gui/images/splash.gif", BaseConsoleOptionsManager.class);
            vss.setImage(ii);
            vss.setTextFont(new Font("SansSerif", 0, 20));
            vss.show();
            VSplashScreen.setMessageText((String)ImplResourceManager.getString("Instantiating console..."));
            SMCConsole gui = new SMCConsole();
            VSplashScreen.setMessageText((String)ImplResourceManager.getString("Initializing console..."));
            gui.init(null);
            VFrame j = new VFrame();
            gui.setContainer((Container)j);
            VSplashScreen.setMessageText((String)ImplResourceManager.getString("Setting options..."));
            gui.setInitialOptions(authData, hostName, userName, password, roleName, rolePassword, toolbox, toolName, scope, secArgs, trusted, yesToAll, silent, input, output, error);
            vss.dispose();
            j.showCenter(null);
            gui.start();
        }
    }

    protected static void editConsole(String authData, String hostName, String userName, String password, String roleName, String rolePassword, String toolbox, String toolName, AdminMgmtScope scope, String[] secArgs, boolean trusted, boolean yesToAll, boolean silent, InputStream input, PrintStream output, PrintStream error, boolean terminalMode) throws Exception {
        if (!terminalMode) {
            ResourceManager.seed((boolean)true);
            VSplashScreen vss = new VSplashScreen(null);
            ImageIcon ii = ConsoleUtility.loadImageIcon((String)"editor/lf/images/splash.gif", BaseConsoleOptionsManager.class);
            vss.setImage(ii);
            vss.setTextFont(new Font("SansSerif", 0, 20));
            vss.show();
            VSplashScreen.setMessageText((String)ImplResourceManager.getString("Instantiating editor..."));
            SMCEditor editor = new SMCEditor();
            VSplashScreen.setMessageText((String)ImplResourceManager.getString("Initializing editor..."));
            editor.init(null);
            VFrame j = new VFrame();
            editor.setContainer((Container)j);
            VSplashScreen.setMessageText((String)ImplResourceManager.getString("Setting options..."));
            editor.setInitialOptions(authData, hostName, userName, password, roleName, rolePassword, toolbox, toolName, scope, secArgs, trusted, yesToAll, silent, input, output, error);
            vss.dispose();
            j.showCenter(null);
            editor.start();
        }
    }

    protected static String smcVersion() {
        return SMCVersion.getVersion();
    }

    public static void main(String[] args) {
        try {
            BaseConsoleOptionsManager.launchConsole(args, System.in, System.out, System.err);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

