/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl;

import com.sun.management.viper.ComponentInfo;
import com.sun.management.viper.ToolInfo;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.server.repository.VRegistry;
import java.util.Date;
import java.util.Properties;

public class ToolInfoImpl
extends LibInfoImpl
implements Cloneable,
ToolInfo {
    static final long serialVersionUID = 716168351019850121L;
    private String classname = null;
    private String helpBase = null;
    private String APIversion = "0.0";
    private String[] parameterList = null;
    private String[] scopeList = null;
    private String[] contextList = null;
    private String[] prefConfigTypes = null;
    private Date editDate = null;
    private LibInfoImpl[] attachments = null;

    public ToolInfoImpl(ToolInfo info) {
        super((ComponentInfo)info);
        if (info == null) {
            return;
        }
        this.classname = info.getClassName();
        this.helpBase = info.getHelpBaseName();
        this.APIversion = info.getAPIVersion();
        this.parameterList = info.getParameterList();
        this.scopeList = info.getSupportedScopes();
        this.contextList = info.getSupportedContexts();
        this.prefConfigTypes = info.getPreferredConfigTypes();
        if (info instanceof ToolInfoImpl) {
            this.editDate = ((ToolInfoImpl)info).getEditDate();
            this.attachments = ((ToolInfoImpl)info).getAttachments();
        }
        if (this.editDate == null) {
            this.editDate = new Date();
        }
        if (this.getJarName() == null) {
            this.setJarName(VRegistry.toJarName((int)1, (String)this.classname));
        }
    }

    public ToolInfoImpl(String classname, String resourceBase, String helpBase, String version, String APIversion, String[] parameterList, Properties props, String[] scopeList, String[] contextList, String[] prefConfigTypes, String id) {
        super(version, resourceBase, props, id);
        this.classname = classname;
        this.helpBase = helpBase;
        this.APIversion = APIversion;
        this.parameterList = parameterList;
        this.scopeList = scopeList;
        this.contextList = contextList;
        this.prefConfigTypes = prefConfigTypes;
        this.setJarName(VRegistry.toJarName((int)1, (String)classname));
        this.setComponentType(1);
        this.attachments = new LibInfoImpl[0];
        this.editDate = new Date();
    }

    public String getClassName() {
        return this.classname;
    }

    public String getHelpBaseName() {
        return this.helpBase;
    }

    public String getAPIVersion() {
        return this.APIversion;
    }

    public String[] getParameterList() {
        return this.parameterList;
    }

    public String[] getSupportedScopes() {
        return this.scopeList;
    }

    public String[] getSupportedContexts() {
        return this.contextList;
    }

    public String[] getPreferredConfigTypes() {
        return this.prefConfigTypes;
    }

    public Date getEditDate() {
        return this.editDate;
    }

    public LibInfoImpl[] getAttachments() {
        return this.attachments;
    }

    public void setAttachments(LibInfoImpl[] l) {
        this.attachments = l != null ? l : new LibInfoImpl[]{};
        this.editDate = new Date();
    }

    public String[] getJarPaths() {
        String[] result = new String[1 + this.attachments.length];
        result[0] = this.getJarPath();
        for (int i = 0; i < this.attachments.length; ++i) {
            result[1 + i] = this.attachments[i].getJarPath();
        }
        return result;
    }

    public synchronized Object clone() {
        return new ToolInfoImpl(this);
    }

    public String toString() {
        return "Tool info:\n\timpl-class=" + this.getClassName() + "\n\thelp-base=" + this.getHelpBaseName() + "\n\tapi-version=" + this.getAPIVersion() + "\n\tparam-list=" + this.printArray(this.getParameterList()) + "\n\tsupported-scopes=" + this.printArray(this.getSupportedScopes()) + "\n\tsupported-contexts=" + this.printArray(this.getSupportedContexts()) + "\n\tpreferred-configs=" + this.printArray(this.getPreferredConfigTypes()) + "\n" + "\n\tlast-modified=" + this.getEditDate() + "\n\tattachments=" + this.printArray(this.getAttachments()) + "\n" + super.toString();
    }
}

