/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http;

import com.sun.xml.rpc.server.http.ServletDelegate;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JAXRPCServlet
extends HttpServlet {
    protected ServletDelegate delegate = null;
    private LocalizableMessageFactory messageFactory;
    private Localizer localizer;
    private static final String DELEGATE_PROPERTY = "delegate";
    private static final String DEFAULT_DELEGATE_CLASS_NAME = "com.sun.xml.rpc.server.http.JAXRPCServletDelegate";
    private static final String EA_CONFIG_FILE_PROPERTY = "configuration.file";
    private static final String EA_DELEGATE_CLASS_NAME = "com.sun.xml.rpc.server.http.ea.JAXRPCServletDelegate";
    public static final String JAXRPC_RI_RUNTIME_INFO = "com.sun.xml.rpc.server.http.info";
    public static final String JAXRPC_RI_PROPERTY_PUBLISH_WSDL = "com.sun.xml.rpc.server.http.publishWSDL";
    public static final String JAXRPC_RI_PROPERTY_PUBLISH_MODEL = "com.sun.xml.rpc.server.http.publishModel";
    public static final String JAXRPC_RI_PROPERTY_PUBLISH_STATUS_PAGE = "com.sun.xml.rpc.server.http.publishStatusPage";
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.rpc.server.http");

    public void destroy() {
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.localizer = new Localizer();
        this.messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.jaxrpcservlet");
        try {
            String delegateClassName = servletConfig.getInitParameter(DELEGATE_PROPERTY);
            if (delegateClassName == null && servletConfig.getInitParameter(EA_CONFIG_FILE_PROPERTY) != null) {
                delegateClassName = EA_DELEGATE_CLASS_NAME;
            }
            if (delegateClassName == null) {
                delegateClassName = DEFAULT_DELEGATE_CLASS_NAME;
            }
            Class<?> delegateClass = Class.forName(delegateClassName, true, Thread.currentThread().getContextClassLoader());
            this.delegate = (ServletDelegate)delegateClass.newInstance();
            this.delegate.init(servletConfig);
        }
        catch (ServletException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Throwable e) {
            String message = this.localizer.localize(this.messageFactory.getMessage("error.servlet.caughtThrowableInInit", new Object[]{e}));
            logger.log(Level.SEVERE, message, e);
            throw new ServletException(message);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.delegate != null) {
            this.delegate.doGet(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.delegate != null) {
            this.delegate.doPost(request, response);
        }
    }
}

