/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding.literal;

import com.sun.xml.rpc.client.dii.ParameterMemberInfo;
import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.DynamicInternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.EncodingException;
import com.sun.xml.rpc.encoding.Initializable;
import com.sun.xml.rpc.encoding.InternalTypeMappingRegistry;
import com.sun.xml.rpc.encoding.JAXRPCDeserializer;
import com.sun.xml.rpc.encoding.JAXRPCSerializer;
import com.sun.xml.rpc.encoding.SOAPDeserializationContext;
import com.sun.xml.rpc.encoding.SOAPDeserializationState;
import com.sun.xml.rpc.encoding.SOAPInstanceBuilder;
import com.sun.xml.rpc.encoding.SOAPSerializationContext;
import com.sun.xml.rpc.encoding.SerializationException;
import com.sun.xml.rpc.encoding.SerializerBase;
import com.sun.xml.rpc.encoding.SerializerCallback;
import com.sun.xml.rpc.encoding.literal.GenericLiteralObjectSerializer;
import com.sun.xml.rpc.encoding.literal.LiteralSimpleTypeSerializer;
import com.sun.xml.rpc.encoding.simpletype.SimpleTypeEncoder;
import com.sun.xml.rpc.encoding.simpletype.XSDListTypeEncoder;
import com.sun.xml.rpc.encoding.xsd.XSDConstants;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderUtil;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public class LiteralRequestSerializer
extends GenericLiteralObjectSerializer
implements Initializable {
    protected QName[] parameterNames;
    protected QName[] parameterXmlTypes;
    protected QName[] parameterXmlTypeQNames;
    protected Class[] parameterJavaTypes;
    protected ArrayList parameterMembers;
    protected String operationStyle = "document";
    protected JAXRPCSerializer[] serializers;
    protected JAXRPCDeserializer[] deserializers;
    protected InternalTypeMappingRegistry typeRegistry = null;
    private SOAPEncodingConstants soapEncodingConstants = null;

    protected boolean isRPCLiteral() {
        return this.operationStyle.equalsIgnoreCase("rpc") && this.encodingStyle.equals("");
    }

    public void initialize(InternalTypeMappingRegistry registry) throws Exception {
        if (this.typeRegistry != null) {
            return;
        }
        int membersSize = this.parameterMembers.size();
        if (this.operationStyle.equals("document")) {
            if (this.parameterXmlTypeQNames != null) {
                this.serializers = new JAXRPCSerializer[this.parameterXmlTypeQNames.length];
                this.deserializers = new JAXRPCDeserializer[this.parameterXmlTypeQNames.length];
                int i = 0;
                while (i < this.parameterXmlTypeQNames.length) {
                    if (this.parameterXmlTypeQNames[i] != null && this.parameterJavaTypes[i] != null) {
                        if (i < membersSize) {
                            ParameterMemberInfo[] thisMembers = (ParameterMemberInfo[])this.parameterMembers.get(i);
                            ((DynamicInternalTypeMappingRegistry)registry).addDynamicRegistryMembers(this.parameterJavaTypes[i], this.parameterXmlTypeQNames[i], "", thisMembers);
                            ((DynamicInternalTypeMappingRegistry)registry).addDynamicRegistryMembers(this.parameterJavaTypes[i], this.parameterXmlTypes[i], "", thisMembers);
                        }
                        if (DynamicInternalTypeMappingRegistry.isLiteralArray(this.parameterJavaTypes[i], null, null) || DynamicInternalTypeMappingRegistry.isValueType(this.parameterJavaTypes[i])) {
                            this.serializers[i] = (JAXRPCSerializer)registry.getSerializer("", this.parameterJavaTypes[i], this.parameterXmlTypes[i]);
                            this.deserializers[i] = (JAXRPCDeserializer)registry.getDeserializer("", this.parameterJavaTypes[i], this.parameterXmlTypes[i]);
                        } else {
                            this.serializers[i] = (JAXRPCSerializer)registry.getSerializer("", this.parameterJavaTypes[i], this.parameterXmlTypeQNames[i]);
                            this.deserializers[i] = (JAXRPCDeserializer)registry.getDeserializer("", this.parameterJavaTypes[i], this.parameterXmlTypeQNames[i]);
                        }
                    } else {
                        this.serializers[i] = null;
                        this.deserializers[i] = null;
                    }
                    ++i;
                }
            }
        } else if (this.operationStyle.equals("rpc") && this.parameterXmlTypes != null) {
            this.serializers = new JAXRPCSerializer[this.parameterXmlTypes.length];
            this.deserializers = new JAXRPCDeserializer[this.parameterXmlTypes.length];
            int i = 0;
            while (i < this.parameterXmlTypes.length) {
                if (this.parameterXmlTypes[i] != null && this.parameterJavaTypes[i] != null) {
                    if (i < membersSize) {
                        ParameterMemberInfo[] thisMembers = (ParameterMemberInfo[])this.parameterMembers.get(i);
                        ((DynamicInternalTypeMappingRegistry)registry).addDynamicRegistryMembers(this.parameterJavaTypes[i], this.parameterXmlTypes[i], "", thisMembers);
                    }
                    this.serializers[i] = (JAXRPCSerializer)registry.getSerializer("", this.parameterJavaTypes[i], this.parameterXmlTypes[i]);
                    this.deserializers[i] = (JAXRPCDeserializer)registry.getDeserializer("", this.parameterJavaTypes[i], this.parameterXmlTypes[i]);
                } else {
                    this.serializers[i] = null;
                    this.deserializers[i] = null;
                }
                ++i;
            }
        }
        this.typeRegistry = registry;
    }

    private JAXRPCDeserializer getDeserializer(int index) {
        if (index < this.deserializers.length) {
            return this.deserializers[index];
        }
        return null;
    }

    private JAXRPCSerializer getSerializer(int index) {
        if (index < this.serializers.length) {
            return this.serializers[index];
        }
        return null;
    }

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    private Class getParameterJavaType(int index) {
        if (index < this.parameterJavaTypes.length) {
            return this.parameterJavaTypes[index];
        }
        return null;
    }

    private void checkParameterListLength(Object[] parameters) {
        if (this.serializers == null) {
            return;
        }
        if (this.serializers.length > 0 && parameters.length != this.serializers.length) {
            String expectedParameters = "\n";
            String actualParameters = "\n";
            int i = 0;
            while (i < this.parameterNames.length) {
                QName name = this.parameterNames[i];
                QName xmlType = this.parameterXmlTypes[i];
                expectedParameters = expectedParameters + name + ":" + xmlType;
                if (i + 1 != this.parameterNames.length) {
                    expectedParameters = expectedParameters + "\n";
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < parameters.length) {
                Object parameter = parameters[i2];
                String javaType = parameter == null ? "null" : parameter.getClass().getName();
                actualParameters = actualParameters + javaType;
                if (i2 + 1 != parameters.length) {
                    actualParameters = actualParameters + "\n";
                }
                ++i2;
            }
            throw new SerializationException("request.parameter.count.incorrect", new Object[]{new Integer(this.serializers.length), new Integer(parameters.length), expectedParameters, actualParameters});
        }
    }

    private QName getParameterName(int index) {
        if (index < this.parameterNames.length) {
            return this.parameterNames[index];
        }
        return null;
    }

    private QName getParameterXmlType(int index) {
        if (index < this.parameterXmlTypes.length) {
            return this.parameterXmlTypes[index];
        }
        return null;
    }

    protected JAXRPCDeserializer getParameterDeserializer(int index, XMLReader reader) throws Exception {
        JAXRPCDeserializer deserializer = this.getDeserializer(index);
        if (deserializer == null) {
            QName parameterXmlType = this.parameterXmlTypes[index] != null ? this.parameterXmlTypes[index] : SerializerBase.getType(reader);
            deserializer = (JAXRPCDeserializer)this.typeRegistry.getDeserializer("", this.getParameterJavaType(index), parameterXmlType);
        }
        return deserializer;
    }

    protected JAXRPCSerializer getParameterSerializer(int index, Object parameter) throws Exception {
        JAXRPCSerializer serializer = this.getSerializer(index);
        if (serializer == null) {
            Class<?> parameterClass = null;
            if (parameter != null) {
                parameterClass = parameter.getClass();
            }
            if ((serializer = (JAXRPCSerializer)this.typeRegistry.getSerializer("", parameterClass, this.getParameterXmlType(index))) == null) {
                serializer = (JAXRPCSerializer)this.typeRegistry.getSerializer("", parameterClass, null);
            }
            if (serializer == null) {
                return null;
            }
        }
        if (!this.isRPCLiteral() && serializer instanceof LiteralSimpleTypeSerializer) {
            SimpleTypeEncoder encoder = ((LiteralSimpleTypeSerializer)serializer).getEncoder();
            if (!(((LiteralSimpleTypeSerializer)serializer).getEncoder() instanceof XSDListTypeEncoder)) {
                serializer = new LiteralSimpleTypeSerializer(this.getParameterXmlType(index), "", encoder);
            }
        }
        if (serializer != null) {
            this.serializers[index] = serializer;
            this.deserializers[index] = (JAXRPCDeserializer)((Object)serializer);
        }
        return serializer;
    }

    protected void writeAdditionalNamespaceDeclarations(Object obj, XMLWriter writer) throws Exception {
    }

    private static String getURIEncoding(SOAPVersion ver) {
        if (ver == SOAPVersion.SOAP_11) {
            return "http://schemas.xmlsoap.org/soap/encoding/";
        }
        if (ver == SOAPVersion.SOAP_11) {
            return "http://schemas.xmlsoap.org/soap/encoding/";
        }
        return null;
    }

    public LiteralRequestSerializer(QName type, boolean isNullable, String encodingStyle) {
        super(type, isNullable, false, encodingStyle);
    }

    public LiteralRequestSerializer(QName type, boolean isNullable, String encodingStyle, boolean encodeType) {
        super(type, isNullable, encodeType, encodingStyle);
    }

    protected void doSerialize(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        this.doSerializeInstance(obj, writer, context);
    }

    protected void doSerializeAttributes(Object obj, XMLWriter writer, SOAPSerializationContext context) throws Exception {
    }

    protected void doSerializeInstance(Object instance, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        if (this.typeRegistry == null) {
            throw new EncodingException("initializable.not.initialized");
        }
        Object[] parameters = (Object[])instance;
        int i = 0;
        while (i < parameters.length) {
            Object parameter = parameters[i];
            if (this.isRPCLiteral()) {
                this.getParameterSerializer(i, parameter).serialize(parameter, this.getParameterName(i), null, writer, context);
            } else {
                this.getParameterSerializer(i, parameter).serialize(parameter, null, null, writer, context);
            }
            ++i;
        }
    }

    protected Object doDeserialize(XMLReader reader, SOAPDeserializationContext context) throws Exception {
        if (this.typeRegistry == null) {
            throw new EncodingException("initializable.not.initialized");
        }
        Object[] instance = new Object[this.parameterXmlTypes.length];
        ParameterArrayBuilder builder = null;
        boolean isComplete = true;
        int i = 0;
        while (i < this.parameterXmlTypes.length) {
            reader.nextElementContent();
            QName parameterName = this.getParameterName(i);
            if (reader.getName().equals(parameterName)) {
                Object parameter = this.getParameterDeserializer(i, reader).deserialize(parameterName, reader, context);
                if (parameter instanceof SOAPDeserializationState) {
                    if (builder == null) {
                        builder = new ParameterArrayBuilder(instance);
                    }
                    isComplete = false;
                } else {
                    instance[i] = parameter;
                }
            }
            ++i;
        }
        reader.nextElementContent();
        XMLReaderUtil.verifyReaderState(reader, 2);
        return instance;
    }

    protected void internalSerialize(Object obj, QName name, XMLWriter writer, SOAPSerializationContext context) throws Exception {
        context.beginSerializing(obj);
        if (this.isRPCLiteral()) {
            QName nm = new QName("ns0:" + name.getLocalPart());
            writer.startElement(nm);
        }
        boolean pushedEncodingStyle = false;
        if (this.encodingStyle != null) {
            pushedEncodingStyle = context.pushEncodingStyle(this.encodingStyle, writer);
        }
        if (this.encodeType) {
            String attrVal = XMLWriterUtil.encodeQName(writer, this.type);
            writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_TYPE, attrVal);
        }
        if (obj == null) {
            if (!this.isNullable) {
                throw new SerializationException("literal.unexpectedNull");
            }
            writer.writeAttributeUnquoted(XSDConstants.QNAME_XSI_NIL, "1");
        } else {
            this.writeAdditionalNamespaceDeclarations(obj, writer);
            this.doSerializeAttributes(obj, writer, context);
            this.doSerialize(obj, writer, context);
        }
        if (this.isRPCLiteral()) {
            writer.endElement();
        }
        if (pushedEncodingStyle) {
            context.popEncodingStyle();
        }
        context.doneSerializing(obj);
    }

    public LiteralRequestSerializer(QName type, QName[] parameterNames, QName[] parameterTypes, Class[] parameterClasses) {
        this(type, parameterNames, parameterTypes, parameterClasses, SOAPVersion.SOAP_11);
    }

    public void serialize(Object value, QName name, SerializerCallback callback, XMLWriter writer, SOAPSerializationContext context) {
        try {
            if (this.isRPCLiteral()) {
                this.internalSerialize(value, name, writer, context);
            } else {
                this.internalSerialize(value, null, writer, context);
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (JAXRPCExceptionBase e) {
            throw new SerializationException(e);
        }
        catch (Exception e) {
            throw new SerializationException(new LocalizableExceptionAdapter(e));
        }
    }

    public LiteralRequestSerializer(QName type, QName[] parameterNames, QName[] parameterTypes, Class[] parameterClasses, SOAPVersion ver) {
        this(type, false, true, "", parameterNames, parameterTypes, parameterClasses);
    }

    public LiteralRequestSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName[] parameterNames, QName[] parameterTypes, Class[] parameterClasses) {
        this(type, encodeType, isNullable, "", parameterNames, parameterTypes, parameterClasses, SOAPVersion.SOAP_11);
    }

    public LiteralRequestSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, QName[] parameterNames, QName[] parameterTypes, Class[] parameterClasses, SOAPVersion ver) {
        super(type, encodeType, isNullable, encodingStyle);
        this.init(ver);
        this.parameterNames = parameterNames;
        this.parameterXmlTypes = parameterTypes;
        this.parameterJavaTypes = parameterClasses;
    }

    public LiteralRequestSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, String operationStyle, QName[] parameterNames, QName[] parameterTypes, Class[] parameterClasses, ArrayList parameterMembers) {
        this(type, encodeType, isNullable, "", operationStyle, parameterNames, parameterTypes, parameterClasses, parameterMembers, SOAPVersion.SOAP_11);
    }

    public LiteralRequestSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, String operationStyle, QName[] parameterNames, QName[] parameterTypes, Class[] parameterClasses, ArrayList parameterMembers, SOAPVersion ver) {
        super(type, encodeType, isNullable, encodingStyle);
        this.init(ver);
        this.parameterNames = parameterNames;
        this.parameterXmlTypes = parameterTypes;
        this.parameterJavaTypes = parameterClasses;
        this.parameterMembers = parameterMembers;
        this.operationStyle = operationStyle;
    }

    public LiteralRequestSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, String operationStyle, QName[] parameterNames, QName[] parameterTypes, QName[] parameterXmlTypeQNames, Class[] parameterClasses, ArrayList parameterMembers) {
        this(type, encodeType, isNullable, "", operationStyle, parameterNames, parameterTypes, parameterXmlTypeQNames, parameterClasses, parameterMembers, SOAPVersion.SOAP_11);
    }

    public LiteralRequestSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, String operationStyle, QName[] parameterNames, QName[] parameterTypes, QName[] parameterXmlTypeQNames, Class[] parameterClasses, ArrayList parameterMembers, SOAPVersion ver) {
        super(type, encodeType, isNullable, encodingStyle);
        this.init(ver);
        this.parameterNames = parameterNames;
        this.parameterXmlTypes = parameterTypes;
        this.parameterXmlTypeQNames = parameterXmlTypeQNames;
        this.parameterJavaTypes = parameterClasses;
        this.parameterMembers = parameterMembers;
        this.operationStyle = operationStyle;
    }

    protected static class ParameterArrayBuilder
    implements SOAPInstanceBuilder {
        Object[] instance = null;

        public void construct() {
        }

        public void initialize() {
        }

        public int memberGateType(int memberIndex) {
            return 6;
        }

        public Object getInstance() {
            return this.instance;
        }

        public void setMember(int index, Object memberValue) {
            try {
                this.instance[index] = memberValue;
            }
            catch (Exception e) {
                throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
            }
        }

        public void setInstance(Object instance) {
            instance = instance;
        }

        ParameterArrayBuilder(Object[] instance) {
            this.instance = instance;
        }
    }
}

