/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esm.mo.dsw;

import com.sun.dae.components.util.ExceptionUtil;
import com.sun.esm.mo.dsw.DswVolException;
import com.sun.esm.mo.dsw.DswVolImpl;
import com.sun.esm.util.Services;

class DswVolDaemon
extends Thread {
    private DswVolImpl volObject;
    private int methodToCall;
    static final String sccs_id = "@(#)DswVolDaemon.java 1.15    99/03/11 SMI";

    public DswVolDaemon(DswVolImpl dswVolImpl, int n) {
        this.setDaemon(true);
        this.setPriority(this.getPriority() - 1);
        this.volObject = dswVolImpl;
        this.methodToCall = n;
        this.daemonTrace("Priority = " + this.getPriority());
        this.start();
    }

    private void daemonTrace(String string) {
        Services.trace((String)(String.valueOf(this.volObject.getShadowName()) + " daemon[" + Thread.currentThread() + "] " + string), (String)this.getClass().getName(), (int)100, (int)32);
    }

    public void run() {
        try {
            switch (this.methodToCall) {
                case 5: {
                    this.daemonTrace("FULL_COPY_ENABLE");
                    this.volObject.fullCopyEnable();
                    break;
                }
                case 1: {
                    this.daemonTrace("COPY_TO_MASTER");
                    this.volObject.copyToMaster();
                    break;
                }
                case 2: {
                    this.daemonTrace("COPY_TO_SHADOW");
                    this.volObject.copyToShadow();
                    break;
                }
                case 3: {
                    this.daemonTrace("UPDATE_TO_MASTER");
                    this.volObject.updateToMaster();
                    break;
                }
                case 4: {
                    this.daemonTrace("UPDATE_TO_SHADOW");
                    this.volObject.updateToShadow();
                    break;
                }
                case 15: {
                    this.daemonTrace("WAIT_UNTIL_COMPLETE");
                    this.volObject.waitUntilComplete();
                    break;
                }
                case 10: {
                    this.daemonTrace("RESUME");
                    this.volObject.resume();
                    break;
                }
                default: {
                    this.daemonTrace("invalid request");
                    break;
                }
            }
        }
        catch (DswVolException dswVolException) {
            this.daemonTrace("DswVolException" + ExceptionUtil.getExceptionTree((Throwable)((Object)dswVolException)));
        }
        this.daemonTrace("returning");
    }
}

