/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esm.mo.dsw.jest;

import com.sun.dae.components.lang.CompositeException;
import com.sun.dae.components.util.ExceptionUtil;
import com.sun.dae.contrib.jest.TestResult;
import com.sun.dae.contrib.jest.TestSuite;
import com.sun.dae.sdok.InetStationAddress;
import com.sun.dae.sdok.StationAddress;
import com.sun.esm.mo.MO;
import com.sun.esm.mo.MOManagerProxy;
import com.sun.esm.mo.dsw.DswVolImplProxy;
import com.sun.esm.mo.dsw.DswVolsMOImplProxy;
import com.sun.esm.mo.dsw.jest.EventCollect;
import com.sun.esm.mo.dsw.jest.EventCollectProxy;
import com.sun.esm.mo.sv.SvImplProxy;
import com.sun.esm.mo.sv.SvMOImplProxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ConfigDswMo
extends TestSuite {
    static final long serialVersionUID = 961712345813375934L;
    private static DswVolsMOImplProxy dswMO = null;
    private static SvMOImplProxy svMO = null;
    private static Hashtable TestVols = new Hashtable();
    private static Hashtable MastTestVolsSel = new Hashtable();
    private static Hashtable ShadTestVolsSel = new Hashtable();
    private static Hashtable PairProxies = new Hashtable();
    private static Vector VolEvents = new Vector(3);

    private TestResult config(boolean bl, boolean bl2) {
        String string = null;
        Enumeration enumeration = ShadTestVolsSel.elements();
        dswMO.createBitmapDirectory("/tmp/bitmaps");
        Enumeration enumeration2 = MastTestVolsSel.elements();
        while (enumeration2.hasMoreElements()) {
            DswVolImplProxy dswVolImplProxy;
            String string2;
            SvImplProxy svImplProxy = (SvImplProxy)enumeration2.nextElement();
            SvImplProxy svImplProxy2 = (SvImplProxy)enumeration.nextElement();
            try {
                string2 = svImplProxy.getVolName();
                dswVolImplProxy = bl2 ? dswMO.addSuspendedDswPair(svImplProxy, svImplProxy2, string) : dswMO.createDswPair(svImplProxy, svImplProxy2, bl, string);
            }
            catch (CompositeException compositeException) {
                this.println("Composite exception caught");
                ExceptionUtil.printException((Throwable)compositeException);
                this.println(compositeException.getLocalizedMessage());
                this.println(compositeException.getMessage());
                return TestResult.fatal((String)"config", (Throwable)compositeException);
            }
            catch (Throwable throwable) {
                ExceptionUtil.printException((Throwable)throwable);
                return TestResult.fatal((String)"config", (Throwable)throwable);
            }
            PairProxies.put(string2, dswVolImplProxy);
            EventCollect eventCollect = new EventCollect(dswVolImplProxy);
            VolEvents.addElement(eventCollect);
        }
        return TestResult.pass();
    }

    public static DswVolImplProxy[] getPairProxies() {
        DswVolImplProxy[] dswVolImplProxyArray = new DswVolImplProxy[PairProxies.size()];
        Enumeration enumeration = PairProxies.elements();
        int n = 0;
        while (n < PairProxies.size()) {
            dswVolImplProxyArray[n] = (DswVolImplProxy)enumeration.nextElement();
            ++n;
        }
        return dswVolImplProxyArray;
    }

    public static Vector getVolEvents() {
        return VolEvents;
    }

    public TestResult setup() {
        SvImplProxy svImplProxy;
        String string;
        MO[] mOArray;
        String string2 = "localhost";
        InetStationAddress inetStationAddress = null;
        if (dswMO != null) {
            return TestResult.pass();
        }
        try {
            mOArray = InetAddress.getByName(string2);
            inetStationAddress = new InetStationAddress("StoreX", "MOStation", (InetAddress)mOArray);
        }
        catch (UnknownHostException unknownHostException) {
            this.println("cannot resolve server station");
            return TestResult.fatal((String)"Cannot resolve server station", (Throwable)unknownHostException);
        }
        mOArray = MOManagerProxy.lookupByClass((String)"com.sun.esm.mo.dsw.DswVolsMOImpl", (StationAddress)inetStationAddress);
        MO[] mOArray2 = MOManagerProxy.lookupByClass((String)"com.sun.esm.mo.sv.SvMOImpl", (StationAddress)inetStationAddress);
        if (mOArray.length != 1) {
            this.println("DSW Vols MO's detected: " + mOArray.length);
            return TestResult.fatal((String)("Found # DSW MO's =" + mOArray.length));
        }
        this.println("DSW Mo found" + mOArray[0].getClass().getName());
        if (mOArray2.length != 1) {
            this.println("SV Vols MO's detected: " + mOArray2.length);
            return TestResult.fatal((String)("Found # SV MO's =" + mOArray2.length));
        }
        this.println("SV Mo found" + mOArray2[0].getClass().getName());
        dswMO = (DswVolsMOImplProxy)mOArray[0];
        svMO = (SvMOImplProxy)mOArray2[0];
        SvImplProxy[] svImplProxyArray = svMO.getSvProxies();
        if (svImplProxyArray.length > 0) {
            this.println("SV proxies returned:" + svImplProxyArray.length + " 1st" + svImplProxyArray[0].getVolName());
        }
        int n = 0;
        while (n < svImplProxyArray.length) {
            string = svImplProxyArray[n].getVolName();
            TestVols.put(string, svImplProxyArray[n]);
            ++n;
        }
        String string3 = "Master1";
        n = 2;
        while ((string = this.getProperty(string3)) != null) {
            svImplProxy = (SvImplProxy)TestVols.get(string);
            if (svImplProxy == null) {
                return TestResult.fatal((String)("Master volume not found:" + string));
            }
            MastTestVolsSel.put(string, svImplProxy);
            string3 = "Master" + Integer.toString(n);
            ++n;
        }
        if (string3.equals("Master1")) {
            return TestResult.fatal((String)"Need at least 1 Master vol");
        }
        string3 = "Shadow1";
        n = 2;
        while ((string = this.getProperty(string3)) != null) {
            svImplProxy = (SvImplProxy)TestVols.get(string);
            if (svImplProxy == null) {
                return TestResult.fatal((String)("Shadow volume not found:" + string));
            }
            ShadTestVolsSel.put(string, svImplProxy);
            string3 = "Shadow" + Integer.toString(n);
            ++n;
        }
        if (string3.equals("Shadow1")) {
            return TestResult.fatal((String)"Need at least 1 Shadow vol");
        }
        if (ShadTestVolsSel.size() != MastTestVolsSel.size()) {
            return TestResult.fatal((String)"Need same # of Master + Shadow Vols");
        }
        return TestResult.pass();
    }

    public TestResult t01() {
        boolean bl = true;
        boolean bl2 = false;
        return this.config(bl, bl2);
    }

    public TestResult t02() {
        boolean bl = false;
        boolean bl2 = false;
        return this.config(bl, bl2);
    }

    public TestResult t03() {
        TestResult testResult = TestResult.pass();
        Enumeration enumeration = PairProxies.elements();
        while (enumeration.hasMoreElements()) {
            DswVolImplProxy dswVolImplProxy = (DswVolImplProxy)enumeration.nextElement();
            try {
                dswMO.deleteDswPair(dswVolImplProxy);
            }
            catch (CompositeException compositeException) {
                testResult = TestResult.fatal((String)"config", (Throwable)compositeException);
                break;
            }
        }
        Enumeration enumeration2 = MastTestVolsSel.keys();
        while (enumeration2.hasMoreElements()) {
            PairProxies.remove((String)enumeration2.nextElement());
        }
        return testResult;
    }

    public TestResult t04() {
        DswVolImplProxy[] dswVolImplProxyArray = dswMO.getDswVolProxies();
        if (dswVolImplProxyArray.length == 0) {
            return TestResult.fatal((String)"No configured DataShadow pairs");
        }
        int n = 0;
        while (n < dswVolImplProxyArray.length) {
            PairProxies.put(dswVolImplProxyArray[n].getMasterName(), dswVolImplProxyArray[n]);
            VolEvents.addElement(new EventCollectProxy(dswVolImplProxyArray[n]));
            ++n;
        }
        return TestResult.pass();
    }

    public TestResult t05() {
        boolean bl = false;
        boolean bl2 = false;
        return this.config(bl, bl2);
    }
}

