/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esm.mo.dsw;

import com.sun.dae.components.Pickle;
import com.sun.dae.components.event.Delegate;
import com.sun.dae.components.lang.CompositeException;
import com.sun.dae.components.util.ExceptionUtil;
import com.sun.dae.sdok.ByReference;
import com.sun.dae.sdok.OID;
import com.sun.dae.sdok.PersistenceException;
import com.sun.dae.sdok.Proxy;
import com.sun.esm.library.spcs.dsw.Dsw;
import com.sun.esm.library.spcs.dsw.DswBitmaps;
import com.sun.esm.library.spcs.dsw.DswConfig;
import com.sun.esm.library.spcs.dsw.DswHandle;
import com.sun.esm.library.spcs.dsw.DswStatus;
import com.sun.esm.mo.dsw.BitmapFile;
import com.sun.esm.mo.dsw.DswConditionEventObject;
import com.sun.esm.mo.dsw.DswVol;
import com.sun.esm.mo.dsw.DswVolDaemon;
import com.sun.esm.mo.dsw.DswVolException;
import com.sun.esm.mo.dsw.DswVolHydrateDaemon;
import com.sun.esm.mo.dsw.DswVolModifierListener;
import com.sun.esm.mo.dsw.DswVolProperties;
import com.sun.esm.mo.dsw.DswVolStateListener;
import com.sun.esm.mo.dsw.DswVolStatus;
import com.sun.esm.mo.dsw.DswVolStatusListener;
import com.sun.esm.mo.sv.SvImplProxy;
import com.sun.esm.util.Condition;
import com.sun.esm.util.Services;
import com.sun.esm.util.slm.MountUtil;
import com.sun.esm.util.slm.dsw.DswModifierCodes;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;

public class DswVolImpl
implements DswVol,
DswVolProperties,
DswVolStatus,
Serializable {
    static final long serialVersionUID = 4800664876697651330L;
    private OID oid;
    private Proxy volProxy = null;
    private boolean debug;
    private boolean verbose;
    private boolean pretend;
    private transient DswVolException fullCpyExp = null;
    private transient DswHandle opHandle = null;
    private transient DswHandle copyHandle = null;
    private transient DswHandle daqHandle = null;
    private transient DswHandle bitmapHandle = null;
    private transient DswHandle statusHandle = null;
    private transient DswConfig cfg = null;
    private transient Dsw dsw = null;
    private transient DswStatus dswStatus;
    private transient DswStatus daqStat1;
    private transient DswStatus daqStat2;
    private transient DswBitmaps dswBitmaps;
    private String masterName = "";
    private String shadowName = "";
    private String bitmapName = "";
    private float cachedPercentDifferent = 0.0f;
    private float cachedPercentSame = 100.0f;
    private float cachedPercentCopied = 1000.0f;
    private float cachedPercentUnCopied = 0.0f;
    private static final int INITIAL_DAQ = 1;
    private static final int QUERY_USING_STAT1 = 2;
    private static final int QUERY_USING_STAT2 = 3;
    private static final int SEND_PREVIOUS_MODIFIER = -559030547;
    private int pingPongDAQ;
    private boolean isIndependent;
    private final Delegate stateListenerDelegate = new Delegate(class$com$sun$esm$mo$dsw$DswVolStateListener != null ? class$com$sun$esm$mo$dsw$DswVolStateListener : (class$com$sun$esm$mo$dsw$DswVolStateListener = DswVolImpl.class$("com.sun.esm.mo.dsw.DswVolStateListener")));
    private final Delegate volStateListenerDelegate = new Delegate(class$com$sun$esm$mo$dsw$DswVolStateListener != null ? class$com$sun$esm$mo$dsw$DswVolStateListener : (class$com$sun$esm$mo$dsw$DswVolStateListener = DswVolImpl.class$("com.sun.esm.mo.dsw.DswVolStateListener")));
    private final Delegate volStatusListenerDelegate = new Delegate(class$com$sun$esm$mo$dsw$DswVolStatusListener != null ? class$com$sun$esm$mo$dsw$DswVolStatusListener : (class$com$sun$esm$mo$dsw$DswVolStatusListener = DswVolImpl.class$("com.sun.esm.mo.dsw.DswVolStatusListener")));
    private final Delegate volModifierListenerDelegate = new Delegate(class$com$sun$esm$mo$dsw$DswVolModifierListener != null ? class$com$sun$esm$mo$dsw$DswVolModifierListener : (class$com$sun$esm$mo$dsw$DswVolModifierListener = DswVolImpl.class$("com.sun.esm.mo.dsw.DswVolModifierListener")));
    private int state;
    private int status;
    private int modifier;
    private int previousModifier;
    private int logLevel = 0;
    private SvImplProxy masterProxy;
    private SvImplProxy shadowProxy;
    private BitmapFile bitmapFile;
    static final String sccs_id = "@(#)DswVolImpl.java 1.114    99/11/18 SMI";
    static /* synthetic */ Class class$com$sun$esm$mo$dsw$DswVolStateListener;
    static /* synthetic */ Class class$com$sun$esm$mo$dsw$DswVolStatusListener;
    static /* synthetic */ Class class$com$sun$esm$mo$dsw$DswVolModifierListener;

    private DswVolImpl() {
    }

    public DswVolImpl(SvImplProxy svImplProxy, SvImplProxy svImplProxy2, BitmapFile bitmapFile) {
        this.masterProxy = svImplProxy;
        this.shadowProxy = svImplProxy2;
        this.bitmapFile = bitmapFile;
        this.dswTrace("DswVolImpl constructor");
        this.state = 1;
        this.dswTrace("state = " + this.state);
        this.status = 1;
        this.dswTrace("status = " + this.status);
        this.debug = System.getProperty("ESMDEBUG") != null;
        this.dswTrace("debug = " + this.debug);
        this.verbose = System.getProperty("ESMVERBOSE") != null;
        this.dswTrace("verbose = " + this.verbose);
        this.pretend = System.getProperty("com.sun.esm.slm.dsw.DBL") != null;
        this.dswTrace("pretend = " + this.pretend);
        this.masterName = new String(svImplProxy.getVolName());
        this.dswTrace("master = " + this.masterName);
        this.shadowName = new String(svImplProxy2.getVolName());
        this.dswTrace("shadow = " + this.shadowName);
        this.bitmapName = new String(bitmapFile.getBitmapFileName());
        this.dswTrace("bitmap = " + this.bitmapName);
        this.pickle();
        this.log("`vol_constructor`");
    }

    public void abort() throws DswVolException {
        this.print("abort");
        try {
            try {
                if (!this.pretend) {
                    this.dsw.abort(this.opHandle, this.getMasterName());
                } else {
                    this.dswTrace("request ignored");
                }
                this.changingDswVolModifier(6);
                this.sendingGoodStatus(9);
            }
            catch (CompositeException compositeException) {
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                this.sendingBadStatus(9);
                throw this.handleLibError(compositeException, "`libspcs_abort_Err`");
            }
            Object var2_2 = null;
            this.dswTrace("abort returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.dswTrace("abort returning");
            throw throwable;
        }
    }

    public void addDswVolModifierListener(DswVolModifierListener dswVolModifierListener) {
        this.dswTrace("addDswVolModifierListener");
        this.volModifierListenerDelegate.addListener((EventListener)dswVolModifierListener);
        this.pickle();
    }

    public void addDswVolStateListener(DswVolStateListener dswVolStateListener) {
        this.dswTrace("addDswVolStateListener");
        this.volStateListenerDelegate.addListener((EventListener)dswVolStateListener);
        this.pickle();
    }

    public void addDswVolStatusListener(DswVolStatusListener dswVolStatusListener) {
        this.dswTrace("addDswVolStatusListener");
        this.volStatusListenerDelegate.addListener((EventListener)dswVolStatusListener);
        this.pickle();
    }

    public synchronized void changingDswVolModifier(int n) {
        if (n == -559030547) {
            this.modifier = this.previousModifier;
            this.dswTrace("changingDswVolModifier  back to " + DswModifierCodes.stateName[this.modifier]);
        } else if (n == 12 || n == 6) {
            this.dswTrace("changingDswVolModifier  from " + DswModifierCodes.stateName[this.modifier] + " to " + DswModifierCodes.stateName[n]);
            this.modifier = n;
        } else {
            this.dswTrace("changingDswVolModifier  from " + DswModifierCodes.stateName[this.modifier] + " to " + DswModifierCodes.stateName[n]);
            this.previousModifier = this.modifier;
            this.modifier = n;
        }
        this.pickle();
        try {
            this.volModifierListenerDelegate.send((EventObject)((Object)new DswConditionEventObject(this.volProxy, this.getCondition())), "isEnabled", true);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.dswTrace("IllegalAccessException: " + ExceptionUtil.getExceptionTree((Throwable)illegalAccessException));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.dswTrace("NoSuchMethodException: " + ExceptionUtil.getExceptionTree((Throwable)noSuchMethodException));
        }
        catch (InvocationTargetException invocationTargetException) {
            this.dswTrace("InvocationTargetException: " + ExceptionUtil.getExceptionTree((Throwable)invocationTargetException));
        }
        this.dswTrace("changingDswVolModifier returning");
    }

    public synchronized void changingDswVolModifierNoEvent(int n) {
        if (n == -559030547) {
            this.modifier = this.previousModifier;
            this.dswTrace("changingDswVolModifier  back to " + DswModifierCodes.stateName[this.modifier]);
        } else if (n == 12 || n == 6) {
            this.dswTrace("changingDswVolModifier  from " + DswModifierCodes.stateName[this.modifier] + " to " + DswModifierCodes.stateName[n]);
            this.modifier = n;
        } else {
            this.dswTrace("changingDswVolModifier  from " + DswModifierCodes.stateName[this.modifier] + " to " + DswModifierCodes.stateName[n]);
            this.previousModifier = this.modifier;
            this.modifier = n;
        }
        this.pickle();
        this.dswTrace("changingDswVolModifier returning");
    }

    public synchronized void changingDswVolState(int n) {
        this.dswTrace("changingDswVolState  from " + Integer.toString(this.state) + " to " + Integer.toString(n));
        this.state = n;
        this.pickle();
        try {
            this.volStateListenerDelegate.send((EventObject)((Object)new DswConditionEventObject(this.volProxy, this.getCondition())), "isRunning", true);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.dswTrace("IllegalAccessException: " + ExceptionUtil.getExceptionTree((Throwable)illegalAccessException));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.dswTrace("NoSuchMethodException: " + ExceptionUtil.getExceptionTree((Throwable)noSuchMethodException));
        }
        catch (InvocationTargetException invocationTargetException) {
            this.dswTrace("InvocationTargetException: " + ExceptionUtil.getExceptionTree((Throwable)invocationTargetException));
        }
        this.dswTrace("changingDswVolState returning");
    }

    private void checkDswBitmap() {
        if (this.modifier == 11 || this.modifier == 12) {
            return;
        }
        if (this.dswBitmaps == null) {
            this.dswBitmaps = new DswBitmaps(this.bitmapHandle, this.getMasterName());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void copyToMaster() throws DswVolException {
        this.print("copyToMaster");
        try {
            try {
                this.changingDswVolModifier(1);
                this.sendingGoodStatus(1);
                if (!this.pretend) {
                    this.dsw.copyShadowToMaster(this.copyHandle, this.getMasterName());
                } else {
                    this.dswTrace("request ignored");
                }
                this.sendingGoodStatus(4);
            }
            catch (CompositeException compositeException) {
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                this.dswTrace("ExceptionTrinket " + compositeException.getMessage());
                if (compositeException.getMessage().equals("`DSW_EABORTED`")) {
                    this.log("`volume_abort`");
                    this.dswTrace("copyToMaster aborted");
                    if (this.modifier != 12 && this.modifier != 11) {
                        this.changingDswVolModifier(6);
                    }
                    this.sendingGoodStatus(8);
                }
                this.sendingBadStatus(4);
                throw this.handleLibError(compositeException, "`libspcs_copytomast_Err`");
            }
            Object var2_2 = null;
            if (!this.isSuspensionOn() && this.modifier != 6) {
                this.dswTrace("copyToMaster retuning to enabled");
                this.changingDswVolModifier(9);
            }
            this.dswTrace("copyToMaster returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            if (!this.isSuspensionOn() && this.modifier != 6) {
                this.dswTrace("copyToMaster retuning to enabled");
                this.changingDswVolModifier(9);
            }
            this.dswTrace("copyToMaster returning");
            throw throwable;
        }
    }

    public void copyToMasterNoWait() {
        this.dswTrace("copyToMasterNoWait()");
        DswVolDaemon dswVolDaemon = new DswVolDaemon(this, 1);
        this.dswTrace("isDaemon() = " + dswVolDaemon.isDaemon());
        this.print("copyToMasterNoWait returning");
    }

    public void copyToShadow() throws DswVolException {
        this.print("copyToShadow");
        try {
            try {
                this.changingDswVolModifier(2);
                this.sendingGoodStatus(1);
                if (!this.pretend) {
                    this.dsw.copyMasterToShadow(this.copyHandle, this.getMasterName());
                } else {
                    this.dswTrace("request ignored");
                }
                this.sendingGoodStatus(5);
            }
            catch (CompositeException compositeException) {
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                this.dswTrace("ExceptionTrinket " + compositeException.getMessage());
                if (compositeException.getMessage().equals("`DSW_EABORTED`")) {
                    this.log("`volume_abort`");
                    this.dswTrace("copyToShadow aborted");
                    if (this.modifier != 12 && this.modifier != 11) {
                        this.changingDswVolModifier(6);
                    }
                    this.sendingGoodStatus(5);
                }
                this.sendingBadStatus(5);
                throw this.handleLibError(compositeException, "`libspcs_copytoshad_Err`");
            }
            Object var2_2 = null;
            if (!this.isSuspensionOn() && this.modifier != 6) {
                this.dswTrace("copyToShadow retuning to enabled");
                this.changingDswVolModifier(9);
            }
            this.dswTrace("copyToShadow returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            if (!this.isSuspensionOn() && this.modifier != 6) {
                this.dswTrace("copyToShadow retuning to enabled");
                this.changingDswVolModifier(9);
            }
            this.dswTrace("copyToShadow returning");
            throw throwable;
        }
    }

    public void copyToShadowNoWait() {
        this.dswTrace("copyToShadowNoWait()");
        DswVolDaemon dswVolDaemon = new DswVolDaemon(this, 2);
        this.dswTrace("isDaemon() = " + dswVolDaemon.isDaemon());
        this.print("copyToShadowNoWait returning");
    }

    public void disable() throws DswVolException {
        this.print("disable");
        try {
            try {
                this.sendIsAboutToDisable(8);
                if (!this.pretend) {
                    if (this.modifier != 12) {
                        this.dsw.disable(this.opHandle, this.getMasterName());
                    }
                    this.opHandle.release();
                    this.dswTrace("opHandle released");
                    this.copyHandle.release();
                    this.dswTrace("copyHandle released");
                    this.daqHandle.release();
                    this.dswTrace("daqHandle released");
                    this.bitmapHandle.release();
                    this.dswTrace("bitmapHandle released");
                    this.statusHandle.release();
                    this.dswTrace("statusHandle released");
                } else {
                    this.dswTrace("request ignored");
                }
                this.changingDswVolModifier(8);
                this.sendingGoodStatus(12);
                this.dswTrace("disable releasing proxy " + this.volProxy);
                this.volProxy = null;
            }
            catch (Exception exception) {
                if (exception.getMessage().equals("`DSW_ENOTFOUND`")) {
                    this.changingDswVolModifier(8);
                    this.sendingGoodStatus(12);
                    this.dswTrace("disable releasing proxy " + this.volProxy);
                    this.volProxy = null;
                }
                this.dswTrace("Exception: " + ExceptionUtil.getExceptionTree((Throwable)exception));
                this.sendingBadStatus(12);
                throw this.handleLibError(exception, "`libspcs_disable_Err`");
            }
            Object var2_2 = null;
            this.dswTrace("disable returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.dswTrace("disable returning");
            throw throwable;
        }
    }

    public void dispose() {
        this.dswTrace("dispose");
        try {
            Pickle.dispose((OID)this.oid);
            this.log("`volume_dispose`");
        }
        catch (PersistenceException persistenceException) {
            this.dswTrace("dispose PersistenceException");
        }
    }

    private void dswDBGTrace(String string) {
        if (this.debug) {
            this.dswTrace(string);
        }
    }

    private void dswStack(Exception exception) {
        if (this.debug) {
            exception.printStackTrace();
        }
    }

    private void dswTrace(String string) {
        Services.trace((String)(String.valueOf(this.getShadowName()) + " " + string), (String)this.getClass().getName(), (int)100, (int)32);
    }

    public void dswVolRegisterHandle() throws DswVolException {
        this.dswTrace("dswVolRegisterHandle");
        try {
            try {
                this.volProxy = this.newProxy();
                if (!this.pretend) {
                    this.pingPongDAQ = 1;
                    this.status = 1;
                    this.opHandle = new DswHandle();
                    this.opHandle.register();
                    this.copyHandle = new DswHandle();
                    this.copyHandle.register();
                    this.daqHandle = new DswHandle();
                    this.daqHandle.register();
                    this.bitmapHandle = new DswHandle();
                    this.bitmapHandle.register();
                    this.statusHandle = new DswHandle();
                    this.statusHandle.register();
                    this.cfg = new DswConfig();
                    this.dsw = new Dsw();
                    this.dswStatus = new DswStatus();
                    this.daqStat1 = new DswStatus();
                    this.daqStat2 = new DswStatus();
                } else {
                    this.dswTrace("request ignored");
                }
            }
            catch (Exception exception) {
                this.dswTrace("Exception: " + ExceptionUtil.getExceptionTree((Throwable)exception));
                throw this.handleLibError(exception, "`libspcs_register_Err`");
            }
            Object var2_2 = null;
            this.dswTrace("dswVolRegisterHandle returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.dswTrace("dswVolRegisterHandle returning");
            throw throwable;
        }
    }

    public void enable() throws DswVolException {
        this.print("enable");
        this.isIndependent = false;
        this.modifier = 9;
        try {
            try {
                this.changingDswVolModifier(9);
                if (!this.pretend) {
                    this.cfg.setMasterVol(this.masterProxy.getVolName());
                    this.cfg.setShadowVol(this.shadowProxy.getVolName());
                    this.cfg.setBitmapVol(this.bitmapFile.getBitmapFileName());
                    this.cfg.enable(this.copyHandle);
                } else {
                    this.dswTrace("request ignored");
                }
                this.changingDswVolState(3);
                this.sendingGoodStatus(13);
            }
            catch (CompositeException compositeException) {
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                this.dswTrace("ExceptionTrinket " + compositeException.getMessage());
                this.sendingBadStatus(13);
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                throw this.handleLibError(compositeException, "`libspcs_enable_Err`");
            }
            Object var2_2 = null;
            this.dswTrace("enable returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.dswTrace("enable returning");
            throw throwable;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void fullCopyEnable() throws DswVolException {
        this.print("fullCopyEnable");
        this.isIndependent = true;
        try {
            try {
                this.changingDswVolModifier(5);
                this.sendingGoodStatus(1);
                if (!this.pretend) {
                    this.cfg.setMasterVol(this.masterProxy.getVolName());
                    this.cfg.setShadowVol(this.shadowProxy.getVolName());
                    this.cfg.setBitmapVol(this.bitmapFile.getBitmapFileName());
                    this.state = 3;
                    this.cfg.enableWithFullCopy(this.copyHandle);
                } else {
                    this.dswTrace("request ignored");
                }
                this.changingDswVolState(3);
                this.sendingGoodStatus(8);
            }
            catch (CompositeException compositeException) {
                this.fullCpyExp = this.handleLibError(compositeException, "`libspcs_enable_Err`");
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                this.dswTrace("ExceptionTrinket " + compositeException.getMessage());
                if (compositeException.getMessage().equals("`DSW_EABORTED`")) {
                    this.log("`volume_abort`");
                    this.dswTrace("fullCopyEnable aborted");
                    if (this.modifier != 12 && this.modifier != 11) {
                        this.changingDswVolModifier(6);
                    }
                    this.sendingGoodStatus(8);
                }
                this.sendingBadStatus(8);
                throw this.fullCpyExp;
            }
            Object var2_2 = null;
            if (!this.isSuspensionOn() && this.modifier != 6) {
                this.dswTrace("fullCopyEnable retuning to enabled");
                this.changingDswVolModifier(9);
            }
            this.dswTrace("fullCopyEnable returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            if (!this.isSuspensionOn() && this.modifier != 6) {
                this.dswTrace("fullCopyEnable retuning to enabled");
                this.changingDswVolModifier(9);
            }
            this.dswTrace("fullCopyEnable returning");
            throw throwable;
        }
    }

    public void fullCopyEnableNoWait() {
        this.print("fullCopyEnableNoWait");
        this.isIndependent = true;
        DswVolDaemon dswVolDaemon = new DswVolDaemon(this, 5);
        this.dswTrace("isDaemon() = " + dswVolDaemon.isDaemon());
        this.dswTrace("fullCopyEnableNoWait returning");
    }

    public BitmapFile getBitmapFile() {
        this.dswTrace("getBitmapFile");
        return this.bitmapFile;
    }

    public String getBitmapName() {
        return this.bitmapName;
    }

    public Condition getCondition() {
        this.dswTrace("state= " + this.state + " modifier= " + this.modifier + " status=" + this.status);
        return new Condition(this.state, this.modifier, this.status);
    }

    public byte[] getCopyBitmap() {
        byte[] byArray = null;
        this.dswTrace("getCopyBitmap");
        if (!this.pretend) {
            this.checkDswBitmap();
            byArray = this.dswBitmaps.retrieveCopyBitmap(this.getMasterName());
        }
        return byArray;
    }

    public int getCopyBitmapIndexed(int n) {
        byte by = 0;
        if (!this.pretend) {
            this.checkDswBitmap();
            by = this.dswBitmaps.getCopyBitmapIndexed(n);
        }
        this.dswTrace("getCopyBitmapIndexed" + by);
        return by;
    }

    public synchronized boolean getDAQStatus(int n) {
        boolean bl = true;
        this.dswDBGTrace("getDAQStatus");
        try {
            if (!this.pretend) {
                if (n == 2) {
                    this.daqStat1.fillInDswStatus(this.daqHandle, this.getMasterName());
                } else {
                    this.daqStat2.fillInDswStatus(this.daqHandle, this.getMasterName());
                }
            } else {
                this.dswDBGTrace("request ignored");
            }
        }
        catch (CompositeException compositeException) {
            this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
            this.handleLibError(compositeException, "`libspcs_getstat_Err`");
            bl = false;
        }
        this.dswDBGTrace("getDAQStatus returning");
        return bl;
    }

    public void getDswBitmap() throws DswVolException {
        this.dswTrace("getDswBitmap");
        if (!this.pretend) {
            if (this.modifier != 12 || this.modifier != 11) {
                this.checkDswBitmap();
            }
        } else {
            this.dswTrace("request ignored");
        }
        this.dswTrace("getDswBitmap returning");
    }

    public synchronized void getDswStatus() throws DswVolException {
        this.dswTrace("getDswStatus");
        try {
            try {
                if (!this.pretend) {
                    this.dswStatus.fillInDswStatus(this.statusHandle, this.getMasterName());
                } else {
                    this.dswTrace("request ignored");
                }
            }
            catch (CompositeException compositeException) {
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                throw this.handleLibError(compositeException, "`libspcs_getstat_Err`");
            }
            Object var2_2 = null;
            this.dswTrace("getDswStatus returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.dswTrace("getDswStatus returning");
            throw throwable;
        }
    }

    public int getDswVolumeSize() {
        int n = 0;
        if (!this.pretend) {
            n = this.dswStatus.getSize();
        }
        this.dswTrace("getSize() = " + n);
        return n;
    }

    public int getMapBitSize() {
        int n = 0;
        if (!this.pretend) {
            this.checkDswBitmap();
            n = this.dswBitmaps.getMapBitSize();
        }
        this.dswTrace("getMapBitSize = " + n);
        return n;
    }

    public int getMapByteSize() {
        int n = 0;
        if (!this.pretend) {
            this.checkDswBitmap();
            n = this.dswBitmaps.getMapByteSize();
        }
        this.dswTrace("getMapByteSize" + n);
        return n;
    }

    public int getMasterCapacity() {
        return this.masterProxy.getVolSize();
    }

    public String getMasterHostname() {
        return this.masterProxy.getVolHostName();
    }

    public String getMasterName() {
        return this.masterName;
    }

    public SvImplProxy getMasterProxy() {
        return this.masterProxy;
    }

    public int getMasterState() {
        return this.masterProxy.getState();
    }

    public float getPercentCopied() {
        if (!this.pretend) {
            if (this.modifier == 12 || this.modifier == 11) {
                return this.cachedPercentCopied;
            }
            this.checkDswBitmap();
            this.cachedPercentCopied = this.dswBitmaps.percentCopied();
        }
        this.dswTrace("getPercentCopied = " + this.cachedPercentCopied);
        return this.cachedPercentCopied;
    }

    public float getPercentDifferent() {
        if (!this.pretend) {
            if (this.modifier == 12 || this.modifier == 12) {
                return this.cachedPercentDifferent;
            }
            this.checkDswBitmap();
            this.cachedPercentDifferent = this.dswBitmaps.percentDifferent();
        }
        this.dswTrace("getPercentDifferent = " + this.cachedPercentDifferent);
        return this.cachedPercentDifferent;
    }

    public float getPercentSame() {
        if (!this.pretend) {
            if (this.modifier == 12 || this.modifier == 11) {
                return this.cachedPercentSame;
            }
            this.checkDswBitmap();
            this.cachedPercentSame = this.dswBitmaps.percentSame();
        }
        this.dswTrace("DswVol: getPercentSame = " + this.cachedPercentSame);
        return this.cachedPercentSame;
    }

    public float getPercentUnCopied() {
        float f = 0.0f;
        if (!this.pretend) {
            if (this.modifier == 12 || this.modifier == 11) {
                return this.cachedPercentUnCopied;
            }
            this.checkDswBitmap();
            this.cachedPercentUnCopied = this.dswBitmaps.percentUnCopied();
        }
        this.dswTrace("getPercentUnCopied = " + this.cachedPercentUnCopied);
        return this.cachedPercentUnCopied;
    }

    public int getSetInCopy() {
        int n = 0;
        if (!this.pretend) {
            this.checkDswBitmap();
            n = this.dswBitmaps.setInCopy();
        }
        this.dswTrace("getSetInCopy = " + n);
        return n;
    }

    public int getSetInShadow() {
        int n = 0;
        if (!this.pretend) {
            this.checkDswBitmap();
            n = this.dswBitmaps.setInShadow();
        }
        this.dswTrace("getSetInShadow = " + n);
        return n;
    }

    public byte[] getShadowBitmap() {
        byte[] byArray = null;
        this.checkDswBitmap();
        byArray = this.dswBitmaps.retrieveShadowBitmap(this.getMasterName());
        this.dswTrace("getShadowBitmap = " + byArray);
        return byArray;
    }

    public byte getShadowBitmapIndexed(int n) {
        byte by = 0;
        if (!this.pretend) {
            this.checkDswBitmap();
            by = this.dswBitmaps.getShdBitmapIndexed(n);
        }
        this.dswTrace("getShadowBitmapIndexed = " + by);
        return by;
    }

    public int getShadowCapacity() {
        return this.shadowProxy.getVolSize();
    }

    public String getShadowHostname() {
        return this.shadowProxy.getVolHostName();
    }

    public String getShadowName() {
        return this.shadowName;
    }

    public SvImplProxy getShadowProxy() {
        return this.shadowProxy;
    }

    public int getShadowState() {
        return this.shadowProxy.getState();
    }

    private DswVolException handleLibError(Throwable throwable, String string) {
        DswVolException dswVolException;
        Object[] objectArray = new Object[]{this.getMasterName(), this.getShadowName()};
        if (throwable instanceof CompositeException) {
            dswVolException = new DswVolException(string, objectArray, ((CompositeException)throwable).getTargets());
        } else {
            Throwable[] throwableArray = new Throwable[]{throwable};
            dswVolException = new DswVolException(string, objectArray, throwableArray);
        }
        Services.log((String)string, (Object[])objectArray, ((Object)((Object)dswVolException)).getClass(), (String)"`InstantImage`", (Throwable)throwable);
        return dswVolException;
    }

    public void hydrate() {
        this.dswTrace("hydrate");
        Vector vector = this.stateListenerDelegate.getListeners();
        this.dswTrace(" stateListenerDelegate members = " + vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.dswTrace(enumeration.nextElement().toString());
        }
        vector = this.volStateListenerDelegate.getListeners();
        this.dswTrace(" volStateListenerDelegate members = " + vector.size());
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            this.dswTrace(enumeration2.nextElement().toString());
        }
        vector = this.volStatusListenerDelegate.getListeners();
        this.dswTrace(" volStatusListenerDelegate members = " + vector.size());
        Enumeration enumeration3 = vector.elements();
        while (enumeration3.hasMoreElements()) {
            this.dswTrace(enumeration3.nextElement().toString());
        }
        vector = this.volModifierListenerDelegate.getListeners();
        this.dswTrace(" volModifierListenerDelegate members = " + vector.size());
        Enumeration enumeration4 = vector.elements();
        while (enumeration4.hasMoreElements()) {
            this.dswTrace(enumeration4.nextElement().toString());
        }
        if (this.modifier != 8 && this.modifier != 0) {
            this.dswTrace("start the hydrate daemon");
            DswVolHydrateDaemon dswVolHydrateDaemon = new DswVolHydrateDaemon(this, this.modifier);
            this.dswTrace("hydrateDaemon() = " + dswVolHydrateDaemon.isDaemon());
        } else {
            this.dswTrace("a disabled object attempted to hydrate, modifier = " + this.modifier);
            this.dispose();
        }
        this.log("`vol_hydrate`");
        this.dswTrace("hydrate returning");
    }

    public boolean isDswBitmapVolumeOffline() {
        boolean bl = false;
        if (!this.pretend) {
            bl = this.dswStatus.bitmapOffline();
        }
        this.dswTrace("isDswBitmapVolumeOffline = " + bl);
        return bl;
    }

    public boolean isDswCopyMasterToShadow() {
        boolean bl = false;
        if (!this.pretend) {
            bl = this.dswStatus.copyingMasterToShadow();
        }
        this.dswTrace("isDswCopyMasterToShadow = " + bl);
        return bl;
    }

    public boolean isDswCopyShadowToMaster() {
        boolean bl = false;
        if (!this.pretend) {
            bl = this.dswStatus.copyingShadowToMaster();
        }
        this.dswTrace("isDswCopyShadowToMaster = " + bl);
        return bl;
    }

    public boolean isDswCopying() {
        boolean bl = false;
        if (!this.pretend) {
            bl = this.dswStatus.copying();
        }
        this.dswTrace("isDswCopying = " + bl);
        return bl;
    }

    public boolean isDswMasterVolumeOffline() {
        boolean bl = false;
        if (!this.pretend) {
            bl = this.dswStatus.masterOffline();
        }
        this.dswTrace("isDswMasterVolumeOffline = " + bl);
        return bl;
    }

    public boolean isDswShadowVolumeOffline() {
        boolean bl = false;
        if (!this.pretend) {
            bl = this.dswStatus.shadowOffline();
        }
        this.dswTrace("isDswShadowVolumeOffline = " + bl);
        return bl;
    }

    public boolean isDswVolumeIndependent() {
        boolean bl = false;
        if (!this.pretend) {
            bl = this.dswStatus.goldenCopy();
        }
        this.dswTrace("isDswVolumeIndependent = " + bl);
        return bl;
    }

    public boolean isEnabledIndependent() {
        this.dswTrace("isEnabledIndependent = " + this.isIndependent);
        return this.isIndependent;
    }

    public boolean isModifierListenerRegistered(DswVolModifierListener dswVolModifierListener) {
        this.dswTrace("isModifierListenerRegistered");
        return this.volModifierListenerDelegate.isListener((EventListener)dswVolModifierListener);
    }

    public boolean isMounted(String string) {
        return MountUtil.isMounted(string);
    }

    public boolean isStateListenerRegistered(DswVolStateListener dswVolStateListener) {
        this.dswTrace("isStateListenerRegistered");
        return this.volStateListenerDelegate.isListener((EventListener)dswVolStateListener);
    }

    public boolean isStatusListenerRegistered(DswVolStatusListener dswVolStatusListener) {
        this.dswTrace("isStatusListenerRegistered");
        return this.volStatusListenerDelegate.isListener((EventListener)dswVolStatusListener);
    }

    protected boolean isSuspensionOn() {
        if (this.modifier == 12 || this.modifier == 14 || this.modifier == 11) {
            this.dswTrace("isSuspentionOn is true");
            return true;
        }
        return false;
    }

    public void log(String string) {
        Object[] objectArray = new Object[]{this.getMasterName(), this.getShadowName()};
        Services.log((String)string, (Object[])objectArray, this.getClass(), (String)"`InstantImage`");
    }

    protected Proxy newProxy() {
        Proxy proxy = ByReference.wrap((Object)this);
        return proxy;
    }

    public void offline() throws DswVolException {
        this.print("offline");
        try {
            try {
                if (!this.pretend) {
                    this.dsw.offline(this.opHandle, this.getMasterName());
                } else {
                    this.dswTrace("request ignored");
                }
                this.changingDswVolModifier(14);
                this.sendingGoodStatus(17);
            }
            catch (CompositeException compositeException) {
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                this.dswTrace("ExceptionTrinket " + compositeException.getMessage());
                this.sendingBadStatus(17);
                throw this.handleLibError(compositeException, "`libspcs_offline_Err`");
            }
            Object var2_2 = null;
            this.dswTrace("offline returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.dswTrace("offline returning");
            throw throwable;
        }
    }

    public void performVolDAQ() {
        if (this.status == 3) {
            this.dswDBGTrace("DAQ returning, pair DEGRADED");
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.state != 3 || this.modifier == 12 || this.modifier == 11 || this.modifier == 14 || this.status == 20) {
            if (this.state != 3) {
                this.dswDBGTrace("DAQ returning, not RUNNING");
            } else if (this.modifier == 12) {
                this.dswDBGTrace("DAQ returning, in SUSPEND");
            } else if (this.modifier == 11) {
                this.dswDBGTrace("DAQ returning, pair SUSPENDING");
            } else if (this.status == 20) {
                this.dswDBGTrace("DAQ returning,  pair INOPERABLE");
            } else if (this.modifier == 14) {
                this.dswDBGTrace("DAQ returning,  pair OFFLINE");
            }
            return;
        }
        if (this.pingPongDAQ == 1) {
            this.dswDBGTrace("initial DAQ");
            if (this.getDAQStatus(2) && this.getDAQStatus(3)) {
                this.pingPongDAQ = 2;
                if (this.daqStat1.masterOffline()) {
                    this.log("`master_offline`");
                    this.dswTrace("master volume went offline during DAQ1");
                    bl2 = true;
                }
                if (this.daqStat1.shadowOffline()) {
                    this.log("`shadow_offline`");
                    this.dswTrace("shadow volume went offline during DAQ1");
                    bl2 = true;
                }
            } else {
                this.pingPongDAQ = 1;
                bl = true;
            }
        } else if (this.pingPongDAQ == 2) {
            if (this.getDAQStatus(2)) {
                if (this.daqStat1.masterOffline() && !this.daqStat2.masterOffline()) {
                    this.dswTrace("master volume went offline during DAQ1");
                    this.log("`master_offline`");
                    bl2 = true;
                }
                if (this.daqStat1.shadowOffline() && !this.daqStat2.shadowOffline()) {
                    this.dswTrace("shadow volume went offline during DAQ1");
                    this.log("`shadow_offline`");
                    bl2 = true;
                }
                this.pingPongDAQ = 3;
            } else {
                this.pingPongDAQ = 1;
                bl = true;
            }
        } else if (this.pingPongDAQ == 3) {
            if (this.getDAQStatus(3)) {
                if (this.daqStat2.masterOffline() && !this.daqStat1.masterOffline()) {
                    this.dswTrace("master volume went offline during DAQ2");
                    this.log("`master_offline`");
                    bl2 = true;
                }
                if (this.daqStat2.shadowOffline() && !this.daqStat1.shadowOffline()) {
                    this.dswTrace("shadow volume went offline during DAQ2");
                    this.log("`shadow_offline`");
                    bl2 = true;
                }
                this.pingPongDAQ = 2;
            } else {
                this.pingPongDAQ = 1;
                bl = true;
            }
        }
        if (bl) {
            this.dswTrace("DAQ failed while attempting to get status");
            this.sendingDegradedStatus(18);
        }
        if (bl2) {
            this.dswTrace("DAQ set pair offline");
            this.setPairOffline();
            this.dswTrace("DAQ sending check status event, volume went offline");
            this.sendingDegradedStatus(19);
        }
    }

    protected void pickle() {
        this.dswTrace("pickle");
        if (this.modifier == 8) {
            this.dswTrace("wave off pickle");
            return;
        }
        try {
            this.oid = Pickle.pickle((Serializable)this, (OID)this.oid, (String)"hydrate");
        }
        catch (PersistenceException persistenceException) {
            this.dswTrace("pickle PersistenceException");
        }
    }

    public void print(String string) {
        this.dswTrace(String.valueOf(string) + "\n master  " + this.getMasterName() + "\n shadow  " + this.getShadowName() + "\n bitmap  " + this.getBitmapName());
    }

    public void removeDswVolModifierListener(DswVolModifierListener dswVolModifierListener) {
        this.dswTrace("removeDswVolModifierListener");
        this.volModifierListenerDelegate.removeListener((EventListener)dswVolModifierListener);
        this.pickle();
    }

    public void removeDswVolStateListener(DswVolStateListener dswVolStateListener) {
        this.dswTrace("removeDswVolStateListener");
        this.volStateListenerDelegate.removeListener((EventListener)dswVolStateListener);
        this.pickle();
    }

    public void removeDswVolStatusListener(DswVolStatusListener dswVolStatusListener) {
        this.dswTrace("removeDswVolStatusListener");
        this.volStatusListenerDelegate.removeListener((EventListener)dswVolStatusListener);
        this.pickle();
    }

    public void reset() throws DswVolException {
        this.print("reset");
        try {
            try {
                if (!this.pretend) {
                    this.dsw.reset(this.opHandle, this.getMasterName());
                } else {
                    this.changingDswVolModifier(7);
                }
                this.sendingGoodStatus(10);
                this.changingDswVolModifier(9);
            }
            catch (CompositeException compositeException) {
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                this.sendingBadStatus(10);
                throw this.handleLibError(compositeException, "`libspcs_reset_Err`");
            }
            Object var2_2 = null;
            this.dswTrace("reset returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.dswTrace("reset returning");
            throw throwable;
        }
    }

    public void resume() throws DswVolException {
        this.print("resume");
        this.dswTrace("resuming modifier " + DswModifierCodes.stateName[this.modifier]);
        try {
            try {
                if (!this.pretend) {
                    this.cfg.setMasterVol(this.masterProxy.getVolName());
                    this.cfg.setShadowVol(this.shadowProxy.getVolName());
                    this.cfg.setBitmapVol(this.bitmapFile.getBitmapFileName());
                } else {
                    this.dswTrace("request ignored");
                }
                if (this.modifier == 12) {
                    this.changingDswVolModifier(-559030547);
                    if (this.status != 3) {
                        this.sendingGoodStatus(1);
                    }
                    if (!this.pretend) {
                        this.cfg.resume(this.opHandle);
                    } else {
                        this.dswTrace("request ignored");
                    }
                    this.sendingGoodStatus(14);
                    if (this.modifier != 6) {
                        this.changingDswVolModifier(9);
                    }
                } else if (!this.pretend) {
                    this.cfg.resume(this.opHandle);
                } else {
                    this.dswTrace("request ignored");
                }
            }
            catch (CompositeException compositeException) {
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                this.dswTrace("ExceptionTrinket " + compositeException.getMessage());
                if (compositeException.getMessage().equals("`DSW_EABORTED`")) {
                    this.log("`volume_abort`");
                    this.dswTrace("resume aborted");
                    if (this.modifier != 12 && this.modifier != 11) {
                        this.changingDswVolModifier(6);
                    }
                    this.sendingGoodStatus(14);
                }
                if (compositeException.getMessage().equals("`DSW_EINUSE`")) {
                    this.dswTrace("resume execption ignored");
                }
                this.changingDswVolModifier(9);
                this.sendingBadStatus(14);
                throw this.handleLibError(compositeException, "`libspcs_resume_Err`");
            }
            Object var2_2 = null;
            this.dswTrace("resume returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.dswTrace("resume returning");
            throw throwable;
        }
    }

    public void resumeNoWait() {
        this.print("resumeNoWait");
        DswVolDaemon dswVolDaemon = new DswVolDaemon(this, 10);
        this.dswTrace("isDaemon() = " + dswVolDaemon.isDaemon());
        this.dswTrace("resumeNoWait returning");
    }

    public void sendIsAboutToDisable(int n) {
        this.dswTrace("sendIsAboutToDisable " + Integer.toString(n));
        try {
            this.volModifierListenerDelegate.send((EventObject)((Object)new DswConditionEventObject(this.volProxy, this.getCondition())), "isAboutToDisable", true);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.dswTrace("IllegalAccessException: " + ExceptionUtil.getExceptionTree((Throwable)illegalAccessException));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.dswTrace("NoSuchMethodException: " + ExceptionUtil.getExceptionTree((Throwable)noSuchMethodException));
        }
        catch (InvocationTargetException invocationTargetException) {
            this.dswTrace("InvocationTargetException: " + ExceptionUtil.getExceptionTree((Throwable)invocationTargetException));
        }
        this.dswTrace("sendIsAboutToDisable returning");
    }

    private synchronized void sendingBadStatus(int n) {
        this.dswTrace("sendingBadStatus  = " + Integer.toString(n));
        this.status = n;
        try {
            this.volStatusListenerDelegate.send((EventObject)((Object)new DswConditionEventObject(this.volProxy, this.getCondition())), "isBAD", true);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.dswTrace("IllegalAccessException: " + ExceptionUtil.getExceptionTree((Throwable)illegalAccessException));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.dswTrace("NoSuchMethodException: " + ExceptionUtil.getExceptionTree((Throwable)noSuchMethodException));
        }
        catch (InvocationTargetException invocationTargetException) {
            this.dswTrace("InvocationTargetException: " + ExceptionUtil.getExceptionTree((Throwable)invocationTargetException));
        }
        this.dswTrace("sendingBadStatus returning");
    }

    synchronized void sendingDegradedStatus(int n) {
        this.dswTrace("sendingDegradedStatus  = " + Integer.toString(n));
        this.status = n;
        try {
            this.volStatusListenerDelegate.send((EventObject)((Object)new DswConditionEventObject(this.volProxy, this.getCondition())), "isDEGRADED", true);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.dswTrace("IllegalAccessException: " + ExceptionUtil.getExceptionTree((Throwable)illegalAccessException));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.dswTrace("NoSuchMethodException: " + ExceptionUtil.getExceptionTree((Throwable)noSuchMethodException));
        }
        catch (InvocationTargetException invocationTargetException) {
            this.dswTrace("InvocationTargetException: " + ExceptionUtil.getExceptionTree((Throwable)invocationTargetException));
        }
        this.dswTrace("sendingDegradedStatus returning");
    }

    private synchronized void sendingGoodStatus(int n) {
        if (this.status == 20) {
            return;
        }
        this.dswTrace("sendingGoodStatus  = " + Integer.toString(n));
        this.status = n;
        try {
            this.volStatusListenerDelegate.send((EventObject)((Object)new DswConditionEventObject(this.volProxy, this.getCondition())), "isGOOD", true);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.dswTrace("IllegalAccessException: " + ExceptionUtil.getExceptionTree((Throwable)illegalAccessException));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.dswTrace("NoSuchMethodException: " + ExceptionUtil.getExceptionTree((Throwable)noSuchMethodException));
        }
        catch (InvocationTargetException invocationTargetException) {
            this.dswTrace("InvocationTargetException: " + ExceptionUtil.getExceptionTree((Throwable)invocationTargetException));
        }
        this.dswTrace("sendingGoodStatus returning");
    }

    public void setBitmapFile(BitmapFile bitmapFile) {
        this.dswTrace("setBitmapFile");
        this.bitmapFile = bitmapFile;
    }

    public void setPairInoperable() {
        this.print("setPairInoperable");
        this.changingDswVolModifier(this.modifier);
        this.sendingBadStatus(20);
        this.dswTrace("setPairInoperable returning");
    }

    void setPairOffline() {
        this.print("setPairOffline");
        this.changingDswVolModifier(14);
        this.dswTrace("setPairOffline returning");
    }

    public void setPairOperable() {
        this.print("setPairOperable");
        this.status = 1;
        this.changingDswVolModifier(this.modifier);
        this.sendingGoodStatus(1);
        this.dswTrace("setPairOperable returning");
    }

    public void shutdown() throws DswVolException {
        this.print("shutdown");
        try {
            try {
                if (!this.pretend) {
                    this.dsw.shutdown(this.opHandle);
                } else {
                    this.dswTrace("request ignored");
                }
                this.changingDswVolModifier(13);
                this.sendingGoodStatus(16);
            }
            catch (CompositeException compositeException) {
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                this.dswTrace("ExceptionTrinket " + compositeException.getMessage());
                this.sendingBadStatus(16);
                throw this.handleLibError(compositeException, "`libspcs_shutdown_Err`");
            }
            Object var2_2 = null;
            this.changingDswVolModifier(9);
            this.dswTrace("shutdown returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.changingDswVolModifier(9);
            this.dswTrace("shutdown returning");
            throw throwable;
        }
    }

    public void stopped() {
        this.print("stopped");
        this.changingDswVolState(5);
        this.dswTrace("stopped returning");
    }

    public void stopping() {
        this.print("stopping");
        this.changingDswVolState(4);
        this.dswTrace("stopping returning");
    }

    public void suspend() throws DswVolException {
        this.print("suspend");
        try {
            try {
                this.changingDswVolModifier(11);
                if (!this.pretend) {
                    this.dsw.suspend(this.opHandle, this.getMasterName());
                } else {
                    this.dswTrace("request ignored");
                }
                this.changingDswVolModifier(12);
                this.sendingGoodStatus(15);
            }
            catch (CompositeException compositeException) {
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                this.dswTrace("ExceptionTrinket " + compositeException.getMessage());
                this.sendingBadStatus(15);
                throw this.handleLibError(compositeException, "`libspcs_suspend_Err`");
            }
            Object var2_2 = null;
            this.dswTrace("suspend returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.dswTrace("suspend returning");
            throw throwable;
        }
    }

    void tryEnabling() throws DswVolException {
        this.print("tryEnabling");
        if (this.fullCpyExp != null) {
            this.dswTrace("tryEnabling detected an exception, re-thrown");
            throw this.fullCpyExp;
        }
    }

    public void updateToMaster() throws DswVolException {
        this.print("updateToMaster");
        try {
            try {
                this.changingDswVolModifier(3);
                this.sendingGoodStatus(6);
                if (!this.pretend) {
                    this.dsw.copyShadowToMasterChunks(this.copyHandle, this.getMasterName());
                } else {
                    this.dswTrace("request ignored");
                }
                this.sendingGoodStatus(6);
            }
            catch (CompositeException compositeException) {
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                this.dswTrace("ExceptionTrinket " + compositeException.getMessage());
                if (compositeException.getMessage().equals("`DSW_EABORTED`")) {
                    this.log("`volume_abort`");
                    this.dswTrace("updateToMaster aborting");
                    if (this.modifier != 12 && this.modifier != 11) {
                        this.changingDswVolModifier(6);
                    }
                    this.sendingGoodStatus(8);
                }
                this.sendingBadStatus(6);
                throw this.handleLibError(compositeException, "`libspcs_updatetomast_Err`");
            }
            Object var2_2 = null;
            if (!this.isSuspensionOn() && this.modifier != 6) {
                this.dswTrace("updateToMaster retuning to enabled");
                this.changingDswVolModifier(9);
            }
            this.dswTrace("updateToMaster returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            if (!this.isSuspensionOn() && this.modifier != 6) {
                this.dswTrace("updateToMaster retuning to enabled");
                this.changingDswVolModifier(9);
            }
            this.dswTrace("updateToMaster returning");
            throw throwable;
        }
    }

    public void updateToMasterNoWait() {
        this.dswTrace("updateToMasterNoWait");
        DswVolDaemon dswVolDaemon = new DswVolDaemon(this, 3);
        this.dswTrace("isDaemon() = " + dswVolDaemon.isDaemon());
        this.dswTrace("updateToMasterNoWait returning");
    }

    public void updateToShadow() throws DswVolException {
        this.print("updateToShadow");
        try {
            try {
                this.changingDswVolModifier(4);
                this.sendingGoodStatus(1);
                if (!this.pretend) {
                    this.dsw.copyMasterToShadowChunks(this.copyHandle, this.getMasterName());
                } else {
                    this.dswTrace("request ignored");
                }
                this.sendingGoodStatus(7);
            }
            catch (CompositeException compositeException) {
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                this.dswTrace("ExceptionTrinket " + compositeException.getMessage());
                if (compositeException.getMessage().equals("`DSW_EABORTED`")) {
                    this.log("`volume_abort`");
                    this.dswTrace("updateToShadow aborted");
                    if (this.modifier != 12 && this.modifier != 11) {
                        this.changingDswVolModifier(6);
                    }
                    this.sendingGoodStatus(8);
                }
                this.sendingBadStatus(7);
                throw this.handleLibError(compositeException, "`libspcs_updatetoshad_Err`");
            }
            Object var2_2 = null;
            if (!this.isSuspensionOn() && this.modifier != 6) {
                this.dswTrace("updateToShadow retuning to enabled");
                this.changingDswVolModifier(9);
            }
            this.dswTrace("updateToShadow returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            if (!this.isSuspensionOn() && this.modifier != 6) {
                this.dswTrace("updateToShadow retuning to enabled");
                this.changingDswVolModifier(9);
            }
            this.dswTrace("updateToShadow returning");
            throw throwable;
        }
    }

    public void updateToShadowNoWait() {
        this.dswTrace("updateToShadowNoWait");
        DswVolDaemon dswVolDaemon = new DswVolDaemon(this, 4);
        this.dswTrace("isDaemon() = " + dswVolDaemon.isDaemon());
        this.dswTrace("copyToShadowNoWait returning");
    }

    public void waitUntilComplete() throws DswVolException {
        this.print("waitUntilComplete");
        try {
            try {
                if (!this.pretend) {
                    this.dsw.wait(this.opHandle, this.getMasterName());
                } else {
                    this.dswTrace("request ignored");
                }
                this.sendingGoodStatus(1);
            }
            catch (CompositeException compositeException) {
                this.dswTrace("CompositeException: " + ExceptionUtil.getExceptionTree((Throwable)compositeException));
                this.dswTrace("ExceptionTrinket " + compositeException.getMessage());
                this.sendingBadStatus(2);
                throw this.handleLibError(compositeException, "`libspcs_wait_Err`");
            }
            Object var2_2 = null;
            if (!this.isSuspensionOn()) {
                this.changingDswVolModifier(9);
            }
            this.dswTrace("waitUntilComplete returning");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            if (!this.isSuspensionOn()) {
                this.changingDswVolModifier(9);
            }
            this.dswTrace("waitUntilComplete returning");
            throw throwable;
        }
    }

    public void waitUntilCompleteNoWait() {
        this.print("waitUntilCompleteNoWait");
        DswVolDaemon dswVolDaemon = new DswVolDaemon(this, 15);
        this.dswTrace("isDaemon() = " + dswVolDaemon.isDaemon());
        this.dswTrace("waitUntilCompleteNoWait returning");
    }
}

