/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esm.library.spcs.sdbc;

import com.sun.esm.library.spcs.AccessException;
import com.sun.esm.library.spcs.SolarisException;
import com.sun.esm.library.spcs.sdbc.SdbcException;
import com.sun.esm.library.spcs.sdbc.SdbcHandle;
import com.sun.esm.library.spcs.sdbc.SdbcVolumeStats;

public class SdbcStats {
    private int netDirty;
    private int netPending;
    private int netFree;
    private int stCount;
    private int stLocCount;
    private int stRdhits;
    private int stRdmiss;
    private int stWrhits;
    private int stWrmiss;
    private int stBlksize;
    private long[] stMemSizes = new long[SdbcStats.getSDMAXMEM()];
    private long stTotalCmem;
    private long stTotalSmem;
    private long stLruBlocks;
    private long stLruNoreq;
    private long stLruReq;
    private int[] stWlruInq = new int[SdbcStats.getMAXCACHENET()];
    private int stCachesize;
    private int stNumblocks;
    private SdbcVolumeStats[] stShared = new SdbcVolumeStats[SdbcStats.getMAXFILES() * 2];

    static {
        SdbcStats.initFIDs();
    }

    public SdbcStats(SdbcHandle sdbcHandle) throws SolarisException, AccessException, SdbcException {
        int n = 0;
        while (n < this.stShared.length) {
            this.stShared[n] = new SdbcVolumeStats();
            ++n;
        }
        this.fillInStats(sdbcHandle);
    }

    public static native void clearStats(SdbcHandle var0) throws SolarisException, AccessException, SdbcException;

    private native void fillInStats(SdbcHandle var1) throws SolarisException, AccessException, SdbcException;

    private static native int getMAXCACHENET();

    private static native int getMAXFILES();

    private int getNetDirty() {
        return this.netDirty;
    }

    private int getNetFree() {
        return this.netFree;
    }

    private int getNetPending() {
        return this.netPending;
    }

    private static native int getSDMAXMEM();

    public int getStBlksize() {
        return this.stBlksize;
    }

    public int getStCachesize() {
        return this.stCachesize;
    }

    public int getStCount() {
        return this.stCount;
    }

    public int getStLocCount() {
        return this.stLocCount;
    }

    public long getStLruBlocks() {
        return this.stLruBlocks;
    }

    public long getStLruNoreq() {
        return this.stLruNoreq;
    }

    public long getStLruReq() {
        return this.stLruReq;
    }

    public long[] getStMemSizes() {
        return this.stMemSizes;
    }

    public long getStMemSizesIndexed(int n) {
        return this.stMemSizes[n];
    }

    public int getStNumblocks() {
        return this.stNumblocks;
    }

    public int getStRdhits() {
        return this.stRdhits;
    }

    public int getStRdmiss() {
        return this.stRdmiss;
    }

    public SdbcVolumeStats[] getStShared() {
        return this.stShared;
    }

    public SdbcVolumeStats getStSharedIndexed(int n) {
        return this.stShared[n];
    }

    public long getStTotalCmem() {
        return this.stTotalCmem;
    }

    public long getStTotalSmem() {
        return this.stTotalSmem;
    }

    public int[] getStWlruInq() {
        return this.stWlruInq;
    }

    public int getStWlruInqIndexed(int n) {
        return this.stWlruInq[n];
    }

    public int getStWrhits() {
        return this.stWrhits;
    }

    public int getStWrmiss() {
        return this.stWrmiss;
    }

    private static native void initFIDs();

    private void setNetDirty(int n) {
        this.netDirty = n;
    }

    private void setNetFree(int n) {
        this.netFree = n;
    }

    private void setNetPending(int n) {
        this.netPending = n;
    }

    private void setStBlksize(int n) {
        this.stBlksize = n;
    }

    private void setStCachesize(int n) {
        this.stCachesize = n;
    }

    private void setStCount(int n) {
        this.stCount = n;
    }

    private void setStLocCount(int n) {
        this.stLocCount = n;
    }

    private void setStLruBlocks(long l) {
        this.stLruBlocks = l;
    }

    private void setStLruNoreq(long l) {
        this.stLruNoreq = l;
    }

    private void setStLruReq(long l) {
        this.stLruReq = l;
    }

    private void setStMemSizes(long[] lArray) {
        this.stMemSizes = lArray;
    }

    private void setStMemSizesIndexed(int n, long l) {
        this.stMemSizes[n] = l;
    }

    private void setStNumblocks(int n) {
        this.stNumblocks = n;
    }

    private void setStRdhits(int n) {
        this.stRdhits = n;
    }

    private void setStRdmiss(int n) {
        this.stRdmiss = n;
    }

    private void setStShared(SdbcVolumeStats[] sdbcVolumeStatsArray) {
        this.stShared = sdbcVolumeStatsArray;
    }

    private void setStSharedIndexed(int n, SdbcVolumeStats sdbcVolumeStats) {
        this.stShared[n] = sdbcVolumeStats;
    }

    private void setStTotalCmem(long l) {
        this.stTotalCmem = l;
    }

    private void setStTotalSmem(long l) {
        this.stTotalSmem = l;
    }

    private void setStWlruInq(int[] nArray) {
        this.stWlruInq = nArray;
    }

    private void setStWlruInqIndexed(int n, int n2) {
        this.stWlruInq[n] = n2;
    }

    private void setStWrhits(int n) {
        this.stWrhits = n;
    }

    private void setStWrmiss(int n) {
        this.stWrmiss = n;
    }

    public void updateStats(SdbcHandle sdbcHandle) throws SolarisException, AccessException, SdbcException {
        this.fillInStats(sdbcHandle);
    }
}

