/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esm.library.spcs.dsw;

import com.sun.esm.library.spcs.AccessException;
import com.sun.esm.library.spcs.SolarisException;
import com.sun.esm.library.spcs.dsw.DswException;
import com.sun.esm.library.spcs.dsw.DswHandle;

public class DswBitmaps {
    private int mapBitSize;
    private int mapByteSize;
    private byte[] shdBitmap;
    private byte[] copyBitmap;
    private String masterVol;
    private DswHandle handle;

    public DswBitmaps(DswHandle dswHandle, String string) throws AccessException {
        this.masterVol = string;
        this.handle = dswHandle;
        this.mapBitSize = this.retrieveMapBitSize();
        this.setMapByteSize((this.getMapBitSize() + this.getDSW_BITS() - 1) / this.getDSW_BITS());
        this.copyBitmap = new byte[this.mapByteSize];
        this.shdBitmap = new byte[this.mapByteSize];
    }

    public void fillInDswBitmaps(DswHandle dswHandle, String string) throws AccessException, DswException, SolarisException {
        this.nFillInDswBitmaps(dswHandle, string, this.getMapByteSize());
    }

    public byte[] getCopyBitmap() {
        return this.copyBitmap;
    }

    public byte getCopyBitmapIndexed(int n) {
        return this.copyBitmap[n];
    }

    private native int getDSW_BITS();

    private native int getDSW_SIZE();

    public DswHandle getHandle() {
        return this.handle;
    }

    public int getMapBitSize() {
        return this.mapBitSize;
    }

    public int getMapByteSize() {
        return this.mapByteSize;
    }

    public String getMasterVol() {
        return this.masterVol;
    }

    public byte[] getShdBitmap() {
        return this.shdBitmap;
    }

    public byte getShdBitmapIndexed(int n) {
        return this.shdBitmap[n];
    }

    private native void nFillInDswBitmaps(DswHandle var1, String var2, int var3) throws AccessException, DswException, SolarisException;

    private native byte[] nativeRetrieveBitmap(String var1, int var2, DswHandle var3, int var4);

    public float percentCopied() {
        float f = 0.0f;
        f = 100.0f - this.percentUnCopied();
        return f;
    }

    public float percentDifferent() {
        return 100.0f * ((float)this.setInShadow() / (float)this.getMapBitSize());
    }

    public float percentSame() {
        return 100.0f - this.percentDifferent();
    }

    public float percentUnCopied() {
        return 100.0f * ((float)this.setInCopy() / (float)this.getMapBitSize());
    }

    public byte[] retrieveCopyBitmap(String string) {
        return this.nativeRetrieveBitmap(string, this.getMapByteSize(), this.handle, 0);
    }

    private native int retrieveMapBitSize() throws AccessException;

    public byte[] retrieveShadowBitmap(String string) {
        return this.nativeRetrieveBitmap(string, this.getMapByteSize(), this.handle, 1);
    }

    public native int setInCopy();

    public native int setInShadow();

    private void setMapByteSize(int n) {
        this.mapByteSize = n;
    }
}

