/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.pm.server;

import com.sun.admin.pm.server.Debug;
import com.sun.admin.pm.server.PrinterDebug;
import com.sun.admin.pm.server.pmInternalErrorException;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class SysCommand {
    private Process p = null;
    private String out = null;
    private String err = null;
    private int status = 0;

    private void dispose() {
        try {
            this.p.getInputStream().close();
            this.p.getOutputStream().close();
            this.p.getErrorStream().close();
            this.p.destroy();
        }
        catch (Exception exception) {
            Debug.message("SVR:" + exception.getMessage());
        }
    }

    public void exec(String string) throws Exception {
        if (string == null) {
            throw new pmInternalErrorException("SysCommand.exec(): null command");
        }
        Debug.message("SVR: " + string);
        this.p = Runtime.getRuntime().exec(string);
        if (this.p == null) {
            throw new pmInternalErrorException("SysCommand.exec(): null process");
        }
        this.out = this.readOut();
        this.err = this.readErr();
        this.p.waitFor();
        this.status = this.getStatus();
        this.dispose();
    }

    public void exec(String string, String string2) throws Exception {
        if (string == null) {
            throw new pmInternalErrorException("SysCommand.exec(): null command");
        }
        Debug.message("SVR: " + string2 + "; " + string);
        String[] stringArray = new String[]{string2};
        this.p = Runtime.getRuntime().exec(string, stringArray);
        if (this.p == null) {
            throw new pmInternalErrorException("SysCommand.exec(): null process");
        }
        this.out = this.readOut();
        this.err = this.readErr();
        this.p.waitFor();
        this.status = this.getStatus();
        this.dispose();
    }

    public void exec(String[] stringArray) throws Exception {
        if (stringArray == null) {
            throw new pmInternalErrorException("SysCommand.exec(): null command");
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) break;
            ++n;
        }
        if (n != stringArray.length) {
            String[] stringArray2 = new String[n];
            n = 0;
            while (n < stringArray2.length) {
                stringArray2[n] = stringArray[n];
                ++n;
            }
            Debug.message("SVR: " + PrinterDebug.arr_to_str(stringArray2));
            this.p = Runtime.getRuntime().exec(stringArray2);
        } else {
            Debug.message("SVR: " + PrinterDebug.arr_to_str(stringArray));
            this.p = Runtime.getRuntime().exec(stringArray);
        }
        if (this.p == null) {
            throw new pmInternalErrorException("SysCommand.exec(): null process");
        }
        this.out = this.readOut();
        this.err = this.readErr();
        this.p.waitFor();
        this.status = this.getStatus();
        this.dispose();
    }

    public String getError() {
        if (this.err == null) {
            return null;
        }
        return new String(this.err);
    }

    public int getExitValue() {
        return this.status;
    }

    public String getOutput() {
        if (this.out == null) {
            return null;
        }
        return new String(this.out);
    }

    private int getStatus() throws Exception {
        return this.p.exitValue();
    }

    public static void main(String[] stringArray) {
        SysCommand sysCommand = new SysCommand();
        String string = "ypcat hosts";
        String string2 = "";
        try {
            sysCommand.exec(string);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        string2 = sysCommand.getOutput();
        System.out.println(string2);
    }

    private String readErr() throws Exception {
        String string = null;
        String string2 = null;
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new InputStreamReader(this.p.getErrorStream()));
        while ((string2 = bufferedReader.readLine()) != null) {
            string = string == null ? string2 : string.concat("\n" + string2);
        }
        return string;
    }

    private String readOut() throws Exception {
        String string = null;
        String string2 = null;
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
        while ((string2 = bufferedReader.readLine()) != null) {
            string = string == null ? string2 : string.concat("\n" + string2);
        }
        return string;
    }
}

