#
#   File:    kernel-reader-d.x
#   Version: 1.19
#
#   Copyright (c) 1998 Sun Microsystems Inc.
#
#   Kernel Reader Module
#


[ requires package kr ]
[ use MANAGED-MODULE ]
[ requires template kernel-reader-models-d ]
[ requires template kernel-reader-family-j ]

family = kernel-reader

#
# Load Default Module Parameters
#

[ load kernel-reader-v2-m.x ]

#
# Load Managed Object  & Property Models
#

#
# Define service required by this module
#

_services = { [ use SERVICE ] 
	#
	# Standard Bourne Shell
	#
	
	sh = {
		command	= "pipe://localhost//bin/sh;transport=shell"
		max	= 2
	}
}

_filters = { [ use PROC ]
    [ source kernel-reader-d.flt ]
}


_rules = { [ use PROC ]
        [ source kernel-reader-d.rul ]
}

user = { [ use templates.kernel-reader-models-d.user ]
	 [ use templates.kernel-reader-family-j.user ]

	type                    = active
        refreshCommand          = userinfo
        refreshInterval         = 300

        family = kernel-reader-user

        primaryUser = {
            type                = active
            refreshService      = _services.sh
            refreshCommand      = kernel-reader-primary-user-d.sh

            # Run once per day
            initInterval        = 10
            refreshInterval     = 86400
        }
}
load = { [ use templates.kernel-reader-models-d.load ]
		[ use templates.kernel-reader-family-j.load ]

    type		= active
    refreshMode		= sync
    refreshCommand	= miscinfo
    refreshInterval	= 300
    refreshService	= _internal

    family = kernel-reader-load

}

#
# Interprocess Communication Information
#
#ipc = { [ use templates.solaris-standard-models-d.ipc ]
#	[ use templates.sun-solaris-family-j.ipc ]
#
#        family = sun-solaris-ipc
#
#        adhocCommand(msgqueuesinfo) = probeserver -c /usr/bin/ipcs -aq
#        adhocCommand(sharedmeminfo) = probeserver -c /usr/bin/ipcs -am
#        adhocCommand(semaphoresinfo) = probeserver -c /usr/bin/ipcs -as
#
#        msg = {
#            type                = active
#            refreshCommand      = ssinfo msg
#            refreshMode         = sync
#            refreshInterval     = 120
#        }
#
#        shm = {
#            type                = active
#            refreshCommand      = ssinfo shm
#            refreshMode         = sync
#            refreshInterval     = 120
#        }
#
#        sem = {
#            type                = active
#            refreshCommand      = ssinfo sem
#            refreshMode         = sync
#            refreshInterval     = 120
#        }
#}
#

#
# Disk Information
#
disk= { [ use templates.kernel-reader-models-d.disk ]
		[ use templates.kernel-reader-family-j.disk-detail ]

    family = kernel-reader-swap

    disk-detail = {
        type            = active
        refreshMode     = sync
        refreshCommand  = diskinfo detail 
        refreshInterval = 300
        initInterval = 1
    }

    disk-srvtime = {
        type            = active
        refreshMode     = sync
        refreshCommand  = diskinfo srv
        refreshInterval = 300

        diskSrvTable = {

	    diskSrvEntry = {

	        w_pct = {
                    alarmRules  = rknrd100
	        }
	        b_pct = {
                    alarmRules  = rknrd401
	        }
                rknrd404 = {
		    type	= active
                    refreshInterval = 3600
                    alarmRules  = rknrd404
                }
	    }
	}
    }
}

#
# Filesystem information
#
filesystem = { [ use templates.kernel-reader-models-d.filesystem ]
	       [ use templates.kernel-reader-family-j.filesystem ]

   family = kernel-reader-filesystem
        adhocCommand(findallgt2m) = probeserver -c find %fragment -local -mount ( -type b -o -type c ) -prune -o ( -size +4096 ) -ls
        adhocCommand(findallgt10m) = probeserver -c find %fragment -local -mount ( -type b -o -type c ) -prune -o ( -size +20480 ) -ls
        adhocCommand(findrecentgt2m) = probeserver -c find %fragment -local -mount ( -type b -o -type c ) -prune -o ( -mtime -1 -size +4096 ) -ls
        adhocCommand(findrecentgt10m) = probeserver -c find %fragment -local -mount ( -type b -o -type c ) -prune -o ( -mtime -1 -size +20480 ) -ls

   ufsFileSystem = { [ use _filters]
        type            = active
        refreshService  = _services.sh
        refreshMode     = sync
        refreshCommand  = /usr/bin/df -F ufs -g
        refreshFilter   = dfgFilter
        refreshInterval = 300
   }
   vxfsFileSystem = { [ use _filters]
        type            = active
        refreshService  = _services.sh
        refreshMode     = sync
        refreshCommand  = /usr/bin/df -F vxfs -g
        refreshFilter   = dfgFilter
        refreshInterval = 300
   }
}

#
# CPU Information
#
cpu-detail = { [ use templates.kernel-reader-models-d.cpu-detail ]
		[ use templates.kernel-reader-family-j.cpu ]

    family = kernel-reader-cpu
    adhocCommand(vmstat) = probeserver -c vmstat
    adhocCommand(mpstat) = probeserver -c mpstat


    cpu-util = {
	type            = active
        refreshMode     = sync
        refreshCommand  = cpuinfo util
        refreshInterval = 300
        initInterval = 1
        
	cpuUtilTable = {
	    cpuUtilEntry = {
		cpu_delta = { [use _filters]
			updateFilter = cpudeltafilter
		}
	        cpu_idle = { [use _filters]
			updateFilter=cpuratefilter
	        }				
	        cpu_user = { [use _filters]
			updateFilter=cpuratefilter
	        }		
	        cpu_kernel = { [use _filters]
			updateFilter=cpuratefilter
                }		
	        cpu_wait = { [use _filters]
                        updateFilter=cpuratefilter
	        }
	        wait_io = { [use _filters]
                        updateFilter=cpuratefilter
	        }
	        wait_swap = { [use _filters]
                        updateFilter=cpuratefilter
	        }
	        wait_pio = { [use _filters]
                        updateFilter=cpuratefilter
	        }
		idlethread = { [use _filters]
                        updateFilter = krgenericratefilter
                }
            	rknrd403 = {
		    type		= active
                    refreshInterval	= 3600
                    alarmRules		= rknrd403
                }
	    }
	}
    }

    cpu-process = {
	cpu-procs = {
            type            = active
            refreshMode     = sync
            refreshCommand  = cpuinfo process
            refreshInterval = 60
            initInterval = 1

	    runqueue = {
                alarmRules  = rknrd400
	    }
            numcpus = {
                type            = derived
                refreshService  = _internal
                refreshMode     = sync
                refreshTrigger  = cpu-util.cpuUtilTable.cpuUtilEntry.cpu-instance:update
                refreshCommand  = toe_send [locate cpu-util.cpuUtilTable.cpuUtilEntry] getTableDepth
	    }
	}
    }

    cpu-io = {
	type            = active
        refreshMode     = sync
        refreshCommand  = cpuinfo io
        refreshInterval = 300
	cpuIoTable = {
	    cpuIoEntry = { 
	        bread = { [ use _filters ] 
			updateFilter = krgenericratefilter
	        }
	        bwrite = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        lread = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        lwrite = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        phread = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        phwrite = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }

	        readch = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        writech = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
                rcvint = { [ use _filters ]
			updateFilter = krgenericratefilter
                }
                xmtint = { [ use _filters ]
			updateFilter = krgenericratefilter
                }
                mdmint = { [ use _filters ]
			updateFilter = krgenericratefilter
                }
	        rawch = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        canch = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        outch = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        bawrite = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        physio = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }		
	    }
        }
    }

    cpu-interrupts = {
	type            = active
        refreshMode     = sync
        refreshCommand  = cpuinfo interrupts
        refreshInterval = 300
    	cpuIntrTable = { 
	    cpuIntrEntry = { 
	        pswitch = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        trap = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        intr = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        intrthread = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        intrblk = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	    }
        }
    }
    cpu-syscall = {
	type            = active
        refreshMode     = sync
        refreshCommand  = cpuinfo syscall
        refreshInterval = 300

    	cpuSysTable = { 
	    cpuSysEntry = { 
	        syscall = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        sysread = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        syswrite = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        sysfork = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        sysvfork = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        sysexec = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        msg = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        sema = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        namei = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        ufsiget = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        ufsdirblk = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        ufsipage = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        ufsinopage = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }	
	        inodeovf = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        fileovf = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        procovf = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	    }
	}
    }
    cpu-misc = {
	type            = active
	refreshMode     = sync
	refreshCommand  = cpuinfo misc
	refreshInterval = 300

    	cpuMiscTable = { 
	    cpuMiscEntry = { 
	        inv_swtch = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        nthreads = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        cpumigrate = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        xcalls = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        mutex_adenters = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        rw_rdfails = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        rw_wrfails = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        modload = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        modunload = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        rw_enters = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	    }
	}
    }

    cpu-regwindow = {
	type            = active
        refreshMode     = sync
        refreshCommand  = cpuinfo regwindow
        refreshInterval = 300
    	cpuRegTable = { 
	    cpuRegEntry = { 
	        win_uo_cnt = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        win_uu_cnt = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        win_so_cnt = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        win_su_cnt = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        win_suo_cnt = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	    }
	}
    }

    cpu-pginfo = {
	type            = active
        refreshMode     = sync
        refreshCommand  = cpuinfo pginfo
        refreshInterval = 300

	cpuPgTable = {
	    cpuPgEntry = {
	        pgrec = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        pgfrec = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        pgin = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        pgpgin = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }				
	        pgout = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        pgpgout = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        swapin = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        pgswapin = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        swapout = { [ use _filters ]
			updateFilter = krgenericratefilter
		    alarmRules	= rknrd103
	        }
	        pgswapout = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        zfod = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        dfree = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        scan = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	        rev = { [ use _filters ]
			updateFilter = krgenericratefilter
	        }
	    	pgrrun = { [ use _filters ]
			updateFilter = krgenericratefilter
	    	}
	    }
	}
    }

    cpu-faults = {
	type          = active
	refreshMode     = sync
        refreshCommand  = cpuinfo faults
        refreshInterval = 300
    	cpuFaultTable = { 
	    cpuFaultEntry = { 
	    	hat_fault = { [ use _filters ]
			updateFilter = krgenericratefilter
	    	}
	    	as_fault = { [ use _filters ]
			updateFilter = krgenericratefilter
	    	}
	    	maj_fault = { [ use _filters ]
			updateFilter = krgenericratefilter
	    	}
	    	cow_fault = { [ use _filters ]
			updateFilter = krgenericratefilter
	    	}
	    	prot_fault = { [ use _filters ]
			updateFilter = krgenericratefilter
	    	}
	    	softlock = { [ use _filters ]
			updateFilter = krgenericratefilter
	    	}
	    	kernel_asflt = { [ use _filters ]
			updateFilter = krgenericratefilter
	    	}
	    }
	}
    }
}

memory-usage = { [ use templates.kernel-reader-models-d.memory-usage ]
		[ use templates.kernel-reader-family-j.memory ]
    type		= active
    refreshMode		= sync
    refreshCommand	= meminfo
    refreshInterval	= 300
    refreshService	= _internal

    family = kernel-reader-memory

    pctUsed = {
	type		= derived
	refreshService	= _internal
	refreshMode	= sync
	refreshTrigger	= mem-inuse:update
	refreshCommand	= pctFilter mem-inuse mem-avail
    }
    pctFree = {
	type		= derived
	refreshService	= _internal
	refreshMode	= sync
	refreshTrigger	= mem-free:update
	refreshCommand	= pctFilter mem-free mem-avail
    }
}

swap-detail = { [ use templates.kernel-reader-models-d.swap-detail ]
		[ use templates.kernel-reader-family-j.swap ]
    type		= active
    refreshMode		= sync
    refreshCommand	= swapinfo
    refreshInterval	= 300


    family = kernel-reader-swap

    swap-avail = {
            alarmRules  = rknrd402
    }
    pctUsed = {
	    type		= derived
	    refreshService	= _internal
	    refreshMode		= sync
	    refreshTrigger	= swap-used
	    refreshCommand	= pctFilter swap-used swap-total
            alarmRules  	= rknrd102
    }
    rknrd405 = {
	   type        = active
           refreshInterval = 3600
           alarmRules  = rknrd405
    }
}

streams-detail = { [ use templates.kernel-reader-models-d.streams-detail ]
		[ use templates.kernel-reader-family-j.streams ]

    template-s = {

	pctUsed = {
	    type		= derived
	    refreshService	= _internal
	    refreshMode		= sync
	    refreshTrigger	= maximum
	    refreshCommand	= pctFilter current maximum
	}

    }
    family = kernel-reader-streams

    stream_head_cache = { [ use template-s ]
	refreshCommand	= kmeminfo stream_head_cache
	type		= active
	refreshMode		= sync
	refreshInterval	= 300
    }
    queue_cache = { [ use template-s ]
	refreshCommand	= kmeminfo queue_cache 
	type		= active
	refreshMode		= sync
	refreshInterval	= 300
    }
    streams_msg = { [ use template-s ]
	refreshCommand	= kmeminfo streams_*
	type		= active
	refreshMode		= sync
	refreshInterval	= 300
    }
    linkinfo_cache = { [ use template-s ]
	refreshCommand	= kmeminfo linkinfo_cache
	type		= active
	refreshMode		= sync
	refreshInterval	= 300
    }
    strevent_cache = { [ use template-s ]
	refreshCommand	= kmeminfo strevent_cache
	type		= active
	refreshMode		= sync
	refreshInterval	= 300
    }
    syncq_cache = { [ use template-s ]
	refreshCommand	= kmeminfo syncq_cache
	type		= active
	refreshMode		= sync
	refreshInterval	= 300
    }
    qband_cache = { [ use template-s ]
	refreshCommand	= kmeminfo qband_cache
	type		= active
	refreshMode		= sync
	refreshInterval	= 300
    }
}

software-rules = { [ use templates.kernel-reader-models-d.software-rules ]
                   [ use templates.kernel-reader-family-j.rules ]


        rknrd105 = {
                alarmRules        =  rknrd105
        }
        rknrd106 = {
                alarmRules        =  rknrd106
        }
}

#[ load kernel-reader-d.def ]

hardware-rules = { [ use templates.kernel-reader-models-d.hardware-rules ]
                   [ use templates.kernel-reader-family-j.rules ]


        rknrd204 = {
                alarmRules        =  rknrd204
        }
        rknrd205 = {
                alarmRules        =  rknrd205
        }
}

[ load kernel-reader-d.def ]
