/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.rmi;

import com.sun.symon.base.security.SyCoderInterface;
import com.sun.symon.base.security.SySecurityException;
import com.sun.symon.base.utility.UcDDL;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;

class RMIDataComposer {
    private ByteArrayOutputStream bs;
    private ObjectOutputStream os;
    private SyCoderInterface coder;
    private boolean sensitive;

    RMIDataComposer(SyCoderInterface syCoderInterface, boolean bl) throws RemoteException {
        this.coder = syCoderInterface;
        this.sensitive = bl;
        try {
            this.bs = new ByteArrayOutputStream();
            this.os = new ObjectOutputStream(this.bs);
        }
        catch (IOException iOException) {
            this.handleEx(iOException);
        }
    }

    byte[] getBytes() throws RemoteException {
        try {
            this.os.close();
            return this.coder.encode(this.bs.toByteArray(), this.sensitive);
        }
        catch (SySecurityException sySecurityException) {
            this.handleEx((Exception)((Object)sySecurityException));
        }
        catch (IOException iOException) {
            this.handleEx(iOException);
        }
        return null;
    }

    private void handleEx(Exception exception) throws RemoteException {
        UcDDL.logErrorMessage((String)"Error building data buffer", (Throwable)exception);
        throw new RemoteException(exception.getMessage());
    }

    void writeBoolean(boolean bl) throws RemoteException {
        try {
            this.os.writeBoolean(bl);
        }
        catch (IOException iOException) {
            this.handleEx(iOException);
        }
    }

    void writeInt(int n) throws RemoteException {
        try {
            this.os.writeInt(n);
        }
        catch (IOException iOException) {
            this.handleEx(iOException);
        }
    }

    void writeObject(Object object) throws RemoteException {
        try {
            this.os.writeObject(object);
        }
        catch (InvalidClassException invalidClassException) {
            this.handleEx(invalidClassException);
        }
        catch (NotSerializableException notSerializableException) {
            this.handleEx(notSerializableException);
        }
        catch (IOException iOException) {
            this.handleEx(iOException);
        }
    }
}

