/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.emitters.snmp;

import com.sun.symon.base.server.common.ScRequestSinkInterface;
import com.sun.symon.base.server.emitters.snmp.SeSnmpException;
import com.sun.symon.base.server.emitters.snmp.SeSnmpFinder;
import com.sun.symon.base.server.emitters.snmp.SeSnmpRequestor;
import com.sun.symon.base.server.types.StObject;
import java.net.InetAddress;

class UrlRequest
implements ScRequestSinkInterface {
    private ScRequestSinkInterface requestSink;
    private String[][] cacheKeys;
    private boolean gotFinderResult;
    private SeSnmpException finderEx;
    private SeSnmpRequestor.ResultCallback resultHandler;

    UrlRequest(final int n, final String string, final int n2, final int n3, final String[] stringArray, final StObject[] stObjectArray, SeSnmpRequestor.ResultCallback resultCallback, final SeSnmpRequestor seSnmpRequestor, SeSnmpFinder seSnmpFinder) throws SeSnmpException {
        SeSnmpFinder.ResultCallback resultCallback2 = new SeSnmpFinder.ResultCallback(){

            public void handleException(SeSnmpException seSnmpException) {
                this.handleFinderException(seSnmpException);
            }

            public void handleResult(InetAddress inetAddress, int n4, String string2, String[] stringArray3, String[] stringArray2) {
                this.handleFinderResult(inetAddress, n4, string2, stringArray3, stringArray2, n, string, n2, n3, stringArray, stObjectArray, seSnmpRequestor);
            }
        };
        this.requestSink = null;
        this.cacheKeys = null;
        this.gotFinderResult = false;
        this.finderEx = null;
        this.resultHandler = resultCallback;
        ScRequestSinkInterface scRequestSinkInterface = null;
        try {
            scRequestSinkInterface = seSnmpFinder.resolveUrlList(stringArray, n2, n3, resultCallback2);
        }
        catch (SeSnmpException seSnmpException) {
            throw this.modifyFinderEx(seSnmpException);
        }
        scRequestSinkInterface.emit();
        UrlRequest urlRequest = this;
        synchronized (urlRequest) {
            if (!this.gotFinderResult) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        scRequestSinkInterface.delete();
    }

    public void delete() {
        if (this.requestSink != null) {
            this.requestSink.delete();
        }
    }

    public void emit() {
        if (this.finderEx == null) {
            this.requestSink.emit();
        } else {
            this.finderEx = this.modifyFinderEx(this.finderEx);
            this.resultHandler.handleException(this.finderEx);
        }
    }

    public String[][] getCacheKeys() {
        return this.cacheKeys;
    }

    private synchronized void handleFinderException(SeSnmpException seSnmpException) {
        this.finderEx = seSnmpException;
        this.gotFinderResult = true;
        this.notify();
    }

    private void handleFinderResult(InetAddress inetAddress, int n, String string, String[] stringArray, String[] stringArray2, int n2, String string2, int n3, int n4, String[] stringArray3, StObject[] stObjectArray, SeSnmpRequestor seSnmpRequestor) {
        ScRequestSinkInterface scRequestSinkInterface;
        try {
            scRequestSinkInterface = seSnmpRequestor.createRequestByOid(inetAddress, n, n2, string2, n3, n4, string, stringArray, stObjectArray, this.resultHandler);
        }
        catch (SeSnmpException seSnmpException) {
            this.handleFinderException(seSnmpException);
            return;
        }
        UrlRequest urlRequest = this;
        synchronized (urlRequest) {
            if (stringArray2 != null) {
                this.cacheKeys = new String[stringArray2.length][1];
                int n5 = 0;
                while (n5 < stringArray2.length) {
                    this.cacheKeys[n5][0] = stringArray2[n5];
                    ++n5;
                }
            }
            this.requestSink = scRequestSinkInterface;
            this.gotFinderResult = true;
            this.notify();
        }
    }

    private SeSnmpException modifyFinderEx(SeSnmpException seSnmpException) {
        String string = "Finder query error: ";
        if (seSnmpException.getMessage().startsWith(string)) {
            return seSnmpException;
        }
        return new SeSnmpException(String.valueOf(string) + seSnmpException.getMessage(), seSnmpException.getUrlOrOidIndex(), seSnmpException.getErrorIndex(), seSnmpException.getException());
    }
}

