/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.tcp;

import com.sun.symon.base.server.receptors.SrReceptor;
import com.sun.symon.base.server.receptors.tcp.SrTCPSession;
import com.sun.symon.base.utility.UcDDL;
import java.net.ServerSocket;
import java.net.Socket;

public class SrTCPReceptor
extends SrReceptor
implements Runnable {
    private int port = -1;
    private ServerSocket server = null;
    private Thread bootstrap = new Thread(this);

    public SrTCPReceptor() {
        this.bootstrap.start();
    }

    private ServerSocket connect() {
        block2: {
            UcDDL.logDebugMessage((String)"connect server port");
            if (this.port == -1) break block2;
            try {
                UcDDL.logDebugMessage((String)("open server port = " + this.port));
                this.server = new ServerSocket(this.port);
            }
            catch (Exception exception) {
                UcDDL.logErrorMessage((String)("unable to create socket (" + this.port + ") " + exception));
            }
        }
        return this.server;
    }

    private void reconnect() {
        UcDDL.logDebugMessage((String)"reconnect server port");
        if (this.server != null) {
            try {
                UcDDL.logDebugMessage((String)"close server port");
                this.server.close();
            }
            catch (Exception exception) {
                UcDDL.logErrorMessage((String)("close failed " + exception));
            }
        }
        this.connect();
    }

    public void run() {
        Thread.currentThread().setPriority(10);
        UcDDL.logDebugMessage((String)"bootstrap started");
        if (this.connect() == null) {
            UcDDL.logDebugMessage((String)"unable to create server port");
            return;
        }
        while (true) {
            Socket socket;
            UcDDL.logDebugMessage((String)"loop started");
            UcDDL.logDebugMessage((String)"listen for clients");
            try {
                socket = this.server.accept();
                UcDDL.logDebugMessage((String)"client accepted");
            }
            catch (Exception exception) {
                UcDDL.logErrorMessage((String)("accept failed " + exception));
                continue;
            }
            UcDDL.logDebugMessage((String)"start TCP session");
            new SrTCPSession(socket, this);
        }
    }

    public void setPort(int n) {
        this.port = n;
        UcDDL.logDebugMessage((String)("set port = " + n));
    }
}

