/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.rmi;

import com.sun.symon.base.server.receptors.rmi.RMICollectorInterface;
import com.sun.symon.base.server.receptors.rmi.RMIResponseInterface;
import com.sun.symon.base.server.receptors.rmi.RMIServerException;
import com.sun.symon.base.server.receptors.rmi.RMIServerSession;
import com.sun.symon.base.server.receptors.rmi.RMISessionInterface;
import com.sun.symon.base.utility.UcDDL;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;

public abstract class RMIServer {
    public RMIServer(String string, int n) throws RMIServerException {
        Object object;
        try {
            object = LocateRegistry.createRegistry(n);
            object.rebind("RMIClientServer", new Collector(this));
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"can't start and bind registry", (Throwable)exception);
            System.err.println("can't start and bind registry\n" + exception);
            UcDDL.logErrorMessage((String)"*** terminating execution ***");
            System.err.println("*** terminating execution ***");
            System.exit(1);
        }
        try {
            object = InetAddress.getLocalHost().getHostName();
            String string2 = InetAddress.getLocalHost().getHostAddress();
            UcDDL.logInfoMessage((String)("registry started on host " + (String)object + " (" + string2 + ") port " + n));
        }
        catch (UnknownHostException unknownHostException) {}
        int n2 = UcDDL.createChannel((String)"snmp");
        if (UcDDL.channelIsActive((int)n2)) {
            System.err.println("The snmp DDL channel is active.  This may");
            System.err.println("cause the server to fail to process snmp");
            System.err.println("responses.  It is recommended that the");
            System.err.println("snmp channel be deactivated by editing");
            System.err.println("the configuration files.");
        }
    }

    protected abstract RMIServerSession newSessionInterface(RMIResponseInterface var1) throws RemoteException;

    private class Collector
    extends UnicastRemoteObject
    implements RMICollectorInterface {
        private RMIServer Server;

        public Collector(RMIServer rMIServer2) throws RemoteException {
            this.Server = rMIServer2;
        }

        public RMISessionInterface getSessionObject(RMIResponseInterface rMIResponseInterface) throws RemoteException {
            return this.Server.newSessionInterface(rMIResponseInterface);
        }
    }
}

