/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import com.sun.symon.base.console.views.table.CvTblCell;
import com.sun.symon.base.console.views.table.CvTblTable;
import com.sun.symon.base.console.views.table.CvTblTableEvent;
import com.sun.symon.base.console.views.table.CvTblTableEventListener;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CvTblTableColumn
extends TableColumn
implements TableCellRenderer {
    private String dataType = "";
    private Vector tableEventListeners = new Vector();
    private Border nonSelBorder;
    private Border nonSelHdrBorder;
    private Border selBorder;

    public CvTblTableColumn(int n, String string, String string2, int n2) {
        this.setModelIndex(n);
        this.setDataType(string2);
        this.setWidth(n2);
        JLabel jLabel = new JLabel(string);
        jLabel.setToolTipText(string);
        jLabel.setBorder(new LineBorder(Color.black, 1));
        this.setHeaderValue(jLabel);
        this.setHeaderRenderer(this);
        this.setCellRenderer(this);
        this.setResizable(true);
        this.enableResizedPosting();
        this.nonSelBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.nonSelHdrBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black, 1), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.selBorder = BorderFactory.createLineBorder(Color.blue.darker().darker(), 2);
    }

    public void addTableEventListener(CvTblTableEventListener cvTblTableEventListener) {
        this.tableEventListeners.addElement(cvTblTableEventListener);
    }

    public String getDataType() {
        return this.dataType;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel;
        CvTblTable cvTblTable = (CvTblTable)jTable;
        if (object instanceof CvTblCell) {
            boolean bl3 = true;
            CvTblCell cvTblCell = (CvTblCell)object;
            jLabel = cvTblCell;
            if (cvTblCell.getAlarmStatus() != null) {
                if (cvTblCell.getAlarmStatus().isAcknowledged()) {
                    cvTblCell.setIcon(cvTblTable.getAcknowledgedIcon());
                    cvTblCell.setIconTextGap(5);
                    cvTblCell.setHorizontalAlignment(4);
                    cvTblCell.setHorizontalTextPosition(2);
                } else {
                    cvTblCell.setAlarmMode(cvTblCell.getAlarmMode());
                    if (cvTblCell.getAlarmStatus().getStatusColor() != null) {
                        bl3 = false;
                    }
                }
            }
            if (bl3) {
                cvTblCell.setBackground(n % 2 == 0 ? cvTblTable.getBackground() : cvTblTable.getAlternateBackground());
            }
            if (bl) {
                jLabel.setBorder(this.selBorder);
            } else {
                jLabel.setBorder(this.nonSelBorder);
            }
        } else if (object instanceof JLabel) {
            jLabel = (JLabel)object;
            jLabel.setBackground(cvTblTable.getBackground());
            jLabel.setForeground(cvTblTable.getForeground());
            if (jTable instanceof CvTblTable) {
                if (((CvTblTable)jTable).getHeaderSelected()) {
                    jLabel.setBorder(this.selBorder);
                } else {
                    jLabel.setBorder(this.nonSelHdrBorder);
                }
            }
        } else {
            jLabel = new JLabel(" ");
            jLabel.setBackground(cvTblTable.getBackground());
            jLabel.setForeground(cvTblTable.getForeground());
        }
        return jLabel;
    }

    public int getWidth() {
        return super.getWidth();
    }

    public void removeTableEventListener(CvTblTableEventListener cvTblTableEventListener) {
        this.tableEventListeners.removeElement(cvTblTableEventListener);
    }

    public void setDataType(String string) {
        String string2 = this.dataType = string != null ? string : "";
        if (!(this.dataType.equals("int") || this.dataType.equals("float") || this.dataType.equals("date") || this.dataType.equals("boolean"))) {
            this.dataType = "string";
        }
    }

    public void setWidth(int n) {
        if (n == 0) {
            return;
        }
        super.setWidth(n);
        CvTblTableEvent cvTblTableEvent = new CvTblTableEvent(this, 1, "", "", 0, 0);
        int n2 = 0;
        while (n2 < this.tableEventListeners.size()) {
            Object e = this.tableEventListeners.elementAt(n2);
            ((CvTblTableEventListener)e).tableEventOccurred(cvTblTableEvent);
            ++n2;
        }
    }
}

