/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.console.views.graph.CvGraphFormat;
import com.sun.symon.base.utility.UcDDL;
import java.awt.Font;

public class CvGraphHeaderFormat {
    private boolean showHeader = false;
    private String fontStyle = "plain";
    private String fontName = "Serif";
    private int fontSize = 14;
    private String orientation = "horizontal";
    private String borderType = "none";
    private int borderWidth = 2;

    public String getBorderType() {
        return this.borderType;
    }

    public int getBorderTypeNumber() {
        return CvGraphFormat.getBorderTypeNumber(this.borderType);
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public String getConfiguration() {
        return "Header^" + this.showHeader + "^" + this.fontStyle + "^" + this.fontName + "^" + new Integer(this.fontSize).toString() + "^" + this.orientation + "^" + this.borderType + "^" + new Integer(this.borderWidth).toString();
    }

    public String getOrientation() {
        return this.orientation;
    }

    public int getOrientationNumber() {
        return CvGraphFormat.getOrientationNumber(this.orientation);
    }

    public boolean getShowHeader() {
        return this.showHeader;
    }

    public Font getTitleFont() {
        return new Font(this.fontName, CvGraphFormat.getFontStyleNumber(this.fontStyle), this.fontSize);
    }

    public void setConfiguration(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = CvGraphFormat.splitString(string, "^");
        if (stringArray.length != 8) {
            UcDDL.logDebugMessage((String)("CvGraphHeaderFormat::setConfiguration - invalid number of parameters '" + string + "'"));
            return;
        }
        if (!stringArray[0].equals("Header")) {
            UcDDL.logDebugMessage((String)("CvGraphFormat::setGraphConfiguration - invalid keyword '" + stringArray[0] + "'"));
            return;
        }
        this.showHeader = Boolean.valueOf(stringArray[1]);
        this.fontStyle = stringArray[2];
        this.fontName = stringArray[3];
        this.orientation = stringArray[5];
        this.borderType = stringArray[6];
        try {
            this.fontSize = new Integer(stringArray[4]);
            this.borderWidth = new Integer(stringArray[7]);
        }
        catch (NumberFormatException numberFormatException) {
            UcDDL.logDebugMessage((String)("CvGraphTitleFromat::setConfiguration -- cannot convert strings " + stringArray[4] + " or " + stringArray[7] + " to integers "));
        }
    }

    public void setShowHeader(boolean bl) {
        this.showHeader = bl;
    }
}

