/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.alarms;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmIteratorAsync;
import com.sun.symon.base.client.alarm.SMAlarmObjectRequest;
import com.sun.symon.base.client.alarm.SMAlarmObjectResponse;
import com.sun.symon.base.console.alarms.AlarmData;
import com.sun.symon.base.console.alarms.AlarmList;
import com.sun.symon.base.console.alarms.AlarmPanel;
import com.sun.symon.base.console.alarms.AlarmTableModel;
import com.sun.symon.base.console.alarms.HeaderRenderer;
import com.sun.symon.base.console.alarms.LabelRenderer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

class AlarmTable
extends JTable
implements SMAlarmObjectResponse {
    private final int HOST_TABLE_COLUMN_COUNT = 4;
    private final int DOMAIN_TABLE_COLUMN_COUNT = 5;
    private final int SEVERITY_COUNT = 6;
    private final int VISIBLE_ROWS = 5;
    private final int[] hostColumnWidths = new int[]{68, 120, 45, 300};
    private final int[] domainColumnWidths = new int[]{68, 120, 45, 85, 300};
    private int[] columnWidths = this.hostColumnWidths;
    private int columns = 4;
    private int newAlarms = 0;
    private boolean newAlarmSet = true;
    private boolean firstTime = true;
    private String[] selectedIDs = new String[0];
    private JLabel status;
    private JDialog waitDialog;
    private AlarmPanel alarmPanel;
    private AlarmList alarmList = new AlarmList();
    private AlarmData[] alarmData = new AlarmData[0];
    private AlarmTableModel tableModel;
    private SMAlarmObjectRequest request;
    private SMRawDataRequest rawRequest;
    private String requestError;

    AlarmData[] getAlarmData() {
        return this.alarmData;
    }

    AlarmList getAlarmList() {
        return this.alarmList;
    }

    public void getAlarmResponse(SMRequestStatus sMRequestStatus, Vector vector, Object object, SMAlarmIteratorAsync sMAlarmIteratorAsync) {
        Object[] objectArray = new Object[]{this.alarmPanel.translate("ok")};
        ArrayList arrayList = new ArrayList(vector);
        if (sMRequestStatus.getReturnCode() != 0) {
            JOptionPane.showOptionDialog(this.alarmPanel.getAlarmWindow(this), String.valueOf(this.alarmPanel.translate("responseFailed")) + "\nReason:  " + sMRequestStatus.getMessageText(), this.alarmPanel.translate("alert"), -1, 0, null, objectArray, objectArray[0]);
            if (!this.alarmPanel.isActive()) {
                this.alarmPanel.setActive(true);
            }
            return;
        }
        if (this.alarmPanel.isActive()) {
            this.alarmPanel.setActive(false);
        }
        if (this.newAlarmSet) {
            if (this.status != null) {
                this.status.setText(this.alarmPanel.translate("loadingAlarms"));
            }
            this.alarmList = new AlarmList();
            this.alarmList.init(this.alarmPanel, arrayList);
            this.tableModel.setAlarmList(this.alarmList);
            this.newAlarms = 0;
        } else if (arrayList.size() > 0) {
            this.newAlarms = this.alarmList.processResponse(arrayList, this.getSelectionModel());
            if (this.newAlarms != 0 && this.status != null) {
                this.status.setText(this.alarmPanel.translate("loadingAlarms"));
            }
        }
        if (arrayList.size() == 0) {
            this.alarmPanel.setAlarmCount(Integer.toString(this.alarmList.size()));
            if (this.alarmList.size() > 1) {
                Object[] objectArray2 = this.alarmList.toArray();
                Arrays.sort(objectArray2);
                this.alarmList = new AlarmList(this.alarmPanel, Arrays.asList(objectArray2));
                this.tableModel.setAlarmList(this.alarmList);
            }
            this.tableChanged(new TableModelEvent(this.getModel()));
            if (!this.alarmPanel.isActive()) {
                this.alarmPanel.setActive(true);
            }
            this.repaint();
            this.restoreSelections();
            if (this.status != null) {
                this.status.setText("");
            }
        } else if (arrayList.size() != 0 || arrayList.size() == 0 && this.newAlarmSet) {
            this.newAlarmSet = false;
            if (this.alarmPanel.getDomainUrl() != null) {
                this.getDomainAlarms(true, sMAlarmIteratorAsync);
            } else {
                this.getHostAlarms(true, sMAlarmIteratorAsync);
            }
        }
    }

    void getDomainAlarms(boolean bl) {
        this.getDomainAlarms(bl, null);
    }

    private void getDomainAlarms(boolean bl, SMAlarmIteratorAsync sMAlarmIteratorAsync) {
        Object[] objectArray = new Object[]{this.alarmPanel.translate("ok")};
        if (this.request == null) {
            return;
        }
        if (this.status != null) {
            this.status.setText(this.alarmPanel.translate("loadingAlarms"));
        }
        if (this.alarmPanel.isActive()) {
            this.alarmPanel.setActive(false);
        }
        try {
            if (bl) {
                if (sMAlarmIteratorAsync != null) {
                    sMAlarmIteratorAsync.getNextAlarms();
                }
            } else {
                this.request.getAlarms("1", this.alarmPanel.getDomainUrl(), this.alarmPanel.getShow().getSeverity(), this.alarmPanel.getShow().getState(), this.alarmPanel.getShow().getAcknowledge(), null, null, null, (SMAlarmObjectResponse)this, new Object(), null);
            }
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.alarmPanel.getAlarmWindow(this), String.valueOf(this.alarmPanel.translate("requestException")) + "\n" + exception.getMessage(), this.alarmPanel.translate("alert"), -1, 0, null, objectArray, objectArray[0]);
            this.alarmPanel.setActive(true);
        }
    }

    void getHostAlarms(boolean bl) {
        this.getHostAlarms(bl, null);
    }

    private void getHostAlarms(boolean bl, SMAlarmIteratorAsync sMAlarmIteratorAsync) {
        Object[] objectArray = new Object[]{this.alarmPanel.translate("ok")};
        if (this.request == null) {
            return;
        }
        if (this.status != null) {
            this.status.setText(this.alarmPanel.translate("loadingAlarms"));
        }
        if (this.alarmPanel.isActive()) {
            this.alarmPanel.setActive(false);
        }
        try {
            if (bl) {
                if (sMAlarmIteratorAsync != null) {
                    sMAlarmIteratorAsync.getNextAlarms();
                }
            } else {
                this.request.getAlarms(this.alarmPanel.getRequestId(), null, this.alarmPanel.getAlarmUrl(), this.alarmPanel.getShow().getSeverity(), this.alarmPanel.getShow().getState(), this.alarmPanel.getShow().getAcknowledge(), null, null, null, (SMAlarmObjectResponse)this, new Object());
            }
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(this.alarmPanel.getAlarmWindow(this), String.valueOf(this.alarmPanel.translate("requestException")) + "\n" + exception.getMessage(), this.alarmPanel.translate("alert"), -1, 0, null, objectArray, objectArray[0]);
            this.alarmPanel.setActive(true);
        }
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        Dimension dimension = this.getIntercellSpacing();
        if (n == 1) {
            return this.rowHeight + dimension.height;
        }
        return 1;
    }

    String[] getSelectedIDs() {
        return this.selectedIDs;
    }

    public void init() {
        int n = 0;
        int n2 = 0;
        this.request = this.alarmPanel.getRequestHandle();
        this.status = this.alarmPanel.getWindowStatusField();
        if (this.status != null) {
            this.status.setText("");
        }
        this.tableModel = new AlarmTableModel(this.alarmPanel);
        if (this.alarmPanel.getDomainUrl() != null) {
            this.columns = 5;
            this.columnWidths = this.domainColumnWidths;
        }
        this.setModel(this.tableModel);
        this.setAutoCreateColumnsFromModel(true);
        this.setRowHeight(22);
        this.setRowSelectionAllowed(true);
        this.setAutoResizeMode(3);
        int n3 = 0;
        while (n3 < this.columns) {
            TableColumn tableColumn = this.getColumn(this.getColumnName(n3));
            tableColumn.setHeaderRenderer(new HeaderRenderer());
            if (n3 == this.columns - 1) {
                tableColumn.setMaxWidth(this.columnWidths[n3] * 3);
            } else {
                tableColumn.setMaxWidth(this.columnWidths[n3] * 2);
            }
            tableColumn.setResizable(true);
            tableColumn.setCellRenderer(new LabelRenderer());
            n += this.columnWidths[n3] + 1;
            ++n3;
        }
        n2 = (this.getRowHeight() + 1) * 5;
        this.setPreferredScrollableViewportSize(new Dimension(n, n2));
    }

    void restoreSelections() {
        if (this.selectedIDs.length > 0) {
            String[] stringArray = this.selectedIDs;
            this.clearSelection();
            int n = this.alarmList.size();
            int n2 = 0;
            while (n2 < n) {
                AlarmData alarmData = (AlarmData)this.alarmList.get(n2);
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (stringArray[n3].compareTo((String)alarmData.alarmId) == 0) {
                        this.addRowSelectionInterval(n2, n2);
                        ++n3;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    void setAlarmPanel(AlarmPanel alarmPanel) {
        this.alarmPanel = alarmPanel;
    }

    public void setAlarmResponse(SMRequestStatus sMRequestStatus, Object object) {
    }

    void setNewAlarmSet(boolean bl) {
        this.newAlarmSet = bl;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this.getSelectedRows();
        this.selectedIDs = new String[nArray.length];
        this.alarmData = new AlarmData[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            this.alarmData[n] = (AlarmData)this.alarmList.get(nArray[n]);
            this.selectedIDs[n] = (String)this.alarmData[n].alarmId;
            ++n;
        }
        if (this.alarmList.size() > 0 && nArray.length == 1) {
            AlarmData alarmData = (AlarmData)this.alarmList.get(nArray[0]);
            this.alarmPanel.updateMore(alarmData);
        } else {
            this.alarmPanel.updateMore(new AlarmData());
        }
        super.valueChanged(listSelectionEvent);
    }
}

