/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.utility;

import java.util.Vector;

public class UcQueueProcessor {
    public static final int BLOCK = 0;
    public static final int THREAD_LIMITED = 1;
    public static final int THREAD_UNLIMITED = 2;
    private Vector Q;
    private String ThreadName;
    private int mode;
    private int numThreads = 0;
    private int numBusyThreads;
    private int priority;

    public UcQueueProcessor() {
        this(null, 0, 0, 0);
    }

    public UcQueueProcessor(String string) {
        this(string, 5);
    }

    public UcQueueProcessor(String string, int n) {
        this(string, 2, 0, n);
    }

    public UcQueueProcessor(String string, int n, int n2, int n3) {
        this.mode = n;
        this.priority = n3;
        if (n == 0) {
            this.ThreadName = null;
            this.Q = null;
        } else {
            this.ThreadName = string == null ? "QueueProcessor" : string;
            this.Q = new Vector();
            int n4 = 0;
            while (n4 < n2) {
                this.startThread(null);
                ++n4;
            }
        }
        this.numBusyThreads = 0;
    }

    public void add(Runnable runnable) {
        if (this.mode == 0) {
            runnable.run();
        } else {
            UcQueueProcessor ucQueueProcessor = this;
            synchronized (ucQueueProcessor) {
                if (this.mode == 2 && this.numBusyThreads == this.numThreads) {
                    ++this.numBusyThreads;
                    this.startThread(runnable);
                } else {
                    this.Q.addElement(runnable);
                    this.notify();
                }
            }
        }
    }

    private void startThread(Runnable runnable) {
        ++this.numThreads;
        new QThread(String.valueOf(this.ThreadName) + "#" + this.numThreads, runnable).start();
    }

    private void waitAndProcess(boolean bl) {
        Runnable runnable = null;
        while (true) {
            UcQueueProcessor ucQueueProcessor = this;
            synchronized (ucQueueProcessor) {
                if (runnable != null || bl) {
                    --this.numBusyThreads;
                }
                runnable = null;
                if (this.Q.size() == 0) {
                    while (true) {
                        try {
                            do {
                                this.wait();
                            } while (this.Q.size() <= 0);
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                runnable = (Runnable)this.Q.elementAt(0);
                this.Q.removeElementAt(0);
                ++this.numBusyThreads;
            }
            runnable.run();
        }
    }

    private class QThread
    extends Thread {
        private Runnable firstJob;

        QThread(String string, Runnable runnable) {
            super(string);
            this.firstJob = runnable;
            this.setPriority(UcQueueProcessor.this.priority);
        }

        public void run() {
            boolean bl;
            boolean bl2 = bl = this.firstJob != null;
            if (bl) {
                this.firstJob.run();
            }
            this.firstJob = null;
            UcQueueProcessor.this.waitAndProcess(bl);
        }
    }
}

