/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.utility;

import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcPeriodicException;
import com.sun.symon.base.utility.UcTickerTimer;
import com.sun.symon.base.utility.UcTickerTimerResponse;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class UcCache
extends Hashtable {
    private UcTickerTimer timer;
    private boolean cleanerActive;
    private long scanFreq;
    private int maxAge;

    public UcCache(long l, int n) {
        this.init(l, n);
    }

    public UcCache(long l, int n, int n2) {
        super(n2);
        this.init(l, n);
    }

    public UcCache(long l, int n, int n2, float f) {
        super(n2, f);
        this.init(l, n);
    }

    public synchronized void clean() {
        long l = new Date().getTime() - (long)(this.maxAge * 1000);
        UcDDL.logInfoMessage("Cleaning cache ...");
        int n = 0;
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            TStamp tStamp = (TStamp)super.get(k);
            if (tStamp.timestamp >= l) continue;
            UcDDL.logInfoMessage("removing old cache object (" + k + "," + tStamp.value + ")");
            super.remove(k);
            ++n;
        }
        if (this.timer != null && this.size() == 0) {
            this.timer.stop();
        }
        if (n == 0) {
            UcDDL.logInfoMessage("no cache objects removed");
        }
        UcDDL.logInfoMessage("Cache cleanup done");
    }

    public synchronized void clear() {
        if (this.timer != null) {
            this.timer.stop();
        }
        super.clear();
    }

    public synchronized Object clone() {
        UcCache ucCache = new UcCache(this.scanFreq, this.maxAge);
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = super.get(k);
            super.put(k, v);
        }
        return ucCache;
    }

    public synchronized boolean contains(Object object) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e != object) continue;
            return true;
        }
        return false;
    }

    public synchronized Enumeration elements() {
        final Enumeration enumeration = super.elements();
        Enumeration enumeration2 = new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                TStamp tStamp = (TStamp)enumeration.nextElement();
                if (tStamp == null) {
                    return null;
                }
                tStamp.refresh();
                return tStamp.value;
            }
        };
        return enumeration2;
    }

    public synchronized Object get(Object object) {
        TStamp tStamp = (TStamp)super.get(object);
        if (tStamp == null) {
            return null;
        }
        tStamp.refresh();
        return tStamp.value;
    }

    private void init(long l, int n) {
        if (l == 0L) {
            this.timer = null;
        } else {
            UcTickerTimerResponse ucTickerTimerResponse = new UcTickerTimerResponse(){

                public final void processTick() {
                    UcCache.this.clean();
                }

                public final void processTickEnd() {
                }
            };
            try {
                this.timer = new UcTickerTimer(l, ucTickerTimerResponse);
            }
            catch (UcPeriodicException ucPeriodicException) {
                UcDDL.logErrorMessage("invalid scan frequency", ucPeriodicException);
                l = 3600L;
                try {
                    this.timer = new UcTickerTimer(l, ucTickerTimerResponse);
                }
                catch (UcPeriodicException ucPeriodicException2) {}
            }
        }
        this.cleanerActive = true;
        this.scanFreq = l;
        this.maxAge = n;
    }

    public synchronized Object put(Object object, Object object2) {
        TStamp tStamp;
        TStamp tStamp2 = new TStamp(object2);
        if (this.timer != null && this.size() == 0 && this.cleanerActive) {
            this.timer.start();
        }
        if ((tStamp = super.put(object, tStamp2)) == null) {
            return null;
        }
        return tStamp.value;
    }

    public synchronized Object remove(Object object) {
        TStamp tStamp = (TStamp)super.remove(object);
        Object object2 = tStamp == null ? null : tStamp.value;
        if (this.timer != null && this.size() == 0) {
            this.timer.stop();
        }
        return object2;
    }

    public synchronized void startClean() {
        if (this.timer != null && this.size() > 0) {
            this.timer.start();
        }
        this.cleanerActive = true;
    }

    public synchronized void stopClean() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.cleanerActive = false;
    }

    private class TStamp {
        Object value;
        long timestamp;

        TStamp(Object object) {
            this.value = object;
            this.refresh();
        }

        void refresh() {
            this.timestamp = new Date().getTime();
        }
    }
}

