/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.discovery.console.presentation;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.console.discovery.SMDiscoveryData;
import com.sun.symon.base.console.discovery.SMDiscoveryRequest;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.tools.discovery.console.presentation.DiscoverGUIException;
import com.sun.symon.tools.discovery.console.presentation.DiscoverPanel;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;

public class DiscoverRequest {
    String requestId = null;
    String requestName = null;
    String domain = null;
    String view = null;
    String discoveryHost = null;
    String pingTimeout = "1";
    String snmpTimeout = "3";
    String pingRetries = "1";
    String snmpRetries = "1";
    String maxHosts = "256";
    String maxDiscoveryTime = "1000000";
    boolean useDefaultPort = true;
    String symonPort = "";
    String ports = "";
    boolean logging = true;
    boolean monitoring = false;
    String startingTime = "12:00";
    String schedule = "weekly";
    String dayOfWeek = "Saturday";
    String dayOfMonth = "1";
    String discoverTopologyMethod = "ping";
    String startIPAddress = DiscoverPanel.getTopologyAgentIpAddress();
    String endIPAddress = DiscoverPanel.getTopologyAgentIpAddress();
    String netmask = "255.255.255.0";
    String numberOfHops = "0";
    String discoverEntityMethod = "ping";
    String communityString = "public";
    String filter = null;
    String[] dayNamesOfWeek;
    String requestStatus = "";
    int numFilterCriteria = 0;
    int[] filterCriteria;
    String[][] includeItemArray = null;
    String[][] excludeItemArray = null;
    DiscoverPanel parent;

    public DiscoverRequest(DiscoverPanel discoverPanel, SMDiscoveryData sMDiscoveryData) {
        this.parent = discoverPanel;
        this.setDayNamesOfWeek();
        this.requestId = sMDiscoveryData.getdiscoveryRequestId();
        this.requestName = UcListUtil.AsciiToUnicode((String)sMDiscoveryData.getrequestDescription());
        this.domain = UcListUtil.AsciiToUnicode((String)sMDiscoveryData.getdomainName());
        this.view = sMDiscoveryData.getviewName();
        Properties properties = sMDiscoveryData.getalgoParameters();
        this.pingTimeout = properties.getProperty("pingtimeout");
        this.pingRetries = properties.getProperty("pingretries");
        this.snmpTimeout = properties.getProperty("snmptimeout");
        this.snmpRetries = properties.getProperty("snmpretries");
        this.maxHosts = String.valueOf(sMDiscoveryData.getmaxHosts());
        this.maxDiscoveryTime = String.valueOf(sMDiscoveryData.getmaxDiscoveryTime());
        this.logging = sMDiscoveryData.getlogResults();
        long l = sMDiscoveryData.getdiscoveryStartTime();
        Date date = new Date(l * 1000L);
        TimeZone timeZone = TimeZone.getDefault();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(7);
        int n2 = gregorianCalendar.get(5);
        int n3 = gregorianCalendar.get(11);
        int n4 = gregorianCalendar.get(12);
        this.startingTime = n4 < 10 ? String.valueOf(String.valueOf(n3)) + ":0" + String.valueOf(n4) : String.valueOf(String.valueOf(n3)) + ":" + String.valueOf(n4);
        this.dayOfWeek = this.dayNamesOfWeek[n - 1];
        this.dayOfMonth = String.valueOf(n2);
        this.schedule = sMDiscoveryData.getdiscoveryFrequency();
        this.discoverTopologyMethod = sMDiscoveryData.gettopologyDiscoveryAlgo();
        this.startIPAddress = sMDiscoveryData.getstartIpAddress();
        this.endIPAddress = sMDiscoveryData.getendIpAddress();
        this.netmask = sMDiscoveryData.getnetMask();
        this.numberOfHops = String.valueOf(sMDiscoveryData.getmaxHops());
        this.discoverEntityMethod = sMDiscoveryData.gethostDiscoveryAlgo();
        this.communityString = properties.getProperty("snmpcommunity");
        this.ports = properties.getProperty("snmpports");
        this.parsePorts();
        this.filter = sMDiscoveryData.getfilter();
        try {
            this.parseFilter(sMDiscoveryData.getfilter());
        }
        catch (DiscoverGUIException discoverGUIException) {
            this.numFilterCriteria = 0;
            discoverGUIException.print();
        }
        this.monitoring = sMDiscoveryData.getschedulingState();
    }

    public DiscoverRequest(DiscoverPanel discoverPanel, DiscoverRequest discoverRequest) {
        this.parent = discoverPanel;
        this.setDayNamesOfWeek();
        this.requestId = null;
        this.requestName = discoverRequest.requestName;
        this.view = discoverRequest.view;
        this.domain = discoverRequest.domain;
        this.requestStatus = discoverRequest.requestStatus;
        this.pingTimeout = discoverRequest.pingTimeout;
        this.pingRetries = discoverRequest.pingRetries;
        this.snmpTimeout = discoverRequest.snmpTimeout;
        this.snmpRetries = discoverRequest.snmpRetries;
        this.maxHosts = discoverRequest.maxHosts;
        this.maxDiscoveryTime = discoverRequest.maxDiscoveryTime;
        this.logging = discoverRequest.logging;
        this.monitoring = discoverRequest.monitoring;
        this.startingTime = discoverRequest.startingTime;
        this.dayOfWeek = discoverRequest.dayOfWeek;
        this.dayOfMonth = discoverRequest.dayOfMonth;
        this.schedule = discoverRequest.schedule;
        this.discoverTopologyMethod = discoverRequest.discoverTopologyMethod;
        this.startIPAddress = discoverRequest.startIPAddress;
        this.endIPAddress = discoverRequest.endIPAddress;
        this.netmask = discoverRequest.netmask;
        this.numberOfHops = discoverRequest.numberOfHops;
        this.discoverEntityMethod = discoverRequest.discoverEntityMethod;
        this.communityString = discoverRequest.communityString;
        this.ports = discoverRequest.ports;
        this.filter = discoverRequest.filter;
        if (discoverRequest.numFilterCriteria != 0) {
            this.numFilterCriteria = discoverRequest.numFilterCriteria;
            this.filterCriteria = new int[this.numFilterCriteria];
            this.includeItemArray = new String[this.numFilterCriteria][];
            this.excludeItemArray = new String[this.numFilterCriteria][];
            int n = 0;
            while (n < this.numFilterCriteria) {
                int n2;
                this.filterCriteria[n] = discoverRequest.filterCriteria[n];
                if (discoverRequest.includeItemArray[n] != null) {
                    this.includeItemArray[n] = new String[discoverRequest.includeItemArray[n].length];
                    n2 = 0;
                    while (n2 < discoverRequest.includeItemArray[n].length) {
                        this.includeItemArray[n][n2] = discoverRequest.includeItemArray[n][n2];
                        ++n2;
                    }
                }
                if (discoverRequest.excludeItemArray[n] != null) {
                    this.excludeItemArray[n] = new String[discoverRequest.excludeItemArray[n].length];
                    n2 = 0;
                    while (n2 < discoverRequest.excludeItemArray[n].length) {
                        this.excludeItemArray[n][n2] = discoverRequest.excludeItemArray[n][n2];
                        ++n2;
                    }
                }
                ++n;
            }
        }
        this.useDefaultPort = discoverRequest.useDefaultPort;
        this.symonPort = discoverRequest.symonPort;
    }

    public DiscoverRequest(DiscoverPanel discoverPanel, String string) {
        this.parent = discoverPanel;
        this.setDayNamesOfWeek();
        this.domain = string;
        this.requestName = this.parent.getI18NString("NoName");
        this.createPorts();
    }

    long convertStartingTime() {
        long l = 0L;
        TimeZone timeZone = TimeZone.getDefault();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        Date date = new Date();
        l = date.getTime() / 1000L;
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(7);
        int n2 = gregorianCalendar.get(5);
        int n3 = gregorianCalendar.get(11);
        int n4 = gregorianCalendar.get(12);
        int n5 = 0;
        int n6 = 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        n9 = this.startingTime.indexOf(58);
        n7 = n9 == -1 ? 0 : Integer.valueOf(this.startingTime.substring(0, n9));
        n8 = Integer.valueOf(this.startingTime.substring(n9 + 1));
        if (this.schedule.equals("weekly")) {
            int n10 = 0;
            while (n10 < this.dayNamesOfWeek.length) {
                if (this.dayNamesOfWeek[n10].equals(this.dayOfWeek)) {
                    n5 = n10 + 1;
                }
                ++n10;
            }
            long l2 = ((n5 - n) * 24 + (n7 - n3)) * 60 + (n8 - n4);
            l = l2 < 0L ? (l += (l2 + 10080L) * 60L) : (l += l2 * 60L);
        } else if (this.schedule.equals("monthly")) {
            n6 = Integer.valueOf(this.dayOfMonth);
            long l3 = ((n6 - n2) * 24 + (n7 - n3)) * 60 + (n8 - n4);
            if (l3 < 0L) {
                int n11 = gregorianCalendar.get(2);
                int n12 = gregorianCalendar.get(1);
                GregorianCalendar gregorianCalendar2 = new GregorianCalendar(n12, n11 + 1, n6, n7, n8, 0);
                Date date2 = gregorianCalendar2.getTime();
                l = date2.getTime() / 1000L;
            } else {
                l += l3 * 60L;
            }
        } else {
            long l4;
            long l5;
            l = this.schedule.equals("daily") ? ((l5 = (long)((n7 - n3) * 60 + (n8 - n4))) < 0L ? (l += (l5 + 1440L) * 60L) : (l += l5 * 60L)) : ((l4 = (long)((n7 - n3) * 60 + (n8 - n4))) < 0L ? (l += 60L) : (l += l4 * 60L));
        }
        return l;
    }

    public String createFilter() {
        String string = new String();
        String string2 = null;
        boolean bl = false;
        int n = 0;
        while (n < this.numFilterCriteria) {
            String string3;
            int n2;
            String string4;
            if (this.filterCriteria[n] == 1) {
                string2 = "OS";
            } else if (this.filterCriteria[n] == 0) {
                string2 = "NAME";
            } else if (this.filterCriteria[n] == 2) {
                string2 = "ARCH";
            }
            if (this.includeItemArray[n] != null && this.includeItemArray[n].length > 0) {
                if (bl) {
                    string = String.valueOf(string) + " AND ";
                }
                string4 = " +" + string2 + "=" + this.includeItemArray[n][0];
                n2 = 1;
                while (n2 < this.includeItemArray[n].length) {
                    string3 = " OR +" + string2 + "=" + this.includeItemArray[n][n2];
                    string4 = String.valueOf(string4) + string3;
                    ++n2;
                }
                string = String.valueOf(string) + string4;
                bl = true;
            } else if (this.excludeItemArray[n] != null && this.excludeItemArray[n].length > 0) {
                if (bl) {
                    string = String.valueOf(string) + " AND ";
                }
                string4 = " -" + string2 + "=" + this.excludeItemArray[n][0];
                n2 = 1;
                while (n2 < this.excludeItemArray[n].length) {
                    string3 = " AND -" + string2 + "=" + this.excludeItemArray[n][n2];
                    string4 = String.valueOf(string4) + string3;
                    ++n2;
                }
                string = String.valueOf(string) + string4;
                bl = true;
            } else {
                bl = false;
            }
            ++n;
        }
        return string;
    }

    public boolean createInDatabase(SMDiscoveryRequest sMDiscoveryRequest, boolean bl) throws DiscoverGUIException {
        if (this.requestId != null) {
            return false;
        }
        long l = this.convertStartingTime();
        this.createPorts();
        Properties properties = new Properties();
        ((Hashtable)properties).put("pingtimeout", this.pingTimeout);
        ((Hashtable)properties).put("pingretries", this.pingRetries);
        ((Hashtable)properties).put("snmptimeout", this.snmpTimeout);
        ((Hashtable)properties).put("snmpretries", this.snmpRetries);
        ((Hashtable)properties).put("snmpcommunity", this.communityString);
        ((Hashtable)properties).put("snmpports", this.ports);
        try {
            SMDiscoveryData sMDiscoveryData = new SMDiscoveryData(this.requestId, this.discoveryHost, UcListUtil.UnicodeToAscii((String)this.requestName), UcListUtil.UnicodeToAscii((String)this.domain), this.view, this.startIPAddress, this.endIPAddress, Integer.valueOf(this.numberOfHops), this.netmask, Integer.valueOf(this.maxHosts), Long.valueOf(this.maxDiscoveryTime), l, this.schedule, this.monitoring, bl, this.logging, this.createFilter(), this.discoverTopologyMethod, this.discoverEntityMethod, properties);
            sMDiscoveryRequest.createRequest(sMDiscoveryData);
        }
        catch (SMAPIException sMAPIException) {
            throw new DiscoverGUIException("SMAPI Exception in craeteRequest");
        }
        return true;
    }

    public void createPorts() {
        if (!this.symonPort.equals("")) {
            this.ports = this.symonPort;
            if (this.useDefaultPort) {
                this.ports = String.valueOf(this.ports) + "|161";
            }
        } else if (this.useDefaultPort) {
            this.ports = "161";
        }
    }

    public String getCommunityString() {
        return this.communityString;
    }

    public String[] getDayNamesOfWeek() {
        return this.dayNamesOfWeek;
    }

    public String getDayOfMonth() {
        return this.dayOfMonth;
    }

    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public String getDiscoverEntityMethod() {
        return this.discoverEntityMethod;
    }

    public String getDiscoverTopologyMethod() {
        return this.discoverTopologyMethod;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getEndIPAddress() {
        return this.endIPAddress;
    }

    public String[] getExcludeItemValue(int n) {
        return this.excludeItemArray[n];
    }

    public int getFilterCriteria(int n) {
        return this.filterCriteria[n];
    }

    public String getId() {
        return this.requestId;
    }

    public String[] getIncludeItemValue(int n) {
        return this.includeItemArray[n];
    }

    public boolean getLogging() {
        return this.logging;
    }

    public String getMaxDiscoveryTime() {
        return this.maxDiscoveryTime;
    }

    public String getMaxHosts() {
        return this.maxHosts;
    }

    public boolean getMonitoring() {
        return this.monitoring;
    }

    public String getName() {
        return this.requestName;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public int getNumFilterCriteria() {
        return this.numFilterCriteria;
    }

    public String getNumberOfHops() {
        return this.numberOfHops;
    }

    public String getPingRetries() {
        return this.pingRetries;
    }

    public String getPingTimeout() {
        return this.pingTimeout;
    }

    public String getPorts() {
        return this.ports;
    }

    public String getPropertyValue(String string) {
        this.createPorts();
        if (string.equals("RequestId")) {
            return this.requestId;
        }
        if (string.equals("Name")) {
            return this.requestName;
        }
        if (string.equals("Logging")) {
            if (this.logging) {
                return "Enabled";
            }
            return "Disabled";
        }
        if (string.equals("Frequency")) {
            return this.schedule;
        }
        if (string.equals("DayOfWeek")) {
            return this.dayOfWeek;
        }
        if (string.equals("DayOfMonth")) {
            return this.dayOfMonth;
        }
        if (string.equals("Time")) {
            return this.startingTime;
        }
        if (string.equals("Scheduled")) {
            if (this.monitoring) {
                return "Yes";
            }
            return "No";
        }
        if (string.equals("Status")) {
            return this.requestStatus;
        }
        if (string.equals("PingTimeout")) {
            return this.pingTimeout;
        }
        if (string.equals("PingRetries")) {
            return this.pingRetries;
        }
        if (string.equals("SnmpTimeout")) {
            return this.snmpTimeout;
        }
        if (string.equals("SnmpRetries")) {
            return this.snmpRetries;
        }
        if (string.equals("MaxHosts")) {
            return this.maxHosts;
        }
        if (string.equals("MaxDiscoveryTime")) {
            return this.maxDiscoveryTime;
        }
        if (string.equals("DiscoverTopologyMethod")) {
            return this.discoverTopologyMethod;
        }
        if (string.equals("StartIPAddress")) {
            return this.startIPAddress;
        }
        if (string.equals("EndIPAddress")) {
            return this.endIPAddress;
        }
        if (string.equals("Netmask")) {
            return this.netmask;
        }
        if (string.equals("NumberOfHops")) {
            return this.numberOfHops;
        }
        if (string.equals("CommunityString")) {
            return this.communityString;
        }
        if (string.equals("Ports")) {
            return this.ports;
        }
        if (string.equals("FilterCriteria")) {
            return this.filter;
        }
        return "Property name not found";
    }

    public String getRequestStatus() {
        return this.requestStatus;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public String getSnmpRetries() {
        return this.snmpRetries;
    }

    public String getSnmpTimeout() {
        return this.snmpTimeout;
    }

    public String getStartIPAddress() {
        return this.startIPAddress;
    }

    public String getStartingTime() {
        return this.startingTime;
    }

    public String getSymonPort() {
        return this.symonPort;
    }

    public boolean getUseDefaultPort() {
        return this.useDefaultPort;
    }

    public String getView() {
        return this.view;
    }

    public void parseFilter(String string) throws DiscoverGUIException {
        int n;
        int n2;
        char c;
        Vector[] vectorArray = new Vector[3];
        Vector[] vectorArray2 = new Vector[3];
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        int n4 = -1;
        boolean bl = false;
        int n5 = 120;
        int n6 = 0;
        while (n6 < string.length()) {
            c = string.charAt(n6);
            if (bl) {
                if (c == '\"' && n5 != 92) {
                    bl = false;
                }
            } else if (c == '\"') {
                bl = true;
            } else {
                String string2 = string.substring(n6);
                if (string2.startsWith(" OR ")) {
                    n4 = n6;
                    vector.addElement(string.substring(n3, n4));
                    n3 = n6 += 4;
                } else if (string2.startsWith(" AND ")) {
                    n4 = n6;
                    vector.addElement(string.substring(n3, n4));
                    n3 = n6 += 5;
                }
            }
            ++n6;
        }
        vector.addElement(string.substring(n3));
        this.numFilterCriteria = 0;
        this.filterCriteria = new int[3];
        c = '\u0001';
        int n7 = 0;
        while (n7 < vector.size()) {
            n2 = -1;
            n = -1;
            String string3 = (String)vector.elementAt(n7);
            int n8 = 0;
            while (n8 < string3.length()) {
                char c2 = string3.charAt(n8);
                if (c2 != ' ' && c2 != '\t') {
                    if (c2 == '-') {
                        c = '\u0000';
                        ++n8;
                    } else if (c2 == '+') {
                        c = '\u0001';
                        ++n8;
                    } else {
                        c = '\u0001';
                    }
                    String string4 = string3.substring(n8);
                    if (string4.startsWith("OS")) {
                        n2 = 1;
                    } else if (string4.startsWith("NAME")) {
                        n2 = 0;
                    } else if (string4.startsWith("ARCH")) {
                        n2 = 2;
                    } else {
                        System.out.println("Invalid filter");
                        System.out.println(string4);
                    }
                    int n9 = 0;
                    while (n9 < this.numFilterCriteria) {
                        if (n2 == this.filterCriteria[n9]) {
                            n = n9;
                            break;
                        }
                        ++n9;
                    }
                    if (n < 0) {
                        this.filterCriteria[this.numFilterCriteria] = n2;
                        n = this.numFilterCriteria++;
                        vectorArray[n] = new Vector();
                        vectorArray2[n] = new Vector();
                    }
                    while (string3.charAt(n8) != '=') {
                        ++n8;
                    }
                    String string5 = string3.substring(n8 + 1);
                    if (c == '\u0001') {
                        vectorArray[n].addElement(string5);
                        break;
                    }
                    vectorArray2[n].addElement(string5);
                    break;
                }
                ++n8;
            }
            ++n7;
        }
        if (this.numFilterCriteria > 0) {
            this.includeItemArray = new String[this.numFilterCriteria][];
            this.excludeItemArray = new String[this.numFilterCriteria][];
            n2 = 0;
            while (n2 < this.numFilterCriteria) {
                if (vectorArray[n2].size() > 0) {
                    this.includeItemArray[n2] = new String[vectorArray[n2].size()];
                    n = 0;
                    while (n < vectorArray[n2].size()) {
                        this.includeItemArray[n2][n] = (String)vectorArray[n2].elementAt(n);
                        ++n;
                    }
                }
                if (vectorArray2[n2].size() > 0) {
                    this.excludeItemArray[n2] = new String[vectorArray2[n2].size()];
                    n = 0;
                    while (n < vectorArray2[n2].size()) {
                        this.excludeItemArray[n2][n] = (String)vectorArray2[n2].elementAt(n);
                        ++n;
                    }
                }
                ++n2;
            }
        }
    }

    public void parsePorts() {
        if (this.ports != null) {
            int n = this.ports.indexOf(124);
            if (n == -1) {
                if (this.ports.equals("161")) {
                    this.symonPort = "";
                    this.useDefaultPort = true;
                } else {
                    this.symonPort = this.ports;
                    this.useDefaultPort = false;
                }
            } else {
                int n2 = this.ports.indexOf(124);
                this.symonPort = this.ports.substring(0, n2);
                this.useDefaultPort = true;
            }
        } else {
            this.useDefaultPort = true;
            this.symonPort = "";
        }
    }

    public void setCommunityString(String string) {
        this.communityString = string;
    }

    public void setDayNamesOfWeek() {
        this.dayNamesOfWeek = new String[7];
        this.dayNamesOfWeek[0] = "Sunday";
        this.dayNamesOfWeek[1] = "Monday";
        this.dayNamesOfWeek[2] = "Tuesday";
        this.dayNamesOfWeek[3] = "Wednesday";
        this.dayNamesOfWeek[4] = "Thursday";
        this.dayNamesOfWeek[5] = "Friday";
        this.dayNamesOfWeek[6] = "Saturday";
    }

    public void setDayOfMonth(String string) {
        this.dayOfMonth = string;
    }

    public void setDayOfWeek(String string) {
        this.dayOfWeek = string;
    }

    public void setDiscoverEntityMethod(String string) {
        this.discoverEntityMethod = string;
    }

    public void setDiscoverTopologyMethod(String string) {
        this.discoverTopologyMethod = string;
    }

    public void setDiscoveryHostIPAddress(String string) {
        this.discoveryHost = string;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public void setEndIPAddress(String string) {
        this.endIPAddress = string;
    }

    public void setExcludeItemValue(int n, String[] stringArray) {
        this.excludeItemArray[n] = stringArray;
    }

    public void setFilterCriteria(int n, int n2) {
        this.filterCriteria[n] = n2;
    }

    public void setId(String string) {
        this.requestId = string;
    }

    public void setIncludeItemValue(int n, String[] stringArray) {
        this.includeItemArray[n] = stringArray;
    }

    public void setLogging(boolean bl) {
        this.logging = bl;
    }

    public void setMaxDiscoveryTime(String string) {
        this.maxDiscoveryTime = string;
    }

    public void setMaxHosts(String string) {
        this.maxHosts = string;
    }

    public void setMonitoring(boolean bl) {
        this.monitoring = bl;
    }

    public void setName(String string) {
        this.requestName = string;
    }

    public void setNetmask(String string) {
        this.netmask = string;
    }

    public void setNumFilterCriteria(int n) {
        this.numFilterCriteria = n;
        this.filterCriteria = new int[this.numFilterCriteria];
        this.includeItemArray = new String[this.numFilterCriteria][];
        this.excludeItemArray = new String[this.numFilterCriteria][];
    }

    public void setNumberOfHops(String string) {
        this.numberOfHops = string;
    }

    public void setPingRetries(String string) {
        this.pingRetries = string;
    }

    public void setPingTimeout(String string) {
        this.pingTimeout = string;
    }

    public void setRequestStatus(String string) {
        this.requestStatus = string;
    }

    public void setSchedule(String string) {
        this.schedule = string;
    }

    public void setSnmpRetries(String string) {
        this.snmpRetries = string;
    }

    public void setSnmpTimeout(String string) {
        this.snmpTimeout = string;
    }

    public void setStartIPAddress(String string) {
        this.startIPAddress = string;
    }

    public void setStartingTime(String string) {
        this.startingTime = string;
    }

    public void setSymonPort(String string) {
        this.symonPort = string;
    }

    public void setUseDefaultPort(boolean bl) {
        this.useDefaultPort = bl;
    }

    public void setView(String string) {
        this.view = string;
    }

    public boolean updateInDatabase(SMDiscoveryRequest sMDiscoveryRequest, boolean bl) throws DiscoverGUIException {
        long l = this.convertStartingTime();
        this.createPorts();
        Properties properties = new Properties();
        ((Hashtable)properties).put("pingtimeout", this.pingTimeout);
        ((Hashtable)properties).put("pingretries", this.pingRetries);
        ((Hashtable)properties).put("snmptimeout", this.snmpTimeout);
        ((Hashtable)properties).put("snmpretries", this.snmpRetries);
        ((Hashtable)properties).put("snmpcommunity", this.communityString);
        ((Hashtable)properties).put("snmpports", this.ports);
        try {
            SMDiscoveryData sMDiscoveryData = new SMDiscoveryData(this.requestId, this.discoveryHost, UcListUtil.UnicodeToAscii((String)this.requestName), UcListUtil.UnicodeToAscii((String)this.domain), this.view, this.startIPAddress, this.endIPAddress, Integer.valueOf(this.numberOfHops), this.netmask, Integer.valueOf(this.maxHosts), Long.valueOf(this.maxDiscoveryTime), l, this.schedule, this.monitoring, bl, this.logging, this.createFilter(), this.discoverTopologyMethod, this.discoverEntityMethod, properties);
            sMDiscoveryRequest.updateRequest(sMDiscoveryData);
        }
        catch (SMAPIException sMAPIException) {
            throw new DiscoverGUIException("SMAPI Exception in craeteRequest");
        }
        return true;
    }
}

