/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.topology.SMFamilyStatusIcon;
import com.sun.symon.base.console.views.CvToolTip;
import com.sun.symon.base.console.views.table.CvTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JToolTip;

public class CvTblCell
extends JLabel
implements Icon {
    public static final int BORDER_WIDTH = 2;
    private static final int ICON_TEXT_GAP_RIGHT = 0;
    private static final int ICON_TEXT_GAP_LEFT = 10;
    private Font alarmFont = CvTable.DEFAULT_ALARM_FONT;
    private Font headerFont = CvTable.DEFAULT_HEADER_FONT;
    private Font normalFont = CvTable.DEFAULT_NORMAL_FONT;
    private SMAlarmStatusData alarmStatus = null;
    private String dataValue = "";
    private String alarmMode = "background";
    private boolean fieldIsColumnHeader = false;
    private String columnHeading = "";

    public CvTblCell() {
        this.setupCell(false, "", null);
    }

    public CvTblCell(boolean bl) {
        this.setupCell(bl, "", null);
    }

    public CvTblCell(boolean bl, SMAlarmStatusData sMAlarmStatusData) {
        this.setupCell(bl, "", sMAlarmStatusData);
    }

    public CvTblCell(boolean bl, String string) {
        this.setupCell(bl, string, null);
    }

    public CvTblCell(boolean bl, String string, SMAlarmStatusData sMAlarmStatusData) {
        this.setupCell(bl, string, sMAlarmStatusData);
    }

    private void configureCell() {
        if (this.fieldIsColumnHeader) {
            this.setFont(this.normalFont);
            this.setToolTipText(this.dataValue);
        } else {
            if (this.alarmStatus != null) {
                this.setToolTipText(this.alarmStatus.getStatusInToolTip("\n"));
            } else if (this.columnHeading.length() > 0) {
                this.setToolTipText(String.valueOf(this.columnHeading) + ": " + this.dataValue);
            } else {
                this.setToolTipText(this.dataValue);
            }
            if (this.alarmStatus != null && this.alarmStatus.getStatusColor() != null) {
                this.setFont(this.alarmFont);
                if (this.alarmMode.equals("background")) {
                    this.setBackground(this.alarmStatus.getStatusColor());
                } else if (this.getParent() != null) {
                    this.setBackground(this.getParent().getBackground());
                }
            } else {
                this.setFont(this.normalFont);
                if (this.getParent() != null) {
                    this.setBackground(this.getParent().getBackground());
                }
            }
        }
        Color color = this.getBackground();
        double d = 0.63 * (double)color.getRed() / 255.0 + 0.15 * (double)color.getBlue() / 255.0 + 0.22 * (double)color.getGreen() / 255.0;
        Color color2 = Color.black;
        if (d < 0.25) {
            color2 = Color.white;
        }
        this.setForeground(color2);
    }

    public JToolTip createToolTip() {
        return new CvToolTip();
    }

    public Font getAlarmFont() {
        return this.alarmFont;
    }

    public String getAlarmMode() {
        return this.alarmMode;
    }

    public SMAlarmStatusData getAlarmStatus() {
        return this.alarmStatus;
    }

    public String getColumnHeading() {
        return this.columnHeading;
    }

    public String getDataValue() {
        return this.dataValue;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public int getIconHeight() {
        return this.getSize().height;
    }

    public int getIconWidth() {
        return this.getIconHeight();
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3;
        if (this.alarmMode.equals("background")) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
        if (this.alarmStatus == null) {
            return;
        }
        Color color = this.alarmStatus.getStatusColor();
        if (color == null) {
            return;
        }
        int n4 = this.getIconWidth();
        int n5 = n4 > (n3 = this.getIconHeight()) ? n3 / 4 : n4 / 4;
        SMFamilyStatusIcon.drawLED((Graphics)graphics, (int)(n + n4 / 2), (int)(n2 + n3 / 2), (int)n5, (Color)color);
    }

    public void setAlarmFont(Font font) {
        this.alarmFont = font != null ? font : CvTable.DEFAULT_ALARM_FONT;
    }

    public void setAlarmMode(String string) {
        if (this.fieldIsColumnHeader) {
            this.alarmMode = "background";
            this.setIcon(null);
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setHorizontalTextPosition(4);
            this.setIconTextGap(0);
        } else if (string.equals("dot_left")) {
            this.alarmMode = string;
            this.setIcon(this);
            this.setIconTextGap(10);
            this.setOpaque(false);
            this.setHorizontalAlignment(4);
            this.setHorizontalTextPosition(4);
        } else if (string.equals("dot_right")) {
            this.alarmMode = string;
            this.setIcon(this);
            this.setIconTextGap(0);
            this.setOpaque(false);
            this.setHorizontalAlignment(4);
            this.setHorizontalTextPosition(2);
        } else if (string == "background") {
            this.alarmMode = string;
            this.setIcon(null);
            this.setIconTextGap(0);
            this.setOpaque(true);
            this.setHorizontalAlignment(4);
            this.setHorizontalTextPosition(4);
        }
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.configureCell();
    }

    public void setAlarmStatus(SMAlarmStatusData sMAlarmStatusData) {
        this.alarmStatus = sMAlarmStatusData;
        this.configureCell();
    }

    public void setColumnHeading(String string) {
        this.columnHeading = string != null ? string : "";
        this.configureCell();
    }

    public void setDataValue(String string) {
        this.dataValue = string != null ? string : "";
        this.setText(this.dataValue);
        this.configureCell();
    }

    public void setHeaderFont(Font font) {
        this.headerFont = font != null ? font : CvTable.DEFAULT_HEADER_FONT;
    }

    public void setNormalFont(Font font) {
        this.normalFont = font != null ? font : CvTable.DEFAULT_NORMAL_FONT;
    }

    private void setupCell(boolean bl, String string, SMAlarmStatusData sMAlarmStatusData) {
        this.fieldIsColumnHeader = bl;
        this.setDataValue(string);
        this.setAlarmStatus(sMAlarmStatusData);
        this.setAlarmMode(this.alarmMode);
        this.configureCell();
    }
}

