/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.objectstatus;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.alarm.SMAlarmStatusRequest;
import com.sun.symon.base.client.alarm.SMAlarmStatusResponse;
import com.sun.symon.base.client.topology.SMFamilyImages;
import com.sun.symon.base.client.topology.SMHierarchyResponse;
import com.sun.symon.base.client.topology.SMHierarchyViewData;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.console.views.CvContextPopupListener;
import com.sun.symon.base.console.views.CvNavigationListener;
import com.sun.symon.base.console.views.CvPresentationView;
import com.sun.symon.base.console.views.CvToolTip;
import com.sun.symon.base.console.views.objectstatus.CvObjectStatusData;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;

public class CvObjectStatusView
extends JLabel
implements MouseMotionListener,
SMHierarchyResponse,
CvPresentationView,
SMAlarmStatusResponse {
    private SMRawDataRequest rawDataSource = null;
    private SMTopologyRequest topDataSource = null;
    private SMAlarmStatusRequest alarmDataSource = null;
    private Object topDataReqHandle = null;
    private boolean showIcon = true;
    private boolean isFromTopology = false;
    private String managedUrl = null;
    private Font labelFont = new Font("SansSerif", 0, 12);
    private Color objectColor = null;
    private String refreshPeriod = "120";
    private CvObjectStatusData objectData = null;
    private SMAlarmStatusData objectStatus = null;
    private Icon icon = null;
    private Rectangle iconRect = null;
    private Insets margin = null;

    public CvObjectStatusView() {
        this.setText(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.readobject"));
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void activateBean() {
        try {
            this.topDataReqHandle = this.isFromTopology ? this.topDataSource.getHierarchyRootRequestFromTopology(this.managedUrl, "60", (SMHierarchyResponse)this, null) : this.topDataSource.getHierarchyRootRequest(this.managedUrl, "60", false, (SMHierarchyResponse)this, null);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)("CvObjectStatusView.activateBean() - Failed to request data: " + (Object)((Object)sMAPIException)));
            if (this.isFromTopology) {
                this.setText(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.deadtopo"));
            } else {
                this.setText(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.deadobject"));
            }
            return;
        }
    }

    public void addCvContextPopupListener(CvContextPopupListener cvContextPopupListener) {
    }

    public void addCvNavigationListener(CvNavigationListener cvNavigationListener) {
    }

    public JToolTip createToolTip() {
        return new CvToolTip();
    }

    public void getAlarmStatusListResponse(SMRequestStatus sMRequestStatus, SMAlarmStatusData[] sMAlarmStatusDataArray, Object object) {
    }

    public void getHierarchyChildResponse(SMRequestStatus sMRequestStatus, SMHierarchyViewData[] sMHierarchyViewDataArray, Object object) {
    }

    public void getHierarchyRootResponse(SMRequestStatus sMRequestStatus, SMHierarchyViewData sMHierarchyViewData, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            UcDDL.logErrorMessage((String)"Error retrieving object details");
            return;
        }
        try {
            this.rawDataSource.removeURLRequest(this.topDataReqHandle);
        }
        catch (SMAPIException sMAPIException) {}
        this.objectData = new CvObjectStatusData(sMHierarchyViewData);
        this.setText(this.objectData.getName());
        this.addMouseMotionListener(this);
        this.updateIcon();
        try {
            Object object2 = this.isFromTopology ? this.topDataSource.getEntityStatusFromTopology(this.managedUrl, this.refreshPeriod, (SMAlarmStatusResponse)this, null) : this.alarmDataSource.getTopAlarmStatusRequest(sMHierarchyViewData.getNavigationUrl(), this.refreshPeriod, (SMAlarmStatusResponse)this, null);
            this.objectData.setTopStatusReqHandle(object2);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)("CvObjectStatusView.receiveDataResult() - Failed to request top status: " + (Object)((Object)sMAPIException)));
            this.objectStatus = SMAlarmStatusData.buildIrrationalData((String)"");
        }
        if (this.objectColor != null) {
            this.setBackground(this.objectColor);
        }
        if (this.labelFont != null) {
            this.setFont(this.labelFont);
        }
    }

    public void getTopAlarmStatusResponse(SMRequestStatus sMRequestStatus, SMAlarmStatusData sMAlarmStatusData, Object object) {
        if (sMRequestStatus.getReturnCode() != 0) {
            UcDDL.logErrorMessage((String)"Error retrieving root status");
            this.objectStatus = SMAlarmStatusData.buildIrrationalData((String)"");
        } else {
            this.objectStatus = sMAlarmStatusData;
        }
        this.updateIcon();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.objectData == null || !this.isEnabled() || !this.showIcon) {
            this.setToolTipText(null);
            return;
        }
        if (this.objectStatus != null) {
            String string = "\n";
            this.setToolTipText(this.objectStatus.getStatusInToolTip(string));
        } else {
            this.setToolTipText(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.awaitstat"));
        }
    }

    public void removeCvContextPopupListener(CvContextPopupListener cvContextPopupListener) {
    }

    public void removeCvNavigationListener(CvNavigationListener cvNavigationListener) {
    }

    public void setBackground(Color color) {
        if (color != null) {
            this.objectColor = color;
            super.setBackground(color);
        }
    }

    public void setDataSource(SMRawDataRequest sMRawDataRequest) {
        this.rawDataSource = sMRawDataRequest;
        this.topDataSource = new SMTopologyRequest(sMRawDataRequest);
        this.alarmDataSource = new SMAlarmStatusRequest(sMRawDataRequest);
    }

    public void setFont(Font font) {
        if (font != null) {
            this.labelFont = font;
            super.setFont(font);
        }
    }

    public void setManagedObjectUrl(String string) {
        this.managedUrl = string;
    }

    public void setShowIcon(boolean bl) {
        this.showIcon = bl;
    }

    public void setStdRefreshPeriod(String string) {
        if (string != null) {
            this.refreshPeriod = string;
        }
    }

    public void setTopologyIndicator(boolean bl) {
        this.isFromTopology = bl;
    }

    public void shutdown() {
        block6: {
            if (this.topDataReqHandle != null) {
                try {
                    this.rawDataSource.removeURLRequest(this.topDataReqHandle);
                }
                catch (SMAPIException sMAPIException) {}
            }
            if (this.objectData == null) {
                return;
            }
            Object object = this.objectData.getTopStatusReqHandle();
            if (object == null) break block6;
            try {
                this.rawDataSource.removeURLRequest(object);
            }
            catch (SMAPIException sMAPIException) {}
        }
    }

    protected void updateIcon() {
        SMFamilyImages sMFamilyImages = this.objectData.getFamilyImages();
        this.icon = this.objectStatus == null ? sMFamilyImages.getIcon(null, false) : sMFamilyImages.getIcon(this.objectStatus.getState(), false);
        if (this.showIcon) {
            this.setIcon(this.icon);
        }
        this.iconRect = new Rectangle(this.icon.getIconWidth(), this.icon.getIconHeight());
        this.repaint();
    }
}

