/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.console.tools.editor.CtEditorListPanel;
import com.sun.symon.base.console.tools.editor.CtFocusChangeEvent;
import com.sun.symon.base.console.tools.editor.CtFocusChangeListener;
import com.sun.symon.base.console.tools.editor.CtFocusTraversable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;

public class CtScrollPanel
extends JScrollPane
implements CtFocusChangeListener {
    JComponent comp;
    Dimension lastSize;
    Dimension scrollAreaSize;
    JScrollBar vbar;
    JScrollBar hbar;

    public CtScrollPanel() {
        this.setBorder(new LineBorder(this.getBackground(), 4));
    }

    public CtScrollPanel(JComponent jComponent) {
        super(jComponent);
        this.setBorder(new LineBorder(new Color(204, 204, 204), 4));
        this.comp = jComponent;
        JComponent[] jComponentArray = ((CtEditorListPanel)jComponent).getAllComponents();
        if (jComponentArray != null && jComponentArray.length != 0 && jComponentArray[0] != null) {
            int n = 0;
            while (n < jComponentArray.length) {
                JComponent jComponent2 = jComponentArray[n];
                if (jComponent2 instanceof CtFocusTraversable) {
                    ((CtFocusTraversable)((Object)jComponent2)).addCtFocusChangeListener(this);
                }
                ++n;
            }
        }
        this.scrollAreaSize = this.getCompSize();
        this.lastSize = this.getCompSize();
        this.vbar = this.getVerticalScrollBar();
        this.hbar = this.getHorizontalScrollBar();
        this.hbar.setUnitIncrement(10);
        this.hbar.setBlockIncrement(10);
        this.vbar.setUnitIncrement(10);
        this.vbar.setBlockIncrement(10);
    }

    public void attributeFocusChanged(CtFocusChangeEvent ctFocusChangeEvent) {
        JComponent jComponent = (JComponent)ctFocusChangeEvent.getSource();
        Point point = jComponent.getLocation();
        Dimension dimension = jComponent.getSize();
        JViewport jViewport = this.getViewport();
        int n = point.y;
        int n2 = dimension.height + n;
        int n3 = this.vbar.getValue();
        Dimension dimension2 = jViewport.getSize();
        this.scrollAreaSize = this.getCompSize();
        int n4 = this.scrollAreaSize.width;
        int n5 = dimension2.width;
        int n6 = dimension2.height;
        int n7 = this.scrollAreaSize.height;
        if (this.vbar.isVisible()) {
            if (n3 + n6 < n2) {
                Rectangle rectangle = new Rectangle(0, n2 - n6, dimension2.width, n6);
                jViewport.scrollRectToVisible(rectangle);
                n3 = n2 - n6;
                this.vbar.setValues(n3, n6, 0, n7);
            } else if (n3 > n) {
                Rectangle rectangle = new Rectangle(0, point.y, dimension2.width, n6);
                jViewport.scrollRectToVisible(rectangle);
                n3 = n;
                this.vbar.setValues(n3, n6, 0, n7);
            }
        }
        this.lastSize = this.scrollAreaSize;
        this.repaint();
    }

    Dimension getCompSize() {
        return this.comp.getSize();
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public JComponent getScrollComponent() {
        return this.comp;
    }
}

