/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.alarms;

import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.console.alarms.AlarmData;
import com.sun.symon.base.console.alarms.AlarmList;
import com.sun.symon.base.console.alarms.AlarmPanel;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class AlarmTableModel
extends AbstractTableModel {
    static final int SEVERITY_IMAGE_COUNT = 10;
    static final int STATE_IMAGE_COUNT = 2;
    static final int OPEN = 0;
    static final int CLOSED = 1;
    static final int SEVERITY1 = 0;
    static final int SEVERITY1_ACK = 1;
    static final int SEVERITY2 = 2;
    static final int SEVERITY2_ACK = 3;
    static final int SEVERITY3 = 4;
    static final int SEVERITY3_ACK = 5;
    static final int SEVERITY4 = 6;
    static final int SEVERITY4_ACK = 7;
    static final int SEVERITY5 = 8;
    static final int SEVERITY5_ACK = 9;
    static final String[] hostColumnNames = new String[]{"severity", "startTime", "state", "message"};
    static final String[] domainColumnNames = new String[]{"severity", "startTime", "state", "hostName", "message"};
    static final int SEVERITY = 0;
    static final int START = 1;
    static final int STATE = 2;
    static final int HOST = 3;
    static final int MESSAGE = 4;
    static ImageIcon ackImage;
    static ImageIcon[] sevImage;
    static ImageIcon[] stateImage;
    private AlarmList alarmList = new AlarmList();
    private AlarmPanel alarmPanel;
    private boolean domain = false;
    private String[] columnNames = hostColumnNames;

    static {
        sevImage = new ImageIcon[10];
        stateImage = new ImageIcon[2];
    }

    public AlarmTableModel(AlarmPanel alarmPanel) {
        this.alarmPanel = alarmPanel;
        SMResourceAccess sMResourceAccess = new SMResourceAccess(this.alarmPanel.getRawRequestHandle());
        AlarmTableModel.sevImage[0] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmSev1.gif"));
        AlarmTableModel.sevImage[1] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmSev1Ack.gif"));
        AlarmTableModel.sevImage[2] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmSev2.gif"));
        AlarmTableModel.sevImage[3] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmSev2Ack.gif"));
        AlarmTableModel.sevImage[4] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmSev3.gif"));
        AlarmTableModel.sevImage[5] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmSev3Ack.gif"));
        AlarmTableModel.sevImage[6] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmSev4.gif"));
        AlarmTableModel.sevImage[7] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmSev4Ack.gif"));
        AlarmTableModel.sevImage[8] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmSev5.gif"));
        AlarmTableModel.sevImage[9] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmSev5Ack.gif"));
        AlarmTableModel.stateImage[0] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmOpen.gif"));
        AlarmTableModel.stateImage[1] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmClosed.gif"));
        ackImage = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmAck.gif"));
        if (this.alarmPanel.getDomainUrl() != null) {
            this.domain = true;
            this.columnNames = domainColumnNames;
        }
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.alarmPanel.translate(this.columnNames[n]);
    }

    public int getRowCount() {
        return this.alarmList.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.alarmList.size()) {
            return new Object();
        }
        AlarmData alarmData = (AlarmData)this.alarmList.get(n);
        if (n2 == 1) {
            return alarmData.start;
        }
        if (n2 == 3) {
            return this.domain ? alarmData.host : alarmData.message;
        }
        if (n2 == 4) {
            return alarmData.message;
        }
        if (n2 == 0) {
            if (alarmData.getSevIndex() == -1) {
                return "";
            }
            return sevImage[alarmData.getSevIndex()];
        }
        if (n2 == 2) {
            if (alarmData.stateIndex == -1) {
                return "";
            }
            return stateImage[alarmData.stateIndex];
        }
        return new Object();
    }

    void setAlarmList(AlarmList alarmList) {
        this.alarmList = alarmList;
    }
}

