/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.alarms;

import com.sun.symon.base.client.alarm.SMAlarmObjectData;
import com.sun.symon.base.console.alarms.SortListener;
import com.sun.symon.base.utility.UcListUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class AlarmData
implements Comparable {
    Object alarmId;
    Object start;
    Object host;
    Object message;
    private int sevIndex;
    int stateIndex;
    String ruleId;
    String fixUser;
    String longMessage;
    private String ackUser;
    long startTime;
    long endTime;
    long fixTime;
    private long ackTime;
    private SortListener sortListener;

    public AlarmData() {
        this.alarmId = "";
        this.start = "";
        this.host = "";
        this.message = "";
        this.ruleId = "";
        this.stateIndex = -1;
        this.sevIndex = -1;
        this.fixTime = 0L;
        this.ackTime = 0L;
        this.endTime = 0L;
        this.startTime = 0L;
    }

    public AlarmData(SMAlarmObjectData sMAlarmObjectData) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM d  HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        this.start = simpleDateFormat.format(new Date(sMAlarmObjectData.getOpenTimestamp() * 1000L));
        this.alarmId = sMAlarmObjectData.getAlarmId();
        this.host = sMAlarmObjectData.getHost();
        String string = sMAlarmObjectData.getAlarmShortText();
        this.message = UcListUtil.AsciiToUnicode((String)string);
        String string2 = sMAlarmObjectData.getSeverity();
        this.sevIndex = string2.compareTo("DWN") == 0 ? (sMAlarmObjectData.isAcked() ? 1 : 0) : (string2.compareTo("ERR") == 0 ? (sMAlarmObjectData.isAcked() ? 3 : 2) : (string2.compareTo("WRN") == 0 ? (sMAlarmObjectData.isAcked() ? 5 : 4) : (string2.compareTo("INF") == 0 ? (sMAlarmObjectData.isAcked() ? 7 : 6) : (sMAlarmObjectData.isAcked() ? 9 : 8))));
        this.stateIndex = sMAlarmObjectData.isClosed() ? 1 : 0;
        this.ruleId = sMAlarmObjectData.getAlarmRuleId();
        this.startTime = sMAlarmObjectData.getOpenTimestamp() * 1000L;
        this.endTime = sMAlarmObjectData.getCloseTimestamp() * 1000L;
        this.fixTime = sMAlarmObjectData.getFixTimestamp() * 1000L;
        this.fixUser = sMAlarmObjectData.getFixOperator();
        this.ackTime = sMAlarmObjectData.getAckTimestamp() * 1000L;
        this.ackUser = sMAlarmObjectData.getAckOperator();
    }

    public int compareTo(Object object) {
        AlarmData alarmData = (AlarmData)object;
        int n = 1;
        switch (this.sortListener.getSortBy()) {
            case 0: {
                n = this.sevIndex - alarmData.sevIndex;
                break;
            }
            case 1: {
                n = (int)(alarmData.startTime - this.startTime);
                break;
            }
            case 2: {
                n = this.stateIndex - alarmData.stateIndex;
                break;
            }
        }
        return n;
    }

    long getAckTime() {
        return this.ackTime;
    }

    String getAckUser() {
        return this.ackUser;
    }

    int getSevIndex() {
        return this.sevIndex;
    }

    void setAckTime(long l) {
        this.ackTime = l;
    }

    void setAckUser(String string) {
        this.ackUser = string;
    }

    void setSevIndex(int n) {
        this.sevIndex = n;
    }

    void setSortListener(SortListener sortListener) {
        this.sortListener = sortListener;
    }
}

