/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.bootstrap;

import com.sun.symon.base.bootstrap.Ping;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Properties;

public class RMIDHCPConfigurator {
    private static final String LOOPBACK_IP = "127.0.0.1";

    public RMIDHCPConfigurator(String string) {
        String string2 = this.whichAdapter(string);
        if (string2.equals("")) {
            return;
        }
        this.configureRMI(string2);
    }

    private void configureRMI(String string) {
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("java.rmi.server.hostname", string);
        System.setProperties(properties);
    }

    private String getIP(InetAddress inetAddress) {
        StringBuffer stringBuffer = new StringBuffer(4);
        byte[] byArray = inetAddress.getAddress();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            if (n2 < 0) {
                n2 += 256;
            }
            stringBuffer.append(n2);
            if (n < byArray.length - 1) {
                stringBuffer.append(".");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private String getThisHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void printRMIProperty() {
        System.out.println("java.rmi.server.hostname=" + System.getProperty("java.rmi.server.hostname"));
    }

    private String whichAdapter(String string) {
        InetAddress[] inetAddressArray;
        String string2 = this.getThisHost();
        try {
            inetAddressArray = InetAddress.getAllByName(string2);
        }
        catch (Exception exception) {
            return "";
        }
        int n = 0;
        String string3 = "";
        int n2 = 0;
        while (n2 < inetAddressArray.length) {
            String string4 = this.getIP(inetAddressArray[n2]);
            if (!string4.equals(LOOPBACK_IP)) {
                ++n;
                string3 = string4;
            }
            ++n2;
        }
        if (n == 1) {
            return string3;
        }
        int n3 = 0;
        while (n3 < inetAddressArray.length) {
            Ping ping;
            String string5 = this.getIP(inetAddressArray[n3]);
            if (!string5.equals(LOOPBACK_IP) && (ping = new Ping(string, inetAddressArray[n3], 0)).isAlive()) {
                return string5;
            }
            ++n3;
        }
        return "";
    }
}

